/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.compat.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedSaw;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import net.minecraft.world.level.ItemLike;

@ParametersAreNonnullByDefault
public class BlockCuttingCategory
extends CreateRecipeCategory<CondensedBlockCuttingRecipe> {
    private final AnimatedSaw saw = new AnimatedSaw();

    public BlockCuttingCategory(Item symbol) {
        super(BlockCuttingCategory.doubleItemIcon((ItemLike)AllBlocks.MECHANICAL_SAW.get(), (ItemLike)symbol), BlockCuttingCategory.emptyBackground(177, 70));
    }

    @Override
    public Class<? extends CondensedBlockCuttingRecipe> getRecipeClass() {
        return CondensedBlockCuttingRecipe.class;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CondensedBlockCuttingRecipe recipe, IFocusGroup focuses) {
        List<List<ItemStack>> results = recipe.getCondensedOutputs();
        builder.addSlot(RecipeIngredientRole.INPUT, 5, 5).setBackground(BlockCuttingCategory.getRenderedSlot(), -1, -1).addItemStacks(Arrays.asList(((Ingredient)recipe.m_7527_().get(0)).m_43908_()));
        int i = 0;
        for (List<ItemStack> itemStacks : results) {
            int xPos = 78 + i % 5 * 19;
            int yPos = 48 + i / 5 * -19;
            builder.addSlot(RecipeIngredientRole.OUTPUT, xPos, yPos).setBackground(BlockCuttingCategory.getRenderedSlot(), -1, -1).addItemStacks(itemStacks);
            ++i;
        }
    }

    public void draw(CondensedBlockCuttingRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        AllGuiTextures.JEI_DOWN_ARROW.render(matrixStack, 31, 6);
        AllGuiTextures.JEI_SHADOW.render(matrixStack, 16, 50);
        this.saw.draw(matrixStack, 33, 37);
    }

    public static class CondensedBlockCuttingRecipe
    extends StonecutterRecipe {
        List<ItemStack> outputs = new ArrayList<ItemStack>();

        public CondensedBlockCuttingRecipe(Ingredient ingredient) {
            super(new ResourceLocation(""), "", ingredient, ItemStack.f_41583_);
        }

        public void addOutput(ItemStack stack) {
            this.outputs.add(stack);
        }

        public List<ItemStack> getOutputs() {
            return this.outputs;
        }

        public List<List<ItemStack>> getCondensedOutputs() {
            ArrayList<List<ItemStack>> result = new ArrayList<List<ItemStack>>();
            int index = 0;
            boolean firstPass = true;
            for (ItemStack itemStack : this.outputs) {
                if (firstPass) {
                    result.add(new ArrayList());
                }
                ((List)result.get(index)).add(itemStack);
                if (++index < 15) continue;
                index = 0;
                firstPass = false;
            }
            return result;
        }

        public boolean m_5598_() {
            return true;
        }

        public static List<CondensedBlockCuttingRecipe> condenseRecipes(List<Recipe<?>> stoneCuttingRecipes) {
            ArrayList<CondensedBlockCuttingRecipe> condensed = new ArrayList<CondensedBlockCuttingRecipe>();
            block0: for (Recipe<?> recipe : stoneCuttingRecipes) {
                Ingredient i1 = (Ingredient)recipe.m_7527_().get(0);
                for (CondensedBlockCuttingRecipe condensedRecipe : condensed) {
                    if (!ItemHelper.matchIngredients(i1, (Ingredient)condensedRecipe.m_7527_().get(0))) continue;
                    condensedRecipe.addOutput(recipe.m_8043_());
                    continue block0;
                }
                CondensedBlockCuttingRecipe cr = new CondensedBlockCuttingRecipe(i1);
                cr.addOutput(recipe.m_8043_());
                condensed.add(cr);
            }
            return condensed;
        }
    }
}

