/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.integration.jei.category;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import vectorwing.farmersdelight.common.crafting.CookingPotRecipe;
import vectorwing.farmersdelight.common.registry.ModItems;
import vectorwing.farmersdelight.common.utility.TextUtils;
import vectorwing.farmersdelight.integration.jei.FDRecipeTypes;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class CookingRecipeCategory
implements IRecipeCategory<CookingPotRecipe> {
    public static final ResourceLocation UID = new ResourceLocation("farmersdelight", "cooking");
    protected final IDrawable heatIndicator;
    protected final IDrawableAnimated arrow;
    private final Component title = TextUtils.getTranslation("jei.cooking", new Object[0]);
    private final IDrawable background;
    private final IDrawable icon;

    public CookingRecipeCategory(IGuiHelper helper) {
        ResourceLocation backgroundImage = new ResourceLocation("farmersdelight", "textures/gui/cooking_pot.png");
        this.background = helper.createDrawable(backgroundImage, 29, 16, 117, 57);
        this.icon = helper.createDrawableIngredient(VanillaTypes.ITEM, (Object)new ItemStack((ItemLike)ModItems.COOKING_POT.get()));
        this.heatIndicator = helper.createDrawable(backgroundImage, 176, 0, 17, 15);
        this.arrow = helper.drawableBuilder(backgroundImage, 176, 15, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends CookingPotRecipe> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }

    public RecipeType<CookingPotRecipe> getRecipeType() {
        return FDRecipeTypes.COOKING;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(CookingPotRecipe cookingPotRecipe, IIngredients ingredients) {
        ArrayList<Ingredient> inputAndContainer = new ArrayList<Ingredient>((Collection<Ingredient>)cookingPotRecipe.m_7527_());
        inputAndContainer.add(Ingredient.m_43927_((ItemStack[])new ItemStack[]{cookingPotRecipe.getOutputContainer()}));
        ingredients.setInputIngredients(inputAndContainer);
        ingredients.setOutput(VanillaTypes.ITEM, (Object)cookingPotRecipe.m_8043_());
    }

    public void setRecipe(IRecipeLayout recipeLayout, CookingPotRecipe recipe, IIngredients ingredients) {
        int MEAL_DISPLAY = 6;
        int CONTAINER_INPUT = 7;
        int OUTPUT = 8;
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        NonNullList<Ingredient> recipeIngredients = recipe.m_7527_();
        int borderSlotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int column = 0; column < 3; ++column) {
                int inputIndex = row * 3 + column;
                if (inputIndex >= recipeIngredients.size()) continue;
                itemStacks.init(inputIndex, true, column * borderSlotSize, row * borderSlotSize);
                itemStacks.set(inputIndex, Arrays.asList(((Ingredient)recipeIngredients.get(inputIndex)).m_43908_()));
            }
        }
        itemStacks.init(6, false, 94, 9);
        itemStacks.set(6, recipe.m_8043_());
        if (!recipe.getOutputContainer().m_41619_()) {
            itemStacks.init(7, false, 62, 38);
            itemStacks.set(7, recipe.getOutputContainer());
        }
        itemStacks.init(8, false, 94, 38);
        itemStacks.set(8, recipe.m_8043_());
    }

    public void draw(CookingPotRecipe recipe, IRecipeSlotsView recipeSlotsView, PoseStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 60, 9);
        this.heatIndicator.draw(matrixStack, 18, 39);
    }
}

