/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.items.IItemHandler;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.entity.SkilletBlockEntity;

public class SkilletRenderer
implements BlockEntityRenderer<SkilletBlockEntity> {
    private final Random random = new Random();

    public SkilletRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(SkilletBlockEntity skilletEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        Direction direction = (Direction)skilletEntity.m_58900_().m_61143_((Property)StoveBlock.FACING);
        IItemHandler inventory = skilletEntity.getInventory();
        int posLong = (int)skilletEntity.m_58899_().m_121878_();
        ItemStack stack = inventory.getStackInSlot(0);
        int seed = stack.m_41619_() ? 187 : Item.m_41393_((Item)stack.m_41720_()) + stack.m_41773_();
        this.random.setSeed(seed);
        if (!stack.m_41619_()) {
            int itemRenderCount = this.getModelCount(stack);
            for (int i = 0; i < itemRenderCount; ++i) {
                poseStack.m_85836_();
                float xOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                float zOffset = (this.random.nextFloat() * 2.0f - 1.0f) * 0.15f * 0.5f;
                poseStack.m_85837_(0.5 + (double)xOffset, 0.1 + 0.03 * (double)(i + 1), 0.5 + (double)zOffset);
                float degrees = -direction.m_122435_();
                poseStack.m_85845_(Vector3f.f_122225_.m_122240_(degrees));
                poseStack.m_85845_(Vector3f.f_122223_.m_122240_(90.0f));
                poseStack.m_85841_(0.5f, 0.5f, 0.5f);
                if (skilletEntity.m_58904_() != null) {
                    Minecraft.m_91087_().m_91291_().m_174269_(stack, ItemTransforms.TransformType.FIXED, combinedLight, combinedOverlay, poseStack, buffer, posLong);
                }
                poseStack.m_85849_();
            }
        }
    }

    protected int getModelCount(ItemStack stack) {
        if (stack.m_41613_() > 48) {
            return 5;
        }
        if (stack.m_41613_() > 32) {
            return 4;
        }
        if (stack.m_41613_() > 16) {
            return 3;
        }
        if (stack.m_41613_() > 1) {
            return 2;
        }
        return 1;
    }
}

