/*
 * Decompiled with CFR 0.152.
 */
package com.github.talrey.createdeco.registry;

import com.github.talrey.createdeco.Registration;
import com.github.talrey.createdeco.blocks.CatwalkBlock;
import com.github.talrey.createdeco.connected.CatwalkCTBehaviour;
import com.github.talrey.createdeco.connected.SpriteShifts;
import com.github.talrey.createdeco.items.CatwalkBlockItem;
import com.simibubi.create.AllItems;
import com.simibubi.create.AllTags;
import com.simibubi.create.foundation.data.CreateRegistrate;
import com.simibubi.create.repack.registrate.Registrate;
import com.simibubi.create.repack.registrate.builders.BlockBuilder;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.Locale;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.IronBarsBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.predicates.LootItemBlockStatePropertyCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.MultiPartBlockStateBuilder;

public class MetalDecoBuilders {
    public static BlockBuilder<IronBarsBlock, ?> buildBars(Registrate reg, String metal, Function<String, Item> getter, String suffix) {
        return MetalDecoBuilders.buildBars(reg, metal, getter, suffix, false);
    }

    public static BlockBuilder<IronBarsBlock, ?> buildBars(Registrate reg, String metal, Function<String, Item> getter, String suffix, boolean doPost) {
        ResourceLocation postTexture;
        File touch;
        ResourceLocation barTexture;
        String base = metal.replace(' ', '_').toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_bars";
        String suf = suffix.equals("") ? "" : "_" + suffix.replace(' ', '_').toLowerCase(Locale.ROOT);
        String post = "block/palettes/metal_bars/" + base + (doPost ? "_post" : "");
        try {
            barTexture = new ResourceLocation(reg.getModid(), "block/palettes/metal_bars/" + base);
            touch = new File("../src/main/resources/assets/" + reg.getModid() + "/textures/" + barTexture.m_135815_() + ".png");
            if (!touch.exists()) {
                throw new FileNotFoundException(base + " was not found!");
            }
        }
        catch (FileNotFoundException fnfe) {
            barTexture = new ResourceLocation("block/" + base);
        }
        try {
            postTexture = new ResourceLocation(reg.getModid(), post);
            touch = new File("../src/main/resources/assets/" + reg.getModid() + "/textures/" + postTexture.m_135815_() + ".png");
            if (!touch.exists()) {
                throw new FileNotFoundException(base + " was not found!");
            }
        }
        catch (FileNotFoundException fnfe) {
            postTexture = barTexture;
        }
        ResourceLocation bartex = barTexture;
        ResourceLocation postex = postTexture;
        return (BlockBuilder)reg.block(base + suf, IronBarsBlock::new).properties(props -> props.m_60955_().m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> {
            MultiPartBlockStateBuilder builder = prov.getMultipartBuilder((Block)ctx.get());
            BlockModelBuilder sideModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side", prov.mcLoc("block/iron_bars_side"))).texture("bars", bartex)).texture("edge", postex)).texture("particle", postex);
            BlockModelBuilder sideAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_side_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", bartex)).texture("edge", postex)).texture("particle", postex);
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post", prov.mcLoc("block/iron_bars_post"))).texture("bars", postex)).texture("particle", postex)).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + "_post_ends", prov.mcLoc("block/iron_bars_post_ends"))).texture("edge", postex)).texture("particle", postex)).addModel()).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            if (!suf.equals("")) {
                BlockModelBuilder sideOverlayModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + suf, prov.mcLoc("block/iron_bars_side"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + suf))).texture("edge", postex)).texture("particle", postex);
                BlockModelBuilder sideOverlayAltModel = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(base + suf + "_alt", prov.mcLoc("block/iron_bars_side_alt"))).texture("bars", prov.modLoc("block/palettes/metal_bars/" + base + suf))).texture("edge", postex)).texture("particle", postex);
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).addModel()).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).addModel()).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
                ((MultiPartBlockStateBuilder.PartBuilder)builder.part().modelFile((ModelFile)sideOverlayAltModel).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            }
        }).tag(new TagKey[]{BlockTags.f_13032_}).addLayer(() -> RenderType::m_110457_).item().model((ctx, prov) -> {
            if (suf.isEmpty()) {
                prov.singleTexture(base, prov.mcLoc("item/generated"), "layer0", bartex);
            } else {
                ((ItemModelBuilder)((ItemModelBuilder)prov.withExistingParent(base + suf, prov.mcLoc("item/generated"))).texture("layer0", bartex)).texture("layer1", prov.modLoc("block/palettes/metal_bars/" + base + suf));
            }
        }).properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).build();
    }

    public static BlockBuilder<DoorBlock, ?> buildDoor(Registrate reg, String name, String path) {
        return MetalDecoBuilders.buildDoor(reg, name, path, Material.f_76279_);
    }

    public static BlockBuilder<DoorBlock, ?> buildDoor(Registrate reg, String name, String path, Material mat) {
        return (BlockBuilder)reg.block(name, DoorBlock::new).initialProperties(mat).properties(props -> props.m_60955_().m_60913_(5.0f, 5.0f).m_60999_().m_60918_(SoundType.f_56725_)).blockstate((ctx, prov) -> prov.doorBlock((DoorBlock)ctx.get(), prov.modLoc(path + "_door_bottom"), prov.modLoc(path + "_door_top"))).addLayer(() -> RenderType::m_110457_).loot((table, block) -> {
            LootTable.Builder builder = LootTable.m_79147_();
            LootPool.Builder pool = LootPool.m_79043_();
            pool.m_165133_((NumberProvider)ConstantValue.m_165692_((float)1.0f)).m_79076_((LootPoolEntryContainer.Builder)LootItem.m_79579_((ItemLike)block)).m_6509_((LootItemCondition.Builder)LootItemBlockStatePropertyCondition.m_81769_((Block)block).m_81784_(StatePropertiesPredicate.Builder.m_67693_().m_67697_((Property)BlockStateProperties.f_61401_, (Comparable)DoubleBlockHalf.LOWER)));
            table.m_124165_((Block)block, builder.m_79161_(pool));
        }).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{BlockTags.f_13103_}).item().model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("item/" + ctx.getName()))).properties(props -> name.contains("Netherite") ? props.m_41486_() : props).build();
    }

    public static BlockBuilder<FenceBlock, ?> buildFence(Registrate reg, String metal) {
        return ((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_mesh_fence", FenceBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60918_(SoundType.f_56728_)).addLayer(() -> RenderType::m_110457_).tag(new TagKey[]{BlockTags.f_13039_}).tag(new TagKey[]{BlockTags.f_144282_}).item().properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).model((ctx, prov) -> prov.singleTexture(ctx.getName(), prov.mcLoc("item/generated"), "layer0", prov.modLoc("block/palettes/chain_link_fence/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_chain_link"))).build()).recipe((ctx, prov) -> {
            if (metal.equals("Andesite")) {
                ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("psp").m_126130_("psp").m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42401_).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()})).m_176498_((Consumer)prov);
            } else {
                TagKey<Item> sheet = Registration.makeItemTag("plates/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"));
                ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_("psp").m_126130_("psp").m_206416_(Character.valueOf('p'), sheet).m_126127_(Character.valueOf('s'), (ItemLike)Items.f_42401_).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(sheet).m_45077_()})).m_176498_((Consumer)prov);
            }
        }).blockstate((ctx, prov) -> prov.getVariantBuilder((Block)ctx.get()).forAllStates(state -> {
            String dir = "chainlink_fence";
            boolean north = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61368_);
            boolean south = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61370_);
            boolean east = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61369_);
            boolean west = (Boolean)state.m_61143_((Property)BlockStateProperties.f_61371_);
            int sides = (north ? 1 : 0) + (south ? 1 : 0) + (east ? 1 : 0) + (west ? 1 : 0);
            ResourceLocation mesh = prov.modLoc("block/palettes/chain_link_fence/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_chain_link");
            ResourceLocation wall = prov.modLoc("block/palettes/sheet_metal/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_sheet_metal");
            switch (sides) {
                case 4: {
                    return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_four_way", prov.modLoc(dir + "_four_way"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).build();
                }
                case 3: {
                    return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_tri_way", prov.modLoc(dir + "_tri_way"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? (south ? (east ? 90 : -90) : 0) : 180).build();
                }
                case 2: {
                    if (north && south || east && west) {
                        return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_straight", prov.modLoc(dir + "_straight"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(east ? 0 : 90).build();
                    }
                    return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_corner", prov.modLoc(dir + "_corner"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? (east ? 0 : -90) : (east ? 90 : 180)).build();
                }
                case 1: {
                    return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_end", prov.modLoc(dir + "_end"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).rotationY(north ? -90 : (south ? 90 : (east ? 0 : 180))).build();
                }
            }
            return ConfiguredModel.builder().modelFile((ModelFile)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_post", prov.modLoc(dir + "_post"))).texture("0", mesh)).texture("1", wall)).texture("particle", wall)).build();
        }));
    }

    public static BlockBuilder<CatwalkBlock, ?> buildCatwalk(Registrate reg, String metal) {
        return (BlockBuilder)((BlockBuilder)reg.block(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk", CatwalkBlock::new).initialProperties(Material.f_76279_).properties(props -> props.m_60913_(5.0f, metal.equals("Netherite") ? 1200.0f : 6.0f).m_60999_().m_60955_().m_60918_(SoundType.f_56725_)).addLayer(() -> RenderType::m_110457_).tag(new TagKey[]{BlockTags.f_144282_}).tag(new TagKey[]{AllTags.AllBlockTags.FAN_TRANSPARENT.tag}).item(CatwalkBlockItem::new).properties(p -> metal.equals("Netherite") ? p.m_41486_() : p).model((ctx, prov) -> ((ItemModelBuilder)prov.withExistingParent(ctx.getName(), prov.mcLoc("block/template_trapdoor_bottom"))).texture("texture", prov.modLoc("block/palettes/catwalks/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk"))).build()).recipe((ctx, prov) -> {
            if (metal.equals("Andesite")) {
                ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_(" p ").m_126130_("pBp").m_126130_(" p ").m_126127_(Character.valueOf('p'), (ItemLike)AllItems.ANDESITE_ALLOY.get()).m_126127_(Character.valueOf('B'), (ItemLike)Registration.BAR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43199_((ItemLike[])new ItemLike[]{(ItemLike)AllItems.ANDESITE_ALLOY.get()})).m_176498_((Consumer)prov);
            } else {
                TagKey<Item> sheet = Registration.makeItemTag("plates/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_"));
                ShapedRecipeBuilder.m_126118_((ItemLike)((ItemLike)ctx.get()), (int)3).m_126130_(" p ").m_126130_("pBp").m_126130_(" p ").m_206416_(Character.valueOf('p'), sheet).m_126127_(Character.valueOf('B'), (ItemLike)Registration.BAR_BLOCKS.get(metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_")).get()).m_142284_("has_item", (CriterionTriggerInstance)InventoryChangeTrigger.TriggerInstance.m_43197_((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.m_45068_().m_204145_(sheet).m_45077_()})).m_176498_((Consumer)prov);
            }
        }).blockstate((ctx, prov) -> {
            String texture = reg.getModid() + ":block/palettes/catwalks/" + metal.toLowerCase(Locale.ROOT).replaceAll(" ", "_") + "_catwalk";
            BlockModelBuilder lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_bottom", prov.modLoc("block/catwalk_bottom"))).texture("2", texture)).texture("particle", texture);
            BlockModelBuilder upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_top", prov.modLoc("block/catwalk_top"))).texture("2", texture)).texture("particle", texture);
            BlockModelBuilder rail_upper = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_rail_upper", prov.modLoc("block/catwalk_rail_upper"))).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
            BlockModelBuilder rail_lower = (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)prov.models().withExistingParent(ctx.getName() + "_rail_lower", prov.modLoc("block/catwalk_rail_lower"))).texture("3", texture + "_rail")).texture("particle", texture + "_rail");
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)lower).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)upper).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(-90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_lower).rotationY(0).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{true}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61368_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(-90).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61370_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(180).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61369_, (Comparable[])new Boolean[]{true}).end();
            ((MultiPartBlockStateBuilder.PartBuilder)prov.getMultipartBuilder((Block)ctx.get()).part().modelFile((ModelFile)rail_upper).rotationY(0).addModel()).condition((Property)BlockStateProperties.f_61427_, (Comparable[])new Boolean[]{false}).condition((Property)BlockStateProperties.f_61371_, (Comparable[])new Boolean[]{true}).end();
        }).onRegister(CreateRegistrate.connectedTextures(new CatwalkCTBehaviour(SpriteShifts.CATWALK_TOPS.get(metal)).getSupplier()));
    }
}

