/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.event.handlers;

import com.google.common.base.Strings;
import journeymap.client.command.ClientCommandInvoker;
import journeymap.client.command.CmdChatPosition;
import journeymap.client.command.CmdEditWaypoint;
import journeymap.client.command.CmdReloadWaypoint;
import journeymap.client.waypoint.WaypointParser;
import journeymap.common.Journeymap;
import journeymap.common.log.LogFormatter;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.commands.CommandSource;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;

public class ChatEventHandler {
    private final ClientCommandInvoker clientCommandInvoker = new ClientCommandInvoker();

    public ChatEventHandler() {
        this.clientCommandInvoker.registerSub(new CmdChatPosition());
        this.clientCommandInvoker.registerSub(new CmdEditWaypoint());
        this.clientCommandInvoker.registerSub(new CmdReloadWaypoint());
    }

    public Component onClientChatEventReceived(Component message) {
        if (message != null) {
            try {
                String text = message.getString();
                if (!Strings.isNullOrEmpty((String)text)) {
                    return WaypointParser.parseChatForWaypoints(message, text);
                }
            }
            catch (Exception e) {
                Journeymap.getLogger().warn("Unexpected exception on ClientChatReceivedEvent: " + LogFormatter.toString(e));
            }
        }
        return null;
    }

    public boolean onChatEvent(String message) {
        if (message.regionMatches(0, "/jm", 0, 3)) {
            if (message.length() > 3) {
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                message = message.substring(4);
                this.clientCommandInvoker.execute((CommandSource)player, message.split(" "));
            } else {
                String commands = this.clientCommandInvoker.getPossibleCommands();
                String text = "Available sub commands are: " + commands;
                Minecraft.m_91087_().f_91074_.m_6352_((Component)new TextComponent(text), Util.f_137441_);
            }
            return true;
        }
        return false;
    }
}

