/*
 * Decompiled with CFR 0.152.
 */
package tschipp.carryon.client.event;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Quaternion;
import com.mojang.math.Vector3f;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.player.PlayerRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.ModList;
import tschipp.carryon.CarryOn;
import tschipp.carryon.client.event.RenderEntityEvents;
import tschipp.carryon.client.helper.CarryRenderHelper;
import tschipp.carryon.client.keybinds.CarryOnKeybinds;
import tschipp.carryon.common.config.Configs;
import tschipp.carryon.common.handler.ModelOverridesHandler;
import tschipp.carryon.common.handler.RegistrationHandler;
import tschipp.carryon.common.helper.KeyboardCallbackWrapper;
import tschipp.carryon.common.helper.ScriptParseHelper;
import tschipp.carryon.common.helper.ScrollCallbackWrapper;
import tschipp.carryon.common.helper.StringParser;
import tschipp.carryon.common.item.ItemCarryonBlock;
import tschipp.carryon.common.item.ItemCarryonEntity;
import tschipp.carryon.common.scripting.CarryOnOverride;
import tschipp.carryon.common.scripting.ScriptChecker;
import tschipp.carryon.network.server.SyncKeybindPacket;

public class RenderEvents {
    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onScroll(ScrollCallbackWrapper.MouseScrolledEvent event) {
        ItemStack stack;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (!(player == null || (stack = player.m_21205_()).m_41619_() || stack.m_41720_() != RegistrationHandler.itemTile && stack.m_41720_() != RegistrationHandler.itemEntity || !ItemCarryonBlock.hasTileData(stack) && !ItemCarryonEntity.hasEntityData(stack))) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onPlayerTick(TickEvent.PlayerTickEvent event) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Player player = event.player;
        if (player != null && event.side == LogicalSide.CLIENT) {
            boolean keyPressed = CarryOnKeybinds.carryKey.m_90857_();
            boolean playerKeyPressed = CarryOnKeybinds.isKeyPressed(player);
            if (keyPressed && !playerKeyPressed) {
                CarryOnKeybinds.setKeyPressed(player, true);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(true));
            } else if (!keyPressed && playerKeyPressed) {
                CarryOnKeybinds.setKeyPressed(player, false);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(false));
            }
        }
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void onJoinLevel(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof Player) {
            Player player = (Player)event.getEntity();
            if (player.f_19853_.f_46443_) {
                CarryOnKeybinds.setKeyPressed(player, false);
                CarryOn.network.sendToServer((Object)new SyncKeybindPacket(false));
                if (CarryOn.FINGERPRINT_VIOLATED) {
                    TextComponent cf = new TextComponent(ChatFormatting.AQUA + "Curseforge" + ChatFormatting.RED);
                    cf.m_7383_().m_131142_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://minecraft.curseforge.com/projects/carry-on"));
                    player.m_5661_((Component)new TextComponent(ChatFormatting.RED + "[CarryOn] WARNING! Invalid fingerprint detected! The Carry On mod file may have been tampered with! If you didn't download the file from ").m_7220_((Component)cf).m_130946_(ChatFormatting.RED + " or through any kind of mod launcher, immediately delete the file and re-download it from ").m_7220_((Component)cf), false);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onGuiInit(ScreenEvent.InitScreenEvent.Pre event) {
        if (event.getScreen() != null) {
            ItemStack stack;
            boolean inventory = event.getScreen() instanceof AbstractContainerScreen;
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            if (player != null && inventory && !(stack = player.m_21120_(InteractionHand.MAIN_HAND)).m_41619_() && (stack.m_41720_() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
                Minecraft.m_91087_().f_91074_.m_6915_();
                Minecraft.m_91087_().f_91080_ = null;
                Minecraft.m_91087_().f_91067_.m_91601_();
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void inputEvent(KeyboardCallbackWrapper.KeyPressedEvent event) throws NoSuchFieldException, SecurityException, IllegalArgumentException, IllegalAccessException {
        Options settings = Minecraft.m_91087_().f_91066_;
        int key = event.key;
        int scancode = event.scancode;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null) {
            ItemStack stack = Minecraft.m_91087_().f_91074_.m_21205_();
            if (!stack.m_41619_() && (stack.m_41720_() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
                if (settings.f_92094_.m_90832_(key, scancode)) {
                    event.setCanceled(true);
                }
                if (settings.f_92093_.m_90832_(key, scancode)) {
                    event.setCanceled(true);
                }
                if (settings.f_92097_.m_90832_(key, scancode)) {
                    event.setCanceled(true);
                }
                for (KeyMapping keyBind : settings.f_92056_) {
                    if (!keyBind.m_90832_(key, scancode)) continue;
                    event.setCanceled(true);
                }
            }
            int current = player.m_150109_().f_35977_;
            if (player.getPersistentData().m_128441_("carrySlot") && player.getPersistentData().m_128451_("carrySlot") != current) {
                player.m_150109_().f_35977_ = player.getPersistentData().m_128451_("carrySlot");
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void renderHand(RenderHandEvent event) {
        ClientLevel level = Minecraft.m_91087_().f_91073_;
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        ItemStack stack = player.m_21205_();
        int perspective = CarryRenderHelper.getPerspective();
        boolean f1 = Minecraft.m_91087_().f_91066_.f_92062_;
        MultiBufferSource buffer = event.getMultiBufferSource();
        PoseStack matrix = event.getPoseStack();
        int light = event.getPackedLight();
        if (!stack.m_41619_() && stack.m_41720_() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) && perspective == 0 && !f1) {
            if (ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) {
                return;
            }
            Block block = ItemCarryonBlock.getBlock(stack);
            CompoundTag tag = ItemCarryonBlock.getTileData(stack);
            BlockState state = ItemCarryonBlock.getBlockState(stack);
            ItemStack tileStack = ItemCarryonBlock.getItemStack(stack);
            matrix.m_85836_();
            matrix.m_85841_(2.5f, 2.5f, 2.5f);
            matrix.m_85837_(0.0, -0.5, -1.0);
            RenderSystem.m_69478_();
            RenderSystem.m_69464_();
            if ((Boolean)Configs.Settings.facePlayer.get() != false ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                matrix.m_85845_(Vector3f.f_122222_.m_122240_(8.0f));
            } else {
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(8.0f));
            }
            BakedModel model = ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag, (Level)level, (Player)player) : (tileStack.m_41619_() ? Minecraft.m_91087_().m_91289_().m_110910_(state) : Minecraft.m_91087_().m_91291_().m_174264_(tileStack, (Level)level, (LivingEntity)player, 0));
            CarryOnOverride carryOverride = ScriptChecker.getOverride((Player)player);
            if (carryOverride != null) {
                Block b;
                CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                if (!carryOverride.getRenderNameBlock().isEmpty() && (b = StringParser.getBlock(carryOverride.getRenderNameBlock())) != null) {
                    ItemStack s = new ItemStack((ItemLike)b, 1);
                    s.m_41751_(carryOverride.getRenderNBT());
                    model = Minecraft.m_91087_().m_91291_().m_174264_(s, (Level)level, (LivingEntity)player, 0);
                }
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
            CarryRenderHelper.renderItem(state, tag, stack, tileStack, matrix, buffer, light, model);
            if (perspective == 0) {
                event.setCanceled(true);
            }
            RenderSystem.m_69481_();
            RenderSystem.m_69461_();
            matrix.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onRenderLevel(RenderLevelLastEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        ClientLevel level = mc.f_91073_;
        float partialticks = event.getPartialTick();
        MultiBufferSource.BufferSource buffer = MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
        PoseStack matrix = event.getPoseStack();
        int light = 0;
        int perspective = CarryRenderHelper.getPerspective();
        EntityRenderDispatcher manager = mc.m_91290_();
        RenderSystem.m_69478_();
        RenderSystem.m_69464_();
        RenderSystem.m_69465_();
        for (Player player : level.m_6907_()) {
            Entity entity;
            if (perspective == 0 && player == mc.f_91074_) continue;
            light = manager.m_114394_((Entity)player, partialticks);
            ItemStack stack = player.m_21205_();
            if (!stack.m_41619_() && stack.m_41720_() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack)) {
                Block block = ItemCarryonBlock.getBlock(stack);
                BlockState state = ItemCarryonBlock.getBlockState(stack);
                CompoundTag tag = ItemCarryonBlock.getTileData(stack);
                ItemStack tileItem = ItemCarryonBlock.getItemStack(stack);
                this.applyBlockTransformations(player, partialticks, matrix, block);
                BakedModel model = ModelOverridesHandler.hasCustomOverrideModel(state, tag) ? ModelOverridesHandler.getCustomOverrideModel(state, tag, (Level)level, player) : (tileItem.m_41619_() ? mc.m_91289_().m_110910_(state) : mc.m_91291_().m_174264_(tileItem, (Level)level, (LivingEntity)player, 0));
                CarryOnOverride carryOverride = ScriptChecker.getOverride(player);
                if (carryOverride != null) {
                    Block b;
                    CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                    if (!carryOverride.getRenderNameBlock().isEmpty() && (b = StringParser.getBlock(carryOverride.getRenderNameBlock())) != null) {
                        ItemStack s = new ItemStack((ItemLike)b, 1);
                        s.m_41751_(carryOverride.getRenderNBT());
                        model = mc.m_91291_().m_174264_(s, (Level)level, (LivingEntity)player, 0);
                    }
                }
                RenderSystem.m_157456_((int)0, (ResourceLocation)TextureAtlas.f_118259_);
                RenderSystem.m_69481_();
                PoseStack.Pose p = matrix.m_85850_();
                PoseStack copy = new PoseStack();
                copy.m_166854_(p.m_85861_());
                matrix.m_85849_();
                this.drawArms(player, partialticks, matrix, (MultiBufferSource)buffer, light);
                RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                CarryRenderHelper.renderItem(state, tag, stack, tileItem, copy, (MultiBufferSource)buffer, light, model);
                buffer.m_109911_();
                matrix.m_85849_();
                continue;
            }
            if (stack.m_41619_() || stack.m_41720_() != RegistrationHandler.itemEntity || !ItemCarryonEntity.hasEntityData(stack) || (entity = RenderEntityEvents.getEntity(stack, (Level)level)) == null) continue;
            this.applyEntityTransformations(player, partialticks, matrix, entity);
            manager.m_114468_(false);
            CarryOnOverride carryOverride = ScriptChecker.getOverride(player);
            if (carryOverride != null) {
                CarryRenderHelper.performOverrideTransformation(matrix, carryOverride);
                String entityname = carryOverride.getRenderNameEntity();
                if (entityname != null) {
                    Entity newEntity = null;
                    Optional type = EntityType.m_20632_((String)entityname);
                    if (type.isPresent()) {
                        newEntity = ((EntityType)type.get()).m_20615_((Level)level);
                    }
                    if (newEntity != null) {
                        CompoundTag nbttag = carryOverride.getRenderNBT();
                        if (nbttag != null) {
                            newEntity.deserializeNBT(nbttag);
                        }
                        entity = newEntity;
                        entity.f_19855_ = 0.0;
                        entity.f_19859_ = 0.0f;
                        entity.m_5616_(0.0f);
                        entity.f_19854_ = 0.0;
                        entity.f_19860_ = 0.0f;
                    }
                }
            }
            if (entity instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)entity;
                le.f_20916_ = 0;
            }
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            manager.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 0.0f, matrix, (MultiBufferSource)buffer, light);
            buffer.m_109911_();
            matrix.m_85849_();
            this.drawArms(player, partialticks, matrix, (MultiBufferSource)buffer, light);
            manager.m_114468_(true);
            matrix.m_85849_();
        }
        RenderSystem.m_69482_();
        RenderSystem.m_69481_();
        RenderSystem.m_69461_();
    }

    private void applyGeneralTransformations(Player player, float partialticks, PoseStack matrix) {
        int perspective = CarryRenderHelper.getPerspective();
        Quaternion playerrot = CarryRenderHelper.getExactBodyRotation((LivingEntity)player, partialticks);
        Vec3 playerpos = CarryRenderHelper.getExactPos((Entity)player, partialticks);
        Vec3 cameraPos = Minecraft.m_91087_().f_91063_.m_109153_().m_90583_();
        Vec3 offset = playerpos.m_82546_(cameraPos);
        Pose pose = player.m_20089_();
        matrix.m_85836_();
        matrix.m_85837_(offset.f_82479_, offset.f_82480_, offset.f_82481_);
        if (perspective == 2) {
            playerrot.m_80148_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        matrix.m_85845_(playerrot);
        matrix.m_85836_();
        matrix.m_85841_(0.6f, 0.6f, 0.6f);
        if (perspective == 2) {
            matrix.m_85837_(0.0, 0.0, -1.35);
        }
        if (RenderEvents.doSneakCheck(player)) {
            matrix.m_85837_(0.0, -0.4, 0.0);
        }
        if (pose == Pose.SWIMMING) {
            float f = player.m_20998_(partialticks);
            float f3 = player.m_20069_() ? -90.0f - player.f_19860_ : -90.0f;
            float f4 = Mth.m_14179_((float)f, (float)0.0f, (float)f3);
            if (perspective == 2) {
                matrix.m_85837_(0.0, 0.0, 1.35);
                matrix.m_85845_(Vector3f.f_122223_.m_122240_(f4));
            } else {
                matrix.m_85845_(Vector3f.f_122222_.m_122240_(f4));
            }
            matrix.m_85837_(0.0, -1.5, -1.848);
            if (perspective == 2) {
                matrix.m_85837_(0.0, 0.0, 2.38);
            }
        }
        if (pose == Pose.FALL_FLYING) {
            float f1 = (float)player.m_21256_() + partialticks;
            float f2 = Mth.m_14036_((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
            if (!player.m_21209_()) {
                if (perspective == 2) {
                    matrix.m_85837_(0.0, 0.0, 1.35);
                }
                if (perspective == 2) {
                    matrix.m_85845_(Vector3f.f_122223_.m_122240_(f2 * (-90.0f - player.f_19860_)));
                } else {
                    matrix.m_85845_(Vector3f.f_122222_.m_122240_(f2 * (-90.0f - player.f_19860_)));
                }
            }
            Vec3 Vector3d = player.m_20252_(partialticks);
            Vec3 Vector3d1 = player.m_20184_();
            double d0 = Vector3d1.m_165925_();
            double d1 = Vector3d1.m_165925_();
            if (d0 > 0.0 && d1 > 0.0) {
                double d2 = (Vector3d1.f_82479_ * Vector3d.f_82479_ + Vector3d1.f_82481_ * Vector3d.f_82481_) / (Math.sqrt(d0) * Math.sqrt(d1));
                double d3 = Vector3d1.f_82479_ * Vector3d.f_82481_ - Vector3d1.f_82481_ * Vector3d.f_82479_;
                matrix.m_85845_(Vector3f.f_122225_.m_122270_((float)(Math.signum(d3) * Math.acos(d2))));
            }
            if (perspective != 2) {
                matrix.m_85837_(0.0, 0.0, -1.35);
            }
            matrix.m_85837_(0.0, -0.2, 0.0);
        }
        matrix.m_85837_(0.0, 1.6, 0.65);
    }

    private void applyBlockTransformations(Player player, float partialticks, PoseStack matrix, Block block) {
        int perspective = CarryRenderHelper.getPerspective();
        this.applyGeneralTransformations(player, partialticks, matrix);
        if ((Boolean)Configs.Settings.facePlayer.get() != false ? !RenderEvents.isChest(block) : RenderEvents.isChest(block)) {
            if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && perspective == 0) {
                matrix.m_85837_(0.0, 0.0, -0.4);
            }
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        } else if ((ModList.get().isLoaded("realrender") || ModList.get().isLoaded("rfpr")) && perspective == 0) {
            matrix.m_85837_(0.0, 0.0, 0.4);
        }
    }

    private void applyEntityTransformations(Player player, float partialticks, PoseStack matrix, Entity entity) {
        int perspective = CarryRenderHelper.getPerspective();
        Pose pose = player.m_20089_();
        this.applyGeneralTransformations(player, partialticks, matrix);
        if (perspective == 2) {
            matrix.m_85837_(0.0, -1.6, 0.65);
        } else {
            matrix.m_85837_(0.0, -1.6, -0.65);
        }
        matrix.m_85841_(1.666f, 1.666f, 1.666f);
        float height = entity.m_20206_();
        float width = entity.m_20205_();
        float multiplier = height * width;
        entity.f_19855_ = 0.0;
        entity.f_19859_ = 0.0f;
        entity.m_5616_(0.0f);
        entity.f_19854_ = 0.0;
        entity.f_19860_ = 0.0f;
        if (perspective == 2) {
            matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
        }
        matrix.m_85841_((10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f, (10.0f - multiplier) * 0.08f);
        matrix.m_85837_(0.0, (double)(height / 2.0f + -(height / 2.0f) + 1.0f), (double)width - 0.1 < 0.7 ? (double)width - 0.1 + (0.7 - ((double)width - 0.1)) : (double)width - 0.1);
        if (pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            matrix.m_85845_(Vector3f.f_122222_.m_122240_(90.0f));
            matrix.m_85837_(0.0, -0.2 * (double)height, 0.0);
            if (pose == Pose.FALL_FLYING) {
                matrix.m_85837_(0.0, 0.0, 0.2);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawArms(Player player, float partialticks, PoseStack matrix, MultiBufferSource buffer, int light) {
        ItemStack stack;
        int perspective = CarryRenderHelper.getPerspective();
        Pose pose = player.m_20089_();
        if (!((Boolean)Configs.Settings.renderArms.get()).booleanValue() || pose == Pose.SWIMMING || pose == Pose.FALL_FLYING) {
            return;
        }
        if (this.handleMobends() && !ModList.get().isLoaded("obfuscate") && (!(stack = player.m_21205_()).m_41619_() && stack.m_41720_() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
            PlayerModel<AbstractClientPlayer> model = RenderEvents.getPlayerModel((AbstractClientPlayer)player);
            AbstractClientPlayer aplayer = (AbstractClientPlayer)player;
            ResourceLocation skinLoc = aplayer.m_108560_();
            matrix.m_85836_();
            if (perspective == 2) {
                matrix.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
            }
            RenderSystem.m_157456_((int)0, (ResourceLocation)skinLoc);
            CarryOnOverride overrider = ScriptChecker.getOverride(player);
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110452_((ResourceLocation)skinLoc));
            if (overrider != null) {
                float[] rotLeft = null;
                float[] rotRight = null;
                if (!overrider.getRenderRotationLeftArm().isEmpty()) {
                    rotLeft = ScriptParseHelper.getXYZArray(overrider.getRenderRotationLeftArm());
                }
                if (!overrider.getRenderRotationRightArm().isEmpty()) {
                    rotRight = ScriptParseHelper.getXYZArray(overrider.getRenderRotationRightArm());
                }
                boolean renderRight = overrider.isRenderRightArm();
                boolean renderLeft = overrider.isRenderLeftArm();
                if (renderLeft && rotLeft != null) {
                    this.renderArmPost(model.f_102812_, rotLeft[0], rotLeft[2], false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.f_103374_, rotLeft[0], rotLeft[2], false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                } else if (renderLeft) {
                    this.renderArmPost(model.f_102812_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.f_103374_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                }
                if (renderRight && rotRight != null) {
                    this.renderArmPost(model.f_102811_, rotRight[0], rotRight[2], true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.f_103375_, rotRight[0], rotRight[2], true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                } else if (renderRight) {
                    this.renderArmPost(model.f_102811_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                    this.renderArmPost(model.f_103375_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                }
            } else {
                this.renderArmPost(model.f_102811_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
                this.renderArmPost(model.f_102812_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                this.renderArmPost(model.f_103374_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? 0.15f : 0.0f, false, RenderEvents.doSneakCheck(player), light, matrix, builder);
                this.renderArmPost(model.f_103375_, 2.0f + (RenderEvents.doSneakCheck(player) ? 0.0f : 0.2f) - (stack.m_41720_() == RegistrationHandler.itemEntity ? 0.3f : 0.0f), stack.m_41720_() == RegistrationHandler.itemEntity ? -0.15f : 0.0f, true, RenderEvents.doSneakCheck(player), light, matrix, builder);
            }
            if (buffer instanceof MultiBufferSource.BufferSource) {
                ((MultiBufferSource.BufferSource)buffer).m_109911_();
            }
            matrix.m_85849_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent(priority=EventPriority.NORMAL)
    public void onEvent(RenderPlayerEvent.Pre event) {
        if (!((Boolean)Configs.Settings.renderArms.get()).booleanValue()) {
            return;
        }
        if (this.handleMobends() && !ModList.get().isLoaded("obfuscate")) {
            Player player = event.getPlayer();
            Pose pose = player.m_20089_();
            ItemStack stack = player.m_21205_();
            if (pose != Pose.SWIMMING && pose != Pose.FALL_FLYING && !stack.m_41619_() && (stack.m_41720_() == RegistrationHandler.itemTile && ItemCarryonBlock.hasTileData(stack) || stack.m_41720_() == RegistrationHandler.itemEntity && ItemCarryonEntity.hasEntityData(stack))) {
                PlayerModel model = (PlayerModel)event.getRenderer().m_7200_();
                CarryOnOverride overrider = ScriptChecker.getOverride(player);
                if (overrider != null) {
                    boolean renderRight = overrider.isRenderRightArm();
                    boolean renderLeft = overrider.isRenderLeftArm();
                    if (renderRight) {
                        this.renderArmPre(model.f_102811_);
                        this.renderArmPre(model.f_103375_);
                    }
                    if (renderLeft) {
                        this.renderArmPre(model.f_102812_);
                        this.renderArmPre(model.f_103374_);
                    }
                } else {
                    this.renderArmPre(model.f_102811_);
                    this.renderArmPre(model.f_102812_);
                    this.renderArmPre(model.f_103374_);
                    this.renderArmPre(model.f_103375_);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderArmPost(ModelPart arm, float x, float z, boolean right, boolean sneaking, int light, PoseStack matrix, VertexConsumer builder) {
        matrix.m_85836_();
        arm.f_104207_ = true;
        if (right) {
            matrix.m_85837_(0.015, 0.0, 0.0);
        } else {
            matrix.m_85837_(-0.015, 0.0, 0.0);
        }
        arm.f_104201_ = !sneaking ? 20.0f : 15.0f;
        arm.f_104203_ = x;
        arm.f_104204_ = 0.0f;
        arm.f_104205_ = -z;
        arm.m_104301_(matrix, builder, light, 655360);
        arm.f_104201_ = 2.0f;
        matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderArmPre(ModelPart arm) {
        arm.f_104207_ = false;
    }

    public boolean handleMobends() {
        return true;
    }

    public static boolean doSneakCheck(Player player) {
        if (player.m_150110_().f_35935_) {
            return false;
        }
        return player.m_6144_() || player.m_6047_();
    }

    public static boolean isChest(Block block) {
        return block == Blocks.f_50087_ || block == Blocks.f_50265_ || block == Blocks.f_50325_;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlayerRenderer getRenderPlayer(AbstractClientPlayer player) {
        Minecraft mc = Minecraft.m_91087_();
        EntityRenderDispatcher manager = mc.m_91290_();
        return (PlayerRenderer)manager.getSkinMap().get(player.m_108564_());
    }

    @OnlyIn(value=Dist.CLIENT)
    private static PlayerModel<AbstractClientPlayer> getPlayerModel(AbstractClientPlayer player) {
        return (PlayerModel)RenderEvents.getRenderPlayer(player).m_7200_();
    }
}

