/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.network;

import java.util.EnumMap;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketData;
import mezz.jei.common.network.packets.IServerPacketHandler;
import mezz.jei.core.config.IServerConfig;
import mezz.jei.network.packets.PacketDeletePlayerItem;
import mezz.jei.network.packets.PacketGiveItemStack;
import mezz.jei.network.packets.PacketRecipeTransfer;
import mezz.jei.network.packets.PacketRequestCheatPermission;
import mezz.jei.network.packets.PacketSetHotbarItemStack;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;

public class ServerPacketRouter {
    public static final ResourceLocation CHANNEL_ID = new ResourceLocation("jei", "channel");
    public final EnumMap<PacketIdServer, IServerPacketHandler> handlers = new EnumMap(PacketIdServer.class);
    private final IConnectionToClient connection;
    private final IServerConfig serverConfig;

    public ServerPacketRouter(IConnectionToClient connection, IServerConfig serverConfig) {
        this.connection = connection;
        this.serverConfig = serverConfig;
        this.handlers.put(PacketIdServer.RECIPE_TRANSFER, PacketRecipeTransfer::readPacketData);
        this.handlers.put(PacketIdServer.DELETE_ITEM, PacketDeletePlayerItem::readPacketData);
        this.handlers.put(PacketIdServer.GIVE_ITEM, PacketGiveItemStack::readPacketData);
        this.handlers.put(PacketIdServer.SET_HOTBAR_ITEM, PacketSetHotbarItemStack::readPacketData);
        this.handlers.put(PacketIdServer.CHEAT_PERMISSION_REQUEST, PacketRequestCheatPermission::readPacketData);
    }

    public void onPacket(FriendlyByteBuf packetBuffer, ServerPlayer player) {
        byte packetIdOrdinal = packetBuffer.readByte();
        PacketIdServer packetId = PacketIdServer.VALUES[packetIdOrdinal];
        IServerPacketHandler packetHandler = this.handlers.get(packetId);
        ServerPacketData data = new ServerPacketData(packetBuffer, player, this.serverConfig, this.connection);
        packetHandler.readPacketData(data);
    }
}

