/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.ingredients;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.helpers.IModIdHelper;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.gui.ingredients.IListElement;
import mezz.jei.ingredients.IListElementInfo;
import mezz.jei.ingredients.IngredientBlacklistInternal;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientInfo;
import mezz.jei.ingredients.IngredientListElementFactory;
import mezz.jei.ingredients.ListElementInfo;
import mezz.jei.ingredients.RegisteredIngredients;
import mezz.jei.ingredients.TypedIngredient;
import mezz.jei.util.ErrorUtil;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Unmodifiable;

public class IngredientManager
implements IIngredientManager {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IModIdHelper modIdHelper;
    private final IngredientBlacklistInternal blacklist;
    private final IClientConfig clientConfig;
    private final RegisteredIngredients registeredIngredients;
    private final IngredientFilter ingredientFilter;

    public IngredientManager(IModIdHelper modIdHelper, IngredientBlacklistInternal blacklist, IClientConfig clientConfig, RegisteredIngredients registeredIngredients, IngredientFilter ingredientFilter) {
        this.modIdHelper = modIdHelper;
        this.blacklist = blacklist;
        this.clientConfig = clientConfig;
        this.registeredIngredients = registeredIngredients;
        this.ingredientFilter = ingredientFilter;
    }

    @Override
    public <V> @Unmodifiable Collection<V> getAllIngredients(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        return ingredientInfo.getAllIngredients();
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientHelper(ingredientType);
    }

    @Override
    public <V> IIngredientHelper<V> getIngredientHelper(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientHelper();
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        IIngredientType<V> ingredientType = this.getIngredientType(ingredient);
        return this.getIngredientRenderer(ingredientType);
    }

    @Override
    public <V> IIngredientRenderer<V> getIngredientRenderer(IIngredientType<V> ingredientType) {
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        return ingredientInfo.getIngredientRenderer();
    }

    @Override
    public Collection<IIngredientType<?>> getRegisteredIngredientTypes() {
        return this.registeredIngredients.getIngredientTypes();
    }

    @Override
    public <V> void addIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being added at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        ingredientInfo.addIngredients(ingredients);
        List<ITypedIngredient> typedIngredients = ingredients.stream().map(i -> TypedIngredient.createTyped(this.registeredIngredients, ingredientType, i)).map(Optional::orElseThrow).toList();
        IIngredientHelper ingredientHelper = ingredientInfo.getIngredientHelper();
        for (ITypedIngredient value : typedIngredients) {
            Optional<IListElementInfo<V>> matchingElementInfo = this.ingredientFilter.searchForMatchingElement(ingredientHelper, value);
            if (matchingElementInfo.isPresent()) {
                IListElement<V> matchingElement = matchingElementInfo.get().getElement();
                ITypedIngredient<V> typedIngredient = matchingElement.getTypedIngredient();
                this.blacklist.removeIngredientFromBlacklist(typedIngredient, ingredientHelper);
                this.ingredientFilter.updateHiddenState(matchingElement);
                if (!this.clientConfig.isDebugModeEnabled()) continue;
                LOGGER.debug("Updated ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
                continue;
            }
            IListElement element = IngredientListElementFactory.createOrderedElement(value);
            IListElementInfo info = ListElementInfo.create(element, this.registeredIngredients, this.modIdHelper);
            if (info == null) continue;
            this.blacklist.removeIngredientFromBlacklist(value, ingredientHelper);
            this.ingredientFilter.addIngredient(info);
            if (!this.clientConfig.isDebugModeEnabled()) continue;
            LOGGER.debug("Added ingredient: {}", (Object)ingredientHelper.getErrorInfo(value.getIngredient()));
        }
        this.ingredientFilter.invalidateCache();
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(V ingredient) {
        ErrorUtil.checkNotNull(ingredient, "ingredient");
        return this.registeredIngredients.getIngredientType(ingredient);
    }

    @Override
    public <V> IIngredientType<V> getIngredientType(Class<? extends V> ingredientClass) {
        ErrorUtil.checkNotNull(ingredientClass, "ingredientClass");
        return this.registeredIngredients.getIngredientType(ingredientClass);
    }

    @Override
    public <V> void removeIngredientsAtRuntime(IIngredientType<V> ingredientType, Collection<V> ingredients) {
        ErrorUtil.assertMainThread();
        ErrorUtil.checkNotNull(ingredientType, "ingredientType");
        ErrorUtil.checkNotEmpty(ingredients, "ingredients");
        IngredientInfo<V> ingredientInfo = this.registeredIngredients.getIngredientInfo(ingredientType);
        LOGGER.info("Ingredients are being removed at runtime: {} {}", (Object)ingredients.size(), (Object)ingredientType.getIngredientClass().getName());
        ingredientInfo.removeIngredients(ingredients);
        IIngredientHelper ingredientHelper = this.getIngredientHelper(ingredientType);
        ingredients.stream().map(i -> TypedIngredient.createTyped(this.registeredIngredients, ingredientType, i)).flatMap(Optional::stream).forEach(typedIngredient -> {
            Optional matchingElementInfo = this.ingredientFilter.searchForMatchingElement(ingredientHelper, typedIngredient);
            if (matchingElementInfo.isEmpty()) {
                String errorInfo = ingredientHelper.getErrorInfo(typedIngredient.getIngredient());
                LOGGER.error("Could not find a matching ingredient to remove: {}", (Object)errorInfo);
            } else {
                if (this.clientConfig.isDebugModeEnabled()) {
                    LOGGER.debug("Removed ingredient: {}", (Object)ingredientHelper.getErrorInfo(typedIngredient.getIngredient()));
                }
                IListElement matchingElement = matchingElementInfo.get().getElement();
                this.blacklist.addIngredientToBlacklist(matchingElement.getTypedIngredient(), ingredientHelper);
                matchingElement.setVisible(false);
            }
        });
        this.ingredientFilter.invalidateCache();
    }
}

