/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.config;

import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.config.KeyBindings;
import mezz.jei.core.config.IWorldConfig;
import mezz.jei.network.packets.PacketRequestCheatPermission;

public class WorldConfig
implements IWorldConfig {
    private final IConnectionToServer serverConnection;
    private boolean overlayEnabled = true;
    private boolean cheatItemsEnabled = false;
    private boolean editModeEnabled = false;
    private boolean bookmarkOverlayEnabled = true;

    public WorldConfig(IConnectionToServer serverConnection) {
        this.serverConnection = serverConnection;
    }

    @Override
    public boolean isOverlayEnabled() {
        return this.overlayEnabled || KeyBindings.toggleOverlay.getKey().m_84873_() == -1;
    }

    @Override
    public void toggleOverlayEnabled() {
        this.overlayEnabled = !this.overlayEnabled;
    }

    @Override
    public boolean isBookmarkOverlayEnabled() {
        return this.isOverlayEnabled() && this.bookmarkOverlayEnabled;
    }

    @Override
    public void toggleBookmarkEnabled() {
        this.setBookmarkEnabled(!this.bookmarkOverlayEnabled);
    }

    @Override
    public void setBookmarkEnabled(boolean value) {
        if (this.bookmarkOverlayEnabled != value) {
            this.bookmarkOverlayEnabled = value;
        }
    }

    @Override
    public boolean isCheatItemsEnabled() {
        return this.cheatItemsEnabled;
    }

    @Override
    public boolean isDeleteItemsInCheatModeActive() {
        return this.cheatItemsEnabled && this.serverConnection.isJeiOnServer();
    }

    @Override
    public void toggleCheatItemsEnabled() {
        this.setCheatItemsEnabled(!this.cheatItemsEnabled);
    }

    @Override
    public void setCheatItemsEnabled(boolean value) {
        if (this.cheatItemsEnabled != value) {
            this.cheatItemsEnabled = value;
            if (this.cheatItemsEnabled && this.serverConnection.isJeiOnServer()) {
                this.serverConnection.sendPacketToServer(new PacketRequestCheatPermission());
            }
        }
    }

    @Override
    public boolean isEditModeEnabled() {
        return this.editModeEnabled;
    }

    @Override
    public void toggleEditModeEnabled() {
        this.editModeEnabled = !this.editModeEnabled;
    }
}

