/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.block.tile;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.api.storage.IFractionalDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.EnumCompDrawer;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.tiledata.FractionalDrawerGroup;
import com.jaquadro.minecraft.storagedrawers.config.CommonConfig;
import com.jaquadro.minecraft.storagedrawers.core.ModBlockEntities;
import com.jaquadro.minecraft.storagedrawers.network.CountUpdateMessage;
import com.jaquadro.minecraft.storagedrawers.network.MessageHandler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.network.PacketDistributor;

public class TileEntityDrawersComp
extends TileEntityDrawers {
    static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerAttributes>(){});

    public TileEntityDrawersComp(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    @Override
    public IDrawerGroup getGroup() {
        return null;
    }

    @Override
    protected boolean emptySlotCanBeCleared(int slot) {
        if (slot != 0) {
            return false;
        }
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            FractionalDrawerGroup fracGroup = (FractionalDrawerGroup)this.getGroup();
            return !this.getGroup().getDrawer(0).isEmpty() && fracGroup.getPooledCount() == 0;
        }
        return false;
    }

    @Override
    public boolean dataPacketRequiresRenderUpdate() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientUpdateCount(int slot, int count) {
        if (!this.m_58904_().f_46443_) {
            return;
        }
        Minecraft.m_91087_().m_6937_(() -> this.clientUpdateCountAsync(count));
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientUpdateCountAsync(int count) {
        if (this.getGroup() instanceof FractionalDrawerGroup) {
            ((FractionalDrawerGroup)this.getGroup()).setPooledCount(count);
        }
    }

    private class GroupData
    extends FractionalDrawerGroup {
        private final LazyOptional<?> capabilityAttributes;

        public GroupData(int slotCount) {
            super(slotCount);
            this.capabilityAttributes = LazyOptional.of(TileEntityDrawersComp.this::getDrawerAttributes);
        }

        @Override
        protected Level getWorld() {
            return TileEntityDrawersComp.this.m_58904_();
        }

        @Override
        public boolean isGroupValid() {
            return TileEntityDrawersComp.this.isGroupValid();
        }

        @Override
        protected void log(String message) {
            if (!this.getWorld().f_46443_ && ((Boolean)CommonConfig.GENERAL.debugTrace.get()).booleanValue()) {
                StorageDrawers.log.info(message);
            }
        }

        @Override
        protected int getStackCapacity() {
            return TileEntityDrawersComp.this.upgrades().getStorageMultiplier() * TileEntityDrawersComp.this.getEffectiveDrawerCapacity();
        }

        @Override
        protected void onItemChanged() {
            if (this.getWorld() != null && !this.getWorld().f_46443_) {
                int usedSlots = 0;
                for (int slot : this.getAccessibleDrawerSlots()) {
                    IFractionalDrawer drawer = this.getDrawer(slot);
                    if (drawer == null || drawer.isEmpty()) continue;
                    ++usedSlots;
                }
                usedSlots = Math.max(usedSlots, 1);
                EnumCompDrawer open = (EnumCompDrawer)((Object)TileEntityDrawersComp.this.m_58900_().m_61143_(BlockCompDrawers.SLOTS));
                if (open.getOpenSlots() != usedSlots) {
                    this.getWorld().m_7731_(TileEntityDrawersComp.this.f_58858_, (BlockState)TileEntityDrawersComp.this.m_58900_().m_61124_(BlockCompDrawers.SLOTS, (Comparable)((Object)EnumCompDrawer.byOpenSlots(usedSlots))), 3);
                }
                TileEntityDrawersComp.this.m_6596_();
                TileEntityDrawersComp.this.markBlockForUpdate();
            }
        }

        @Override
        protected void onAmountChanged() {
            if (this.getWorld() != null && !this.getWorld().f_46443_) {
                PacketDistributor.TargetPoint point = new PacketDistributor.TargetPoint((double)TileEntityDrawersComp.this.m_58899_().m_123341_(), (double)TileEntityDrawersComp.this.m_58899_().m_123342_(), (double)TileEntityDrawersComp.this.m_58899_().m_123343_(), 500.0, this.getWorld().m_46472_());
                MessageHandler.INSTANCE.send(PacketDistributor.NEAR.with(() -> point), (Object)new CountUpdateMessage(TileEntityDrawersComp.this.m_58899_(), 0, this.getPooledCount()));
                TileEntityDrawersComp.this.m_6596_();
            }
        }

        @Override
        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
            if (capability == DRAWER_ATTRIBUTES_CAPABILITY) {
                return this.capabilityAttributes.cast();
            }
            return super.getCapability(capability, facing);
        }
    }

    public static class Slot3
    extends TileEntityDrawersComp {
        private GroupData groupData = new GroupData(3);

        public Slot3(BlockPos pos, BlockState state) {
            super((BlockEntityType)ModBlockEntities.FRACTIONAL_DRAWERS_3.get(), pos, state);
            this.groupData.setCapabilityProvider(this);
            this.injectPortableData(this.groupData);
        }

        @Override
        public IDrawerGroup getGroup() {
            return this.groupData;
        }

        @Override
        protected void onAttributeChanged() {
            super.onAttributeChanged();
            this.groupData.syncAttributes();
        }
    }
}

