/*
 * Decompiled with CFR 0.152.
 */
package io.github.andrew6rant.autoslabs;

import io.github.andrew6rant.autoslabs.Util;
import io.github.andrew6rant.autoslabs.VerticalType;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2389;
import net.minecraft.class_243;
import net.minecraft.class_2482;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2771;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_6089;

public class PlacementUtil {
    public static boolean calcPaneCanConnectToVerticalSlab(class_2350 paneDirection, class_2680 offsetState, boolean sideSolidFullSquare) {
        if (sideSolidFullSquare && !class_2389.method_9581((class_2680)offsetState)) {
            return true;
        }
        if (offsetState.method_26204() instanceof class_2482) {
            switch (paneDirection) {
                case field_11043: 
                case field_11035: {
                    return offsetState.method_11654(Util.VERTICAL_TYPE) == VerticalType.EAST_WEST;
                }
                case field_11034: 
                case field_11039: {
                    return offsetState.method_11654(Util.VERTICAL_TYPE) == VerticalType.NORTH_SOUTH;
                }
            }
        }
        return offsetState.method_26204() instanceof class_2389 || offsetState.method_26164(class_3481.field_15504);
    }

    public static class_265 getDynamicOutlineShape(VerticalType verticalType, class_2350 side, class_3965 cast) {
        return switch (verticalType) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalType.FALSE -> {
                switch (side) {
                    case field_11036: {
                        yield Util.TOP_SHAPE;
                    }
                    case field_11033: {
                        yield Util.BOTTOM_SHAPE;
                    }
                }
                double yPos = cast.method_17784().field_1351;
                double yOffset = (yPos % 1.0 + 1.0) % 1.0;
                if (yOffset > 0.5) {
                    yield Util.TOP_SHAPE;
                }
                yield Util.BOTTOM_SHAPE;
            }
            case VerticalType.NORTH_SOUTH -> {
                switch (side) {
                    case field_11043: {
                        yield Util.VERTICAL_NORTH_SOUTH_TOP_SHAPE;
                    }
                    case field_11035: {
                        yield Util.VERTICAL_NORTH_SOUTH_BOTTOM_SHAPE;
                    }
                }
                double zPos = cast.method_17784().field_1350;
                double zOffset = (zPos % 1.0 + 1.0) % 1.0;
                if (zOffset > 0.5) {
                    yield Util.VERTICAL_NORTH_SOUTH_BOTTOM_SHAPE;
                }
                yield Util.VERTICAL_NORTH_SOUTH_TOP_SHAPE;
            }
            case VerticalType.EAST_WEST -> {
                switch (side) {
                    case field_11034: {
                        yield Util.VERTICAL_EAST_WEST_TOP_SHAPE;
                    }
                    case field_11039: {
                        yield Util.VERTICAL_EAST_WEST_BOTTOM_SHAPE;
                    }
                }
                double xPos = cast.method_17784().field_1352;
                double xOffset = (xPos % 1.0 + 1.0) % 1.0;
                if (xOffset > 0.5) {
                    yield Util.VERTICAL_EAST_WEST_TOP_SHAPE;
                }
                yield Util.VERTICAL_EAST_WEST_BOTTOM_SHAPE;
            }
        };
    }

    public static class_265 getOutlineShape(class_2680 state) {
        class_2771 slabType = (class_2771)state.method_11654(Util.TYPE);
        VerticalType verticalType = (VerticalType)((Object)state.method_11654(Util.VERTICAL_TYPE));
        if (slabType == class_2771.field_12682) {
            return class_259.method_1077();
        }
        return switch (verticalType) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalType.FALSE -> {
                if (slabType == class_2771.field_12679) {
                    yield Util.TOP_SHAPE;
                }
                yield Util.BOTTOM_SHAPE;
            }
            case VerticalType.NORTH_SOUTH -> {
                if (slabType == class_2771.field_12679) {
                    yield Util.VERTICAL_NORTH_SOUTH_TOP_SHAPE;
                }
                yield Util.VERTICAL_NORTH_SOUTH_BOTTOM_SHAPE;
            }
            case VerticalType.EAST_WEST -> slabType == class_2771.field_12679 ? Util.VERTICAL_EAST_WEST_TOP_SHAPE : Util.VERTICAL_EAST_WEST_BOTTOM_SHAPE;
        };
    }

    public static class_2680 getModelState(class_2680 state, VerticalType verticalType, class_2350 side, class_3965 cast) {
        return switch (verticalType) {
            default -> throw new IncompatibleClassChangeError();
            case VerticalType.FALSE -> {
                switch (side) {
                    case field_11036: {
                        yield (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
                    }
                    case field_11033: {
                        yield (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
                    }
                }
                double yPos = cast.method_17784().field_1351;
                double yOffset = (yPos % 1.0 + 1.0) % 1.0;
                if (yOffset > 0.5) {
                    yield (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
                }
                yield (class_2680)state.method_26204().method_9564().method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
            }
            case VerticalType.NORTH_SOUTH -> {
                switch (side) {
                    case field_11043: {
                        yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
                    }
                    case field_11035: {
                        yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
                    }
                }
                double zPos = cast.method_17784().field_1350;
                double zOffset = (zPos % 1.0 + 1.0) % 1.0;
                if (zOffset > 0.5) {
                    yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
                }
                yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
            }
            case VerticalType.EAST_WEST -> {
                switch (side) {
                    case field_11034: {
                        yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
                    }
                    case field_11039: {
                        yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
                    }
                }
                double xPos = cast.method_17784().field_1352;
                double xOffset = (xPos % 1.0 + 1.0) % 1.0;
                if (xOffset > 0.5) {
                    yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679);
                }
                yield (class_2680)((class_2680)state.method_26204().method_9564().method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681);
            }
        };
    }

    public static class_3965 calcRaycast(class_1297 entity) {
        class_243 vec3d = entity.method_5836(0.0f);
        class_243 vec3d2 = entity.method_5828(0.0f);
        class_243 vec3d3 = vec3d.method_1031(vec3d2.field_1352 * 5.0, vec3d2.field_1351 * 5.0, vec3d2.field_1350 * 5.0);
        return entity.method_37908().method_17742(new class_3959(vec3d, vec3d3, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, entity));
    }

    public static class_2771 calcKleeSlab(class_2680 breakState, class_3965 cast) {
        class_2350 side = cast.method_17780();
        VerticalType verticalType = (VerticalType)((Object)breakState.method_11654(Util.VERTICAL_TYPE));
        class_2771 breakType = class_2771.field_12682;
        if (verticalType != null) {
            switch (verticalType) {
                case FALSE: {
                    breakType = switch (side) {
                        case class_2350.field_11036 -> class_2771.field_12681;
                        case class_2350.field_11033 -> class_2771.field_12679;
                        default -> {
                            double yPos = cast.method_17784().field_1351;
                            double yOffset = (yPos % 1.0 + 1.0) % 1.0;
                            if (yOffset > 0.5) {
                                yield class_2771.field_12681;
                            }
                            yield class_2771.field_12679;
                        }
                    };
                    break;
                }
                case NORTH_SOUTH: {
                    breakType = switch (side) {
                        case class_2350.field_11043 -> class_2771.field_12681;
                        case class_2350.field_11035 -> class_2771.field_12679;
                        default -> {
                            double zPos = cast.method_17784().field_1350;
                            double zOffset = (zPos % 1.0 + 1.0) % 1.0;
                            if (zOffset > 0.5) {
                                yield class_2771.field_12679;
                            }
                            yield class_2771.field_12681;
                        }
                    };
                    break;
                }
                case EAST_WEST: {
                    breakType = switch (side) {
                        case class_2350.field_11034 -> class_2771.field_12681;
                        case class_2350.field_11039 -> class_2771.field_12679;
                        default -> {
                            double xPos = cast.method_17784().field_1352;
                            double xOffset = (xPos % 1.0 + 1.0) % 1.0;
                            if (xOffset > 0.5) {
                                yield class_2771.field_12681;
                            }
                            yield class_2771.field_12679;
                        }
                    };
                }
            }
        }
        return breakType;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canReplace(class_2680 state, class_1750 context) {
        class_1799 itemStack = context.method_8041();
        class_2771 slabType = (class_2771)state.method_11654((class_2769)class_2482.field_11501);
        class_1657 entity = context.method_8036();
        if (entity == null) {
            return false;
        }
        if (slabType == class_2771.field_12682) return false;
        if (!itemStack.method_31574(state.method_26204().method_8389())) return false;
        if (!context.method_7717()) return true;
        class_3965 blockHitResult = PlacementUtil.calcRaycast((class_1297)entity);
        Util.HitPart part = Util.getHitPart(blockHitResult);
        boolean topHalfX = context.method_17698().field_1352 - (double)context.method_8037().method_10263() > 0.5;
        boolean topHalfY = context.method_17698().field_1351 - (double)context.method_8037().method_10264() > 0.5;
        boolean topHalfZ = context.method_17698().field_1350 - (double)context.method_8037().method_10260() > 0.5;
        class_2350 direction = context.method_8038();
        VerticalType verticalType = (VerticalType)((Object)state.method_11654(Util.VERTICAL_TYPE));
        if (verticalType == null) return false;
        if (verticalType == VerticalType.FALSE) {
            if (slabType == class_2771.field_12681) {
                if (direction != class_2350.field_11036) {
                    if (!topHalfY) return false;
                    if (!direction.method_10166().method_10179()) return false;
                }
                if (part != Util.HitPart.CENTER) return false;
                return true;
            }
            if (direction != class_2350.field_11033) {
                if (topHalfY) return false;
                if (!direction.method_10166().method_10179()) return false;
            }
            if (part != Util.HitPart.CENTER) return false;
            return true;
        }
        if (verticalType == VerticalType.NORTH_SOUTH) {
            if (slabType == class_2771.field_12681) {
                if (direction != class_2350.field_11043) {
                    if (topHalfZ) return false;
                    if (!direction.method_10166().method_10178()) return false;
                }
                if (part != Util.HitPart.CENTER) return false;
                return true;
            }
            if (direction != class_2350.field_11035) {
                if (!topHalfZ) return false;
                if (!direction.method_10166().method_10178()) return false;
            }
            if (part != Util.HitPart.CENTER) return false;
            return true;
        }
        if (verticalType != VerticalType.EAST_WEST) return false;
        if (slabType == class_2771.field_12681) {
            if (direction != class_2350.field_11034) {
                if (!topHalfX) return false;
                if (!direction.method_10166().method_10178()) return false;
            }
            if (part != Util.HitPart.CENTER) return false;
            return true;
        }
        if (direction != class_2350.field_11039) {
            if (topHalfX) return false;
            if (!direction.method_10166().method_10178()) return false;
        }
        if (part != Util.HitPart.CENTER) return false;
        return true;
    }

    public static class_2680 calcPlacementState(class_1750 ctx, class_2680 state) {
        class_2338 blockPos = ctx.method_8037();
        class_2680 blockState = ctx.method_8045().method_8320(blockPos);
        if (!(ctx.method_8045() instanceof class_3218)) {
            if (blockState.method_27852(state.method_26204())) {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(false));
            }
            return (class_2680)class_2246.field_31037.method_9564().method_11657((class_2769)class_6089.field_31187, (Comparable)Integer.valueOf(0));
        }
        class_2350 ctxSide = ctx.method_8038();
        class_3610 fluidState = ctx.method_8045().method_8316(blockPos);
        class_1657 entity = ctx.method_8036();
        if (entity == null) {
            return null;
        }
        class_3965 blockHitResult = PlacementUtil.calcRaycast((class_1297)entity);
        Util.HitPart part = Util.getHitPart(blockHitResult);
        return switch (ctxSide) {
            default -> throw new IncompatibleClassChangeError();
            case class_2350.field_11036 -> PlacementUtil.calcUpPlacement(blockState, state, part, fluidState);
            case class_2350.field_11033 -> PlacementUtil.calcDownPlacement(blockState, state, part, fluidState);
            case class_2350.field_11043 -> PlacementUtil.calcNorthPlacement(blockState, state, part, fluidState);
            case class_2350.field_11035 -> PlacementUtil.calcSouthPlacement(blockState, state, part, fluidState);
            case class_2350.field_11034 -> PlacementUtil.calcEastPlacement(blockState, state, part, fluidState);
            case class_2350.field_11039 -> PlacementUtil.calcWestPlacement(blockState, state, part, fluidState);
        };
    }

    public static class_2680 calcUpPlacement(class_2680 blockState, class_2680 state, Util.HitPart part, class_3610 fluidState) {
        if (part != null) {
            if (blockState.method_27852(state.method_26204())) {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(false));
            }
            if (part == Util.HitPart.CENTER) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.BOTTOM) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.TOP) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.LEFT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.RIGHT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
        }
        return null;
    }

    public static class_2680 calcDownPlacement(class_2680 blockState, class_2680 state, Util.HitPart part, class_3610 fluidState) {
        if (part != null) {
            if (blockState.method_27852(state.method_26204())) {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(false));
            }
            if (part == Util.HitPart.CENTER) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.BOTTOM) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.TOP) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.LEFT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.RIGHT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
        }
        return null;
    }

    public static class_2680 calcNorthPlacement(class_2680 blockState, class_2680 state, Util.HitPart part, class_3610 fluidState) {
        if (part != null) {
            if (blockState.method_27852(state.method_26204())) {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(false));
            }
            if (part == Util.HitPart.CENTER) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.BOTTOM) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.TOP) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.LEFT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.RIGHT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
        }
        return null;
    }

    public static class_2680 calcSouthPlacement(class_2680 blockState, class_2680 state, Util.HitPart part, class_3610 fluidState) {
        if (part != null) {
            if (blockState.method_27852(state.method_26204())) {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(false));
            }
            if (part == Util.HitPart.CENTER) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.BOTTOM) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.TOP) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.LEFT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.RIGHT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
        }
        return null;
    }

    public static class_2680 calcEastPlacement(class_2680 blockState, class_2680 state, Util.HitPart part, class_3610 fluidState) {
        if (part != null) {
            if (blockState.method_27852(state.method_26204())) {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(false));
            }
            if (part == Util.HitPart.CENTER) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.BOTTOM) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.TOP) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.LEFT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.RIGHT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
        }
        return null;
    }

    public static class_2680 calcWestPlacement(class_2680 blockState, class_2680 state, Util.HitPart part, class_3610 fluidState) {
        if (part != null) {
            if (blockState.method_27852(state.method_26204())) {
                return (class_2680)((class_2680)blockState.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12682)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(false));
            }
            if (part == Util.HitPart.CENTER) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.EAST_WEST))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.BOTTOM) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.TOP) {
                return (class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.LEFT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12679)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
            if (part == Util.HitPart.RIGHT) {
                return (class_2680)((class_2680)((class_2680)state.method_11657((class_2769)class_2482.field_11501, (Comparable)class_2771.field_12681)).method_11657(Util.VERTICAL_TYPE, (Comparable)((Object)VerticalType.NORTH_SOUTH))).method_11657((class_2769)class_2482.field_11502, (Comparable)Boolean.valueOf(fluidState.method_15772() == class_3612.field_15910));
            }
        }
        return null;
    }
}

