/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.client.ColorUtils;
import immersive_aircraft.entity.VehicleEntity;
import java.awt.Color;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public abstract class DyeableVehicleEntity
extends VehicleEntity {
    protected static final class_2940<Integer> DYE_COLOR = class_2945.method_12791(DyeableVehicleEntity.class, (class_2941)class_2943.field_13327);

    public DyeableVehicleEntity(class_1299<? extends VehicleEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super(entityType, world, canExplodeOnCrash);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(DYE_COLOR, (Object)-1);
    }

    @Override
    protected void addItemTag(@NotNull class_2487 tag) {
        super.addItemTag(tag);
        if (this.getDyeColor() >= 0) {
            tag.method_10562("display").method_10569("color", this.getDyeColor());
        }
    }

    @Override
    protected void readItemTag(@NotNull class_2487 tag) {
        super.readItemTag(tag);
        class_2487 displayTag = tag.method_10562("display");
        if (displayTag.method_10573("color", 99)) {
            this.setDyeColor(displayTag.method_10550("color"));
        }
    }

    @Override
    protected void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10545("Color")) {
            this.setDyeColor(tag.method_10550("Color"));
        }
    }

    @Override
    protected void method_5652(@NotNull class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Color", this.getDyeColor());
    }

    public int getDyeColor() {
        return (Integer)this.field_6011.method_12789(DYE_COLOR);
    }

    public void setDyeColor(int v) {
        this.field_6011.method_12778(DYE_COLOR, (Object)v);
    }

    public int getBodyColor() {
        int[] rgb = ColorUtils.hexToRGB(this.getDyeColor() < 0 ? this.getDefaultDyeColor() : this.getDyeColor());
        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        hsb[2] = class_3532.method_15363((float)hsb[2], (float)0.18f, (float)0.95f);
        Color resultColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return resultColor.getRGB();
    }

    public int getHighlightColor() {
        int[] rgb = ColorUtils.hexToRGB(this.getBodyColor());
        float[] hsb = Color.RGBtoHSB(rgb[0], rgb[1], rgb[2], null);
        hsb[1] = class_3532.method_15363((float)(hsb[1] * 0.88311f), (float)0.0f, (float)1.0f);
        hsb[2] = class_3532.method_15363((float)(hsb[2] * 1.11494f), (float)0.0f, (float)1.0f);
        Color resultColor = Color.getHSBColor(hsb[0], hsb[1], hsb[2]);
        return resultColor.getRGB();
    }

    public int getDefaultDyeColor() {
        return 0xFFFFFF;
    }

    @Override
    public class_2561 method_5476() {
        return super.method_5476();
    }
}

