/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.client.render.entity.renderer.utils;

import com.mojang.datafixers.util.Pair;
import immersive_aircraft.client.render.entity.renderer.utils.ModelPartRenderHandler;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.resources.bbmodel.BBAnimation;
import immersive_aircraft.resources.bbmodel.BBAnimator;
import immersive_aircraft.resources.bbmodel.BBBone;
import immersive_aircraft.resources.bbmodel.BBFace;
import immersive_aircraft.resources.bbmodel.BBFaceContainer;
import immersive_aircraft.resources.bbmodel.BBMesh;
import immersive_aircraft.resources.bbmodel.BBModel;
import immersive_aircraft.resources.bbmodel.BBObject;
import immersive_aircraft.util.Utils;
import java.util.List;
import net.minecraft.class_1767;
import net.minecraft.class_1921;
import net.minecraft.class_2582;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_4722;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class BBModelRenderer {
    public static final VertexConsumerProvider DEFAULT_VERTEX_CONSUMER_PROVIDER = (source, container, face) -> source.getBuffer(container.enableCulling() ? class_1921.method_23576((class_2960)face.texture.location) : class_1921.method_23578((class_2960)face.texture.location));

    public static <T extends VehicleEntity> void renderModel(BBModel model, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        model.root.forEach(object -> BBModelRenderer.renderObject(model, object, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
    }

    public static <T extends VehicleEntity> void renderObject(BBModel model, BBObject object, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        BBAnimation animation;
        matrixStack.method_22903();
        matrixStack.method_46416(object.origin.x(), object.origin.y(), object.origin.z());
        if (!model.animations.isEmpty() && (animation = model.animations.get(0)).hasAnimator(object.uuid)) {
            Vector3f position = animation.sample(object.uuid, BBAnimator.Channel.POSITION, time);
            position.mul(0.0625f);
            matrixStack.method_46416(position.x(), position.y(), position.z());
            Vector3f rotation = animation.sample(object.uuid, BBAnimator.Channel.ROTATION, time);
            rotation.mul(0.017453294f);
            matrixStack.method_22907(Utils.fromXYZ(rotation));
            Vector3f scale = animation.sample(object.uuid, BBAnimator.Channel.SCALE, time);
            matrixStack.method_22905(scale.x(), scale.y(), scale.z());
        }
        matrixStack.method_22907(Utils.fromXYZ(object.rotation));
        if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            if (modelPartRenderer != null) {
                modelPartRenderer.animate(bone.name, entity, matrixStack, time);
            }
        }
        if (object instanceof BBBone) {
            matrixStack.method_46416(-object.origin.x(), -object.origin.y(), -object.origin.z());
        }
        if (modelPartRenderer == null || !modelPartRenderer.render(object.name, model, object, vertexConsumerProvider, entity, matrixStack, light, time, modelPartRenderer)) {
            BBModelRenderer.renderObjectInner(model, object, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha);
        }
        matrixStack.method_22909();
    }

    public static <T extends VehicleEntity> void renderObjectInner(BBModel model, BBObject object, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float time, T entity, ModelPartRenderHandler<T> modelPartRenderer, float red, float green, float blue, float alpha) {
        if (object instanceof BBFaceContainer) {
            BBFaceContainer cube = (BBFaceContainer)((Object)object);
            BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumerProvider, light, red, green, blue, alpha, modelPartRenderer == null ? DEFAULT_VERTEX_CONSUMER_PROVIDER : modelPartRenderer.getVertexConsumerProvider());
        } else if (object instanceof BBBone) {
            BBBone bone = (BBBone)object;
            boolean shouldRender = bone.visibility;
            if (bone.name.equals("lod0")) {
                shouldRender = entity.isWithinParticleRange();
            } else if (bone.name.equals("lod1")) {
                boolean bl = shouldRender = !entity.isWithinParticleRange();
            }
            if (shouldRender) {
                bone.children.forEach(child -> BBModelRenderer.renderObject(model, child, matrixStack, vertexConsumerProvider, light, time, entity, modelPartRenderer, red, green, blue, alpha));
            }
        }
    }

    public static void renderFaces(BBFaceContainer cube, class_4587 matrixStack, class_4597 source, int light, float red, float green, float blue, float alpha, VertexConsumerProvider provider) {
        class_4587.class_4665 last = matrixStack.method_23760();
        Matrix4f positionMatrix = last.method_23761();
        Matrix3f normalMatrix = last.method_23762();
        for (BBFace face : cube.getFaces()) {
            class_4588 vertexConsumer = provider.getBuffer(source, cube, face);
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                vertexConsumer.method_22918(positionMatrix, v.x, v.y, v.z);
                vertexConsumer.method_22915(red, green, blue, alpha);
                vertexConsumer.method_22913(v.u, v.v);
                vertexConsumer.method_22922(class_4608.field_21444);
                vertexConsumer.method_22916(light);
                vertexConsumer.method_23763(normalMatrix, v.nx, v.ny, v.nz);
                vertexConsumer.method_1344();
            }
        }
    }

    public static void renderBanner(BBFaceContainer cube, class_4587 matrixStack, class_4597 vertexConsumers, int light, boolean isBanner, List<Pair<class_6880<class_2582>, class_1767>> patterns) {
        matrixStack.method_22903();
        if (cube instanceof BBObject) {
            BBObject object = (BBObject)((Object)cube);
            matrixStack.method_46416(object.origin.x(), object.origin.y(), object.origin.z());
        }
        for (int i = 0; i < 17 && i < patterns.size(); ++i) {
            Pair<class_6880<class_2582>, class_1767> pair = patterns.get(i);
            class_6880 bannerPattern = (class_6880)pair.getFirst();
            bannerPattern.method_40230().map(key -> isBanner ? class_4722.method_33081((class_5321)key) : class_4722.method_33083((class_5321)key)).ifPresent(material -> {
                float[] fs = ((class_1767)pair.getSecond()).method_7787();
                BBModelRenderer.renderFaces(cube, matrixStack, vertexConsumers, light, fs[0], fs[1], fs[2], 1.0f, (source, container, face) -> material.method_24145(vertexConsumers, class_1921::method_23588));
            });
        }
        matrixStack.method_22909();
    }

    public static void renderSailObject(BBMesh cube, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float time, float red, float green, float blue, float alpha) {
        BBModelRenderer.renderSailObject(cube, matrixStack, vertexConsumerProvider, light, time, red, green, blue, alpha, 0.025f, 0.0f);
    }

    public static void renderSailObject(BBMesh cube, class_4587 matrixStack, class_4597 vertexConsumerProvider, int light, float time, float red, float green, float blue, float alpha, float distanceScale, float baseScale) {
        class_4587.class_4665 last = matrixStack.method_23760();
        Matrix4f positionMatrix = last.method_23761();
        Matrix3f normalMatrix = last.method_23762();
        for (BBFace face : cube.getFaces()) {
            class_4588 vertexConsumer = vertexConsumerProvider.getBuffer(class_1921.method_23578((class_2960)face.texture.location));
            for (int i = 0; i < 4; ++i) {
                BBFace.BBVertex v = face.vertices[i];
                float distance = Math.max(Math.max(Math.abs(v.x), Math.abs(v.y)), Math.abs(v.z));
                double angle = ((double)(v.x + v.z) + (double)v.y * 0.25) * 4.0 + (double)(time * 4.0f);
                double scale = distanceScale * distance + baseScale;
                float x = (float)((Math.cos(angle) + Math.cos(angle * 1.7)) * scale);
                float z = (float)((Math.sin(angle) + Math.sin(angle * 1.7)) * scale);
                vertexConsumer.method_22918(positionMatrix, v.x + x, v.y, v.z + z).method_22915(red, green, blue, alpha).method_22913(v.u, v.v).method_22922(class_4608.field_21444).method_22916(light).method_23763(normalMatrix, v.nx, v.ny, v.nz).method_1344();
            }
        }
    }

    public static interface VertexConsumerProvider {
        public class_4588 getBuffer(class_4597 var1, BBFaceContainer var2, BBFace var3);
    }
}

