/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.core.render.world;

import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.util.SortedSet;
import me.jellysquid.mods.sodium.client.gl.device.RenderDevice;
import me.jellysquid.mods.sodium.client.render.SodiumWorldRenderer;
import me.jellysquid.mods.sodium.client.render.chunk.ChunkRenderMatrices;
import me.jellysquid.mods.sodium.client.render.viewport.Viewport;
import me.jellysquid.mods.sodium.client.render.viewport.ViewportProvider;
import me.jellysquid.mods.sodium.client.util.FlawlessFrames;
import me.jellysquid.mods.sodium.client.world.WorldRendererExtended;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3191;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4599;
import net.minecraft.class_4604;
import net.minecraft.class_638;
import net.minecraft.class_757;
import net.minecraft.class_761;
import net.minecraft.class_765;
import net.minecraft.class_824;
import net.minecraft.class_898;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_761.class})
public abstract class WorldRendererMixin
implements WorldRendererExtended {
    @Shadow
    @Final
    private class_4599 field_20951;
    @Shadow
    @Final
    private Long2ObjectMap<SortedSet<class_3191>> field_20950;
    @Shadow
    @Nullable
    private class_638 field_4085;
    @Unique
    private SodiumWorldRenderer renderer;
    @Unique
    private int frame;

    @Override
    public SodiumWorldRenderer sodium$getWorldRenderer() {
        return this.renderer;
    }

    @Redirect(method={"method_3279()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/class_315;method_38521()I", ordinal=1))
    private int nullifyBuiltChunkStorage(class_315 options) {
        return 0;
    }

    @Inject(method={"<init>(Lnet/minecraft/class_310;Lnet/minecraft/class_898;Lnet/minecraft/class_824;Lnet/minecraft/class_4599;)V"}, at={@At(value="RETURN")})
    private void init(class_310 client, class_898 entityRenderDispatcher, class_824 blockEntityRenderDispatcher, class_4599 bufferBuilderStorage, CallbackInfo ci) {
        this.renderer = new SodiumWorldRenderer(client);
    }

    @Inject(method={"method_3244(Lnet/minecraft/class_638;)V"}, at={@At(value="RETURN")})
    private void onWorldChanged(class_638 world, CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setWorld(world);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public int method_3246() {
        return this.renderer.getVisibleChunkCount();
    }

    @Overwrite
    public boolean method_3281() {
        return this.renderer.isTerrainRenderComplete();
    }

    @Inject(method={"method_3292()V"}, at={@At(value="RETURN")})
    private void onTerrainUpdateScheduled(CallbackInfo ci) {
        this.renderer.scheduleTerrainUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void method_3251(class_1921 renderLayer, class_4587 matrices, double x, double y, double z, Matrix4f projection) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.drawChunkLayer(renderLayer, new ChunkRenderMatrices((Matrix4fc)projection, (Matrix4fc)matrices.method_23760().method_23761()), x, y, z);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Overwrite
    private void method_3273(class_4184 camera, class_4604 frustum, boolean hasForcedFrustum, boolean spectator) {
        Viewport viewport = ((ViewportProvider)frustum).sodium$createViewport();
        boolean updateChunksImmediately = FlawlessFrames.isActive();
        RenderDevice.enterManagedCode();
        try {
            this.renderer.setupTerrain(camera, viewport, this.frame++, spectator, updateChunksImmediately);
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Overwrite
    public void method_18146(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        this.renderer.scheduleRebuildForBlockArea(minX, minY, minZ, maxX, maxY, maxZ, false);
    }

    @Overwrite
    public void method_18145(int x, int y, int z) {
        this.renderer.scheduleRebuildForChunks(x - 1, y - 1, z - 1, x + 1, y + 1, z + 1, false);
    }

    @Overwrite
    private void method_16037(class_2338 pos, boolean important) {
        this.renderer.scheduleRebuildForBlockArea(pos.method_10263() - 1, pos.method_10264() - 1, pos.method_10260() - 1, pos.method_10263() + 1, pos.method_10264() + 1, pos.method_10260() + 1, important);
    }

    @Overwrite
    private void method_3295(int x, int y, int z, boolean important) {
        this.renderer.scheduleRebuildForChunk(x, y, z, important);
    }

    @Overwrite
    public boolean method_40050(class_2338 pos) {
        return this.renderer.isSectionReady(pos.method_10263() >> 4, pos.method_10264() >> 4, pos.method_10260() >> 4);
    }

    @Inject(method={"method_3279()V"}, at={@At(value="RETURN")})
    private void onReload(CallbackInfo ci) {
        RenderDevice.enterManagedCode();
        try {
            this.renderer.reload();
        }
        finally {
            RenderDevice.exitManagedCode();
        }
    }

    @Inject(method={"method_22710(Lnet/minecraft/class_4587;FJZLnet/minecraft/class_4184;Lnet/minecraft/class_757;Lnet/minecraft/class_765;Lorg/joml/Matrix4f;)V"}, at={@At(value="FIELD", target="Lnet/minecraft/class_761;field_4055:Ljava/util/Set;", shift=At.Shift.BEFORE, ordinal=0)})
    private void onRenderBlockEntities(class_4587 matrices, float tickDelta, long limitTime, boolean renderBlockOutline, class_4184 camera, class_757 gameRenderer, class_765 lightmapTextureManager, Matrix4f positionMatrix, CallbackInfo ci) {
        this.renderer.renderBlockEntities(matrices, this.field_20951, this.field_20950, camera, tickDelta);
    }

    @Overwrite
    public String method_3289() {
        return this.renderer.getChunksDebugString();
    }
}

