/*
 * Decompiled with CFR 0.152.
 */
package xaero.pac.common.server.player.config;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.class_2561;
import net.minecraftforge.common.ForgeConfigSpec;
import xaero.pac.client.player.config.PlayerConfigClientStorage;
import xaero.pac.common.packet.config.ClientboundPlayerConfigDynamicOptionsPacket;
import xaero.pac.common.server.player.config.PlayerConfig;
import xaero.pac.common.server.player.config.PlayerConfigOptionCategory;
import xaero.pac.common.server.player.config.PlayerConfigOptionSpec;
import xaero.pac.common.server.player.config.api.PlayerConfigType;

public final class PlayerConfigRangedOptionSpec<T extends Comparable<T>>
extends PlayerConfigOptionSpec<T> {
    private final T minValue;
    private final T maxValue;

    private PlayerConfigRangedOptionSpec(Class<T> type, String id, String shortenedId, List<String> path, T defaultValue, BiFunction<PlayerConfig<?>, T, T> defaultReplacer, String comment, String translation, String[] translationArgs, String commentTranslation, String[] commentTranslationArgs, PlayerConfigOptionCategory category, Function<String, T> commandInputParser, Function<T, class_2561> commandOutputWriter, BiPredicate<PlayerConfig<?>, T> serverSideValidator, BiPredicate<PlayerConfigClientStorage, T> clientSideValidator, T minValue, T maxValue, String tooltipPrefix, Predicate<PlayerConfigType> configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType syncOptionType, boolean dynamic) {
        super(type, id, shortenedId, path, defaultValue, defaultReplacer, comment, translation, translationArgs, commentTranslation, commentTranslationArgs, category, commandInputParser, commandOutputWriter, serverSideValidator, clientSideValidator, tooltipPrefix, configTypeFilter, syncOptionType, dynamic);
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public PlayerConfigOptionSpec<T> applyToForgeSpec(ForgeConfigSpec.Builder builder) {
        ForgeConfigSpec.Builder b = this.buildForgeSpec(builder);
        if (this.type == Integer.class) {
            b.defineInRange(this.id, ((Integer)this.defaultValue).intValue(), ((Integer)this.minValue).intValue(), ((Integer)this.maxValue).intValue());
        } else {
            b.defineInRange(this.id, ((Double)this.defaultValue).doubleValue(), ((Double)this.minValue).doubleValue(), ((Double)this.maxValue).doubleValue());
        }
        return this;
    }

    public T getMinValue() {
        return this.minValue;
    }

    public T getMaxValue() {
        return this.maxValue;
    }

    public static final class Builder<T extends Comparable<T>>
    extends PlayerConfigOptionSpec.Builder<T, Builder<T>> {
        private T minValue;
        private T maxValue;

        private Builder(Class<T> valueType) {
            super(valueType);
        }

        private T getAbsoluteMax() {
            if (this.type == Integer.class) {
                return (T)Integer.valueOf(Integer.MAX_VALUE);
            }
            return (T)Double.valueOf(Double.MAX_VALUE);
        }

        private T getAbsoluteMin() {
            if (this.type == Integer.class) {
                return (T)Integer.valueOf(Integer.MIN_VALUE);
            }
            return (T)Double.valueOf(Double.MIN_VALUE);
        }

        private void setDefaultMinMaxValues() {
            this.setMinValue(this.getAbsoluteMin());
            this.setMaxValue(this.getAbsoluteMax());
        }

        @Override
        public Builder<T> setDefault() {
            this.setDefaultMinMaxValues();
            return (Builder)super.setDefault();
        }

        public Builder<T> setMinValue(T minValue) {
            this.minValue = minValue;
            return this;
        }

        public Builder<T> setMaxValue(T maxValue) {
            this.maxValue = maxValue;
            return this;
        }

        public static <T extends Comparable<T>> Builder<T> begin(Class<T> valueType) {
            if (valueType != Integer.class && valueType != Double.class) {
                throw new IllegalArgumentException();
            }
            return new Builder<T>(valueType).setDefault();
        }

        @Override
        protected Predicate<T> buildValueValidator() {
            Predicate normalValidator = super.buildValueValidator();
            return v -> {
                double maxValueDouble;
                double minValueDouble;
                double value;
                if (!normalValidator.test(v)) {
                    return false;
                }
                if (this.type == Integer.class) {
                    value = ((Integer)v).intValue();
                    minValueDouble = ((Integer)this.minValue).intValue();
                    maxValueDouble = ((Integer)this.maxValue).intValue();
                } else {
                    value = (Double)v;
                    minValueDouble = (Double)this.minValue;
                    maxValueDouble = (Double)this.maxValue;
                }
                return value >= minValueDouble && value <= maxValueDouble;
            };
        }

        @Override
        public PlayerConfigRangedOptionSpec<T> build(Map<String, PlayerConfigOptionSpec<?>> dest) {
            if (this.minValue == null || this.maxValue == null) {
                throw new IllegalStateException();
            }
            if (this.tooltipPrefix == null) {
                boolean absoluteMin = this.minValue.equals(this.getAbsoluteMin());
                boolean absoluteMax = this.maxValue.equals(this.getAbsoluteMax());
                if (!absoluteMin && !absoluteMax) {
                    this.tooltipPrefix = String.format("%s - %s", this.minValue, this.maxValue);
                } else if (!absoluteMin) {
                    this.tooltipPrefix = String.format(">= %s", this.minValue);
                } else if (!absoluteMax) {
                    this.tooltipPrefix = String.format("<= %s", this.maxValue);
                }
            }
            return (PlayerConfigRangedOptionSpec)super.build(dest);
        }

        @Override
        protected PlayerConfigRangedOptionSpec<T> buildInternally(List<String> path, String shortenedId, Function<String, T> commandInputParser) {
            return new PlayerConfigRangedOptionSpec<Comparable>(this.type, this.id, shortenedId, path, this.defaultValue, this.defaultReplacer, this.comment, this.translation, this.translationArgs, this.commentTranslation, this.commentTranslationArgs, this.category, (Function<String, Comparable>)commandInputParser, this.commandOutputWriter, this.serverSideValidator, this.clientSideValidator, (Comparable)this.minValue, (Comparable)this.maxValue, this.tooltipPrefix, this.configTypeFilter, ClientboundPlayerConfigDynamicOptionsPacket.OptionType.RANGED, this.dynamic);
        }
    }
}

