/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefullib.client.components.selection;

import com.teamresourceful.resourcefullib.client.components.selection.ListEntry;
import com.teamresourceful.resourcefullib.client.scissor.CloseableScissorStack;
import com.teamresourceful.resourcefullib.client.utils.RenderUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_362;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_6379;
import net.minecraft.class_6382;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectionList<T extends ListEntry>
extends class_362
implements class_4068,
class_6379 {
    private final List<T> entries = new ArrayList<T>();
    private final int x;
    private final int y;
    private final int width;
    private final int height;
    private final int itemHeight;
    private final Consumer<@Nullable T> onSelection;
    private final boolean relativeClicks;
    @Nullable
    private T selected;
    @Nullable
    private T hovered;
    private double scrollAmount;

    public SelectionList(int x, int y, int width, int height, int itemHeight, Consumer<@Nullable T> onSelection) {
        this(x, y, width, height, itemHeight, onSelection, false);
    }

    public SelectionList(int x, int y, int width, int height, int itemHeight, Consumer<@Nullable T> onSelection, boolean relativeClicks) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.itemHeight = itemHeight;
        this.onSelection = onSelection;
        this.relativeClicks = relativeClicks;
    }

    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTicks) {
        this.hovered = this.getEntryAtPosition(mouseX, mouseY);
        try (CloseableScissorStack scissorStack = RenderUtils.createScissor(class_310.method_1551(), graphics, this.x, this.y, this.width, this.height);){
            for (int i = 0; i < this.entries.size(); ++i) {
                int scrollY = this.y - (int)this.scrollAmount + i * this.itemHeight;
                if (scrollY + this.itemHeight < this.y || scrollY > this.y + this.height) continue;
                ListEntry entry = (ListEntry)this.entries.get(i);
                entry.render(graphics, scissorStack.stack(), i, this.x, scrollY, this.width, this.itemHeight, mouseX, mouseY, this.isHoveredItem(i), partialTicks, this.isSelectedItem(i));
            }
        }
    }

    @NotNull
    public List<T> method_25396() {
        return this.entries;
    }

    public void addEntry(@NotNull T entry) {
        this.entries.add(entry);
    }

    public boolean removeEntry(T entry) {
        boolean removed = this.entries.remove(entry);
        if (removed && entry == this.selected) {
            this.setSelected(null);
        }
        return removed;
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.selected, this.method_25396().get(index));
    }

    protected boolean isHoveredItem(int index) {
        return Objects.equals(this.hovered, this.method_25396().get(index));
    }

    @Nullable
    protected final T getEntryAtPosition(double mouseX, double mouseY) {
        if (!this.method_25405(mouseX, mouseY)) {
            return null;
        }
        int index = class_3532.method_15357((double)(this.scrollAmount + (mouseY - (double)this.y))) / this.itemHeight;
        return (T)(index < 0 || index >= this.method_25396().size() ? null : (ListEntry)this.method_25396().get(index));
    }

    public void ensureVisible(T entry) {
        int k;
        int i = (int)((double)this.y - this.scrollAmount + (double)(this.method_25396().indexOf(entry) * this.itemHeight));
        int j = i - this.y - this.itemHeight;
        if (j < 0) {
            this.setScrollAmount(this.scrollAmount + (double)j);
        }
        if ((k = this.y + this.height - i - this.itemHeight - this.itemHeight) < 0) {
            this.setScrollAmount(this.scrollAmount - (double)k);
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return mouseX <= (double)(this.x + this.width) && mouseX >= (double)this.x && mouseY <= (double)(this.y + this.height) && mouseY >= (double)this.y;
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        T entry = this.getEntryAtPosition(mouseX, mouseY);
        if (entry != null) {
            if (this.relativeClicks) {
                int scrollY = this.y - (int)this.scrollAmount + this.method_25396().indexOf(entry) * this.itemHeight;
                mouseX -= (double)this.x;
                mouseY -= (double)scrollY;
            }
            if (entry.method_25402(mouseX, mouseY, button)) {
                this.method_25395((class_364)entry);
                this.method_25398(true);
            }
            this.setSelected(entry);
            return true;
        }
        return false;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        for (int i = 0; i < this.entries.size(); ++i) {
            int scrollY = this.y - (int)this.scrollAmount + i * this.itemHeight;
            ListEntry entry = (ListEntry)this.entries.get(i);
            if (!(this.relativeClicks ? entry.method_25406(mouseX - (double)this.x, mouseY - (double)scrollY, button) : entry.method_25406(mouseX, mouseY, button))) continue;
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollAmount) {
        this.setScrollAmount(this.scrollAmount - scrollAmount * (double)this.itemHeight / 2.0);
        return true;
    }

    public boolean method_25404(int key, int point, int mod) {
        if (super.method_25404(key, point, mod)) {
            return true;
        }
        if (key == 265 || key == 264) {
            if (!this.method_25396().isEmpty()) {
                int clampedIndex;
                int index = this.method_25396().indexOf(this.selected);
                if (index == (clampedIndex = class_3532.method_15340((int)(index + (key == 265 ? -1 : 1)), (int)0, (int)(this.entries.size() - 1)))) {
                    return true;
                }
                ListEntry entry = (ListEntry)this.method_25396().get(clampedIndex);
                this.setSelected(entry);
                this.ensureVisible(entry);
            }
            return true;
        }
        return false;
    }

    public void setSelected(@Nullable T entry) {
        this.selected = entry;
        this.onSelection.accept(this.selected);
    }

    protected void setScrollAmount(double amount) {
        this.scrollAmount = class_3532.method_15350((double)amount, (double)0.0, (double)Math.max(0, this.entries.size() * this.itemHeight - this.height));
    }

    public void updateEntries(List<? extends T> entries) {
        this.scrollAmount = 0.0;
        this.selected = null;
        this.hovered = null;
        this.entries.clear();
        entries.forEach(this::addEntry);
    }

    @NotNull
    public class_6379.class_6380 method_37018() {
        return class_6379.class_6380.field_33784;
    }

    public void method_37020(@NotNull class_6382 output) {
    }

    public T getSelected() {
        return this.selected;
    }

    public T getHovered() {
        return this.hovered;
    }

    public double getScrollAmount() {
        return this.scrollAmount;
    }
}

