/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.item;

import com.google.common.base.Preconditions;
import fuzs.puzzleslib.api.core.v1.ModLoaderEnvironment;
import fuzs.puzzleslib.api.item.v2.CreativeModeTabConfigurator;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1761;
import net.minecraft.class_1772;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class CreativeModeTabConfiguratorImpl
implements CreativeModeTabConfigurator {
    private static final class_1792[] POTION_ITEMS = new class_1792[]{class_1802.field_8574, class_1802.field_8436, class_1802.field_8150, class_1802.field_8087};
    private final class_2960 identifier;
    @Nullable
    private Supplier<class_1799> icon;
    @Nullable
    private Supplier<class_1799[]> icons;
    private class_1761.class_7914 displayItemsGenerator = (itemDisplayParameters, output) -> {};
    private boolean hasSearchBar;
    private boolean appendEnchantmentsAndPotions;

    public CreativeModeTabConfiguratorImpl(class_2960 identifier) {
        this.identifier = identifier;
    }

    public class_2960 getIdentifier() {
        return this.identifier;
    }

    public Supplier<class_1799[]> getIcons() {
        return this.icons;
    }

    public boolean isHasSearchBar() {
        return this.hasSearchBar;
    }

    @Override
    public CreativeModeTabConfigurator icon(Supplier<class_1799> icon) {
        this.icon = icon;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator icons(Supplier<class_1799[]> icons) {
        this.icons = icons;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator displayItems(class_1761.class_7914 displayItemsGenerator) {
        this.displayItemsGenerator = displayItemsGenerator;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator withSearchBar() {
        this.hasSearchBar = true;
        return this;
    }

    @Override
    public CreativeModeTabConfigurator appendEnchantmentsAndPotions() {
        this.appendEnchantmentsAndPotions = true;
        return this;
    }

    public void configure(class_1761.class_7913 builder) {
        String translationKey = "itemGroup.%s.%s".formatted(this.identifier.method_12836(), this.identifier.method_12832());
        builder.method_47321((class_2561)class_2561.method_43471((String)translationKey));
        if (this.icon != null) {
            builder.method_47320(this.icon);
        } else {
            Objects.requireNonNull(this.icons, "both icon suppliers are null");
            if (!ModLoaderEnvironment.INSTANCE.isForge()) {
                builder.method_47320(() -> {
                    class_1799[] icons = this.icons.get();
                    Preconditions.checkPositionIndex((int)1, (int)icons.length, (String)"icons is empty");
                    return icons[0];
                });
            }
        }
        if (this.appendEnchantmentsAndPotions) {
            builder.method_47317((itemDisplayParameters, output) -> {
                this.displayItemsGenerator.accept(itemDisplayParameters, output);
                CreativeModeTabConfiguratorImpl.appendAllEnchantments(this.identifier.method_12836(), itemDisplayParameters.comp_1253(), arg_0 -> ((class_1761.class_7704)output).method_45420(arg_0));
                CreativeModeTabConfiguratorImpl.appendAllPotions(this.identifier.method_12836(), itemDisplayParameters.comp_1253(), arg_0 -> ((class_1761.class_7704)output).method_45420(arg_0));
            });
        } else {
            builder.method_47317(this.displayItemsGenerator);
        }
    }

    private static void appendAllEnchantments(String namespace, class_7225.class_7874 holders, Consumer<class_1799> itemStacks) {
        Comparator<class_6880.class_6883> comparator = Comparator.comparing(entry -> entry.method_40237().method_29177().method_12832());
        holders.method_46759(class_7924.field_41265).stream().flatMap(class_7225::method_42017).filter(entry -> entry.method_40237().method_29177().method_12836().equals(namespace)).sorted(comparator).map(class_6880.class_6883::comp_349).forEach(enchantment -> itemStacks.accept(class_1772.method_7808((class_1889)new class_1889(enchantment, enchantment.method_8183()))));
    }

    private static void appendAllPotions(String namespace, class_7225.class_7874 holders, Consumer<class_1799> itemStacks) {
        Comparator<class_1842> comparator = Comparator.comparing(potion -> {
            if (potion.method_8049().isEmpty()) {
                throw new IllegalArgumentException("Cannot compare potions with empty effects!");
            }
            class_1291 effect = ((class_1293)potion.method_8049().get(0)).method_5579();
            class_2960 key = class_7923.field_41174.method_10221((Object)effect);
            Objects.requireNonNull(key, "Mob effect key for class %s is null".formatted(effect.getClass()));
            return key.method_12832();
        }).thenComparingInt(potion -> ((class_1293)potion.method_8049().get(0)).method_5578()).thenComparingInt(potion -> ((class_1293)potion.method_8049().get(0)).method_5584());
        class_1842[] potions = (class_1842[])holders.method_46759(class_7924.field_41215).stream().flatMap(class_7225::method_42017).filter(entry -> entry.method_40237().method_29177().method_12836().equals(namespace)).map(class_6880.class_6883::comp_349).filter(potion -> !potion.method_8049().isEmpty()).sorted(comparator).toArray(class_1842[]::new);
        for (class_1792 item : POTION_ITEMS) {
            for (class_1842 potion2 : potions) {
                itemStacks.accept(class_1844.method_8061((class_1799)new class_1799((class_1935)item), (class_1842)potion2));
            }
        }
    }
}

