/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.client.core;

import com.google.common.collect.Lists;
import fuzs.puzzleslib.api.client.core.v1.ClientModConstructor;
import fuzs.puzzleslib.api.client.core.v1.context.BuiltinModelItemRendererContext;
import fuzs.puzzleslib.api.client.core.v1.context.CoreShadersContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicBakingCompletedContext;
import fuzs.puzzleslib.api.client.core.v1.context.DynamicModifyBakingResultContext;
import fuzs.puzzleslib.api.client.core.v1.context.ParticleProvidersContext;
import fuzs.puzzleslib.api.client.event.v1.FabricClientEvents;
import fuzs.puzzleslib.api.client.particle.v1.ClientParticleTypes;
import fuzs.puzzleslib.api.core.v1.ContentRegistrationFlags;
import fuzs.puzzleslib.api.core.v1.resources.FabricReloadListener;
import fuzs.puzzleslib.api.core.v1.resources.ForwardingReloadListenerHelper;
import fuzs.puzzleslib.api.core.v1.resources.NamedReloadListener;
import fuzs.puzzleslib.impl.PuzzlesLib;
import fuzs.puzzleslib.impl.client.core.DynamicModifyBakingResultContextImpl;
import fuzs.puzzleslib.impl.client.core.context.AdditionalModelsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockColorProvidersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockEntityRenderersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.BlockRenderTypesContextImpl;
import fuzs.puzzleslib.impl.client.core.context.BuiltinModelItemRendererContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ClientTooltipComponentsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.CoreShadersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.DynamicBakingCompletedContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.EntityRenderersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.EntitySpectatorShaderContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.FluidRenderTypesContextImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemColorProvidersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemDecorationContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ItemModelPropertiesContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.KeyMappingsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.LayerDefinitionsContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.LivingEntityRenderLayersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.MenuScreensContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ParticleProvidersContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.ResourcePackSourcesContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.SearchRegistryContextFabricImpl;
import fuzs.puzzleslib.impl.client.core.context.SkullRenderersContextFabricImpl;
import fuzs.puzzleslib.impl.client.particle.ClientParticleTypesImpl;
import fuzs.puzzleslib.impl.core.context.AddReloadListenersContextFabricImpl;
import java.util.ArrayList;
import java.util.Set;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientLifecycleEvents;
import net.fabricmc.fabric.api.client.rendering.v1.CoreShaderRegistrationCallback;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.minecraft.class_1088;
import net.minecraft.class_1092;
import net.minecraft.class_2960;
import net.minecraft.class_3264;

public final class FabricClientModConstructor {
    private FabricClientModConstructor() {
    }

    public static void construct(ClientModConstructor constructor, String modId, Set<ContentRegistrationFlags> availableFlags, Set<ContentRegistrationFlags> flagsToHandle) {
        constructor.onConstructMod();
        constructor.onClientSetup();
        constructor.onRegisterEntityRenderers(new EntityRenderersContextFabricImpl());
        constructor.onRegisterBlockEntityRenderers(new BlockEntityRenderersContextFabricImpl());
        constructor.onRegisterClientTooltipComponents(new ClientTooltipComponentsContextFabricImpl());
        FabricClientModConstructor.registerClientParticleTypesManager(modId, constructor::onRegisterParticleProviders, flagsToHandle);
        constructor.onRegisterLayerDefinitions(new LayerDefinitionsContextFabricImpl());
        constructor.onRegisterSearchTrees(new SearchRegistryContextFabricImpl());
        FabricClientModConstructor.registerModelBakingListeners(modId, constructor::onModifyBakingResult, constructor::onBakingCompleted);
        constructor.onRegisterAdditionalModels(new AdditionalModelsContextFabricImpl());
        constructor.onRegisterItemModelProperties(new ItemModelPropertiesContextFabricImpl());
        constructor.onRegisterEntitySpectatorShaders(new EntitySpectatorShaderContextFabricImpl());
        FabricClientModConstructor.registerBuiltinModelItemRenderers(modId, constructor::onRegisterBuiltinModelItemRenderers, availableFlags);
        constructor.onRegisterMenuScreens(new MenuScreensContextFabricImpl());
        constructor.onRegisterResourcePackReloadListeners(new AddReloadListenersContextFabricImpl(class_3264.field_14188, modId));
        constructor.onRegisterLivingEntityRenderLayers(new LivingEntityRenderLayersContextFabricImpl());
        constructor.onRegisterItemDecorations(new ItemDecorationContextFabricImpl());
        constructor.onRegisterSkullRenderers(new SkullRenderersContextFabricImpl());
        constructor.onRegisterKeyMappings(new KeyMappingsContextFabricImpl());
        constructor.onAddResourcePackFinders(new ResourcePackSourcesContextFabricImpl());
        FabricClientModConstructor.registerRenderProperties(constructor);
        FabricClientModConstructor.registerCoreShaders(constructor::onRegisterCoreShaders);
    }

    private static void registerModelBakingListeners(String modId, Consumer<DynamicModifyBakingResultContext> modifyBakingResultConsumer, Consumer<DynamicBakingCompletedContext> bakingCompletedConsumer) {
        FabricClientEvents.MODIFY_BAKING_RESULT.register((models, modelBakery) -> {
            try {
                modifyBakingResultConsumer.accept(new DynamicModifyBakingResultContextImpl(models, (class_1088)modelBakery.get()));
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during modify baking result phase provided by {}", (Object)modId, (Object)e);
            }
        });
        FabricClientEvents.BAKING_COMPLETED.register((modelManager, models, modelBakery) -> {
            try {
                bakingCompletedConsumer.accept(new DynamicBakingCompletedContextFabricImpl((class_1092)modelManager.get(), models, (class_1088)modelBakery.get()));
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Unable to execute additional resource pack model processing during baking completed phase provided by {}", (Object)modId, (Object)e);
            }
        });
    }

    private static void registerClientParticleTypesManager(String modId, Consumer<ParticleProvidersContext> consumer, Set<ContentRegistrationFlags> flagsToHandle) {
        consumer.accept(new ParticleProvidersContextFabricImpl());
        if (flagsToHandle.contains((Object)ContentRegistrationFlags.CLIENT_PARTICLE_TYPES)) {
            class_2960 identifier = new class_2960(modId, "client_particle_types");
            FabricReloadListener reloadListener = new FabricReloadListener(identifier, ((ClientParticleTypesImpl)ClientParticleTypes.INSTANCE).getParticleTypesManager(modId));
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)reloadListener);
        }
    }

    private static void registerBuiltinModelItemRenderers(String modId, Consumer<BuiltinModelItemRendererContext> consumer, Set<ContentRegistrationFlags> availableFlags) {
        ArrayList dynamicRenderers = Lists.newArrayList();
        consumer.accept(new BuiltinModelItemRendererContextFabricImpl(modId, dynamicRenderers));
        if (availableFlags.contains((Object)ContentRegistrationFlags.DYNAMIC_RENDERERS)) {
            class_2960 identifier = new class_2960(modId, "built_in_model_item_renderers");
            FabricReloadListener reloadListener = new FabricReloadListener((NamedReloadListener)ForwardingReloadListenerHelper.fromResourceManagerReloadListeners(identifier, dynamicRenderers));
            ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener((IdentifiableResourceReloadListener)reloadListener);
        }
    }

    private static void registerRenderProperties(ClientModConstructor constructor) {
        ClientLifecycleEvents.CLIENT_STARTED.register(client -> {
            constructor.onRegisterBlockRenderTypes(new BlockRenderTypesContextImpl());
            constructor.onRegisterFluidRenderTypes(new FluidRenderTypesContextImpl());
            constructor.onRegisterBlockColorProviders(new BlockColorProvidersContextFabricImpl());
            constructor.onRegisterItemColorProviders(new ItemColorProvidersContextFabricImpl());
        });
    }

    private static void registerCoreShaders(Consumer<CoreShadersContext> modifyBakingResultConsumer) {
        CoreShaderRegistrationCallback.EVENT.register(context -> modifyBakingResultConsumer.accept(new CoreShadersContextFabricImpl(context)));
    }
}

