/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.init.v3;

import fuzs.puzzleslib.api.core.v1.CommonAbstractions;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_5712;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public final class RegistryHelper {
    private RegistryHelper() {
    }

    public static <T> class_2378<T> findRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        return RegistryHelper.findRegistry(registryKey, false);
    }

    public static <T> class_2378<T> findBuiltInRegistry(class_5321<? extends class_2378<? super T>> registryKey) {
        return RegistryHelper.findRegistry(registryKey, true);
    }

    private static <T> class_2378<T> findRegistry(class_5321<? extends class_2378<? super T>> registryKey, boolean onlyBuiltIn) {
        MinecraftServer minecraftServer;
        Objects.requireNonNull(registryKey, "registry key is null");
        Optional registry = Optional.empty();
        if (!onlyBuiltIn && (minecraftServer = CommonAbstractions.INSTANCE.getMinecraftServer()) != null) {
            registry = minecraftServer.method_30611().method_33310(registryKey);
        }
        if (registry.isEmpty()) {
            registry = class_7923.field_41167.method_31189(registryKey);
        }
        return (class_2378)registry.orElseThrow(() -> new IllegalArgumentException("Registry for key %s not found".formatted(registryKey)));
    }

    public static <T> Optional<class_5321<T>> getResourceKey(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.findRegistry(registryKey).method_29113(object);
    }

    public static <T> class_5321<T> getResourceKeyOrThrow(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.getResourceKey(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> Optional<class_6880.class_6883<T>> getHolder(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        class_2378<T> registry = RegistryHelper.findRegistry(registryKey);
        return registry.method_29113(object).flatMap(arg_0 -> registry.method_40264(arg_0));
    }

    public static <T> class_6880.class_6883<T> getHolderOrThrow(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.getHolder(registryKey, object).orElseThrow(() -> new IllegalStateException("Missing object in " + String.valueOf(registryKey) + ": " + String.valueOf(object)));
    }

    public static <T> class_6880<T> wrapAsHolder(class_5321<? extends class_2378<? super T>> registryKey, T object) {
        return RegistryHelper.findRegistry(registryKey).method_47983(object);
    }

    public static <T> boolean is(class_6862<T> tagKey, T object) {
        if (object instanceof class_2248) {
            class_2248 block = (class_2248)object;
            return block.method_40142().method_40220(tagKey);
        }
        if (object instanceof class_1792) {
            class_1792 item = (class_1792)object;
            return item.method_40131().method_40220(tagKey);
        }
        if (object instanceof class_1299) {
            class_1299 entityType = (class_1299)object;
            return entityType.method_40124().method_40220(tagKey);
        }
        if (object instanceof class_5712) {
            class_5712 gameEvent = (class_5712)object;
            return gameEvent.method_40157().method_40220(tagKey);
        }
        if (object instanceof class_3611) {
            class_3611 fluid = (class_3611)object;
            return fluid.method_40178().method_40220(tagKey);
        }
        class_2378<T> registry = RegistryHelper.findRegistry(tagKey.comp_326());
        return tagKey.method_41007(registry.method_30517()) && registry.method_47983(object).method_40220(tagKey);
    }
}

