/*
 * Decompiled with CFR 0.152.
 */
package pyzpre.createbicyclesbitterballen.compat.jei;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.compat.jei.category.animations.AnimatedBlazeBurner;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.content.processing.recipe.HeatCondition;
import com.simibubi.create.content.processing.recipe.ProcessingOutput;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import com.simibubi.create.foundation.item.ItemHelper;
import com.simibubi.create.foundation.utility.Lang;
import com.simibubi.create.foundation.utility.Pair;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import mezz.jei.api.fabric.constants.FabricTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import org.apache.commons.lang3.mutable.MutableInt;
import pyzpre.createbicyclesbitterballen.block.mechanicalfryer.DeepFryingRecipe;
import pyzpre.createbicyclesbitterballen.compat.jei.animations.AnimatedFryer;

@ParametersAreNonnullByDefault
public class FryingCategory
extends CreateRecipeCategory<DeepFryingRecipe> {
    private final AnimatedFryer fryer = new AnimatedFryer();
    private final AnimatedBlazeBurner heater = new AnimatedBlazeBurner();
    FryingType type;

    public void setRecipe(IRecipeLayoutBuilder builder, DeepFryingRecipe recipe, IFocusGroup focuses) {
        List condensedIngredients = ItemHelper.condenseIngredients((class_2371)recipe.method_8117());
        int size = condensedIngredients.size() + recipe.getFluidIngredients().size();
        int xOffset = size < 3 ? (3 - size) * 19 / 2 : 0;
        int i = 0;
        for (Pair pair : condensedIngredients) {
            ArrayList<class_1799> stacks = new ArrayList<class_1799>();
            for (class_1799 itemStack : ((class_1856)pair.getFirst()).method_8105()) {
                class_1799 copy = itemStack.method_7972();
                copy.method_7939(((MutableInt)pair.getSecond()).getValue().intValue());
                stacks.add(copy);
            }
            builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 51 - i / 3 * 19).setBackground(FryingCategory.getRenderedSlot(), -1, -1).addItemStacks(stacks);
            ++i;
        }
        for (FluidIngredient fluidIngredient : recipe.getFluidIngredients()) {
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.INPUT, 17 + xOffset + i % 3 * 19, 51 - i / 3 * 19).setBackground(FryingCategory.getRenderedSlot(), -1, -1).addIngredients((IIngredientType)FabricTypes.FLUID_STACK, FryingCategory.toJei((List)FryingCategory.withImprovedVisibility((List)fluidIngredient.getMatchingFluidStacks())))).addTooltipCallback(FryingCategory.addFluidTooltip((long)fluidIngredient.getRequiredAmount()));
            ++i;
        }
        size = recipe.getRollableResults().size() + recipe.getFluidResults().size();
        i = 0;
        for (ProcessingOutput result : recipe.getRollableResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(FryingCategory.getRenderedSlot((ProcessingOutput)result), -1, -1).addItemStack(result.getStack())).addTooltipCallback(FryingCategory.addStochasticTooltip((ProcessingOutput)result));
            ++i;
        }
        for (FluidStack fluidResult : recipe.getFluidResults()) {
            int xPosition = 142 - (size % 2 != 0 && i == size - 1 ? 0 : (i % 2 == 0 ? 10 : -9));
            int yPosition = -19 * (i / 2) + 51;
            ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, xPosition, yPosition).setBackground(FryingCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)FabricTypes.FLUID_STACK, (Object)FryingCategory.toJei((FluidStack)FryingCategory.withImprovedVisibility((FluidStack)fluidResult)))).addTooltipCallback(FryingCategory.addFluidTooltip((long)fluidResult.getAmount()));
            ++i;
        }
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.NONE)) {
            builder.addSlot(RecipeIngredientRole.RENDER_ONLY, 134, 81).addItemStack(AllBlocks.BLAZE_BURNER.asStack());
        }
        if (!requiredHeat.testBlazeBurner(BlazeBurnerBlock.HeatLevel.KINDLED)) {
            builder.addSlot(RecipeIngredientRole.CATALYST, 153, 81).addItemStack(AllItems.BLAZE_CAKE.asStack());
        }
    }

    public static FryingCategory standard(CreateRecipeCategory.Info<DeepFryingRecipe> info) {
        return new FryingCategory(info, FryingType.FRYING);
    }

    protected FryingCategory(CreateRecipeCategory.Info<DeepFryingRecipe> info, FryingType type) {
        super(info);
        this.type = type;
    }

    public void draw(DeepFryingRecipe recipe, IRecipeSlotsView iRecipeSlotsView, class_332 graphics, double mouseX, double mouseY) {
        super.draw((Object)recipe, iRecipeSlotsView, graphics, mouseX, mouseY);
        HeatCondition requiredHeat = recipe.getRequiredHeat();
        boolean noHeat = requiredHeat == HeatCondition.NONE;
        int vRows = (1 + recipe.getFluidResults().size() + recipe.getRollableResults().size()) / 2;
        if (vRows <= 2) {
            AllGuiTextures.JEI_DOWN_ARROW.render(graphics, 136, -19 * (vRows - 1) + 32);
        }
        AllGuiTextures shadow = noHeat ? AllGuiTextures.JEI_SHADOW : AllGuiTextures.JEI_LIGHT;
        shadow.render(graphics, 81, 58 + (noHeat ? 10 : 30));
        AllGuiTextures heatBar = noHeat ? AllGuiTextures.JEI_NO_HEAT_BAR : AllGuiTextures.JEI_HEAT_BAR;
        heatBar.render(graphics, 4, 80);
        graphics.method_51439(class_310.method_1551().field_1772, (class_2561)Lang.translateDirect((String)requiredHeat.getTranslationKey(), (Object[])new Object[0]), 9, 86, requiredHeat.getColor(), false);
        if (!noHeat) {
            this.heater.withHeat(requiredHeat.visualizeAsBlazeBurner()).draw(graphics, this.getBackground().getWidth() / 2 + 3, 55);
        }
        this.fryer.draw(graphics, this.getBackground().getWidth() / 2 + 3, 34);
    }

    static enum FryingType {
        FRYING;

    }
}

