/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity.layer;

import com.iafenvoy.iceandfire.entity.EntityHydra;
import com.iafenvoy.iceandfire.render.entity.RenderHydra;
import com.iafenvoy.iceandfire.render.model.ModelHydraBody;
import com.iafenvoy.iceandfire.render.model.ModelHydraHead;
import com.iafenvoy.uranus.client.model.AdvancedModelBox;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7833;
import net.minecraft.class_922;

public class LayerHydraHead
extends class_3887<EntityHydra, ModelHydraBody> {
    public static final class_2960 TEXTURE_STONE = class_2960.method_43902((String)"iceandfire", (String)"textures/models/hydra/stone.png");
    private static final float[][] TRANSLATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.15f, 0.15f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.3f, 0.0f, 0.3f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.4f, -0.1f, 0.1f, 0.4f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.5f, -0.2f, 0.0f, 0.2f, 0.5f, 0.0f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f, 0.0f}, {-0.7f, -0.4f, -0.2f, 0.0f, 0.2f, 0.4f, 0.7f, 0.0f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.1f, 0.2f, 0.4f, 0.6f, 0.0f}, {-0.6f, -0.4f, -0.2f, -0.1f, 0.0f, 0.1f, 0.2f, 0.4f, 0.6f}};
    private static final float[][] ROTATE = new float[][]{{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {10.0f, 0.0f, -10.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {25.0f, 10.0f, -10.0f, -25.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {30.0f, 15.0f, 0.0f, -15.0f, -30.0f, 0.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 25.0f, 5.0f, -5.0f, -25.0f, -40.0f, 0.0f, 0.0f, 0.0f}, {40.0f, 30.0f, 15.0f, 0.0f, -15.0f, -30.0f, -40.0f, 0.0f, 0.0f}, {45.0f, 30.0f, 20.0f, 5.0f, -5.0f, -20.0f, -30.0f, -45.0f, 0.0f}, {50.0f, 37.0f, 25.0f, 15.0f, 0.0f, -15.0f, -25.0f, -37.0f, -50.0f}};
    private static final ModelHydraHead[] modelArr = new ModelHydraHead[9];
    private final RenderHydra renderer;

    public LayerHydraHead(RenderHydra renderer) {
        super((class_3883)renderer);
        this.renderer = renderer;
    }

    public static void renderHydraHeads(ModelHydraBody model, boolean stone, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, EntityHydra hydra, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        matrixStackIn.method_22903();
        int heads = hydra.getHeadCount();
        LayerHydraHead.translateToBody(model, matrixStackIn);
        class_1921 type = class_1921.method_23576((class_2960)(stone ? TEXTURE_STONE : LayerHydraHead.getHeadTexture(hydra)));
        for (int head = 1; head <= heads; ++head) {
            matrixStackIn.method_22903();
            float bodyWidth = 0.5f;
            matrixStackIn.method_46416(TRANSLATE[heads - 1][head - 1] * bodyWidth, 0.0f, 0.0f);
            matrixStackIn.method_22907(class_7833.field_40716.rotationDegrees(ROTATE[heads - 1][head - 1]));
            modelArr[head - 1].setAngles(hydra, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            modelArr[head - 1].method_2828(matrixStackIn, bufferIn.getBuffer(type), packedLightIn, class_922.method_23622((class_1309)hydra, (float)0.0f), 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStackIn.method_22909();
        }
        matrixStackIn.method_22909();
    }

    public static class_2960 getHeadTexture(EntityHydra gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> RenderHydra.TEXUTURE_1;
            case 2 -> RenderHydra.TEXUTURE_2;
            default -> RenderHydra.TEXUTURE_0;
        };
    }

    protected static void translateToBody(ModelHydraBody model, class_4587 stack) {
        LayerHydraHead.postRender(model.BodyUpper, stack);
    }

    protected static void postRender(AdvancedModelBox renderer, class_4587 matrixStackIn) {
        if (renderer.rotateAngleX == 0.0f && renderer.rotateAngleY == 0.0f && renderer.rotateAngleZ == 0.0f) {
            if (renderer.rotationPointX != 0.0f || renderer.rotationPointY != 0.0f) {
                matrixStackIn.method_46416(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            }
        } else {
            matrixStackIn.method_46416(renderer.rotationPointX * 0.0625f, renderer.rotationPointY * 0.0625f, renderer.rotateAngleZ * 0.0625f);
            if (renderer.rotateAngleZ != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40718.rotation(renderer.rotateAngleZ));
            }
            if (renderer.rotateAngleY != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40716.rotation(renderer.rotateAngleY));
            }
            if (renderer.rotateAngleX != 0.0f) {
                matrixStackIn.method_22907(class_7833.field_40714.rotation(renderer.rotateAngleX));
            }
        }
    }

    public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, EntityHydra entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        if (entity.method_5767()) {
            return;
        }
        LayerHydraHead.renderHydraHeads((ModelHydraBody)this.renderer.method_4038(), false, matrixStackIn, bufferIn, packedLightIn, entity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
    }

    public class_2960 getTexture(EntityHydra gorgon) {
        return switch (gorgon.getVariant()) {
            case 1 -> RenderHydra.TEXUTURE_1;
            case 2 -> RenderHydra.TEXUTURE_2;
            default -> RenderHydra.TEXUTURE_0;
        };
    }

    static {
        for (int i = 0; i < modelArr.length; ++i) {
            LayerHydraHead.modelArr[i] = new ModelHydraHead(i);
        }
    }
}

