/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.render.entity;

import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import com.iafenvoy.iceandfire.entity.EntityLightningDragon;
import com.iafenvoy.iceandfire.particle.LightningBoltData;
import com.iafenvoy.iceandfire.particle.LightningRender;
import com.iafenvoy.iceandfire.render.entity.RenderDragonBase;
import com.iafenvoy.uranus.client.model.TabulaModel;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4604;
import net.minecraft.class_5617;

public class RenderLightningDragon
extends RenderDragonBase {
    private final LightningRender lightningRender = new LightningRender();

    public RenderLightningDragon(class_5617.class_5618 context, TabulaModel modelSupplier, int dragonType) {
        super(context, (TabulaModel<EntityDragonBase>)modelSupplier);
    }

    private static float getBoundedScale(float scale) {
        return 0.5f + scale * 1.5f;
    }

    public boolean shouldRender(EntityDragonBase livingEntityIn, class_4604 camera, double camX, double camY, double camZ) {
        if (super.method_4068((class_1308)livingEntityIn, camera, camX, camY, camZ)) {
            return true;
        }
        EntityLightningDragon lightningDragon = (EntityLightningDragon)livingEntityIn;
        if (lightningDragon.hasLightningTarget()) {
            class_243 Vector3d1 = lightningDragon.getHeadPosition();
            class_243 Vector3d = new class_243((double)lightningDragon.getLightningTargetX(), (double)lightningDragon.getLightningTargetY(), (double)lightningDragon.getLightningTargetZ());
            return camera.method_23093(new class_238(Vector3d1.field_1352, Vector3d1.field_1351, Vector3d1.field_1350, Vector3d.field_1352, Vector3d.field_1351, Vector3d.field_1350));
        }
        return false;
    }

    public void render(EntityDragonBase entityIn, float entityYaw, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        super.method_4072((class_1308)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        EntityLightningDragon lightningDragon = (EntityLightningDragon)entityIn;
        matrixStackIn.method_22903();
        if (lightningDragon.hasLightningTarget()) {
            assert (class_310.method_1551().field_1724 != null);
            double dist = class_310.method_1551().field_1724.method_5739((class_1297)lightningDragon);
            if (dist <= (double)Math.max(256.0f, (float)((Integer)class_310.method_1551().field_1690.method_42503().method_41753()).intValue() * 16.0f)) {
                class_243 Vector3d1 = lightningDragon.getHeadPosition();
                class_243 Vector3d = new class_243((double)lightningDragon.getLightningTargetX(), (double)lightningDragon.getLightningTargetY(), (double)lightningDragon.getLightningTargetZ());
                float energyScale = 0.4f * lightningDragon.method_17825();
                LightningBoltData bolt = new LightningBoltData(LightningBoltData.BoltRenderInfo.ELECTRICITY, Vector3d1, Vector3d, 15).size(0.05f * RenderLightningDragon.getBoundedScale(energyScale)).lifespan(4).spawn(LightningBoltData.SpawnFunction.NO_DELAY);
                this.lightningRender.update(null, bolt, partialTicks);
                matrixStackIn.method_22904(-lightningDragon.method_23317(), -lightningDragon.method_23318(), -lightningDragon.method_23321());
                this.lightningRender.render(partialTicks, matrixStackIn, bufferIn);
            }
        }
        matrixStackIn.method_22909();
    }
}

