/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.item;

import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.entity.EntityDragonBase;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1814;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_4051;
import net.minecraft.class_5250;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class ItemDragonSeeker
extends class_1792 {
    private final SeekerType type;

    public ItemDragonSeeker(SeekerType type) {
        super(new class_1792.class_1793().method_7889(1).method_7894(class_1814.field_8903));
        this.type = type;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        if (world.field_9236) {
            return super.method_7836(world, user, hand);
        }
        if (!((Boolean)IafCommonConfig.INSTANCE.misc.enableDragonSeeker.getValue()).booleanValue()) {
            user.method_7353((class_2561)class_2561.method_43471((String)"text.iceandfire.not_enable"), false);
            return super.method_7836(world, user, hand);
        }
        class_1799 stack = user.method_5998(hand);
        EntityDragonBase dragon = (EntityDragonBase)world.method_21726(EntityDragonBase.class, class_4051.method_36625().method_18420(entity -> {
            if (!(entity instanceof EntityDragonBase)) {
                return false;
            }
            EntityDragonBase d = (EntityDragonBase)entity;
            if (d.isMobDead() && !this.type.trackDead) {
                return false;
            }
            return !d.method_6181() || this.type.trackTeamed;
        }), (class_1309)user, user.method_23317(), user.method_23318(), user.method_23321(), new class_238(this.type.add(user.method_19538(), true), this.type.add(user.method_19538(), false)));
        if (dragon == null) {
            user.method_43496((class_2561)class_2561.method_43471((String)"item.iceandfire.dragon_seeker.not_found"));
            return class_1271.method_22431((Object)stack);
        }
        if (this.type.admin) {
            String pos1 = String.format("[%d, %d, %d]", (int)dragon.method_23317(), (int)dragon.method_23318(), (int)dragon.method_23321());
            String pos2 = String.format("/tp @s %d %d %d", (int)dragon.method_23317(), (int)dragon.method_23318(), (int)dragon.method_23321());
            class_5250 locationText = class_2561.method_43470((String)pos1).method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_10958(new class_2558(class_2558.class_2559.field_11745, pos2)).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"chat.coordinates.tooltip"))));
            user.method_43496((class_2561)class_2561.method_43471((String)"item.iceandfire.dragon_seeker.found_location").method_10852((class_2561)locationText));
        } else {
            user.method_43496((class_2561)class_2561.method_43471((String)"item.iceandfire.dragon_seeker.found"));
        }
        return class_1271.method_22427((Object)stack);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        super.method_7851(stack, world, tooltip, context);
        String name = class_7923.field_41178.method_10221((Object)this).method_12832();
        tooltip.add((class_2561)class_2561.method_43471((String)("item.iceandfire." + name + ".tooltip")));
        tooltip.add((class_2561)class_2561.method_43471((String)"item.iceandfire.dragon_seeker.credit").method_10862(class_2583.field_24360.method_10977(class_124.field_1080).method_10978(Boolean.valueOf(true))));
    }

    public static enum SeekerType {
        NORMAL(150, true, true, false),
        EPIC(200, false, true, false),
        LEGENDARY(300, false, false, false),
        GODLY(500, false, false, true);

        private final int trackRange;
        private final boolean trackDead;
        private final boolean trackTeamed;
        private final boolean admin;

        private SeekerType(int trackRange, boolean trackDead, boolean trackTeamed, boolean admin) {
            this.trackRange = trackRange;
            this.trackDead = trackDead;
            this.trackTeamed = trackTeamed;
            this.admin = admin;
        }

        public class_243 add(class_243 origin, boolean reverse) {
            int range = this.trackRange;
            if (reverse) {
                range *= -1;
            }
            return origin.method_1031((double)range, (double)range, (double)range);
        }
    }
}

