/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.google.common.base.Predicate;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.ai.AquaticAIGetInWater;
import com.iafenvoy.iceandfire.entity.ai.AquaticAIGetOutOfWater;
import com.iafenvoy.iceandfire.entity.ai.SirenAIFindWaterTarget;
import com.iafenvoy.iceandfire.entity.ai.SirenAIWander;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IHearsSiren;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafParticles;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import java.util.List;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1335;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1412;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3959;
import net.minecraft.class_3988;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5766;
import net.minecraft.class_7;

public class EntitySiren
extends class_1588
implements IAnimatedEntity,
IVillagerFear,
IHasCustomizableAttributes {
    public static final int SEARCH_RANGE = 32;
    public static final Predicate<class_1297> SIREN_PREY = p_apply_1_ -> p_apply_1_ instanceof class_1657 && !((class_1657)p_apply_1_).method_7337() && !p_apply_1_.method_7325() || p_apply_1_ instanceof class_3988 || p_apply_1_ instanceof IHearsSiren;
    public static final Animation ANIMATION_BITE = Animation.create((int)20);
    public static final Animation ANIMATION_PULL = Animation.create((int)20);
    private static final class_2940<Integer> HAIR_COLOR = class_2945.method_12791(EntitySiren.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> AGGRESSIVE = class_2945.method_12791(EntitySiren.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> SING_POSE = class_2945.method_12791(EntitySiren.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> SINGING = class_2945.method_12791(EntitySiren.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> SWIMMING = class_2945.method_12791(EntitySiren.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> CHARMED = class_2945.method_12791(EntitySiren.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Byte> CLIMBING = class_2945.method_12791(EntitySiren.class, (class_2941)class_2943.field_13319);
    public ChainBuffer tail_buffer;
    public float singProgress;
    public float swimProgress;
    public int singCooldown;
    private int animationTick;
    private Animation currentAnimation;
    private boolean isSinging;
    private boolean isSwimming;
    private boolean isLandNavigator;
    private int ticksAgressive;

    public EntitySiren(class_1299<EntitySiren> t, class_1937 worldIn) {
        super(t, worldIn);
        this.switchNavigator(true);
        if (worldIn.field_9236) {
            this.tail_buffer = new ChainBuffer();
        }
        this.method_49477(1.0f);
    }

    public static boolean isWearingEarplugs(class_1309 entity) {
        class_1799 helmet = entity.method_6118(class_1304.field_6169);
        return helmet.method_7909() == IafItems.EARPLUGS.get() || helmet != class_1799.field_8037 && helmet.method_31574((class_1792)IafItems.EARPLUGS.get());
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, ((Double)IafCommonConfig.INSTANCE.siren.maxHealth.getValue()).doubleValue()).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23721, 6.0);
    }

    public static float updateRotation(float angle, float targetAngle, float maxIncrease) {
        float f = class_3532.method_15393((float)(targetAngle - angle));
        return angle + class_3532.method_15363((float)f, (float)(-maxIncrease), (float)maxIncrease);
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new SirenAIFindWaterTarget(this));
        this.field_6201.method_6277(1, (class_1352)new AquaticAIGetInWater((class_1308)this, 1.0));
        this.field_6201.method_6277(1, (class_1352)new AquaticAIGetOutOfWater((class_1308)this, 1.0));
        this.field_6201.method_6277(2, (class_1352)new SirenAIWander(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(3, (class_1352)new class_1366((class_1314)this, 1.0, false));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f, 1.0f));
        this.field_6185.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_1657.class, 10, true, false, entity -> {
            if (!(entity instanceof class_1657)) return false;
            class_1657 player = (class_1657)entity;
            if (!this.isAgressive()) return false;
            if (player.method_7337()) return false;
            if (player.method_7325()) return false;
            return true;
        }));
        this.field_6185.method_6277(4, (class_1352)new class_1400((class_1308)this, class_3988.class, 10, true, false, entity -> this.isAgressive()));
    }

    public int method_6110() {
        return 8;
    }

    public float method_6149(class_2338 pos) {
        return this.method_37908().method_8320(pos).method_27852(class_2246.field_10382) ? 10.0f : super.method_6149(pos);
    }

    public boolean method_6121(class_1297 entityIn) {
        if (this.method_6051().method_43048(2) == 0) {
            if (this.getAnimation() != ANIMATION_PULL) {
                this.setAnimation(ANIMATION_PULL);
                this.method_5783((class_3414)IafSounds.NAGA_ATTACK.get(), 1.0f, 1.0f);
            }
        } else if (this.getAnimation() != ANIMATION_BITE) {
            this.setAnimation(ANIMATION_BITE);
            this.method_5783((class_3414)IafSounds.NAGA_ATTACK.get(), 1.0f, 1.0f);
        }
        return true;
    }

    public boolean isDirectPathBetweenPoints(class_243 vec1, class_243 pos) {
        class_243 Vector3d1 = new class_243(pos.method_10216() + 0.5, pos.method_10214() + 0.5, pos.method_10215() + 0.5);
        return this.method_37908().method_17742(new class_3959(vec1, Vector3d1, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this)).method_17783() == class_239.class_240.field_1333;
    }

    public float method_5944(class_7 nodeType) {
        return nodeType == class_7.field_18 ? 0.0f : super.method_5944(nodeType);
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_6207 = new class_1335((class_1308)this);
            this.field_6189 = new class_5766((class_1308)this, this.method_37908());
            this.isLandNavigator = true;
        } else {
            this.field_6207 = new SwimmingMoveHelper();
            this.field_6189 = new class_1412((class_1308)this, this.method_37908());
            this.isLandNavigator = false;
        }
    }

    private boolean isPathOnHighGround() {
        if (this.field_6189 != null && this.field_6189.method_6345() != null && this.field_6189.method_6345().method_45() != null) {
            class_2338 target = new class_2338(this.field_6189.method_6345().method_45().field_40, this.field_6189.method_6345().method_45().field_39, this.field_6189.method_6345().method_45().field_38);
            class_2338 siren = this.method_24515();
            return this.method_37908().method_22347(siren.method_10084()) && this.method_37908().method_22347(target.method_10084()) && target.method_10264() >= siren.method_10264();
        }
        return false;
    }

    public boolean method_6094() {
        return true;
    }

    public void method_6007() {
        boolean singing;
        class_1657 player;
        boolean pathOnHighGround;
        super.method_6007();
        this.field_6283 = this.method_36454();
        class_1309 attackTarget = this.method_5968();
        if (this.singCooldown > 0) {
            --this.singCooldown;
            this.setSinging(false);
        }
        if (!this.method_37908().field_9236 && attackTarget == null && !this.isAgressive()) {
            this.setSinging(true);
        }
        if (this.getAnimation() == ANIMATION_BITE && attackTarget != null && this.method_5858((class_1297)attackTarget) < 7.0 && this.getAnimationTick() == 5) {
            attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194());
        }
        if (this.getAnimation() == ANIMATION_PULL && attackTarget != null && this.method_5858((class_1297)attackTarget) < 16.0 && this.getAnimationTick() == 5) {
            attackTarget.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)this.method_5996(class_5134.field_23721).method_6194());
            double attackmotionX = (Math.signum(this.method_23317() - attackTarget.method_23317()) * 0.5 - attackTarget.method_18798().field_1350) * 0.100000000372529 * 5.0;
            double attackmotionY = (Math.signum(this.method_23318() - attackTarget.method_23318() + 1.0) * 0.5 - attackTarget.method_18798().field_1351) * 0.100000000372529 * 5.0;
            double attackmotionZ = (Math.signum(this.method_23321() - attackTarget.method_23321()) * 0.5 - attackTarget.method_18798().field_1350) * 0.100000000372529 * 5.0;
            attackTarget.method_18799(attackTarget.method_18798().method_1031(attackmotionX, attackmotionY, attackmotionZ));
            double d0 = this.method_23317() - attackTarget.method_23317();
            double d2 = this.method_23321() - attackTarget.method_23321();
            double d1 = this.method_23318() - 1.0 - attackTarget.method_23318();
            double d3 = Math.sqrt((float)(d0 * d0 + d2 * d2));
            float f = (float)(class_3532.method_15349((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float f1 = (float)(-(class_3532.method_15349((double)d1, (double)d3) * 57.29577951308232));
            attackTarget.method_36457(EntitySiren.updateRotation(attackTarget.method_36455(), f1, 30.0f));
            attackTarget.method_36456(EntitySiren.updateRotation(attackTarget.method_36454(), f, 30.0f));
        }
        if (this.method_37908().field_9236) {
            this.tail_buffer.calculateChainSwingBuffer(40.0f, 10, 2.5f, (class_1309)this);
        }
        this.ticksAgressive = this.isAgressive() ? ++this.ticksAgressive : 0;
        if (this.ticksAgressive > 300 && this.isAgressive() && attackTarget == null && !this.method_37908().field_9236) {
            this.method_19540(false);
            this.ticksAgressive = 0;
            this.setSinging(false);
        }
        if (this.method_5799() && !this.method_5681()) {
            this.method_5796(true);
        }
        if (!this.method_5799() && this.method_5681()) {
            this.method_5796(false);
        }
        class_1309 target = this.method_5968();
        boolean bl = pathOnHighGround = this.isPathOnHighGround() || !this.method_37908().field_9236 && target != null && !target.method_5799();
        if ((target == null || !target.method_5799() && !target.method_5799()) && pathOnHighGround && this.method_5799()) {
            this.method_6043();
            this.method_5746();
        }
        if (this.method_5799() && !pathOnHighGround && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!(this.method_5799() && !pathOnHighGround || this.isLandNavigator)) {
            this.switchNavigator(true);
        }
        if (target instanceof class_1657 && (player = (class_1657)target).method_7337()) {
            this.method_5980(null);
            this.method_19540(false);
        }
        if (target != null && !this.isAgressive()) {
            this.method_19540(true);
        }
        boolean bl2 = singing = this.isActuallySinging() && !this.isAgressive() && !this.method_5799() && this.method_24828();
        if (singing && this.singProgress < 20.0f) {
            this.singProgress += 1.0f;
        } else if (!singing && this.singProgress > 0.0f) {
            this.singProgress -= 1.0f;
        }
        boolean swimming = this.method_5681();
        if (swimming && this.swimProgress < 20.0f) {
            this.swimProgress += 1.0f;
        } else if (!swimming && this.swimProgress > 0.0f) {
            this.swimProgress -= 0.5f;
        }
        if (!this.method_37908().field_9236 && !EntityGorgon.isStoneMob((class_1309)this) && this.isActuallySinging()) {
            this.updateLure();
            this.checkForPrey();
        }
        if (!this.method_37908().field_9236 && EntityGorgon.isStoneMob((class_1309)this) && this.isSinging()) {
            this.setSinging(false);
        }
        if (this.isActuallySinging() && !this.method_5799() && this.method_6051().method_43048(3) == 0) {
            this.field_6283 = this.method_36454();
            if (this.method_37908().field_9236) {
                float radius = -0.9f;
                float angle = (float)Math.PI / 180 * this.field_6283 - 3.0f;
                double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
                double extraY = 1.2f;
                double extraZ = radius * class_3532.method_15362((float)angle);
                this.method_37908().method_8406((class_2394)IafParticles.SIREN_MUSIC.get(), this.method_23317() + extraX + (double)this.field_5974.method_43057() - 0.5, this.method_23318() + extraY + (double)this.field_5974.method_43057() - 0.5, this.method_23321() + extraZ + (double)this.field_5974.method_43057() - 0.5, 0.0, 0.0, 0.0);
            }
        }
        if (this.isActuallySinging() && !this.method_5799() && this.field_6012 % 200 == 0) {
            this.method_5783((class_3414)IafSounds.SIREN_SONG.get(), 2.0f, 1.0f);
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
    }

    private void checkForPrey() {
        this.setSinging(true);
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5529() != null && source.method_5529() instanceof class_1309) {
            this.triggerOtherSirens((class_1309)source.method_5529());
        }
        return super.method_5643(source, amount);
    }

    public void triggerOtherSirens(class_1309 aggressor) {
        List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1009(12.0, 12.0, 12.0));
        for (class_1297 entity : entities) {
            if (!(entity instanceof EntitySiren)) continue;
            EntitySiren siren = (EntitySiren)entity;
            siren.method_5980(aggressor);
            siren.method_19540(true);
            siren.setSinging(false);
        }
    }

    public void updateLure() {
        if (this.field_6012 % 20 == 0) {
            List entities = this.method_37908().method_8390(class_1309.class, this.method_5829().method_1009(50.0, 12.0, 50.0), SIREN_PREY);
            for (class_1309 entity : entities) {
                if (EntitySiren.isWearingEarplugs(entity)) continue;
                IafEntityData data = IafEntityData.get(entity);
                if (!data.sirenData.isCharmed && data.sirenData.charmedBy != null) continue;
                data.sirenData.setCharmed((class_1297)this);
            }
        }
    }

    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("HairColor", this.getHairColor());
        tag.method_10556("Aggressive", this.isAgressive());
        tag.method_10569("SingingPose", this.getSingingPose());
        tag.method_10556("Singing", this.isSinging());
        tag.method_10556("Swimming", this.method_5681());
        tag.method_10556("Passive", this.isCharmed());
    }

    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.setHairColor(tag.method_10550("HairColor"));
        this.method_19540(tag.method_10577("Aggressive"));
        this.setSingingPose(tag.method_10550("SingingPose"));
        this.setSinging(tag.method_10577("Singing"));
        this.method_5796(tag.method_10577("Swimming"));
        this.setCharmed(tag.method_10577("Passive"));
        this.setConfigurableAttributes();
    }

    public boolean isSinging() {
        this.isSinging = (Boolean)this.field_6011.method_12789(SINGING);
        return this.isSinging;
    }

    public void setSinging(boolean singing) {
        if (this.singCooldown > 0) {
            singing = false;
        }
        this.field_6011.method_12778(SINGING, (Object)singing);
        this.isSinging = singing;
    }

    public boolean wantsToSing() {
        return this.isSinging() && this.method_5799() && !this.isAgressive();
    }

    public boolean isActuallySinging() {
        return this.isSinging() && !this.wantsToSing();
    }

    public boolean method_5681() {
        if (this.method_37908().field_9236) {
            this.isSwimming = (Boolean)this.field_6011.method_12789(SWIMMING);
            return this.isSwimming;
        }
        return this.isSwimming;
    }

    public void method_5796(boolean swimming) {
        this.field_6011.method_12778(SWIMMING, (Object)swimming);
        if (!this.method_37908().field_9236) {
            this.isSwimming = swimming;
        }
    }

    public void method_19540(boolean aggressive) {
        this.field_6011.method_12778(AGGRESSIVE, (Object)aggressive);
    }

    public boolean isAgressive() {
        return (Boolean)this.field_6011.method_12789(AGGRESSIVE);
    }

    public boolean isCharmed() {
        return (Boolean)this.field_6011.method_12789(CHARMED);
    }

    public void setCharmed(boolean aggressive) {
        this.field_6011.method_12778(CHARMED, (Object)aggressive);
    }

    public int getHairColor() {
        return (Integer)this.field_6011.method_12789(HAIR_COLOR);
    }

    public void setHairColor(int hairColor) {
        this.field_6011.method_12778(HAIR_COLOR, (Object)hairColor);
    }

    public int getSingingPose() {
        return (Integer)this.field_6011.method_12789(SING_POSE);
    }

    public void setSingingPose(int pose) {
        this.field_6011.method_12778(SING_POSE, (Object)class_3532.method_15340((int)pose, (int)0, (int)2));
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23716).method_6192(((Double)IafCommonConfig.INSTANCE.siren.maxHealth.getValue()).doubleValue());
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HAIR_COLOR, (Object)0);
        this.field_6011.method_12784(SING_POSE, (Object)0);
        this.field_6011.method_12784(AGGRESSIVE, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SINGING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(SWIMMING, (Object)Boolean.FALSE);
        this.field_6011.method_12784(CHARMED, (Object)Boolean.FALSE);
        this.field_6011.method_12784(CLIMBING, (Object)0);
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setHairColor(this.method_6051().method_43048(3));
        this.setSingingPose(this.method_6051().method_43048(3));
        return spawnDataIn;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
    }

    public Animation[] getAnimations() {
        return new Animation[]{NO_ANIMATION, ANIMATION_BITE, ANIMATION_PULL};
    }

    protected class_3414 method_5994() {
        return this.isAgressive() ? (class_3414)IafSounds.NAGA_IDLE.get() : (class_3414)IafSounds.MERMAID_IDLE.get();
    }

    protected class_3414 method_6011(class_1282 damageSourceIn) {
        return this.isAgressive() ? (class_3414)IafSounds.NAGA_HURT.get() : (class_3414)IafSounds.MERMAID_HURT.get();
    }

    protected class_3414 method_6002() {
        return this.isAgressive() ? (class_3414)IafSounds.NAGA_DIE.get() : (class_3414)IafSounds.MERMAID_DIE.get();
    }

    public void method_6091(class_243 motion) {
        super.method_6091(motion);
    }

    public boolean method_5947() {
        return true;
    }

    public boolean method_5974(double distanceToClosestPlayer) {
        return false;
    }

    @Override
    public boolean shouldFear() {
        return this.isAgressive();
    }

    class SwimmingMoveHelper
    extends class_1335 {
        private final EntitySiren siren;

        public SwimmingMoveHelper() {
            super((class_1308)EntitySiren.this);
            this.siren = EntitySiren.this;
        }

        public void method_6240() {
            if (this.field_6374 == class_1335.class_1336.field_6378) {
                double distanceX = this.field_6370 - this.siren.method_23317();
                double distanceY = this.field_6369 - this.siren.method_23318();
                double distanceZ = this.field_6367 - this.siren.method_23321();
                double distance = Math.abs(distanceX * distanceX + distanceZ * distanceZ);
                double distanceWithY = Math.sqrt(distanceX * distanceX + distanceY * distanceY + distanceZ * distanceZ);
                distanceY /= distanceWithY;
                float angle = (float)(Math.atan2(distanceZ, distanceX) * 180.0 / Math.PI) - 90.0f;
                this.siren.method_36456(this.method_6238(this.siren.method_36454(), angle, 30.0f));
                this.siren.method_6125(1.0f);
                float f1 = 0.0f;
                float f2 = 0.0f;
                if (distance < (double)Math.max(1.0f, this.siren.method_17681())) {
                    float f = this.siren.method_36454() * ((float)Math.PI / 180);
                    f1 -= class_3532.method_15374((float)f) * 0.35f;
                    f2 += class_3532.method_15362((float)f) * 0.35f;
                }
                this.siren.method_18799(this.siren.method_18798().method_1031((double)f1, (double)this.siren.method_6029() * distanceY * 0.1, (double)f2));
            } else if (this.field_6374 == class_1335.class_1336.field_6379) {
                this.siren.method_6125((float)(this.field_6372 * this.siren.method_5996(class_5134.field_23719).method_6194()));
                if (this.siren.method_24828()) {
                    this.field_6374 = class_1335.class_1336.field_6377;
                }
            } else {
                this.siren.method_6125(0.0f);
            }
        }
    }
}

