/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.entity;

import com.iafenvoy.iceandfire.StaticVariables;
import com.iafenvoy.iceandfire.api.IafEvents;
import com.iafenvoy.iceandfire.config.IafCommonConfig;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.data.DragonType;
import com.iafenvoy.iceandfire.data.component.IafEntityData;
import com.iafenvoy.iceandfire.entity.EntityDragonEgg;
import com.iafenvoy.iceandfire.entity.EntityDragonPart;
import com.iafenvoy.iceandfire.entity.EntityDreadQueen;
import com.iafenvoy.iceandfire.entity.EntityGorgon;
import com.iafenvoy.iceandfire.entity.ai.DragonAIAttackMelee;
import com.iafenvoy.iceandfire.entity.ai.DragonAIEscort;
import com.iafenvoy.iceandfire.entity.ai.DragonAILookIdle;
import com.iafenvoy.iceandfire.entity.ai.DragonAIMate;
import com.iafenvoy.iceandfire.entity.ai.DragonAIReturnToRoost;
import com.iafenvoy.iceandfire.entity.ai.DragonAITarget;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetItems;
import com.iafenvoy.iceandfire.entity.ai.DragonAITargetNonTamed;
import com.iafenvoy.iceandfire.entity.ai.DragonAIWander;
import com.iafenvoy.iceandfire.entity.ai.DragonAIWatchClosest;
import com.iafenvoy.iceandfire.entity.block.BlockEntityDragonForgeInput;
import com.iafenvoy.iceandfire.entity.util.ChainBuffer;
import com.iafenvoy.iceandfire.entity.util.EntityUtil;
import com.iafenvoy.iceandfire.entity.util.HomePosition;
import com.iafenvoy.iceandfire.entity.util.IAnimalFear;
import com.iafenvoy.iceandfire.entity.util.ICustomMoveController;
import com.iafenvoy.iceandfire.entity.util.IDeadMob;
import com.iafenvoy.iceandfire.entity.util.IDropArmor;
import com.iafenvoy.iceandfire.entity.util.IFlyingMount;
import com.iafenvoy.iceandfire.entity.util.IHasCustomizableAttributes;
import com.iafenvoy.iceandfire.entity.util.IMultipartEntity;
import com.iafenvoy.iceandfire.entity.util.ISyncMount;
import com.iafenvoy.iceandfire.entity.util.IVillagerFear;
import com.iafenvoy.iceandfire.entity.util.ReversedBuffer;
import com.iafenvoy.iceandfire.entity.util.dragon.DragonUtils;
import com.iafenvoy.iceandfire.entity.util.dragon.IDragonFlute;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonAttacks;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonFlightManager;
import com.iafenvoy.iceandfire.entity.util.dragon.IafDragonLogic;
import com.iafenvoy.iceandfire.item.ItemSummoningCrystal;
import com.iafenvoy.iceandfire.item.armor.ItemDragonArmor;
import com.iafenvoy.iceandfire.item.block.util.IDragonProof;
import com.iafenvoy.iceandfire.registry.IafEntities;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.iceandfire.registry.IafSounds;
import com.iafenvoy.iceandfire.registry.tag.IafBlockTags;
import com.iafenvoy.iceandfire.registry.tag.IafItemTags;
import com.iafenvoy.iceandfire.render.model.IFChainBuffer;
import com.iafenvoy.iceandfire.render.model.util.LegSolverQuadruped;
import com.iafenvoy.iceandfire.screen.handler.DragonScreenHandler;
import com.iafenvoy.iceandfire.world.DragonPosWorldData;
import com.iafenvoy.uranus.ServerHelper;
import com.iafenvoy.uranus.animation.Animation;
import com.iafenvoy.uranus.animation.AnimationHandler;
import com.iafenvoy.uranus.animation.IAnimatedEntity;
import com.iafenvoy.uranus.data.EntityPropertyDelegate;
import com.iafenvoy.uranus.network.PacketBufferUtils;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IPassabilityNavigator;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathingStuckHandler;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.iafenvoy.uranus.object.item.FoodUtils;
import com.iafenvoy.uranus.util.RandomHelper;
import dev.architectury.networking.NetworkManager;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_1263;
import net.minecraft.class_1265;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1322;
import net.minecraft.class_1352;
import net.minecraft.class_1386;
import net.minecraft.class_1391;
import net.minecraft.class_1399;
import net.minecraft.class_1403;
import net.minecraft.class_1406;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_173;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1856;
import net.minecraft.class_1922;
import net.minecraft.class_1924;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2388;
import net.minecraft.class_239;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3908;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_52;
import net.minecraft.class_5425;
import net.minecraft.class_8111;
import net.minecraft.class_8567;
import org.jetbrains.annotations.Nullable;

public abstract class EntityDragonBase
extends class_1321
implements class_3908,
IPassabilityNavigator,
ISyncMount,
IFlyingMount,
IMultipartEntity,
IAnimatedEntity,
IDragonFlute,
IDeadMob,
IVillagerFear,
IAnimalFear,
IDropArmor,
IHasCustomizableAttributes,
ICustomSizeNavigator,
ICustomMoveController,
class_1265 {
    public static final int FLIGHT_CHANCE_PER_TICK = 1500;
    public static final float[] growth_stage_1 = new float[]{1.0f, 3.0f};
    public static final float[] growth_stage_2 = new float[]{3.0f, 7.0f};
    public static final float[] growth_stage_3 = new float[]{7.0f, 12.5f};
    public static final float[] growth_stage_4 = new float[]{12.5f, 20.0f};
    public static final float[] growth_stage_5 = new float[]{20.0f, 30.0f};
    public static final float[][] growth_stages = new float[][]{growth_stage_1, growth_stage_2, growth_stage_3, growth_stage_4, growth_stage_5};
    protected static final class_2940<Boolean> SWIMMING = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final UUID ARMOR_MODIFIER_UUID = UUID.fromString("556E1665-8B10-40C8-8F9D-CF9B1667F295");
    private static final class_2940<Integer> HUNGER = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> AGE_TICKS = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Boolean> GENDER = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> VARIANT = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13326);
    private static final class_2940<Boolean> SLEEPING = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FIREBREATHING = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> HOVERING = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FLYING = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> MODEL_DEAD = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> DEATH_STAGE = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Byte> CONTROL_STATE = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13319);
    private static final class_2940<Boolean> TACKLE = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> AGINGDISABLED = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Integer> COMMAND = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> DRAGON_PITCH = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Boolean> CRYSTAL_BOUND = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13323);
    private static final class_2940<String> CUSTOM_POSE = class_2945.method_12791(EntityDragonBase.class, (class_2941)class_2943.field_13326);
    public static Animation ANIMATION_FIRECHARGE;
    public static Animation ANIMATION_EAT;
    public static Animation ANIMATION_SPEAK;
    public static Animation ANIMATION_BITE;
    public static Animation ANIMATION_SHAKEPREY;
    public static Animation ANIMATION_WINGBLAST;
    public static Animation ANIMATION_ROAR;
    public static Animation ANIMATION_EPIC_ROAR;
    public static Animation ANIMATION_TAILWHACK;
    public final DragonType dragonType;
    public final double minimumDamage;
    public final double maximumDamage;
    public final double minimumHealth;
    public final double maximumHealth;
    public final double minimumSpeed;
    public final double maximumSpeed;
    public final double minimumArmor;
    public final double maximumArmor;
    public final float[] prevAnimationProgresses = new float[10];
    public final LegSolverQuadruped legSolver;
    public final IafDragonLogic logic;
    public final IafDragonFlightManager flightManager;
    public final boolean allowLocalMotionControl = true;
    public final boolean allowMousePitchControl = true;
    public float sitProgress;
    public float sleepProgress;
    public float hoverProgress;
    public float flyProgress;
    public float fireBreathProgress;
    public float diveProgress;
    public float prevDiveProgress;
    public float prevFireBreathProgress;
    public int fireStopTicks;
    public int flyTicks;
    public float modelDeadProgress;
    public float prevModelDeadProgress;
    public float ridingProgress;
    public float tackleProgress;
    public boolean isSwimming;
    public float prevSwimProgress;
    public float swimProgress;
    public int ticksSwiming;
    public int swimCycle;
    public boolean isDaytime;
    public int flightCycle;
    public HomePosition homePos;
    public boolean hasHomePosition = false;
    public IFChainBuffer roll_buffer;
    public IFChainBuffer pitch_buffer;
    public IFChainBuffer pitch_buffer_body;
    public ReversedBuffer turn_buffer;
    public ChainBuffer tail_buffer;
    public int spacebarTicks;
    public int walkCycle;
    public class_2338 burningTarget;
    public int burnProgress;
    public double burnParticleX;
    public double burnParticleY;
    public double burnParticleZ;
    public float prevDragonPitch;
    public IafDragonAttacks.Air airAttack;
    public IafDragonAttacks.Ground groundAttack;
    public boolean usingGroundAttack = true;
    public int hoverTicks;
    public int tacklingTicks;
    public int ticksStill;
    public int navigatorType;
    public class_1277 dragonInventory;
    public boolean lookingForRoostAIFlag = false;
    public int flyHovering;
    public boolean hasHadHornUse = false;
    public int blockBreakCounter;
    public int fireBreathTicks;
    protected boolean gliding = false;
    protected float glidingSpeedBonus = 0.0f;
    protected float riderWalkingExtraY = 0.0f;
    private int prevFlightCycle;
    private boolean isModelDead;
    private int animationTick;
    private Animation currentAnimation;
    private float lastScale;
    private EntityDragonPart headPart;
    private EntityDragonPart neckPart;
    private EntityDragonPart rightWingUpperPart;
    private EntityDragonPart rightWingLowerPart;
    private EntityDragonPart leftWingUpperPart;
    private EntityDragonPart leftWingLowerPart;
    private EntityDragonPart tail1Part;
    private EntityDragonPart tail2Part;
    private EntityDragonPart tail3Part;
    private EntityDragonPart tail4Part;
    private boolean isOverAir;

    public EntityDragonBase(class_1299<? extends EntityDragonBase> t, class_1937 world, DragonType type, double minimumDamage, double maximumDamage, double minimumHealth, double maximumHealth, double minimumSpeed, double maximumSpeed) {
        super(t, world);
        this.dragonType = type;
        this.minimumDamage = minimumDamage;
        this.maximumDamage = maximumDamage;
        this.minimumHealth = minimumHealth;
        this.maximumHealth = maximumHealth;
        this.minimumSpeed = minimumSpeed;
        this.maximumSpeed = maximumSpeed;
        this.minimumArmor = 1.0;
        this.maximumArmor = 20.0;
        ANIMATION_EAT = Animation.create((int)20);
        this.createInventory();
        if (world.field_9236) {
            this.roll_buffer = new IFChainBuffer();
            this.pitch_buffer = new IFChainBuffer();
            this.pitch_buffer_body = new IFChainBuffer();
            this.turn_buffer = new ReversedBuffer();
            this.tail_buffer = new ChainBuffer();
        }
        this.legSolver = new LegSolverQuadruped(0.3f, 0.35f, 0.2f, 1.45f, 1.0f);
        this.flightManager = new IafDragonFlightManager(this);
        this.logic = this.createDragonLogic();
        this.field_5985 = true;
        this.switchNavigator(0);
        this.randomizeAttacks();
        this.lastScale = 0.0f;
    }

    public static class_5132.class_5133 bakeAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.3).method_26868(class_5134.field_23721, 1.0).method_26868(class_5134.field_23717, (double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue())).method_26868(class_5134.field_23724, 4.0);
    }

    @Override
    public void setConfigurableAttributes() {
        this.method_5996(class_5134.field_23717).method_6192((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
    }

    public class_2338 method_18412() {
        return this.homePos == null ? super.method_18412() : this.homePos.getPosition();
    }

    public float method_18413() {
        return ((Integer)IafCommonConfig.INSTANCE.dragon.wanderFromHomeDistance.getValue()).intValue();
    }

    public String getHomeDimensionName() {
        return this.homePos == null ? "" : this.homePos.getDimension();
    }

    public boolean method_18410() {
        return this.hasHomePosition && this.getHomeDimensionName().equals(DragonUtils.getDimensionName(this.method_37908())) || super.method_18410();
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1386((class_1321)this));
        this.field_6201.method_6277(2, (class_1352)new DragonAIMate(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new DragonAIReturnToRoost(this, 1.0));
        this.field_6201.method_6277(4, (class_1352)new DragonAIEscort(this, 1.0));
        this.field_6201.method_6277(5, (class_1352)new DragonAIAttackMelee(this, 1.5, false));
        this.field_6201.method_6277(6, (class_1352)new class_1391((class_1314)this, 1.0, class_1856.method_8106(IafItemTags.TEMPT_DRAGON), false));
        this.field_6201.method_6277(7, (class_1352)new DragonAIWander(this, 1.0));
        this.field_6201.method_6277(8, (class_1352)new DragonAIWatchClosest((class_1314)this, class_1309.class, 6.0f));
        this.field_6201.method_6277(8, (class_1352)new DragonAILookIdle(this));
        this.field_6185.method_6277(1, (class_1352)new class_1406((class_1321)this));
        this.field_6185.method_6277(2, (class_1352)new class_1403((class_1321)this));
        this.field_6185.method_6277(3, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6185.method_6277(4, new DragonAITargetItems(this, 60, false, false, true));
        this.field_6185.method_6277(5, new DragonAITargetNonTamed<class_1309>(this, class_1309.class, false, (Predicate<class_1309>)((com.google.common.base.Predicate)entity -> {
            if (entity instanceof class_1657) {
                class_1657 player = (class_1657)entity;
                return !player.method_7337();
            }
            if (this.method_6051().method_43048(100) > this.getHunger()) {
                return entity.method_5864() != this.method_5864() && DragonUtils.canHostilesTarget((class_1297)entity) && DragonUtils.isAlive(entity) && this.shouldTarget((class_1297)entity);
            }
            return false;
        })));
        this.field_6185.method_6277(6, new DragonAITarget<class_1309>(this, class_1309.class, true, (Predicate<class_1309>)((com.google.common.base.Predicate)entity -> DragonUtils.canHostilesTarget((class_1297)entity) && entity.method_5864() != this.method_5864() && this.shouldTarget((class_1297)entity) && DragonUtils.isAlive(entity))));
        this.field_6185.method_6277(7, new DragonAITargetItems(this, false));
    }

    protected abstract boolean shouldTarget(class_1297 var1);

    public void updateScale(float scale) {
        if (this.headPart == null || this.headPart.method_31481()) {
            this.headPart = new EntityDragonPart(this, 1.55f, 0.0f, 0.6f, 0.5f, 0.35f, 1.5f);
            this.method_37908().method_8649((class_1297)this.headPart);
        }
        this.headPart.updateScale(scale);
        if (this.neckPart == null || this.neckPart.method_31481()) {
            this.neckPart = new EntityDragonPart(this, 0.85f, 0.0f, 0.7f, 0.5f, 0.2f, 1.0f);
            this.method_37908().method_8649((class_1297)this.neckPart);
        }
        this.neckPart.updateScale(scale);
        if (this.rightWingUpperPart == null || this.rightWingUpperPart.method_31481()) {
            this.rightWingUpperPart = new EntityDragonPart(this, 1.0f, 90.0f, 0.5f, 0.85f, 0.3f, 0.5f);
            this.method_37908().method_8649((class_1297)this.rightWingUpperPart);
        }
        this.rightWingUpperPart.updateScale(scale);
        if (this.rightWingLowerPart == null || this.rightWingLowerPart.method_31481()) {
            this.rightWingLowerPart = new EntityDragonPart(this, 1.4f, 100.0f, 0.3f, 0.85f, 0.2f, 0.5f);
            this.method_37908().method_8649((class_1297)this.rightWingLowerPart);
        }
        this.rightWingLowerPart.updateScale(scale);
        if (this.leftWingUpperPart == null || this.leftWingUpperPart.method_31481()) {
            this.leftWingUpperPart = new EntityDragonPart(this, 1.0f, -90.0f, 0.5f, 0.85f, 0.3f, 0.5f);
            this.method_37908().method_8649((class_1297)this.leftWingUpperPart);
        }
        this.leftWingUpperPart.updateScale(scale);
        if (this.leftWingLowerPart == null || this.leftWingLowerPart.method_31481()) {
            this.leftWingLowerPart = new EntityDragonPart(this, 1.4f, -100.0f, 0.3f, 0.85f, 0.2f, 0.5f);
            this.method_37908().method_8649((class_1297)this.leftWingLowerPart);
        }
        this.leftWingLowerPart.updateScale(scale);
        if (this.tail1Part == null || this.tail1Part.method_31481()) {
            this.tail1Part = new EntityDragonPart(this, -0.75f, 0.0f, 0.6f, 0.35f, 0.35f, 1.0f);
            this.method_37908().method_8649((class_1297)this.tail1Part);
        }
        this.tail1Part.updateScale(scale);
        if (this.tail2Part == null || this.tail2Part.method_31481()) {
            this.tail2Part = new EntityDragonPart(this, -1.15f, 0.0f, 0.45f, 0.35f, 0.35f, 1.0f);
            this.method_37908().method_8649((class_1297)this.tail2Part);
        }
        this.tail2Part.updateScale(scale);
        if (this.tail3Part == null || this.tail3Part.method_31481()) {
            this.tail3Part = new EntityDragonPart(this, -1.5f, 0.0f, 0.35f, 0.35f, 0.35f, 1.0f);
            this.method_37908().method_8649((class_1297)this.tail3Part);
        }
        this.tail3Part.updateScale(scale);
        if (this.tail4Part == null || this.tail4Part.method_31481()) {
            this.tail4Part = new EntityDragonPart(this, -1.95f, 0.0f, 0.25f, 0.45f, 0.3f, 1.5f);
            this.method_37908().method_8649((class_1297)this.tail4Part);
        }
        this.tail4Part.updateScale(scale);
    }

    public void removeParts() {
        if (this.headPart != null) {
            this.headPart.method_5650(class_1297.class_5529.field_26999);
            this.headPart = null;
        }
        if (this.neckPart != null) {
            this.neckPart.method_5650(class_1297.class_5529.field_26999);
            this.neckPart = null;
        }
        if (this.rightWingUpperPart != null) {
            this.rightWingUpperPart.method_5650(class_1297.class_5529.field_26999);
            this.rightWingUpperPart = null;
        }
        if (this.rightWingLowerPart != null) {
            this.rightWingLowerPart.method_5650(class_1297.class_5529.field_26999);
            this.rightWingLowerPart = null;
        }
        if (this.leftWingUpperPart != null) {
            this.leftWingUpperPart.method_5650(class_1297.class_5529.field_26999);
            this.leftWingUpperPart = null;
        }
        if (this.leftWingLowerPart != null) {
            this.leftWingLowerPart.method_5650(class_1297.class_5529.field_26999);
            this.leftWingLowerPart = null;
        }
        if (this.tail1Part != null) {
            this.tail1Part.method_5650(class_1297.class_5529.field_26999);
            this.tail1Part = null;
        }
        if (this.tail2Part != null) {
            this.tail2Part.method_5650(class_1297.class_5529.field_26999);
            this.tail2Part = null;
        }
        if (this.tail3Part != null) {
            this.tail3Part.method_5650(class_1297.class_5529.field_26999);
            this.tail3Part = null;
        }
        if (this.tail4Part != null) {
            this.tail4Part.method_5650(class_1297.class_5529.field_26999);
            this.tail4Part = null;
        }
    }

    public void updateParts() {
        if (this.method_31481()) {
            return;
        }
        this.headPart.method_5719((class_1297)this);
        this.neckPart.method_5719((class_1297)this);
        this.rightWingUpperPart.method_5719((class_1297)this);
        this.rightWingLowerPart.method_5719((class_1297)this);
        this.leftWingUpperPart.method_5719((class_1297)this);
        this.leftWingLowerPart.method_5719((class_1297)this);
        this.tail1Part.method_5719((class_1297)this);
        this.tail2Part.method_5719((class_1297)this);
        this.tail3Part.method_5719((class_1297)this);
        this.tail4Part.method_5719((class_1297)this);
        EntityUtil.updatePart(this.headPart, (class_1309)this);
        EntityUtil.updatePart(this.neckPart, (class_1309)this);
        EntityUtil.updatePart(this.rightWingUpperPart, (class_1309)this);
        EntityUtil.updatePart(this.rightWingLowerPart, (class_1309)this);
        EntityUtil.updatePart(this.leftWingUpperPart, (class_1309)this);
        EntityUtil.updatePart(this.leftWingLowerPart, (class_1309)this);
        EntityUtil.updatePart(this.tail1Part, (class_1309)this);
        EntityUtil.updatePart(this.tail2Part, (class_1309)this);
        EntityUtil.updatePart(this.tail3Part, (class_1309)this);
        EntityUtil.updatePart(this.tail4Part, (class_1309)this);
    }

    public void updateBurnTarget() {
        if (!(this.burningTarget == null || this.method_6113() || this.isModelDead() || this.method_6109())) {
            BlockEntityDragonForgeInput forge;
            float maxDist = 115 * this.getDragonStage();
            class_2586 class_25862 = this.method_37908().method_8321(this.burningTarget);
            if (class_25862 instanceof BlockEntityDragonForgeInput && (forge = (BlockEntityDragonForgeInput)class_25862).isAssembled() && this.method_5649((double)this.burningTarget.method_10263() + 0.5, (double)this.burningTarget.method_10264() + 0.5, (double)this.burningTarget.method_10260() + 0.5) < (double)maxDist && this.canPositionBeSeen((double)this.burningTarget.method_10263() + 0.5, (double)this.burningTarget.method_10264() + 0.5, (double)this.burningTarget.method_10260() + 0.5)) {
                this.method_5988().method_6230((double)this.burningTarget.method_10263() + 0.5, (double)this.burningTarget.method_10264() + 0.5, (double)this.burningTarget.method_10260() + 0.5, 180.0f, 180.0f);
                this.breathFireAtPos(this.burningTarget);
                this.setBreathingFire(true);
            } else {
                if (!this.method_37908().field_9236) {
                    class_2540 buf = PacketBufferUtils.create();
                    buf.writeInt(this.method_5628()).writeBoolean(true);
                    buf.method_10807(this.burningTarget);
                    ServerHelper.sendToAll((class_2960)StaticVariables.DRAGON_SET_BURN_BLOCK, (class_2540)buf);
                }
                this.burningTarget = null;
            }
        }
    }

    protected abstract void breathFireAtPos(class_2338 var1);

    protected PathingStuckHandler createStuckHandler() {
        return PathingStuckHandler.createStuckHandler();
    }

    protected class_1408 method_5965(class_1937 worldIn) {
        return this.createNavigator(worldIn, AdvancedPathNavigate.MovementType.WALKING);
    }

    protected class_1408 createNavigator(class_1937 worldIn, AdvancedPathNavigate.MovementType type) {
        return this.createNavigator(worldIn, type, this.createStuckHandler());
    }

    protected class_1408 createNavigator(class_1937 worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler) {
        return this.createNavigator(worldIn, type, stuckHandler, 4.0f);
    }

    protected class_1408 createNavigator(class_1937 worldIn, AdvancedPathNavigate.MovementType type, PathingStuckHandler stuckHandler, float width) {
        AdvancedPathNavigate newNavigator = new AdvancedPathNavigate((class_1308)this, this.method_37908(), type, width, 4.0f);
        this.field_6189 = newNavigator;
        newNavigator.method_6354(true);
        newNavigator.method_6342().method_20(true);
        return newNavigator;
    }

    public void switchNavigator(int navigatorType) {
        if (navigatorType == 0) {
            this.field_6207 = new IafDragonFlightManager.GroundMoveHelper((class_1308)this);
            this.field_6189 = this.createNavigator(this.method_37908(), AdvancedPathNavigate.MovementType.WALKING, this.createStuckHandler().withTeleportSteps(5));
            this.navigatorType = 0;
            this.setFlying(false);
            this.setHovering(false);
        } else if (navigatorType == 1) {
            this.field_6207 = new IafDragonFlightManager.FlightMoveHelper(this);
            this.field_6189 = this.createNavigator(this.method_37908(), AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 1;
        } else {
            this.field_6207 = new IafDragonFlightManager.PlayerFlightMoveHelper<EntityDragonBase>(this);
            this.field_6189 = this.createNavigator(this.method_37908(), AdvancedPathNavigate.MovementType.FLYING);
            this.navigatorType = 2;
        }
    }

    public boolean method_5860(class_1297 rider) {
        return true;
    }

    protected void method_5958() {
        super.method_5958();
        this.breakBlocks(false);
    }

    public void method_5982() {
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.canDespawn.getValue()).booleanValue()) {
            super.method_5982();
        }
    }

    public boolean canDestroyBlock(class_2338 pos, class_2680 state) {
        return state.method_26204().method_36555() <= 100.0f;
    }

    @Override
    public boolean isMobDead() {
        return this.isModelDead();
    }

    public int method_5986() {
        return 30 * this.getDragonStage() / 5;
    }

    public void openInventory(class_1657 player) {
        player.method_17355((class_3908)this);
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 inv, class_1657 player) {
        return new DragonScreenHandler(syncId, (class_1263)this.dragonInventory, player.method_31548(), new EntityPropertyDelegate(this.method_5628()));
    }

    public int method_5970() {
        return 90;
    }

    protected void method_6108() {
        this.field_6213 = 0;
        this.setModelDead(true);
        this.method_5772();
        if (this.getDeathStage() >= this.getAgeInDays() / 5) {
            this.method_5650(class_1297.class_5529.field_26998);
            for (int k = 0; k < 40; ++k) {
                double d2 = this.field_5974.method_43059() * 0.02;
                double d0 = this.field_5974.method_43059() * 0.02;
                double d1 = this.field_5974.method_43059() * 0.02;
                if (!this.method_37908().field_9236) continue;
                this.method_37908().method_8406((class_2394)class_2398.field_11204, this.method_23317() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), this.method_23318() + (double)(this.field_5974.method_43057() * this.method_17682()), this.method_23321() + (double)(this.field_5974.method_43057() * this.method_17681() * 2.0f) - (double)this.method_17681(), d2, d0, d1);
            }
            this.spawnDeathParticles();
        }
    }

    protected void spawnDeathParticles() {
    }

    public void spawnBabyParticles() {
    }

    public void method_5650(class_1297.class_5529 reason) {
        this.removeParts();
        super.method_5650(reason);
    }

    public int method_6110() {
        return switch (this.getDragonStage()) {
            case 2 -> 20;
            case 3 -> 150;
            case 4 -> 300;
            case 5 -> 650;
            default -> 5;
        };
    }

    public boolean method_5987() {
        return this.isModelDead() || super.method_5987();
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HUNGER, (Object)0);
        this.field_6011.method_12784(AGE_TICKS, (Object)0);
        this.field_6011.method_12784(GENDER, (Object)false);
        this.field_6011.method_12784(VARIANT, (Object)DragonColor.RED.name());
        this.field_6011.method_12784(SLEEPING, (Object)false);
        this.field_6011.method_12784(FIREBREATHING, (Object)false);
        this.field_6011.method_12784(HOVERING, (Object)false);
        this.field_6011.method_12784(FLYING, (Object)false);
        this.field_6011.method_12784(DEATH_STAGE, (Object)0);
        this.field_6011.method_12784(MODEL_DEAD, (Object)false);
        this.field_6011.method_12784(CONTROL_STATE, (Object)0);
        this.field_6011.method_12784(TACKLE, (Object)false);
        this.field_6011.method_12784(AGINGDISABLED, (Object)false);
        this.field_6011.method_12784(COMMAND, (Object)0);
        this.field_6011.method_12784(DRAGON_PITCH, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(CRYSTAL_BOUND, (Object)false);
        this.field_6011.method_12784(CUSTOM_POSE, (Object)"");
    }

    @Override
    public boolean isGoingUp() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) & 1) == 1;
    }

    @Override
    public boolean isGoingDown() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 1 & 1) == 1;
    }

    public boolean method_6510() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 2 & 1) == 1;
    }

    public boolean isStriking() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 3 & 1) == 1;
    }

    public boolean isDismounting() {
        return ((Byte)this.field_6011.method_12789(CONTROL_STATE) >> 4 & 1) == 1;
    }

    @Override
    public void up(boolean up) {
        this.setStateField(0, up);
    }

    @Override
    public void down(boolean down) {
        this.setStateField(1, down);
    }

    @Override
    public void attack(boolean attack) {
        this.setStateField(2, attack);
    }

    @Override
    public void strike(boolean strike) {
        this.setStateField(3, strike);
    }

    @Override
    public void dismount(boolean dismount) {
        this.setStateField(4, dismount);
    }

    private void setStateField(int i, boolean newState) {
        byte prevState = (Byte)this.field_6011.method_12789(CONTROL_STATE);
        if (newState) {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState | 1 << i)));
        } else {
            this.field_6011.method_12778(CONTROL_STATE, (Object)((byte)(prevState & ~(1 << i))));
        }
    }

    @Override
    public byte getControlState() {
        return (Byte)this.field_6011.method_12789(CONTROL_STATE);
    }

    @Override
    public void setControlState(byte state) {
        this.field_6011.method_12778(CONTROL_STATE, (Object)state);
    }

    public int getCommand() {
        return (Integer)this.field_6011.method_12789(COMMAND);
    }

    public void setCommand(int command) {
        this.field_6011.method_12778(COMMAND, (Object)command);
        this.method_24346(command == 1);
    }

    public float getDragonPitch() {
        return ((Float)this.field_6011.method_12789(DRAGON_PITCH)).floatValue();
    }

    public void setDragonPitch(float pitch) {
        this.field_6011.method_12778(DRAGON_PITCH, (Object)Float.valueOf(pitch));
    }

    public void incrementDragonPitch(float pitch) {
        this.field_6011.method_12778(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() + pitch));
    }

    public void decrementDragonPitch(float pitch) {
        this.field_6011.method_12778(DRAGON_PITCH, (Object)Float.valueOf(this.getDragonPitch() - pitch));
    }

    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("Hunger", this.getHunger());
        compound.method_10569("AgeTicks", this.getAgeInTicks());
        compound.method_10556("Gender", this.isMale());
        compound.method_10582("Variant", this.getVariant());
        compound.method_10556("Sleeping", this.method_6113());
        compound.method_10556("TamedDragon", this.method_6181());
        compound.method_10556("FireBreathing", this.isBreathingFire());
        compound.method_10556("AttackDecision", this.usingGroundAttack);
        compound.method_10556("Hovering", this.isHovering());
        compound.method_10556("Flying", this.isFlying());
        compound.method_10569("DeathStage", this.getDeathStage());
        compound.method_10556("ModelDead", this.isModelDead());
        compound.method_10548("DeadProg", this.modelDeadProgress);
        compound.method_10556("Tackle", this.isTackling());
        compound.method_10556("HasHomePosition", this.hasHomePosition);
        compound.method_10582("CustomPose", this.getCustomPose());
        if (this.homePos != null && this.hasHomePosition) {
            this.homePos.write(compound);
        }
        compound.method_10556("AgingDisabled", this.isAgingDisabled());
        compound.method_10569("Command", this.getCommand());
        if (this.dragonInventory != null) {
            class_2499 nbttaglist = new class_2499();
            for (int i = 0; i < this.dragonInventory.method_5439(); ++i) {
                class_1799 itemstack = this.dragonInventory.method_5438(i);
                if (itemstack.method_7960()) continue;
                class_2487 CompoundNBT = new class_2487();
                CompoundNBT.method_10567("Slot", (byte)i);
                itemstack.method_7953(CompoundNBT);
                nbttaglist.add((Object)CompoundNBT);
            }
            compound.method_10566("Items", (class_2520)nbttaglist);
        }
        compound.method_10556("CrystalBound", this.isBoundToCrystal());
        if (this.method_16914()) {
            compound.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.method_5797()));
        }
        this.removeParts();
        this.lastScale = 0.0f;
    }

    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.setHunger(compound.method_10550("Hunger"));
        this.setAgeInTicks(compound.method_10550("AgeTicks"));
        this.setGender(compound.method_10577("Gender"));
        if (compound.method_10545("Variant") && compound.method_10580("Variant").method_10711() == 8) {
            this.setVariant(compound.method_10558("Variant"));
        } else {
            List<DragonColor> colors = DragonColor.getColorsByType(this.dragonType);
            this.setVariant(colors.get(compound.method_10550("Variant")).name());
        }
        this.method_6179(compound.method_10577("Sleeping"));
        this.method_6173(compound.method_10577("TamedDragon"));
        this.setBreathingFire(compound.method_10577("FireBreathing"));
        this.usingGroundAttack = compound.method_10577("AttackDecision");
        this.setHovering(compound.method_10577("Hovering"));
        this.setFlying(compound.method_10577("Flying"));
        this.setDeathStage(compound.method_10550("DeathStage"));
        this.setModelDead(compound.method_10577("ModelDead"));
        this.modelDeadProgress = compound.method_10583("DeadProg");
        this.setCustomPose(compound.method_10558("CustomPose"));
        this.hasHomePosition = compound.method_10577("HasHomePosition");
        if (this.hasHomePosition && compound.method_10550("HomeAreaX") != 0 && compound.method_10550("HomeAreaY") != 0 && compound.method_10550("HomeAreaZ") != 0) {
            this.homePos = new HomePosition(compound, this.method_37908());
        }
        this.setTackling(compound.method_10577("Tackle"));
        this.setAgingDisabled(compound.method_10577("AgingDisabled"));
        this.setCommand(compound.method_10550("Command"));
        if (this.dragonInventory != null) {
            nbttaglist = compound.method_10554("Items", 10);
            this.createInventory();
            for (class_2520 inbt : nbttaglist) {
                class_2487 CompoundNBT = (class_2487)inbt;
                int j = CompoundNBT.method_10571("Slot") & 0xFF;
                if (j > 4) continue;
                this.dragonInventory.method_5447(j, class_1799.method_7915((class_2487)CompoundNBT));
            }
        } else {
            nbttaglist = compound.method_10554("Items", 10);
            this.createInventory();
            for (class_2520 inbt : nbttaglist) {
                class_2487 CompoundNBT = (class_2487)inbt;
                int j = CompoundNBT.method_10571("Slot") & 0xFF;
                this.dragonInventory.method_5447(j, class_1799.method_7915((class_2487)CompoundNBT));
            }
        }
        this.setCrystalBound(compound.method_10577("CrystalBound"));
        if (compound.method_10573("CustomName", 8) && !compound.method_10558("CustomName").startsWith("TextComponent")) {
            this.method_5665((class_2561)class_2561.class_2562.method_10877((String)compound.method_10558("CustomName")));
        }
        this.setConfigurableAttributes();
        this.updateAttributes();
    }

    public int getContainerSize() {
        return 5;
    }

    protected void createInventory() {
        class_1277 tempInventory = this.dragonInventory;
        this.dragonInventory = new class_1277(this.getContainerSize());
        if (tempInventory != null) {
            tempInventory.method_5488((class_1265)this);
            int i = Math.min(tempInventory.method_5439(), this.dragonInventory.method_5439());
            for (int j = 0; j < i; ++j) {
                class_1799 itemstack = tempInventory.method_5438(j);
                if (itemstack.method_7960()) continue;
                this.dragonInventory.method_5447(j, itemstack.method_7972());
            }
        }
        this.dragonInventory.method_5489((class_1265)this);
        this.updateContainerEquipment();
    }

    protected void updateContainerEquipment() {
        if (!this.method_37908().field_9236) {
            this.updateAttributes();
        }
    }

    public boolean hasInventoryChanged(class_1263 pInventory) {
        return this.dragonInventory != pInventory;
    }

    public class_1309 method_5642() {
        for (class_1297 passenger : this.method_5685()) {
            if (!(passenger instanceof class_1657)) continue;
            class_1657 player = (class_1657)passenger;
            if (this.method_5968() == passenger || !this.method_6181() || this.method_6139() == null || !this.method_6139().equals(player.method_5667())) continue;
            return player;
        }
        return null;
    }

    @Override
    public class_1657 getRidingPlayer() {
        class_1309 class_13092 = this.method_5642();
        if (class_13092 instanceof class_1657) {
            class_1657 player = (class_1657)class_13092;
            return player;
        }
        return null;
    }

    public void updateAttributes() {
        double age = Math.min(this.getAgeInDays(), 125);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        double attackStep = (this.maximumDamage - this.minimumDamage) / 125.0;
        double speedStep = (this.maximumSpeed - this.minimumSpeed) / 125.0;
        double armorStep = (this.maximumArmor - this.minimumArmor) / 125.0;
        this.method_5996(class_5134.field_23716).method_6192((double)Math.round(this.minimumHealth + healthStep * age));
        this.method_5996(class_5134.field_23721).method_6192((double)Math.round(this.minimumDamage + attackStep * age));
        this.method_5996(class_5134.field_23719).method_6192(this.minimumSpeed + speedStep * age);
        double baseValue = this.minimumArmor + armorStep * (double)this.getAgeInDays();
        this.method_5996(class_5134.field_23724).method_6192(baseValue);
        if (!this.method_37908().field_9236) {
            this.method_5996(class_5134.field_23724).method_6200(ARMOR_MODIFIER_UUID);
            this.method_5996(class_5134.field_23724).method_26837(new class_1322(ARMOR_MODIFIER_UUID, "Dragon armor bonus", this.calculateArmorModifier(), class_1322.class_1323.field_6328));
        }
        this.method_5996(class_5134.field_23717).method_6192((double)Math.min(2048, (Integer)IafCommonConfig.INSTANCE.dragon.targetSearchLength.getValue()));
    }

    public int getHunger() {
        return (Integer)this.field_6011.method_12789(HUNGER);
    }

    public void setHunger(int hunger) {
        this.field_6011.method_12778(HUNGER, (Object)class_3532.method_15340((int)hunger, (int)0, (int)100));
    }

    public String getVariant() {
        return (String)this.field_6011.method_12789(VARIANT);
    }

    public void setVariant(String variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    public int getAgeInDays() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(AGE_TICKS) / 24000), (int)0, (int)(this.method_6181() ? (Integer)IafCommonConfig.INSTANCE.dragon.maxTamedDragonAge.getValue() : 128));
    }

    public void setAgeInDays(int age) {
        this.field_6011.method_12778(AGE_TICKS, (Object)(age * 24000));
    }

    public int getAgeInTicks() {
        return (Integer)this.field_6011.method_12789(AGE_TICKS);
    }

    public void setAgeInTicks(int age) {
        this.field_6011.method_12778(AGE_TICKS, (Object)age);
    }

    public int getDeathStage() {
        return (Integer)this.field_6011.method_12789(DEATH_STAGE);
    }

    public void setDeathStage(int stage) {
        this.field_6011.method_12778(DEATH_STAGE, (Object)stage);
    }

    public boolean isMale() {
        return (Boolean)this.field_6011.method_12789(GENDER);
    }

    public boolean isModelDead() {
        if (this.method_37908().field_9236) {
            this.isModelDead = (Boolean)this.field_6011.method_12789(MODEL_DEAD);
            return this.isModelDead;
        }
        return this.isModelDead;
    }

    public void setModelDead(boolean modeldead) {
        this.field_6011.method_12778(MODEL_DEAD, (Object)modeldead);
        if (!this.method_37908().field_9236) {
            this.isModelDead = modeldead;
        }
    }

    @Override
    public boolean isHovering() {
        return (Boolean)this.field_6011.method_12789(HOVERING);
    }

    public void setHovering(boolean hovering) {
        this.field_6011.method_12778(HOVERING, (Object)hovering);
    }

    @Override
    public boolean isFlying() {
        return (Boolean)this.field_6011.method_12789(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_6011.method_12778(FLYING, (Object)flying);
    }

    public boolean useFlyingPathFinder() {
        return this.isFlying() && this.method_5642() == null;
    }

    public void setGender(boolean male) {
        this.field_6011.method_12778(GENDER, (Object)male);
    }

    public boolean method_6113() {
        return (Boolean)this.field_6011.method_12789(SLEEPING);
    }

    public boolean isBlinking() {
        return this.field_6012 % 50 > 43;
    }

    public boolean isBreathingFire() {
        return (Boolean)this.field_6011.method_12789(FIREBREATHING);
    }

    public void setBreathingFire(boolean breathing) {
        this.field_6011.method_12778(FIREBREATHING, (Object)breathing);
    }

    protected boolean method_5818(class_1297 passenger) {
        return this.method_5685().size() < 2;
    }

    public boolean method_24345() {
        return ((Byte)this.field_6011.method_12789(field_6322) & 1) != 0;
    }

    public void method_24346(boolean sitting) {
        byte b0 = (Byte)this.field_6011.method_12789(field_6322);
        if (sitting) {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b0 | 1)));
            this.method_5942().method_6340();
        } else {
            this.field_6011.method_12778(field_6322, (Object)((byte)(b0 & 0xFFFFFFFE)));
        }
    }

    public void method_6179(boolean sleeping) {
        this.field_6011.method_12778(SLEEPING, (Object)sleeping);
        if (sleeping) {
            this.method_5942().method_6340();
        }
    }

    public String getCustomPose() {
        return (String)this.field_6011.method_12789(CUSTOM_POSE);
    }

    public void setCustomPose(String customPose) {
        this.field_6011.method_12778(CUSTOM_POSE, (Object)customPose);
        this.modelDeadProgress = 20.0f;
    }

    public void riderShootFire(class_1297 controller) {
    }

    private double calculateArmorModifier() {
        class_1304[] slots;
        double val = 1.0;
        for (class_1304 slot : slots = new class_1304[]{class_1304.field_6169, class_1304.field_6174, class_1304.field_6172, class_1304.field_6166}) {
            class_1792 class_17922;
            class_1799 stack = this.method_6118(slot);
            if (stack.method_7960() || !((class_17922 = stack.method_7909()) instanceof ItemDragonArmor)) continue;
            ItemDragonArmor armorItem = (ItemDragonArmor)class_17922;
            val += armorItem.type.getProtection();
        }
        return val;
    }

    public boolean canMove() {
        return !this.method_24345() && !this.method_6113() && this.method_5642() == null && !this.method_5765() && !this.isModelDead() && this.sleepProgress == 0.0f && this.getAnimation() != ANIMATION_SHAKEPREY;
    }

    public boolean isFuelingForge() {
        return this.burningTarget != null && this.method_37908().method_8321(this.burningTarget) instanceof BlockEntityDragonForgeInput;
    }

    public boolean method_5805() {
        if (this.isModelDead()) {
            return !this.method_31481();
        }
        return super.method_5805();
    }

    public class_1269 method_5664(class_1657 player, class_243 vec, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (stack.method_7909() == IafItems.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return class_1269.field_5812;
        }
        return super.method_5664(player, vec, hand);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_6047();
        int lastDeathStage = Math.min(this.getAgeInDays() / 5, 25);
        if (stack == class_1799.field_8037) {
            stack = player.method_5998(hand);
        }
        if (stack.method_7909() == IafItems.DRAGON_DEBUG_STICK.get()) {
            this.logic.debug();
            return class_1269.field_5812;
        }
        if (!this.isModelDead()) {
            if (stack.method_7909() == IafItems.CREATIVE_DRAGON_MEAL.get()) {
                this.method_6173(true);
                this.method_6170(player);
                this.setHunger(this.getHunger() + 20);
                this.method_6025(Math.min(this.method_6032(), (float)((int)(this.method_6063() / 2.0f))));
                this.method_5783(class_3417.field_20614, this.method_6107(), this.method_6017());
                this.spawnItemCrackParticles(stack.method_7909());
                this.spawnItemCrackParticles(class_1802.field_8606);
                this.spawnItemCrackParticles(class_1802.field_8324);
                if (!player.method_7337()) {
                    stack.method_7934(1);
                }
                return class_1269.field_5812;
            }
            if (this.method_6481(stack) && this.method_27071()) {
                this.method_5614(0);
                this.method_6475(player, class_1268.field_5808, stack);
                this.method_6480(player);
                return class_1269.field_5812;
            }
            if (this.method_6171((class_1309)player)) {
                if (stack.method_7909() == this.dragonType.getCrystalItem() && !ItemSummoningCrystal.hasDragon(stack)) {
                    this.setCrystalBound(true);
                    class_2487 compound = stack.method_7948();
                    class_2487 dragonTag = new class_2487();
                    dragonTag.method_25927("DragonUUID", this.method_5667());
                    if (this.method_5797() != null) {
                        dragonTag.method_10582("CustomName", this.method_5797().getString());
                    }
                    compound.method_10566("Dragon", (class_2520)dragonTag);
                    this.method_5783(class_3417.field_15029, 1.0f, 1.0f);
                    player.method_6104(hand);
                    return class_1269.field_5812;
                }
                this.method_6170(player);
                if (stack.method_7909() == IafItems.DRAGON_HORN.get()) {
                    return super.method_5992(player, hand);
                }
                if (stack.method_7960() && !player.method_5715()) {
                    if (!this.method_37908().field_9236) {
                        int dragonStage = this.getDragonStage();
                        if (dragonStage < 2) {
                            if (player.method_5685().size() >= 3) {
                                return class_1269.field_5814;
                            }
                            this.method_5873((class_1297)player, true);
                            class_2540 buf = PacketBufferUtils.create();
                            buf.writeInt(this.method_5628()).writeBoolean(true).writeBoolean(true);
                            ServerHelper.sendToAll((class_2960)StaticVariables.START_RIDING_MOB_S2C, (class_2540)buf);
                        } else if (dragonStage > 2 && !player.method_5765()) {
                            player.method_5660(false);
                            player.method_5873((class_1297)this, true);
                            class_2540 buf = PacketBufferUtils.create();
                            buf.writeInt(this.method_5628()).writeBoolean(true).writeBoolean(false);
                            ServerHelper.sendToAll((class_2960)StaticVariables.START_RIDING_MOB_S2C, (class_2540)buf);
                            this.method_6179(false);
                        }
                        this.method_5942().method_6340();
                    }
                    return class_1269.field_5812;
                }
                if (stack.method_7960() && player.method_5715()) {
                    this.openInventory(player);
                    return class_1269.field_5812;
                }
                int itemFoodAmount = FoodUtils.getFoodPoints((class_1799)stack, (boolean)true, (boolean)this.dragonType.isPiscivore());
                if (itemFoodAmount > 0 && (this.getHunger() < 100 || this.method_6032() < this.method_6063())) {
                    this.setHunger(this.getHunger() + itemFoodAmount);
                    this.method_6033(Math.min(this.method_6063(), (float)((int)(this.method_6032() + (float)itemFoodAmount / 10.0f))));
                    this.method_5783(class_3417.field_20614, this.method_6107(), this.method_6017());
                    this.spawnItemCrackParticles(stack.method_7909());
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
                class_1792 stackItem = stack.method_7909();
                if (stackItem == IafItems.DRAGON_MEAL.get() && this.getAgeInDays() < (this.method_6181() ? (Integer)IafCommonConfig.INSTANCE.dragon.maxTamedDragonAge.getValue() : 128)) {
                    this.growDragon(1);
                    this.setHunger(this.getHunger() + 20);
                    this.method_6025(Math.min(this.method_6032(), (float)((int)(this.method_6063() / 2.0f))));
                    this.method_5783(class_3417.field_20614, this.method_6107(), this.method_6017());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(class_1802.field_8606);
                    this.spawnItemCrackParticles(class_1802.field_8324);
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
                if (stackItem == IafItems.SICKLY_DRAGON_MEAL.get() && !this.isAgingDisabled()) {
                    this.setHunger(this.getHunger() + 20);
                    this.method_6025(this.method_6063());
                    this.method_5783(class_3417.field_14905, this.method_6107(), this.method_6017());
                    this.spawnItemCrackParticles(stackItem);
                    this.spawnItemCrackParticles(class_1802.field_8606);
                    this.spawnItemCrackParticles(class_1802.field_8324);
                    this.spawnItemCrackParticles(class_1802.field_8635);
                    this.spawnItemCrackParticles(class_1802.field_8635);
                    this.setAgingDisabled(true);
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    return class_1269.field_5812;
                }
                if (stackItem == IafItems.DRAGON_STAFF.get()) {
                    if (player.method_5715()) {
                        if (this.hasHomePosition) {
                            this.hasHomePosition = false;
                            player.method_7353((class_2561)class_2561.method_43471((String)"dragon.command.remove_home"), true);
                        } else {
                            class_2338 pos = this.method_24515();
                            this.homePos = new HomePosition(pos, this.method_37908());
                            this.hasHomePosition = true;
                            player.method_7353((class_2561)class_2561.method_43469((String)"dragon.command.new_home", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260(), this.homePos.getDimension()}), true);
                        }
                    } else {
                        this.method_5783(class_3417.field_14986, this.method_6107(), this.method_6017());
                        if (!this.method_37908().field_9236) {
                            this.setCommand(this.getCommand() + 1);
                            if (this.getCommand() > 2) {
                                this.setCommand(0);
                            }
                        }
                        String commandText = "stand";
                        if (this.getCommand() == 1) {
                            commandText = "sit";
                        } else if (this.getCommand() == 2) {
                            commandText = "escort";
                        }
                        player.method_7353((class_2561)class_2561.method_43471((String)("dragon.command." + commandText)), true);
                    }
                    return class_1269.field_5812;
                }
            }
        } else {
            if (this.getDeathStage() < lastDeathStage && player.method_7294()) {
                if (!this.method_37908().field_9236 && !stack.method_7960() && stack.method_7909() != null && stack.method_7909() == class_1802.field_8469 && this.getDeathStage() < lastDeathStage / 2 && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootBlood.getValue()).booleanValue()) {
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    this.setDeathStage(this.getDeathStage() + 1);
                    player.method_31548().method_7394(new class_1799((class_1935)this.getBloodItem(), 1));
                    return class_1269.field_5812;
                }
                if (!this.method_37908().field_9236 && stack.method_7960() && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootSkull.getValue()).booleanValue()) {
                    if (this.getDeathStage() >= lastDeathStage - 1) {
                        class_1799 skull = this.getSkull().method_7972();
                        skull.method_7980(new class_2487());
                        assert (skull.method_7969() != null);
                        skull.method_7969().method_10569("Stage", this.getDragonStage());
                        skull.method_7969().method_10569("DragonType", 0);
                        skull.method_7969().method_10569("DragonAge", this.getAgeInDays());
                        this.setDeathStage(this.getDeathStage() + 1);
                        if (!this.method_37908().field_9236) {
                            this.method_5699(skull, 1.0f);
                        }
                        this.method_5650(class_1297.class_5529.field_26999);
                    } else if (this.getDeathStage() == lastDeathStage / 2 - 1 && ((Boolean)IafCommonConfig.INSTANCE.dragon.lootHeart.getValue()).booleanValue()) {
                        class_1799 heart = new class_1799(this.getHeartItem(), 1);
                        List<DragonColor> colors = DragonColor.getColorsByType(this.dragonType);
                        class_1799 egg = new class_1799((class_1935)colors.get(this.field_5974.method_43048(colors.size())).getEggItem(), 1);
                        if (!this.method_37908().field_9236) {
                            this.method_5699(heart, 1.0f);
                            if (!this.isMale() && this.getDragonStage() > 3) {
                                this.method_5699(egg, 1.0f);
                            }
                        }
                        this.setDeathStage(this.getDeathStage() + 1);
                    } else {
                        this.setDeathStage(this.getDeathStage() + 1);
                        class_1799 drop = this.getRandomDrop();
                        if (!drop.method_7960() && !this.method_37908().field_9236) {
                            this.method_5699(drop, 1.0f);
                        }
                    }
                }
                return class_1269.field_5812;
            }
            return super.method_5992(player, hand);
        }
        return class_1269.field_5811;
    }

    public abstract class_1935 getHeartItem();

    public abstract class_1792 getBloodItem();

    public abstract class_1792 getFleshItem();

    public class_1799 getSkull() {
        return class_1799.field_8037;
    }

    private class_1799 getRandomDrop() {
        class_1799 stack = this.getItemFromLootTable();
        if (stack.method_7909() == IafItems.DRAGON_BONE.get()) {
            this.method_5783(class_3417.field_15200, 1.0f, 1.0f);
        } else {
            this.method_5783(class_3417.field_14581, 1.0f, 1.0f);
        }
        return stack;
    }

    public boolean canPositionBeSeen(double x, double y, double z) {
        class_3965 result = this.method_37908().method_17742(new class_3959(new class_243(this.method_23317(), this.method_23318() + (double)this.method_5751(), this.method_23321()), new class_243(x, y, z), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        double dist = result.method_17784().method_1028(x, y, z);
        return dist <= 1.0 || result.method_17783() == class_239.class_240.field_1333;
    }

    public abstract class_2960 getDeadLootTable();

    public class_1799 getItemFromLootTable() {
        class_8567.class_8568 lootparams$builder;
        class_52 loottable = this.method_37908().method_8503().method_3857().getLootTable(this.getDeadLootTable());
        ObjectListIterator objectListIterator = loottable.method_51878((lootparams$builder = new class_8567.class_8568((class_3218)this.method_37908()).method_51874(class_181.field_1226, (Object)this).method_51874(class_181.field_24424, (Object)this.method_19538()).method_51874(class_181.field_1231, (Object)this.method_37908().method_48963().method_48830())).method_51875(class_173.field_1173)).iterator();
        if (objectListIterator.hasNext()) {
            class_1799 itemstack = (class_1799)objectListIterator.next();
            return itemstack;
        }
        return class_1799.field_8037;
    }

    public boolean method_17326() {
        return true;
    }

    public boolean method_5947() {
        return true;
    }

    public void growDragon(int ageInDays) {
        if (this.isAgingDisabled()) {
            return;
        }
        this.setAgeInDays(this.getAgeInDays() + ageInDays);
        this.method_5857(this.method_5829());
        if (this.method_37908().field_9236 && this.getAgeInDays() % 25 == 0) {
            int i = 0;
            while ((float)i < this.getRenderSize() * 4.0f) {
                float f = (float)((double)this.method_6051().method_43057() * (this.method_5829().field_1320 - this.method_5829().field_1323) + this.method_5829().field_1323);
                float f1 = (float)((double)this.method_6051().method_43057() * (this.method_5829().field_1325 - this.method_5829().field_1322) + this.method_5829().field_1322);
                float f2 = (float)((double)this.method_6051().method_43057() * (this.method_5829().field_1324 - this.method_5829().field_1321) + this.method_5829().field_1321);
                double motionX = this.method_6051().method_43059() * 0.07;
                double motionY = this.method_6051().method_43059() * 0.07;
                double motionZ = this.method_6051().method_43059() * 0.07;
                this.method_37908().method_8406((class_2394)class_2398.field_11211, (double)f, (double)f1, (double)f2, motionX, motionY, motionZ);
                ++i;
            }
        }
        if (this.getDragonStage() >= 2) {
            this.method_29239();
        }
        this.updateAttributes();
    }

    public void spawnItemCrackParticles(class_1792 item) {
        for (int i = 0; i < 15; ++i) {
            double motionX = this.method_6051().method_43059() * 0.07;
            double motionY = this.method_6051().method_43059() * 0.07;
            double motionZ = this.method_6051().method_43059() * 0.07;
            class_243 headVec = this.getHeadPosition();
            if (!this.method_37908().field_9236) {
                ((class_3218)this.method_37908()).method_14199((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)item)), headVec.field_1352, headVec.field_1351, headVec.field_1350, 1, motionX, motionY, motionZ, 0.1);
                continue;
            }
            this.method_37908().method_8406((class_2394)new class_2392(class_2398.field_11218, new class_1799((class_1935)item)), headVec.field_1352, headVec.field_1351, headVec.field_1350, motionX, motionY, motionZ);
        }
    }

    public boolean isTimeToWake() {
        return this.method_37908().method_8530() || this.getCommand() == 2;
    }

    private boolean isStuck() {
        boolean checkNavigation;
        boolean skip;
        boolean bl = skip = this.isChained() || this.method_6181();
        if (skip) {
            return false;
        }
        boolean bl2 = checkNavigation = this.ticksStill > 80 && this.canMove() && !this.isHovering();
        if (checkNavigation) {
            class_1408 navigation = this.method_5942();
            class_11 path = navigation.method_6345();
            return !navigation.method_6357() && (path == null || path.method_45() != null || this.method_24515().method_10262((class_2382)path.method_45().method_22879()) > 15.0);
        }
        return false;
    }

    public boolean isOverAir() {
        return this.isOverAir;
    }

    private boolean isOverAirLogic() {
        return this.method_37908().method_22347(class_2338.method_49637((double)this.method_31477(), (double)(this.method_5829().field_1322 - 1.0), (double)this.method_31479()));
    }

    public boolean isDiving() {
        return false;
    }

    public boolean isBeyondHeight() {
        if (this.method_23318() > (double)this.method_37908().method_31600()) {
            return true;
        }
        return this.method_23318() > (double)((Integer)IafCommonConfig.INSTANCE.dragon.maxFlight.getValue()).intValue();
    }

    private int calculateDownY() {
        if (this.method_5942().method_6345() != null) {
            class_11 path = this.method_5942().method_6345();
            class_243 p = path.method_47((class_1297)this, Math.min(path.method_38() - 1, path.method_39() + 1));
            if (p.field_1351 < this.method_23318() - 1.0) {
                return -1;
            }
        }
        return 1;
    }

    public void breakBlock(class_2338 position) {
        float hardness;
        if (((IafEvents.GriefBreakBlock)IafEvents.ON_GRIEF_BREAK_BLOCK.invoker()).onBreakBlock((class_1309)this, position.method_10263(), position.method_10264(), position.method_10260())) {
            return;
        }
        class_2680 state = this.method_37908().method_8320(position);
        float f = hardness = (Boolean)IafCommonConfig.INSTANCE.dragon.griefing.getValue() != false || this.getDragonStage() <= 3 ? 2.0f : 5.0f;
        if (this.isBreakable(position, state, hardness, this)) {
            this.method_18799(this.method_18798().method_18805((double)0.6f, 1.0, (double)0.6f));
            if (!this.method_37908().method_8608()) {
                this.method_37908().method_22352(position, !state.method_26164(IafBlockTags.DRAGON_BLOCK_BREAK_NO_DROPS) && (double)this.field_5974.method_43057() <= (Double)IafCommonConfig.INSTANCE.dragon.blockBreakingDropChance.getValue());
            }
        }
    }

    public void breakBlocks(boolean force) {
        boolean doBreak = force;
        if (this.blockBreakCounter > 0 || (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue() == 0) {
            --this.blockBreakCounter;
            if (this.blockBreakCounter == 0 || (Integer)IafCommonConfig.INSTANCE.dragon.breakBlockCooldown.getValue() == 0) {
                doBreak = true;
            }
        }
        if (doBreak && this.method_37908().method_8450().method_8355(class_1928.field_19388) && DragonUtils.canGrief(this) && !this.isModelDead() && this.getDragonStage() >= 3 && (this.canMove() || this.method_5642() != null)) {
            boolean bounds = true;
            int flightModifier = this.isFlying() && this.method_5968() != null ? -1 : 1;
            int yMinus = this.calculateDownY();
            class_2338.method_17962((int)((int)Math.floor(this.method_5829().field_1323) - 1), (int)((int)Math.floor(this.method_5829().field_1322) + yMinus), (int)((int)Math.floor(this.method_5829().field_1321) - 1), (int)((int)Math.floor(this.method_5829().field_1320) + 1), (int)((int)Math.floor(this.method_5829().field_1325) + 1 + flightModifier), (int)((int)Math.floor(this.method_5829().field_1324) + 1)).forEach(this::breakBlock);
        }
    }

    protected boolean isBreakable(class_2338 pos, class_2680 state, float hardness, EntityDragonBase entity) {
        return state.method_51366() && !state.method_26215() && state.method_26227().method_15769() && !state.method_26218((class_1922)this.method_37908(), pos).method_1110() && state.method_26214((class_1922)this.method_37908(), pos) >= 0.0f && state.method_26214((class_1922)this.method_37908(), pos) <= hardness && DragonUtils.canDragonBreak(state, (class_1297)entity) && this.canDestroyBlock(pos, state);
    }

    public void spawnGroundEffects() {
        if (this.method_37908().field_9236) {
            int i = 0;
            while ((float)i < this.getRenderSize()) {
                for (int i1 = 0; i1 < 20; ++i1) {
                    float radius = 0.75f * (0.7f * this.getRenderSize() / 3.0f) * -3.0f;
                    float angle = (float)Math.PI / 180 * this.field_6283 + (float)i1 * 1.0f;
                    double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
                    double extraY = 0.8f;
                    double extraZ = radius * class_3532.method_15362((float)angle);
                    class_2338 ground = this.getGround(class_2338.method_49637((double)(this.method_23317() + extraX), (double)(this.method_23318() + (double)0.8f - 1.0), (double)(this.method_23321() + extraZ)));
                    class_2680 BlockState = this.method_37908().method_8320(ground);
                    if (!BlockState.method_26215()) continue;
                    double motionX = this.method_6051().method_43059() * 0.07;
                    double motionY = this.method_6051().method_43059() * 0.07;
                    double motionZ = this.method_6051().method_43059() * 0.07;
                    this.method_37908().method_8466((class_2394)new class_2388(class_2398.field_11217, BlockState), true, this.method_23317() + extraX, (double)ground.method_10264() + (double)0.8f, this.method_23321() + extraZ, motionX, motionY, motionZ);
                }
                ++i;
            }
        }
    }

    private class_2338 getGround(class_2338 blockPos) {
        while (this.method_37908().method_22347(blockPos) && blockPos.method_10264() > 1) {
            blockPos = blockPos.method_10074();
        }
        return blockPos;
    }

    public boolean isActuallyBreathingFire() {
        return this.fireBreathTicks > 20 && this.isBreathingFire();
    }

    public boolean doesWantToLand() {
        return this.flyTicks > 6000 || this.isGoingDown() || this.flyTicks > 40 && this.flyProgress == 0.0f || this.isChained() && this.flyTicks > 100;
    }

    public abstract String getVariantName(int var1);

    public void method_5865(class_1297 passenger, class_1297.class_4738 callback) {
        super.method_5865(passenger, callback);
        if (this.method_5626(passenger)) {
            if (this.method_5642() == null || !this.method_5642().method_5667().equals(passenger.method_5667())) {
                this.updatePreyInMouth(passenger);
            } else {
                if (this.isModelDead()) {
                    passenger.method_5848();
                }
                this.method_36456(passenger.method_36454());
                this.method_5847(passenger.method_5791());
                this.method_36457(passenger.method_36455());
                class_243 riderPos = this.getRiderPosition();
                passenger.method_5814(riderPos.field_1352, riderPos.field_1351 + (double)passenger.method_17682(), riderPos.field_1350);
            }
        }
    }

    private float bob(float speed, float degree, boolean bounce, float f, float f1) {
        double a = class_3532.method_15374((float)(f * speed)) * f1 * degree;
        float bob = (float)(a - (double)(f1 * degree));
        if (bounce) {
            bob = (float)(-Math.abs(a));
        }
        return bob * this.getRenderSize() / 3.0f;
    }

    protected void updatePreyInMouth(class_1297 prey) {
        if (this.getAnimation() != ANIMATION_SHAKEPREY) {
            this.setAnimation(ANIMATION_SHAKEPREY);
        }
        if (this.getAnimation() == ANIMATION_SHAKEPREY && this.getAnimationTick() > 55 && prey != null) {
            float baseDamage = (float)this.method_5996(class_5134.field_23721).method_6194();
            float damage = baseDamage * 2.0f;
            boolean didDamage = prey.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), damage);
            if (didDamage && ((Boolean)IafCommonConfig.INSTANCE.dragon.canHealFromBiting.getValue()).booleanValue()) {
                this.method_6025(damage * 0.5f);
            }
            if (!(prey instanceof class_1657)) {
                this.setHunger(this.getHunger() + 1);
            }
            prey.method_5848();
        } else {
            double extraY;
            this.field_6283 = this.method_36454();
            float modTick_0 = this.getAnimationTick() - 25;
            float modTick_1 = this.getAnimationTick() > 25 && this.getAnimationTick() < 55 ? 8.0f * class_3532.method_15363((float)class_3532.method_15374((float)((float)(Math.PI + (double)modTick_0 * 0.25))), (float)-0.8f, (float)0.8f) : 0.0f;
            float modTick_2 = this.getAnimationTick() > 30 ? 10.0f : (float)Math.max(0, this.getAnimationTick() - 20);
            float radius = 0.75f * (0.6f * this.getRenderSize() / 3.0f) * -3.0f;
            float angle = (float)Math.PI / 180 * this.field_6283 + 3.15f + modTick_1 * 2.0f * 0.015f;
            double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * class_3532.method_15362((float)angle);
            double d = extraY = modTick_2 == 0.0f ? 0.0 : (double)0.035f * ((double)(this.getRenderSize() / 3.0f) + (double)modTick_2 * 0.5 * (double)(this.getRenderSize() / 3.0f));
            assert (prey != null);
            prey.method_5814(this.method_23317() + extraX, this.method_23318() + extraY, this.method_23321() + extraZ);
        }
    }

    public int getDragonStage() {
        int age = this.getAgeInDays();
        if (age >= 100) {
            return 5;
        }
        if (age >= 75) {
            return 4;
        }
        if (age >= 50) {
            return 3;
        }
        if (age >= 25) {
            return 2;
        }
        return 1;
    }

    public boolean isTeen() {
        return this.getDragonStage() == 3;
    }

    public boolean method_27071() {
        return this.getDragonStage() >= 4;
    }

    public boolean method_6109() {
        return this.getDragonStage() < 2;
    }

    public class_1315 method_5943(class_5425 worldIn, class_1266 difficultyIn, class_3730 reason, class_1315 spawnDataIn, class_2487 dataTag) {
        spawnDataIn = super.method_5943(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setGender(this.method_6051().method_43056());
        int age = this.method_6051().method_43048(80) + 1;
        this.growDragon(age);
        List<DragonColor> colors = DragonColor.getColorsByType(this.dragonType);
        this.setVariant(colors.get(new Random().nextInt(colors.size())).name());
        this.method_6179(false);
        double healthStep = (this.maximumHealth - this.minimumHealth) / 125.0;
        this.method_6025(Math.round(this.minimumHealth + healthStep * (double)age));
        this.usingGroundAttack = true;
        this.setHunger(50);
        return spawnDataIn;
    }

    public boolean method_5643(class_1282 dmg, float i) {
        if (this.isModelDead() && dmg != this.method_37908().method_48963().method_48829()) {
            return false;
        }
        if (this.method_5782() && dmg.method_5529() != null && this.method_5642() != null && dmg.method_5529() == this.method_5642()) {
            return false;
        }
        if ((dmg.method_48792().comp_1242().contains("arrow") || this.method_5854() != null && dmg.method_5529() != null && dmg.method_5529().method_5779(this.method_5854())) && this.method_5765()) {
            return false;
        }
        if (dmg.method_49708(class_8111.field_42340) || dmg.method_49708(class_8111.field_42356) || dmg.method_49708(class_8111.field_42341)) {
            return false;
        }
        if (!this.method_37908().field_9236 && dmg.method_5529() != null && this.method_6051().method_43048(4) == 0) {
            this.roar();
        }
        if (i > 0.0f && this.method_6113()) {
            this.method_6179(false);
            if (!this.method_6181() && dmg.method_5529() instanceof class_1657) {
                this.method_5980((class_1309)((class_1657)dmg.method_5529()));
            }
        }
        return super.method_5643(dmg, i);
    }

    public void method_18382() {
        super.method_18382();
        float scale = Math.min(this.getRenderSize() * 0.35f, 7.0f);
        if (scale != this.lastScale) {
            this.updateScale(this.getRenderSize() / 3.0f);
        }
        this.lastScale = scale;
    }

    public float method_49476() {
        return Math.max(1.2f, 1.2f + (float)(Math.min(this.getAgeInDays(), 125) - 25) * 1.8f / 100.0f);
    }

    public void method_5773() {
        super.method_5773();
        this.method_18382();
        this.updateParts();
        this.prevDragonPitch = this.getDragonPitch();
        this.method_37908().method_16107().method_15396("dragonLogic");
        this.method_49477(this.method_49476());
        this.isOverAir = this.isOverAirLogic();
        this.logic.updateDragonCommon();
        if (this.isModelDead()) {
            if (!this.method_37908().field_9236 && this.method_37908().method_22347(class_2338.method_49637((double)this.method_31477(), (double)this.method_5829().field_1322, (double)this.method_31479())) && this.method_23318() > -1.0) {
                this.method_5784(class_1313.field_6308, new class_243(0.0, (double)-0.2f, 0.0));
            }
            this.setBreathingFire(false);
            float dragonPitch = this.getDragonPitch();
            if (dragonPitch > 0.0f) {
                dragonPitch = Math.min(0.0f, dragonPitch - 5.0f);
                this.setDragonPitch(dragonPitch);
            }
            if (dragonPitch < 0.0f) {
                this.setDragonPitch(Math.max(0.0f, dragonPitch + 5.0f));
            }
        } else if (this.method_37908().field_9236) {
            this.logic.updateDragonClient();
        } else {
            this.logic.updateDragonServer();
            this.logic.updateDragonAttack();
        }
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15396("dragonFlight");
        if (this.useFlyingPathFinder() && !this.method_37908().field_9236) {
            this.flightManager.update();
        }
        this.method_37908().method_16107().method_15407();
        this.method_37908().method_16107().method_15407();
        if (!this.method_37908().method_8608() && ((Boolean)IafCommonConfig.INSTANCE.dragon.digWhenStuck.getValue()).booleanValue() && this.isStuck()) {
            this.breakBlocks(true);
            this.resetStuck();
        }
    }

    private void resetStuck() {
        this.ticksStill = 0;
    }

    public void method_6007() {
        super.method_6007();
        this.prevModelDeadProgress = this.modelDeadProgress;
        this.prevDiveProgress = this.diveProgress;
        this.prevAnimationProgresses[0] = this.sitProgress;
        this.prevAnimationProgresses[1] = this.sleepProgress;
        this.prevAnimationProgresses[2] = this.hoverProgress;
        this.prevAnimationProgresses[3] = this.flyProgress;
        this.prevAnimationProgresses[4] = this.fireBreathProgress;
        this.prevAnimationProgresses[5] = this.ridingProgress;
        this.prevAnimationProgresses[6] = this.tackleProgress;
        if (this.method_37908().method_8407() == class_1267.field_5801 && this.method_5968() instanceof class_1657) {
            this.method_5980(null);
        }
        if (this.isModelDead()) {
            if (this.method_5782()) {
                this.method_5772();
            }
            this.setHovering(false);
            this.setFlying(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((class_1297)this);
        if (this.animationTick > this.getAnimation().getDuration() && !this.method_37908().field_9236) {
            this.animationTick = 0;
        }
    }

    public class_4048 method_18377(class_4050 poseIn) {
        return this.method_5864().method_18386().method_18383(this.method_17825());
    }

    public float method_17825() {
        return Math.min(this.getRenderSize() * 0.35f, 7.0f);
    }

    protected void method_5623(double y, boolean onGroundIn, class_2680 state, class_2338 pos) {
    }

    public float getRenderSize() {
        int stage = this.getDragonStage() - 1;
        float step = (growth_stages[stage][1] - growth_stages[stage][0]) / 25.0f;
        if (this.getAgeInDays() > 125) {
            return growth_stages[stage][0] + step * 25.0f;
        }
        return growth_stages[stage][0] + step * (float)this.getAgeFactor();
    }

    private int getAgeFactor() {
        return this.getDragonStage() > 1 ? this.getAgeInDays() - 25 * (this.getDragonStage() - 1) : this.getAgeInDays();
    }

    public boolean method_6121(class_1297 entityIn) {
        this.method_5988().method_6226(entityIn, 30.0f, 30.0f);
        if (this.isTackling() || this.isModelDead()) {
            return false;
        }
        boolean flag = entityIn.method_5643(this.method_37908().method_48963().method_48812((class_1309)this), (float)((int)this.method_5996(class_5134.field_23721).method_6194()));
        if (flag) {
            this.method_5723((class_1309)this, entityIn);
        }
        return flag;
    }

    public void method_5842() {
        class_1297 entity = this.method_5854();
        if (this.method_5765() && !entity.method_5805()) {
            this.method_5848();
        } else {
            this.method_18800(0.0, 0.0, 0.0);
            this.method_5773();
            if (this.method_5765()) {
                this.updateRiding(entity);
            }
        }
    }

    public void updateRiding(class_1297 riding) {
        if (riding != null && riding.method_5626((class_1297)this) && riding instanceof class_1657) {
            class_1657 player = (class_1657)riding;
            int i = riding.method_5685().indexOf(this);
            float radius = (i == 2 ? -0.2f : 0.5f) + (float)(player.method_6128() ? 2 : 0);
            float angle = (float)Math.PI / 180 * player.field_6283 + (float)(i == 1 ? 90 : (i == 0 ? -90 : 0));
            double extraX = radius * class_3532.method_15374((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * class_3532.method_15362((float)angle);
            double extraY = (riding.method_5715() ? 1.2 : 1.4) + (i == 2 ? 0.4 : 0.0);
            this.field_6241 = player.field_6241;
            this.method_36456(this.field_6241);
            this.method_5814(riding.method_23317() + extraX, riding.method_23318() + extraY, riding.method_23321() + extraZ);
            if ((this.getControlState() == 16 || player.method_6128()) && !riding.method_5765()) {
                this.method_5848();
                if (this.method_37908().field_9236) {
                    class_2540 buf = PacketBufferUtils.create();
                    buf.writeInt(this.method_5628()).writeBoolean(false).writeBoolean(true);
                    NetworkManager.sendToServer((class_2960)StaticVariables.START_RIDING_MOB_C2S, (class_2540)buf);
                }
            }
        }
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int tick) {
        this.animationTick = tick;
    }

    public Animation getAnimation() {
        if (this.isModelDead()) {
            return NO_ANIMATION;
        }
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        if (this.isModelDead()) {
            return;
        }
        this.currentAnimation = animation;
    }

    public void method_5966() {
        if (!(this.method_6113() || this.isModelDead() || this.method_37908().field_9236)) {
            if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.method_5966();
        }
    }

    protected void method_6013(class_1282 source) {
        if (!this.isModelDead()) {
            if (this.getAnimation() == IAnimatedEntity.NO_ANIMATION && !this.method_37908().field_9236) {
                this.setAnimation(ANIMATION_SPEAK);
            }
            super.method_6013(source);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{IAnimatedEntity.NO_ANIMATION, ANIMATION_EAT};
    }

    public class_1296 method_5613(class_3218 serverWorld, class_1296 ageable) {
        return null;
    }

    public boolean method_6474(class_1429 other) {
        EntityDragonBase dragon;
        if (this.getDragonStage() < 4 || this.isModelDead || !(other instanceof EntityDragonBase) || (dragon = (EntityDragonBase)other).getDragonStage() < 4 || dragon.isModelDead) {
            return false;
        }
        if (other != this && other.getClass() == this.getClass()) {
            return this.isMale() && !dragon.isMale() || !this.isMale() && dragon.isMale();
        }
        return false;
    }

    public EntityDragonEgg createEgg() {
        EntityDragonEgg dragon = new EntityDragonEgg((class_1299<EntityDragonEgg>)((class_1299)IafEntities.DRAGON_EGG.get()), this.method_37908());
        List<DragonColor> colors = DragonColor.getColorsByType(this.dragonType);
        dragon.setEggType(colors.isEmpty() ? DragonColor.RED : (DragonColor)RandomHelper.randomOne(colors));
        dragon.method_5814((double)class_3532.method_15357((double)this.method_23317()) + 0.5, class_3532.method_15357((double)this.method_23318()) + 1, (double)class_3532.method_15357((double)this.method_23321()) + 0.5);
        return dragon;
    }

    public boolean isTargetBlocked(class_243 target) {
        if (target != null) {
            class_3965 rayTrace = this.method_37908().method_17742(new class_3959(this.method_19538().method_1031(0.0, (double)this.method_5751(), 0.0), target, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            class_2338 sidePos = rayTrace.method_17777();
            if (!this.method_37908().method_22347(sidePos)) {
                return true;
            }
            return rayTrace.method_17783() == class_239.class_240.field_1332;
        }
        return false;
    }

    private double getFlySpeed() {
        return (2.0 + (double)this.getAgeInDays() / 125.0 * 2.0) * (double)(this.isTackling() ? 2 : 1);
    }

    public boolean isTackling() {
        return (Boolean)this.field_6011.method_12789(TACKLE);
    }

    public void setTackling(boolean tackling) {
        this.field_6011.method_12778(TACKLE, (Object)tackling);
    }

    public boolean isAgingDisabled() {
        return (Boolean)this.field_6011.method_12789(AGINGDISABLED);
    }

    public void setAgingDisabled(boolean isAgingDisabled) {
        this.field_6011.method_12778(AGINGDISABLED, (Object)isAgingDisabled);
    }

    public boolean isBoundToCrystal() {
        return (Boolean)this.field_6011.method_12789(CRYSTAL_BOUND);
    }

    public void setCrystalBound(boolean crystalBound) {
        this.field_6011.method_12778(CRYSTAL_BOUND, (Object)crystalBound);
    }

    public float getDistanceSquared(class_243 Vector3d) {
        float f = (float)(this.method_23317() - Vector3d.field_1352);
        float f1 = (float)(this.method_23318() - Vector3d.field_1351);
        float f2 = (float)(this.method_23321() - Vector3d.field_1350);
        return f * f + f1 * f1 + f2 * f2;
    }

    public boolean method_6062() {
        return this.method_6032() <= 0.0f || this.method_24345() && !this.method_5782() || this.isModelDead() || this.method_5765();
    }

    public boolean method_5799() {
        return super.method_5799() && this.method_5861(class_3486.field_15517) > (double)class_3532.method_15375((float)((float)this.getDragonStage() / 2.0f));
    }

    public void method_6091(class_243 pTravelVector) {
        if (this.getAnimation() == ANIMATION_SHAKEPREY || !this.canMove() && !this.method_5782() || this.method_24345()) {
            if (this.method_5942().method_6345() != null) {
                this.method_5942().method_6340();
            }
            pTravelVector = new class_243(0.0, 0.0, 0.0);
        }
        Objects.requireNonNull(this);
        if (this.method_5642() != null) {
            class_1309 rider = this.method_5642();
            if (rider == null) {
                super.method_6091(pTravelVector);
                return;
            }
            if (this.isHovering() || this.isFlying()) {
                double forward = rider.field_6250;
                double strafing = rider.field_6212;
                double vertical = 0.0;
                float speed = (float)this.method_26825(class_5134.field_23719);
                float airSpeedModifier = (float)((double)5.2f + 1.0 * class_3532.method_33722((double)speed, (double)this.minimumSpeed, (double)this.maximumSpeed, (double)0.0, (double)1.5));
                speed *= airSpeedModifier;
                if (forward > 0.0) {
                    this.setFlying(true);
                    this.setHovering(false);
                }
                this.setTackling(this.method_6510() && this.method_36455() > -5.0f && this.method_18798().method_1033() > 1.0);
                Objects.requireNonNull(this);
                boolean bl = this.gliding = rider.method_5624();
                if (!this.gliding) {
                    speed += this.glidingSpeedBonus;
                    forward *= rider.field_6250 > 0.0f ? 1.0 : 0.5;
                    strafing *= (double)0.4f;
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = 1.0;
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = -1.0;
                    } else {
                        this.method_5787();
                    }
                } else {
                    speed *= 1.5f;
                    strafing *= (double)0.1f;
                    this.glidingSpeedBonus = (float)class_3532.method_15350((double)((double)this.glidingSpeedBonus + this.method_18798().field_1351 * -0.05), (double)-0.8, (double)1.5);
                    speed += this.glidingSpeedBonus;
                    forward = class_3532.method_15379((float)class_3532.method_15362((float)(this.method_36455() * ((float)Math.PI / 180))));
                    vertical = class_3532.method_15379((float)class_3532.method_15374((float)(this.method_36455() * ((float)Math.PI / 180))));
                    if (this.isGoingUp() && !this.isGoingDown()) {
                        vertical = Math.max(vertical, 0.5);
                    } else if (this.isGoingDown() && !this.isGoingUp()) {
                        vertical = Math.min(vertical, -0.5);
                    } else if (this.isGoingUp() && this.isGoingDown()) {
                        vertical = 0.0;
                    } else if (this.method_36455() < 0.0f) {
                        vertical *= 1.0;
                    } else if (this.method_36455() > 0.0f) {
                        vertical *= -1.0;
                    } else {
                        this.method_5787();
                    }
                }
                this.glidingSpeedBonus -= (float)((double)this.glidingSpeedBonus * 0.01);
                if (this.method_5787()) {
                    float flyingSpeed = speed * 0.1f;
                    this.method_6125(flyingSpeed);
                    this.method_5724(flyingSpeed, new class_243(strafing, vertical, forward));
                    this.method_5784(class_1313.field_6308, this.method_18798());
                    this.method_18799(this.method_18798().method_18806(new class_243(0.9, 0.9, 0.9)));
                    class_243 currentMotion = this.method_18798();
                    if (this.field_5976) {
                        currentMotion = new class_243(currentMotion.field_1352, 0.1, currentMotion.field_1350);
                    }
                    this.method_18799(currentMotion);
                    this.method_29242(false);
                } else {
                    this.method_18799(class_243.field_1353);
                }
                this.method_36974();
                this.updatePitch(this.field_5971 - this.method_23318());
            } else if (this.method_5799() || this.method_5771()) {
                double forward = rider.field_6250;
                double strafing = rider.field_6212;
                double vertical = 0.0;
                float speed = (float)this.method_26825(class_5134.field_23719);
                if (this.isGoingUp() && !this.isGoingDown()) {
                    vertical = 0.5;
                } else if (this.isGoingDown() && !this.isGoingUp()) {
                    vertical = -0.5;
                }
                float flyingSpeed = speed;
                this.method_6125(flyingSpeed);
                this.method_5930((float)forward);
                super.method_6091(pTravelVector.method_1031(strafing, vertical, forward));
            } else {
                double forward = rider.field_6250;
                double strafing = rider.field_6212 * 0.5f;
                double vertical = pTravelVector.field_1351;
                float speed = (float)this.method_26825(class_5134.field_23719);
                float groundSpeedModifier = (float)((double)1.8f * this.getFlightSpeedModifier());
                forward *= (double)(speed *= groundSpeedModifier);
                forward *= rider.method_5624() ? (double)1.2f : 1.0;
                forward *= rider.field_6250 > 0.0f ? 1.0 : (double)0.2f;
                if (this.method_5787()) {
                    this.method_6125(speed);
                    super.method_6091(new class_243(strafing, vertical, forward));
                } else {
                    this.method_18799(class_243.field_1353);
                }
                this.method_36974();
                this.updatePitch(this.field_5971 - this.method_23318());
            }
        } else {
            super.method_6091(pTravelVector);
        }
    }

    public void updatePitch(double verticalDelta) {
        if (this.isOverAir() && !this.method_5765()) {
            if (!this.isHovering()) {
                this.incrementDragonPitch((float)verticalDelta * 10.0f);
            }
            this.setDragonPitch(class_3532.method_15363((float)this.getDragonPitch(), (float)-60.0f, (float)40.0f));
            float plateau = 2.0f;
            float planeDist = (float)((Math.abs(this.method_18798().field_1352) + Math.abs(this.method_18798().field_1350)) * 6.0);
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(planeDist * Math.abs(this.getDragonPitch()) / 90.0f);
            }
            if (this.getDragonPitch() > 2.0f) {
                this.decrementDragonPitch(1.0f);
            } else if (this.getDragonPitch() < -2.0f) {
                this.incrementDragonPitch(1.0f);
            }
            if (this.method_5642() == null && this.getDragonPitch() < -45.0f && planeDist < 3.0f && this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
        } else if (class_3532.method_15379((float)this.getDragonPitch()) < 1.0f) {
            this.setDragonPitch(0.0f);
        } else {
            this.setDragonPitch(this.getDragonPitch() / 1.5f);
        }
    }

    public void updateRider() {
        class_1309 controllingPassenger = this.method_5642();
        if (controllingPassenger instanceof class_1657) {
            class_1657 rider = (class_1657)controllingPassenger;
            this.ticksStill = 0;
            this.hoverTicks = 0;
            this.flyTicks = 0;
            if (this.isGoingUp()) {
                if (!this.isFlying() && !this.isHovering()) {
                    this.spacebarTicks += 2;
                }
            } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.setCommand(2);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.method_35057() != null && this.method_5685().contains(this.method_35057()) && !this.isFlying() && !this.isHovering() && !this.method_5799()) {
                this.setHovering(true);
                this.spacebarTicks = 0;
                this.glidingSpeedBonus = 0.0f;
            }
            if (this.isFlying() || this.isHovering()) {
                if (rider.field_6250 > 0.0f) {
                    this.setFlying(true);
                    this.setHovering(false);
                } else {
                    this.setFlying(false);
                    this.setHovering(true);
                }
                if (!this.isOverAir() && this.isFlying() && rider.method_36455() > 10.0f && !this.method_5799()) {
                    this.setHovering(false);
                    this.setFlying(false);
                }
                if (!this.isOverAir() && this.isGoingDown() && !this.method_5799()) {
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (this.isTackling()) {
                ++this.tacklingTicks;
                if (this.tacklingTicks == 40) {
                    this.tacklingTicks = 0;
                }
                if (!this.isFlying() && this.method_24828()) {
                    this.tacklingTicks = 0;
                    this.setTackling(false);
                }
                List victims = this.method_37908().method_8333((class_1297)this, this.method_5829().method_1012(2.0, 2.0, 2.0), potentialVictim -> potentialVictim != rider && potentialVictim instanceof class_1309);
                victims.forEach(victim -> this.logic.attackTarget((class_1297)victim, rider, this.getDragonStage() * 3));
            }
            if (this.isStriking() && this.method_5642() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire((class_1297)this.method_5642());
                this.fireStopTicks = 10;
            }
            if (this.method_6510() && this.method_5642() != null && this.method_5642() instanceof class_1657) {
                int damage;
                boolean didDamage;
                class_1309 target = DragonUtils.riderLookingAtEntity((class_1309)this, this.method_5642(), (double)this.getDragonStage() + (this.method_5829().field_1320 - this.method_5829().field_1323));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (class_1297)target) && (didDamage = this.logic.attackTarget((class_1297)target, rider, damage = (int)this.method_5996(class_5134.field_23721).method_6194())) && ((Boolean)IafCommonConfig.INSTANCE.dragon.canHealFromBiting.getValue()).booleanValue()) {
                    this.method_6025((float)damage * 0.1f);
                }
            }
            if (this.method_5642() != null && this.method_5642().method_5715()) {
                IafEntityData data = IafEntityData.get(this.method_5642());
                data.miscData.setDismounted(true);
                this.method_5642().method_5848();
            }
            if (this.method_5968() != null && !this.method_5685().isEmpty() && this.method_35057() != null && this.method_5685().contains(this.method_35057())) {
                this.method_5980(null);
            }
            if (this.method_36601().method_26227().method_15771() && this.method_5799() && !this.isGoingUp()) {
                this.setFlying(false);
                this.setHovering(false);
            }
        } else if (controllingPassenger instanceof EntityDreadQueen) {
            class_1657 ridingPlayer = this.getRidingPlayer();
            if (ridingPlayer != null) {
                if (this.isGoingUp()) {
                    if (!this.isFlying() && !this.isHovering()) {
                        this.spacebarTicks += 2;
                    }
                } else if (this.isDismounting() && (this.isFlying() || this.isHovering())) {
                    this.method_18799(this.method_18798().method_1031(0.0, -0.04, 0.0));
                    this.setFlying(false);
                    this.setHovering(false);
                }
            }
            if (!this.isDismounting() && (this.isFlying() || this.isHovering())) {
                this.method_18799(this.method_18798().method_1031(0.0, 0.01, 0.0));
            }
            if (this.isStriking() && this.method_5642() != null && this.getDragonStage() > 1) {
                this.setBreathingFire(true);
                this.riderShootFire((class_1297)this.method_5642());
                this.fireStopTicks = 10;
            }
            if (this.method_6510() && this.method_5642() != null && this.method_5642() instanceof class_1657) {
                class_1309 target = DragonUtils.riderLookingAtEntity((class_1309)this, this.method_5642(), (double)this.getDragonStage() + (this.method_5829().field_1320 - this.method_5829().field_1323));
                if (this.getAnimation() != ANIMATION_BITE) {
                    this.setAnimation(ANIMATION_BITE);
                }
                if (target != null && !DragonUtils.hasSameOwner(this, (class_1297)target)) {
                    this.logic.attackTarget((class_1297)target, ridingPlayer, (int)this.method_5996(class_5134.field_23721).method_6194());
                }
            }
            if (this.method_5642() != null && this.method_5642().method_5715()) {
                IafEntityData data = IafEntityData.get(this.method_5642());
                data.miscData.setDismounted(true);
                this.method_5642().method_5848();
            }
            if (this.isFlying()) {
                if (!this.isHovering() && this.method_5642() != null && !this.method_24828() && Math.max(Math.abs(this.method_18798().method_10216()), Math.abs(this.method_18798().method_10215())) < (double)0.1f) {
                    this.setHovering(true);
                    this.setFlying(false);
                }
            } else if (this.isHovering() && this.method_5642() != null && !this.method_24828() && Math.max(Math.abs(this.method_18798().method_10216()), Math.abs(this.method_18798().method_10215())) > (double)0.1f) {
                this.setFlying(true);
                this.usingGroundAttack = false;
                this.setHovering(false);
            }
            if (this.spacebarTicks > 0) {
                --this.spacebarTicks;
            }
            if (this.spacebarTicks > 20 && this.method_35057() != null && this.method_5685().contains(this.method_35057()) && !this.isFlying() && !this.isHovering()) {
                this.setHovering(true);
            }
            if (this.method_5782() && !this.isOverAir() && this.isFlying() && !this.isHovering() && this.flyTicks > 40) {
                this.setFlying(false);
            }
        }
    }

    public void method_5784(class_1313 pType, class_243 pPos) {
        if (this.method_24345() && !this.method_5782()) {
            pPos = new class_243(0.0, pPos.method_10214(), 0.0);
        }
        if (this.method_5782()) {
            if (this.method_5787()) {
                if (this.field_5976) {
                    this.method_18799(this.method_18798().method_18805((double)0.6f, 1.0, (double)0.6f));
                }
                super.method_5784(pType, pPos);
            } else {
                super.method_5784(pType, pPos);
            }
            this.method_5875(this.isHovering() || this.isFlying());
        } else {
            this.method_5875(false);
            super.method_5784(pType, pPos);
        }
    }

    public void updateCheckPlayer() {
        double checkLength = this.method_5829().method_995() * 3.0;
        class_1657 player = this.method_37908().method_18460((class_1297)this, checkLength);
        if (this.method_6113() && player != null && !this.method_6171((class_1309)player) && !player.method_7337()) {
            this.method_6179(false);
            this.method_24346(false);
            this.method_5980((class_1309)player);
        }
    }

    public boolean isDirectPathBetweenPoints(class_243 vec1, class_243 vec2) {
        class_3965 rayTrace = this.method_37908().method_17742(new class_3959(vec1, new class_243(vec2.field_1352, vec2.field_1351 + (double)this.method_17682() * 0.5, vec2.field_1350), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        return rayTrace.method_17783() != class_239.class_240.field_1332;
    }

    public void method_6078(class_1282 cause) {
        super.method_6078(cause);
        this.setHunger(this.getHunger() + FoodUtils.getFoodPoints((class_1297)this));
    }

    @Override
    public void onHearFlute(class_1657 player) {
        if (this.method_6181() && this.method_6171((class_1309)player) && (this.isFlying() || this.isHovering())) {
            this.setFlying(false);
            this.setHovering(false);
        }
    }

    public abstract class_3414 getRoarSound();

    public void roar() {
        block9: {
            block8: {
                if (EntityGorgon.isStoneMob((class_1309)this) || this.isModelDead()) {
                    return;
                }
                if (!this.field_5974.method_43056()) break block8;
                if (this.getAnimation() != ANIMATION_EPIC_ROAR) {
                    this.setAnimation(ANIMATION_EPIC_ROAR);
                    this.method_5783(this.getRoarSound(), this.method_6107() + 3.0f + (float)Math.max(0, this.getDragonStage() - 2), this.method_6017() * 0.7f);
                }
                if (this.getDragonStage() <= 3) break block9;
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1012((double)size, (double)size, (double)size));
                for (class_1297 entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = (class_1309)entity;
                    if (isStrongerDragon) continue;
                    if (this.method_6171(living) || this.isOwnersPet(living)) {
                        living.method_6092(new class_1293(class_1294.field_5910, 50 * size));
                        continue;
                    }
                    if (living.method_6118(class_1304.field_6169).method_7909() == IafItems.EARPLUGS.get()) continue;
                    living.method_6092(new class_1293(class_1294.field_5911, 50 * size));
                }
                break block9;
            }
            if (this.getAnimation() != ANIMATION_ROAR) {
                this.setAnimation(ANIMATION_ROAR);
                this.method_5783(this.getRoarSound(), this.method_6107() + 2.0f + (float)Math.max(0, this.getDragonStage() - 3), this.method_6017());
            }
            if (this.getDragonStage() > 3) {
                int size = (this.getDragonStage() - 3) * 30;
                List entities = this.method_37908().method_8335((class_1297)this, this.method_5829().method_1012((double)size, (double)size, (double)size));
                for (class_1297 entity : entities) {
                    boolean isStrongerDragon;
                    boolean bl = isStrongerDragon = entity instanceof EntityDragonBase && ((EntityDragonBase)entity).getDragonStage() >= this.getDragonStage();
                    if (!(entity instanceof class_1309)) continue;
                    class_1309 living = (class_1309)entity;
                    if (isStrongerDragon) continue;
                    if (this.method_6171(living) || this.isOwnersPet(living)) {
                        living.method_6092(new class_1293(class_1294.field_5910, 30 * size));
                        continue;
                    }
                    living.method_6092(new class_1293(class_1294.field_5911, 30 * size));
                }
            }
        }
    }

    private boolean isOwnersPet(class_1309 living) {
        return this.method_6181() && this.method_35057() != null && living instanceof class_1321 && ((class_1321)living).method_35057() != null && this.method_35057().method_5779((class_1297)((class_1321)living).method_35057());
    }

    public boolean isDirectPathBetweenPoints(class_1297 entity, class_243 vec1, class_243 vec2) {
        class_3965 movingobjectposition = this.method_37908().method_17742(new class_3959(vec1, vec2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
        return movingobjectposition.method_17783() != class_239.class_240.field_1332;
    }

    public boolean shouldRenderEyes() {
        return !this.method_6113() && !this.isModelDead() && !this.isBlinking() && !EntityGorgon.isStoneMob((class_1309)this);
    }

    @Override
    public boolean shouldAnimalsFear(class_1297 entity) {
        return DragonUtils.canTameDragonAttack(this, entity);
    }

    @Override
    public void dropArmor() {
    }

    public boolean isChained() {
        AtomicBoolean isChained = new AtomicBoolean(false);
        IafEntityData data = IafEntityData.get((class_1309)this);
        isChained.set(data.chainData.getChainedTo().isEmpty());
        return isChained.get();
    }

    protected void method_16077(class_1282 damageSourceIn, boolean attackedRecently) {
    }

    public class_239 rayTraceRider(class_1297 rider, double blockReachDistance, float partialTicks) {
        class_243 Vector3d = rider.method_5836(partialTicks);
        class_243 Vector3d1 = rider.method_5828(partialTicks);
        class_243 Vector3d2 = Vector3d.method_1031(Vector3d1.field_1352 * blockReachDistance, Vector3d1.field_1351 * blockReachDistance, Vector3d1.field_1350 * blockReachDistance);
        return this.method_37908().method_17742(new class_3959(Vector3d, Vector3d2, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
    }

    protected float getRideHeightBase() {
        return 0.00223789f * class_3532.method_27285((float)this.getRenderSize()) + 0.23313718f * this.getRenderSize() - 1.7179043f;
    }

    protected float getRideHorizontalBase() {
        return 0.00336283f * class_3532.method_27285((float)this.getRenderSize()) + 0.19342425f * this.getRenderSize() - 0.026221339f;
    }

    public class_243 getRiderPosition() {
        float extraXZ = 0.0f;
        float extraY = 0.0f;
        float pitchXZ = 0.0f;
        float pitchY = 0.0f;
        float dragonPitch = this.getDragonPitch();
        if (dragonPitch > 0.0f) {
            pitchXZ = Math.min(dragonPitch / 90.0f, 0.2f);
            pitchY = -(dragonPitch / 90.0f) * 0.6f;
        } else if (dragonPitch < 0.0f) {
            pitchXZ = Math.max(dragonPitch / 90.0f, -0.5f);
            pitchY = dragonPitch / 90.0f * 0.03f;
        }
        extraXZ += pitchXZ * this.getRenderSize();
        extraY += pitchY * this.getRenderSize();
        float linearFactor = class_3532.method_37959((float)Math.max(this.getAgeInDays() - 50, 0), (float)0.0f, (float)75.0f, (float)0.0f, (float)1.0f);
        class_1309 rider = this.method_5642();
        if (rider != null && rider.method_36455() < 0.0f) {
            extraY += (float)class_3532.method_33722((double)rider.method_36455(), (double)60.0, (double)-40.0, (double)-0.1, (double)0.1);
        }
        if (this.isHovering() || this.isFlying()) {
            extraY += 1.1f * linearFactor;
            extraY += this.getRideHeightBase() * 0.6f;
        } else {
            if (rider != null && rider.field_6250 > 0.0f) {
                float MAX_RAISE_HEIGHT = 1.1f * linearFactor + this.getRideHeightBase() * 0.1f;
                this.riderWalkingExtraY = Math.min(MAX_RAISE_HEIGHT, this.riderWalkingExtraY + 0.1f);
            } else {
                this.riderWalkingExtraY = Math.max(0.0f, this.riderWalkingExtraY - 0.15f);
            }
            extraY += this.riderWalkingExtraY;
        }
        float xzMod = this.getRideHorizontalBase() + extraXZ;
        float yMod = this.getRideHeightBase() + extraY;
        float headPosX = (float)(this.method_23317() + (double)(xzMod * class_3532.method_15362((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.method_23318() + (double)yMod);
        float headPosZ = (float)(this.method_23321() + (double)(xzMod * class_3532.method_15374((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
        return new class_243((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public class_243 method_24829(class_1309 passenger) {
        if (passenger.method_5757()) {
            return this.method_19538().method_1031(0.0, 1.0, 0.0);
        }
        return this.getRiderPosition().method_1031(0.0, (double)passenger.method_17682(), 0.0);
    }

    public void method_5768() {
        this.method_5650(class_1297.class_5529.field_26998);
        this.setDeathStage(this.getAgeInDays() / 5);
        this.setModelDead(false);
    }

    public boolean method_5722(class_1297 entityIn) {
        if (this.isModelDead()) {
            return true;
        }
        if (this.method_6181()) {
            class_1309 livingentity = this.method_35057();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof class_1321) {
                class_1321 entity = (class_1321)entityIn;
                return entity.method_6171(livingentity);
            }
            if (livingentity != null) {
                return livingentity.method_5722(entityIn);
            }
        }
        return super.method_5722(entityIn);
    }

    public class_243 getHeadPosition() {
        float sitProg = this.sitProgress * 0.015f;
        float deadProg = this.modelDeadProgress * -0.02f;
        float hoverProg = this.hoverProgress * 0.03f;
        float flyProg = this.flyProgress * 0.01f;
        int tick = this.getAnimationTick() < 10 ? this.getAnimationTick() : (this.getAnimationTick() > 50 ? 60 - this.getAnimationTick() : 10);
        float epicRoarProg = this.getAnimation() == ANIMATION_EPIC_ROAR ? (float)tick * 0.1f : 0.0f;
        float sleepProg = this.sleepProgress * -0.025f;
        float pitchMulti = 0.0f;
        float pitchAdjustment = 0.0f;
        float pitchMinus = 0.0f;
        float dragonPitch = -this.getDragonPitch();
        if (this.isFlying() || this.isHovering()) {
            pitchMulti = class_3532.method_15374((float)((float)Math.toRadians(dragonPitch)));
            pitchAdjustment = 1.2f;
            if ((pitchMulti *= 2.1f * Math.abs(dragonPitch) / 90.0f) > 0.0f) {
                pitchMulti *= 1.5f - pitchMulti * 0.5f;
            }
            if (pitchMulti < 0.0f) {
                pitchMulti *= 1.3f - pitchMulti * 0.1f;
            }
            pitchMinus = 0.3f * Math.abs(dragonPitch / 90.0f);
            if (dragonPitch >= 0.0f) {
                pitchAdjustment = 0.6f * Math.abs(dragonPitch / 90.0f);
                pitchMinus = 0.95f * Math.abs(dragonPitch / 90.0f);
            }
        }
        float flightXz = 1.0f + flyProg + hoverProg;
        float xzMod = 1.7f * this.getRenderSize() * 0.3f * flightXz + this.getRenderSize() * (0.3f * class_3532.method_15374((float)((float)((double)(dragonPitch + 90.0f) * Math.PI / 180.0))) * pitchAdjustment - pitchMinus - hoverProg * 0.45f);
        float headPosX = (float)(this.method_23317() + (double)(xzMod * class_3532.method_15362((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
        float headPosY = (float)(this.method_23318() + (double)((0.7f + sitProg + hoverProg + deadProg + epicRoarProg + sleepProg + flyProg + pitchMulti) * this.getRenderSize() * 0.3f));
        float headPosZ = (float)(this.method_23321() + (double)(xzMod * class_3532.method_15374((float)((float)((double)(this.method_36454() + 90.0f) * Math.PI / 180.0)))));
        return new class_243((double)headPosX, (double)headPosY, (double)headPosZ);
    }

    public abstract void stimulateFire(double var1, double var3, double var5, int var7);

    public void randomizeAttacks() {
        this.airAttack = IafDragonAttacks.Air.values()[this.method_6051().method_43048(IafDragonAttacks.Air.values().length)];
        this.groundAttack = IafDragonAttacks.Ground.values()[this.method_6051().method_43048(IafDragonAttacks.Ground.values().length)];
    }

    public boolean method_5853(class_1927 explosionIn, class_1922 worldIn, class_2338 pos, class_2680 blockStateIn, float explosionPower) {
        return !(blockStateIn.method_26204() instanceof IDragonProof) && DragonUtils.canDragonBreak(blockStateIn, (class_1297)this);
    }

    public void tryScorchTarget() {
        class_1309 entity = this.method_5968();
        if (entity != null) {
            float distX = (float)(entity.method_23317() - this.method_23317());
            float distZ = (float)(entity.method_23321() - this.method_23321());
            if (this.isBreathingFire()) {
                if (this.isActuallyBreathingFire()) {
                    this.method_36456(this.field_6283);
                    if (this.field_6012 % 5 == 0) {
                        this.method_5783((class_3414)IafSounds.FIREDRAGON_BREATH.get(), 4.0f, 1.0f);
                    }
                    int breathTicks = class_3532.method_15340((int)this.fireBreathTicks, (int)0, (int)40);
                    this.stimulateFire(this.method_23317() + (double)(distX * (float)breathTicks / 40.0f), entity.method_23318(), this.method_23321() + (double)(distZ * (float)breathTicks / 40.0f), 1);
                }
            } else {
                this.setBreathingFire(true);
            }
        }
    }

    public void method_5980(class_1309 LivingEntityIn) {
        super.method_5980(LivingEntityIn);
        this.flightManager.onSetAttackTarget(LivingEntityIn);
    }

    public boolean method_6178(class_1309 target, class_1309 owner) {
        class_1321 tamableTarget;
        UUID targetOwner;
        if (this.method_6181() && target instanceof class_1321 && (targetOwner = (tamableTarget = (class_1321)target).method_6139()) != null && targetOwner.equals(this.method_6139())) {
            return false;
        }
        return super.method_6178(target, owner);
    }

    public boolean method_18395(class_1309 target) {
        return super.method_18395(target) && DragonUtils.isAlive(target);
    }

    public boolean isPart(class_1297 entityHit) {
        return this.headPart != null && this.headPart.method_5779(entityHit) || this.neckPart != null && this.neckPart.method_5779(entityHit) || this.leftWingLowerPart != null && this.leftWingLowerPart.method_5779(entityHit) || this.rightWingLowerPart != null && this.rightWingLowerPart.method_5779(entityHit) || this.leftWingUpperPart != null && this.leftWingUpperPart.method_5779(entityHit) || this.rightWingUpperPart != null && this.rightWingUpperPart.method_5779(entityHit) || this.tail1Part != null && this.tail1Part.method_5779(entityHit) || this.tail2Part != null && this.tail2Part.method_5779(entityHit) || this.tail3Part != null && this.tail3Part.method_5779(entityHit) || this.tail4Part != null && this.tail4Part.method_5779(entityHit);
    }

    @Override
    public double getFlightSpeedModifier() {
        return (Double)IafCommonConfig.INSTANCE.dragon.dragonFlightSpeedMod.getValue();
    }

    public boolean isAllowedToTriggerFlight() {
        return (this.hasFlightClearance() && this.method_24828() || this.method_5799()) && !this.method_24345() && this.method_5685().isEmpty() && !this.method_6109() && !this.method_6113() && this.canMove();
    }

    public class_2338 getEscortPosition() {
        return this.method_35057() != null ? new class_2338((class_2382)this.method_35057().method_24515()) : this.method_24515();
    }

    public boolean shouldTPtoOwner() {
        return this.method_35057() != null && this.method_5739((class_1297)this.method_35057()) > 10.0f;
    }

    public boolean isSkeletal() {
        return this.getDeathStage() >= this.getAgeInDays() / 5 / 2;
    }

    public boolean method_5662(class_2487 compound) {
        return this.method_5786(compound);
    }

    public void method_5783(class_3414 soundIn, float volume, float pitch) {
        if (soundIn == class_3417.field_20614 || soundIn == this.method_5994() || soundIn == this.method_6011(this.method_37908().method_48963().method_48830()) || soundIn == this.method_6002() || soundIn == this.getRoarSound()) {
            if (!this.method_5701() && this.headPart != null) {
                this.method_37908().method_43128(null, this.headPart.method_23317(), this.headPart.method_23318(), this.headPart.method_23321(), soundIn, this.method_5634(), volume, pitch);
            }
        } else {
            super.method_5783(soundIn, volume, pitch);
        }
    }

    public class_3419 method_5634() {
        return class_3419.field_15251;
    }

    public boolean hasFlightClearance() {
        class_2338 topOfBB = class_2338.method_49637((double)this.method_31477(), (double)this.method_5829().field_1325, (double)this.method_31479());
        for (int i = 1; i < 4; ++i) {
            if (this.method_37908().method_22347(topOfBB.method_10086(i))) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_6118(class_1304 slotIn) {
        return switch (slotIn) {
            case class_1304.field_6171 -> this.dragonInventory.method_5438(0);
            case class_1304.field_6169 -> this.dragonInventory.method_5438(1);
            case class_1304.field_6174 -> this.dragonInventory.method_5438(2);
            case class_1304.field_6172 -> this.dragonInventory.method_5438(3);
            case class_1304.field_6166 -> this.dragonInventory.method_5438(4);
            default -> super.method_6118(slotIn);
        };
    }

    public void method_5673(class_1304 slotIn, class_1799 stack) {
        switch (slotIn) {
            case field_6171: {
                this.dragonInventory.method_5447(0, stack);
                break;
            }
            case field_6169: {
                this.dragonInventory.method_5447(1, stack);
                break;
            }
            case field_6174: {
                this.dragonInventory.method_5447(2, stack);
                break;
            }
            case field_6172: {
                this.dragonInventory.method_5447(3, stack);
                break;
            }
            case field_6166: {
                this.dragonInventory.method_5447(4, stack);
                break;
            }
            default: {
                super.method_6118(slotIn);
                return;
            }
        }
        this.dragonInventory.method_5431();
    }

    public class_3414 getBabyFireSound() {
        return class_3417.field_15102;
    }

    public boolean isPlayingAttackAnimation() {
        return this.getAnimation() == ANIMATION_BITE || this.getAnimation() == ANIMATION_SHAKEPREY || this.getAnimation() == ANIMATION_WINGBLAST || this.getAnimation() == ANIMATION_TAILWHACK;
    }

    protected IafDragonLogic createDragonLogic() {
        return new IafDragonLogic(this);
    }

    public int getFlightChancePerTick() {
        return 1500;
    }

    public void method_36209() {
        DragonPosWorldData data;
        if (((Boolean)IafCommonConfig.INSTANCE.dragon.chunkLoadSummonCrystal.getValue()).booleanValue() && this.isBoundToCrystal() && (data = DragonPosWorldData.get(this.method_37908())) != null) {
            data.addDragon(this.method_5667(), this.method_24515());
        }
        super.method_36209();
    }

    public int maxSearchNodes() {
        return (int)this.method_5996(class_5134.field_23717).method_6194();
    }

    public boolean isSmallerThanBlock() {
        return false;
    }

    public float getXZNavSize() {
        return Math.max(1.4f, this.method_17681() / 2.0f);
    }

    public int getYNavSize() {
        return class_3532.method_15386((float)this.method_17682());
    }

    public void method_5453(class_1263 invBasic) {
        if (!this.method_37908().field_9236) {
            this.updateAttributes();
        }
    }

    public class_243 method_26318(class_243 pDeltaMovement, float pFriction) {
        if (this.field_6207 instanceof IafDragonFlightManager.PlayerFlightMoveHelper) {
            return pDeltaMovement;
        }
        return super.method_26318(pDeltaMovement, pFriction);
    }

    public class_1924 method_48926() {
        return this.method_37908();
    }

    public boolean isBlockExplicitlyPassable(class_2680 state, class_2338 pos, class_2338 entityPos) {
        return false;
    }

    public boolean isBlockExplicitlyNotPassable(class_2680 state, class_2338 pos, class_2338 entityPos) {
        return false;
    }
}

