/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.impl.ComponentManager;
import com.iafenvoy.iceandfire.registry.IafBlocks;
import com.iafenvoy.iceandfire.registry.IafWorld;
import com.iafenvoy.iceandfire.world.processor.DreadPortalProcessor;
import com.iafenvoy.iceandfire.world.util.DimensionUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_5425;
import net.minecraft.class_5454;
import net.minecraft.server.MinecraftServer;

public class PortalData {
    private final class_1657 player;
    private boolean teleported = false;
    private int teleportTick = -1;

    public PortalData(class_1657 player) {
        this.player = player;
    }

    public void tick() {
        class_1937 world = this.player.method_37908();
        if (!this.teleported && this.teleportTick == 0 && world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            this.teleported = true;
            MinecraftServer server = serverWorld.method_8503();
            if (world.method_27983().method_29177().equals((Object)IafWorld.DREAD_LAND.method_29177())) {
                DimensionUtil.changeDimension(this.player, server.method_3847(class_1937.field_25179), new class_5454(this.player.method_19538(), class_243.field_1353, this.player.field_6241, this.player.method_36455()));
            } else {
                class_3218 dreadLand = server.method_3847(IafWorld.DREAD_LAND);
                if (dreadLand == null) {
                    return;
                }
                DimensionUtil.changeDimension(this.player, dreadLand, new class_5454(this.player.method_19538(), class_243.field_1353, this.player.field_6241, this.player.method_36455()));
                if (!dreadLand.method_8320(this.player.method_24515()).method_27852((class_2248)IafBlocks.DREAD_PORTAL.get())) {
                    server.method_27727().method_15094(class_2960.method_43902((String)"iceandfire", (String)"dread_exit_portal")).ifPresent(structureTemplate -> structureTemplate.method_15172((class_5425)dreadLand, this.player.method_24515().method_10059((class_2382)new class_2338(2, 1, 2)), class_2338.field_10980, new class_3492().method_16184((class_3491)new DreadPortalProcessor()), dreadLand.field_9229, 2));
                }
                this.player.method_43496((class_2561)class_2561.method_43471((String)"warning.iceandfire.dreadland.not_complete"));
            }
        }
        if (world.method_8320(this.player.method_24515()).method_27852((class_2248)IafBlocks.DREAD_PORTAL.get())) {
            if (this.teleportTick > 0) {
                --this.teleportTick;
            } else if (this.teleportTick == -1) {
                this.teleportTick = 100;
            }
        } else {
            this.teleported = false;
            this.teleportTick = -1;
        }
    }

    public void readFromNbt(class_2487 tag) {
        this.setTeleported(tag.method_10577("teleported"));
        this.setTeleportTick(tag.method_10550("teleport_tick"));
    }

    public void writeToNbt(class_2487 tag) {
        tag.method_10556("teleported", this.isTeleported());
        tag.method_10569("teleport_tick", this.getTeleportTick());
    }

    public boolean isTeleported() {
        return this.teleported;
    }

    public int getTeleportTick() {
        return this.teleportTick;
    }

    public void setTeleported(boolean teleported) {
        this.teleported = teleported;
    }

    public void setTeleportTick(int teleportTick) {
        this.teleportTick = teleportTick;
    }

    public static PortalData get(class_1657 player) {
        return ComponentManager.getPortalData(player);
    }
}

