/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data.component;

import com.iafenvoy.iceandfire.data.component.NeedUpdateData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_3218;

public class ChainData
extends NeedUpdateData {
    public List<class_1297> chainedTo;
    private List<Integer> chainedToIds;
    private List<UUID> chainedToUUIDs;
    private boolean isInitialized;

    public void tickChain(class_1309 entity) {
        if (!this.isInitialized) {
            this.initialize(entity.method_37908());
        }
        if (this.chainedTo == null) {
            return;
        }
        for (class_1297 chain : this.chainedTo) {
            double distance = chain.method_5739((class_1297)entity);
            if (!(distance > 7.0)) continue;
            double x = (chain.method_23317() - entity.method_23317()) / distance;
            double y = (chain.method_23318() - entity.method_23318()) / distance;
            double z = (chain.method_23321() - entity.method_23321()) / distance;
            entity.method_18799(entity.method_18798().method_1031(x * Math.abs(x) * 0.4, y * Math.abs(y) * 0.2, z * Math.abs(z) * 0.4));
        }
    }

    public List<class_1297> getChainedTo() {
        return Objects.requireNonNullElse(this.chainedTo, Collections.emptyList());
    }

    public void clearChains() {
        if (this.chainedTo == null) {
            return;
        }
        this.chainedTo = null;
        this.triggerUpdate();
    }

    public void attachChain(class_1297 chain) {
        if (this.chainedTo == null) {
            this.chainedTo = new ArrayList<class_1297>();
        } else if (this.chainedTo.contains(chain)) {
            return;
        }
        this.chainedTo.add(chain);
        this.triggerUpdate();
    }

    public void removeChain(class_1297 chain) {
        if (this.chainedTo == null) {
            return;
        }
        this.chainedTo.remove(chain);
        this.triggerUpdate();
        if (this.chainedTo.isEmpty()) {
            this.chainedTo = null;
        }
    }

    public boolean isChainedTo(class_1297 toCheck) {
        if (this.chainedTo == null || this.chainedTo.isEmpty()) {
            return false;
        }
        return this.chainedTo.contains(toCheck);
    }

    public void serialize(class_2487 tag) {
        class_2487 chainedData = new class_2487();
        class_2499 uuids = new class_2499();
        if (this.chainedTo != null) {
            int[] ids = new int[this.chainedTo.size()];
            for (int i = 0; i < this.chainedTo.size(); ++i) {
                class_1297 entity = this.chainedTo.get(i);
                ids[i] = entity.method_5628();
                uuids.add((Object)class_2512.method_25929((UUID)entity.method_5667()));
            }
            chainedData.method_10539("chainedToIds", ids);
            chainedData.method_10566("chainedToUUIDs", (class_2520)uuids);
        }
        tag.method_10566("chainedData", (class_2520)chainedData);
    }

    public void deserialize(class_2487 tag) {
        class_2487 chainedData = tag.method_10562("chainedData");
        int[] loadedChainedToIds = chainedData.method_10561("chainedToIds");
        class_2499 uuids = chainedData.method_10554("chainedToUUIDs", 11);
        this.isInitialized = false;
        if (loadedChainedToIds.length > 0) {
            this.chainedToIds = new ArrayList<Integer>();
            for (int loadedChainedToId : loadedChainedToIds) {
                this.chainedToIds.add(loadedChainedToId);
            }
        } else {
            this.chainedToIds = null;
        }
        if (!uuids.isEmpty()) {
            this.chainedToUUIDs = new ArrayList<UUID>();
            Object object = uuids.iterator();
            while (object.hasNext()) {
                class_2520 uuid = (class_2520)object.next();
                this.chainedToUUIDs.add(class_2512.method_25930((class_2520)uuid));
            }
        } else {
            this.chainedToUUIDs = null;
        }
    }

    private void initialize(class_1937 level) {
        ArrayList<class_1297> entities = new ArrayList<class_1297>();
        if (this.chainedToUUIDs != null && level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            for (UUID uuid : this.chainedToUUIDs) {
                class_1297 entity = serverLevel.method_14190(uuid);
                if (entity == null) continue;
                entities.add(entity);
            }
            this.triggerUpdate();
        } else if (this.chainedToIds != null) {
            for (int id : this.chainedToIds) {
                class_1297 entity;
                if (id == -1 || (entity = level.method_8469(id)) == null) continue;
                entities.add(entity);
            }
        }
        this.chainedTo = !entities.isEmpty() ? entities : null;
        this.chainedToIds = null;
        this.chainedToUUIDs = null;
        this.isInitialized = true;
    }
}

