/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.iceandfire.data;

import com.google.common.collect.ImmutableList;
import com.iafenvoy.iceandfire.data.DragonColor;
import com.iafenvoy.iceandfire.item.armor.IafArmorMaterial;
import com.iafenvoy.iceandfire.item.armor.ItemScaleArmor;
import com.iafenvoy.iceandfire.registry.IafItems;
import com.iafenvoy.uranus.object.IdUtil;
import com.iafenvoy.uranus.object.item.CustomArmorMaterial;
import dev.architectury.registry.registries.RegistrySupplier;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.function.Supplier;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_3417;

public class DragonArmor {
    private static final List<DragonArmor> ARMORS = new ArrayList<DragonArmor>();
    public static final DragonArmor RED = new DragonArmor(DragonColor.RED, (Supplier<class_1792>)IafItems.DRAGONSCALES_RED);
    public static final DragonArmor BRONZE = new DragonArmor(DragonColor.BRONZE, (Supplier<class_1792>)IafItems.DRAGONSCALES_BRONZE);
    public static final DragonArmor GREEN = new DragonArmor(DragonColor.GREEN, (Supplier<class_1792>)IafItems.DRAGONSCALES_GREEN);
    public static final DragonArmor GRAY = new DragonArmor(DragonColor.GRAY, (Supplier<class_1792>)IafItems.DRAGONSCALES_GRAY);
    public static final DragonArmor BLUE = new DragonArmor(DragonColor.BLUE, (Supplier<class_1792>)IafItems.DRAGONSCALES_BLUE);
    public static final DragonArmor WHITE = new DragonArmor(DragonColor.WHITE, (Supplier<class_1792>)IafItems.DRAGONSCALES_WHITE);
    public static final DragonArmor SAPPHIRE = new DragonArmor(DragonColor.SAPPHIRE, (Supplier<class_1792>)IafItems.DRAGONSCALES_SAPPHIRE);
    public static final DragonArmor SILVER = new DragonArmor(DragonColor.SILVER, (Supplier<class_1792>)IafItems.DRAGONSCALES_SILVER);
    public static final DragonArmor ELECTRIC = new DragonArmor(DragonColor.ELECTRIC, (Supplier<class_1792>)IafItems.DRAGONSCALES_ELECTRIC);
    public static final DragonArmor AMETHYST = new DragonArmor(DragonColor.AMETHYST, (Supplier<class_1792>)IafItems.DRAGONSCALES_AMETHYST);
    public static final DragonArmor COPPER = new DragonArmor(DragonColor.COPPER, (Supplier<class_1792>)IafItems.DRAGONSCALES_COPPER);
    public static final DragonArmor BLACK = new DragonArmor(DragonColor.BLACK, (Supplier<class_1792>)IafItems.DRAGONSCALES_BLACK);
    private final DragonColor color;
    private final Supplier<class_1792> repairItem;
    public CustomArmorMaterial material;
    public RegistrySupplier<class_1792> helmet;
    public RegistrySupplier<class_1792> chestplate;
    public RegistrySupplier<class_1792> leggings;
    public RegistrySupplier<class_1792> boots;
    public CustomArmorMaterial armorMaterial;

    public DragonArmor(DragonColor color, Supplier<class_1792> repairItem) {
        this.color = color;
        this.repairItem = repairItem;
        ARMORS.add(this);
    }

    public static void initArmors() {
        for (int i = 0; i < ARMORS.size(); ++i) {
            DragonArmor value = ARMORS.get(i);
            value.armorMaterial = new IafArmorMaterial(IdUtil.build((String)"iceandfire", (String)("armor_dragon_scales" + (i + 1))), 36, new int[]{5, 7, 9, 5}, 15, class_3417.field_15191, 2.0f);
            String sub = "armor_" + value.color.name().toLowerCase(Locale.ROOT);
            value.helmet = IafItems.register(sub + "_helmet", () -> new ItemScaleArmor(value.color, value, value.armorMaterial, class_1738.class_8051.field_41934));
            value.chestplate = IafItems.register(sub + "_chestplate", () -> new ItemScaleArmor(value.color, value, value.armorMaterial, class_1738.class_8051.field_41935));
            value.leggings = IafItems.register(sub + "_leggings", () -> new ItemScaleArmor(value.color, value, value.armorMaterial, class_1738.class_8051.field_41936));
            value.boots = IafItems.register(sub + "_boots", () -> new ItemScaleArmor(value.color, value, value.armorMaterial, class_1738.class_8051.field_41937));
        }
    }

    public static List<DragonArmor> values() {
        return ImmutableList.copyOf(ARMORS);
    }

    public class_1792 getScaleItem() {
        return this.repairItem.get();
    }

    public DragonColor getColor() {
        return this.color;
    }
}

