/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.kinetics.clock;

import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.clock.CuckooClockBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import com.simibubi.create.foundation.utility.NBTHelper;
import com.simibubi.create.foundation.utility.VecHelper;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class CuckooClockBlockEntity
extends KineticBlockEntity {
    public LerpedFloat hourHand = LerpedFloat.angular();
    public LerpedFloat minuteHand = LerpedFloat.angular();
    public LerpedFloat animationProgress = LerpedFloat.linear();
    public Animation animationType = Animation.NONE;
    private boolean sendAnimationUpdate;

    public CuckooClockBlockEntity(class_2591<?> type, class_2338 pos, class_2680 state) {
        super(type, pos, state);
    }

    @Override
    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, AllAdvancements.CUCKOO_CLOCK);
    }

    @Override
    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (clientPacket && compound.method_10545("Animation")) {
            this.animationType = NBTHelper.readEnum(compound, "Animation", Animation.class);
            this.animationProgress.startWithValue(0.0);
        }
    }

    @Override
    public void write(class_2487 compound, boolean clientPacket) {
        if (clientPacket && this.sendAnimationUpdate) {
            NBTHelper.writeEnum(compound, "Animation", this.animationType);
        }
        this.sendAnimationUpdate = false;
        super.write(compound, clientPacket);
    }

    @Override
    public void tick() {
        block23: {
            block26: {
                block24: {
                    block25: {
                        super.tick();
                        if (this.getSpeed() == 0.0f) {
                            return;
                        }
                        boolean isNatural = this.field_11863.method_8597().comp_645();
                        int dayTime = (int)(this.field_11863.method_8532() * (long)(isNatural ? 1 : 24) % 24000L);
                        int hours = (dayTime / 1000 + 6) % 24;
                        int minutes = dayTime % 1000 * 60 / 1000;
                        if (!isNatural) {
                            if (this.field_11863.field_9236) {
                                this.moveHands(hours, minutes);
                                if (AnimationTickHolder.getTicks() % 6 == 0) {
                                    this.playSound((class_3414)class_3417.field_15204.comp_349(), 0.0625f, 2.0f);
                                } else if (AnimationTickHolder.getTicks() % 3 == 0) {
                                    this.playSound((class_3414)class_3417.field_15204.comp_349(), 0.0625f, 1.5f);
                                }
                            }
                            return;
                        }
                        if (!this.field_11863.field_9236) {
                            if (this.animationType == Animation.NONE) {
                                if (hours == 12 && minutes < 5) {
                                    this.startAnimation(Animation.PIG);
                                }
                                if (hours == 18 && minutes < 36 && minutes > 31) {
                                    this.startAnimation(Animation.CREEPER);
                                }
                            } else {
                                float value = this.animationProgress.getValue();
                                this.animationProgress.setValue(value + 1.0f);
                                if (value > 100.0f) {
                                    this.animationType = Animation.NONE;
                                }
                                if (this.animationType == Animation.SURPRISE && class_3532.method_15347((float)this.animationProgress.getValue(), (float)50.0f)) {
                                    class_243 center = VecHelper.getCenterOf((class_2382)this.field_11867);
                                    this.field_11863.method_22352(this.field_11867, false);
                                    class_1282 damageSource = CreateDamageSources.cuckooSurprise(this.field_11863);
                                    this.field_11863.method_8454(null, damageSource, null, center.field_1352, center.field_1351, center.field_1350, 3.0f, false, class_1937.class_7867.field_40889);
                                }
                            }
                        }
                        if (!this.field_11863.field_9236) break block23;
                        this.moveHands(hours, minutes);
                        if (this.animationType != Animation.NONE) break block24;
                        if (AnimationTickHolder.getTicks() % 32 != 0) break block25;
                        this.playSound((class_3414)class_3417.field_15204.comp_349(), 0.0625f, 2.0f);
                        break block26;
                    }
                    if (AnimationTickHolder.getTicks() % 16 != 0) break block26;
                    this.playSound((class_3414)class_3417.field_15204.comp_349(), 0.0625f, 1.5f);
                    break block26;
                }
                boolean isSurprise = this.animationType == Animation.SURPRISE;
                float value = this.animationProgress.getValue();
                this.animationProgress.setValue(value + 1.0f);
                if (value > 100.0f) {
                    this.animationType = null;
                }
                if (value == 1.0f) {
                    this.playSound((class_3414)class_3417.field_14725.comp_349(), 2.0f, 0.5f);
                }
                if (value == 21.0f) {
                    this.playSound((class_3414)class_3417.field_14725.comp_349(), 2.0f, 0.793701f);
                }
                if (value > 30.0f && isSurprise) {
                    class_243 pos = VecHelper.offsetRandomly(VecHelper.getCenterOf((class_2382)this.field_11867), this.field_11863.field_9229, 0.5f);
                    this.field_11863.method_8406((class_2394)class_2398.field_11237, pos.field_1352, pos.field_1351, pos.field_1350, 0.0, 0.0, 0.0);
                }
                if (value == 40.0f && isSurprise) {
                    this.playSound(class_3417.field_15079, 1.0f, 1.0f);
                }
                int step = isSurprise ? 3 : 15;
                for (int phase = 30; phase <= 60; phase += step) {
                    if (value == (float)(phase - step / 3)) {
                        this.playSound(class_3417.field_14982, 0.0625f, 2.0f);
                    }
                    if (value == (float)phase) {
                        if (this.animationType == Animation.PIG) {
                            this.playSound(class_3417.field_14615, 0.25f, 1.0f);
                        } else {
                            this.playSound(class_3417.field_15192, 0.25f, 3.0f);
                        }
                    }
                    if (value != (float)(phase + step / 3)) continue;
                    this.playSound(class_3417.field_14823, 0.0625f, 2.0f);
                }
            }
            return;
        }
    }

    public void startAnimation(Animation animation) {
        this.animationType = animation;
        if (animation != null && CuckooClockBlock.containsSurprise(this.method_11010())) {
            this.animationType = Animation.SURPRISE;
        }
        this.animationProgress.startWithValue(0.0);
        this.sendAnimationUpdate = true;
        if (animation == Animation.CREEPER) {
            this.awardIfNear(AllAdvancements.CUCKOO_CLOCK, 32);
        }
        this.sendData();
    }

    public void moveHands(int hours, int minutes) {
        float hourTarget = 30 * (hours % 12);
        float minuteTarget = 6 * minutes;
        this.hourHand.chase(hourTarget, 0.2f, LerpedFloat.Chaser.EXP);
        this.minuteHand.chase(minuteTarget, 0.2f, LerpedFloat.Chaser.EXP);
        this.hourHand.tickChaser();
        this.minuteHand.tickChaser();
    }

    private void playSound(class_3414 sound, float volume, float pitch) {
        class_243 vec = VecHelper.getCenterOf((class_2382)this.field_11867);
        this.field_11863.method_8486(vec.field_1352, vec.field_1351, vec.field_1350, sound, class_3419.field_15245, volume, pitch, false);
    }

    static enum Animation {
        PIG,
        CREEPER,
        SURPRISE,
        NONE;

    }
}

