/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.fuel.tank;

import com.railwayteam.railways.content.fuel.tank.FuelTankBlockEntity;
import com.railwayteam.railways.content.fuel.tank.FuelTankItem;
import com.railwayteam.railways.registry.fabric.CRBlockEntitiesImpl;
import com.simibubi.create.api.connectivity.ConnectivityHandler;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.fluids.transfer.GenericItemEmptying;
import com.simibubi.create.content.fluids.transfer.GenericItemFilling;
import com.simibubi.create.foundation.advancement.AdvancementBehaviour;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.ComparatorUtil;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.fluid.FluidHelper;
import com.simibubi.create.foundation.utility.Lang;
import io.github.fabricators_of_create.porting_lib.block.CustomSoundTypeBlock;
import io.github.fabricators_of_create.porting_lib.fluids.FluidStack;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariantAttributes;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2388;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2415;
import net.minecraft.class_243;
import net.minecraft.class_2470;
import net.minecraft.class_2498;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2746;
import net.minecraft.class_2754;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;

public class FuelTankBlock
extends class_2248
implements IWrenchable,
IBE<FuelTankBlockEntity>,
CustomSoundTypeBlock {
    public static final class_2746 TOP = class_2746.method_11825((String)"top");
    public static final class_2746 BOTTOM = class_2746.method_11825((String)"bottom");
    public static final class_2754<Shape> SHAPE = class_2754.method_11850((String)"shape", Shape.class);
    public static final class_2758 LIGHT_LEVEL = class_2758.method_11867((String)"light_level", (int)0, (int)15);
    public static final class_2498 SILENCED_METAL = new class_2498(0.1f, 1.5f, class_3417.field_15044, class_3417.field_14924, class_3417.field_15167, class_3417.field_14557, class_3417.field_15142);

    public void method_9567(@NotNull class_1937 pLevel, @NotNull class_2338 pPos, @NotNull class_2680 pState, class_1309 pPlacer, @NotNull class_1799 pStack) {
        super.method_9567(pLevel, pPos, pState, pPlacer, pStack);
        AdvancementBehaviour.setPlacedBy((class_1937)pLevel, (class_2338)pPos, (class_1309)pPlacer);
    }

    public FuelTankBlock(class_4970.class_2251 properties) {
        super(FuelTankBlock.setLightFunction(properties));
        this.method_9590((class_2680)((class_2680)((class_2680)((class_2680)this.method_9564().method_11657((class_2769)TOP, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)BOTTOM, (Comparable)Boolean.valueOf(true))).method_11657(SHAPE, (Comparable)((Object)Shape.WINDOW))).method_11657((class_2769)LIGHT_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    private static class_4970.class_2251 setLightFunction(class_4970.class_2251 properties) {
        return properties.method_9631(state -> (Integer)state.method_11654((class_2769)LIGHT_LEVEL));
    }

    public static boolean isTank(class_2680 state) {
        return state.method_26204() instanceof FuelTankBlock;
    }

    public void method_9615(class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, class_2680 oldState, boolean moved) {
        if (oldState.method_26204() == state.method_26204()) {
            return;
        }
        if (moved) {
            return;
        }
        Consumer<FuelTankBlockEntity> consumer = FuelTankItem.IS_PLACING_NBT ? FuelTankBlockEntity::queueConnectivityUpdate : FuelTankBlockEntity::updateConnectivity;
        this.withBlockEntityDo((class_1922)world, pos, consumer);
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{TOP, BOTTOM, SHAPE, LIGHT_LEVEL});
    }

    public class_1269 onWrenched(class_2680 state, class_1838 context) {
        this.withBlockEntityDo((class_1922)context.method_8045(), context.method_8037(), FuelTankBlockEntity::toggleWindows);
        return class_1269.field_5812;
    }

    @NotNull
    public class_265 method_25959(@NotNull class_2680 pState, @NotNull class_1922 pReader, @NotNull class_2338 pPos) {
        return class_259.method_1077();
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, class_1937 world, @NotNull class_2338 pos, class_1657 player, @NotNull class_1268 hand, @NotNull class_3965 ray) {
        FuelTankBlockEntity controllerBE;
        class_3611 fluid;
        class_1799 heldItem = player.method_5998(hand);
        boolean onClient = world.field_9236;
        if (heldItem.method_7960()) {
            return class_1269.field_5811;
        }
        if (!player.method_7337()) {
            return class_1269.field_5811;
        }
        FluidHelper.FluidExchange exchange = null;
        FuelTankBlockEntity be = (FuelTankBlockEntity)ConnectivityHandler.partAt(this.getBlockEntityType(), (class_1922)world, (class_2338)pos);
        if (be == null) {
            return class_1269.field_5814;
        }
        class_2350 direction = ray.method_17780();
        Storage<FluidVariant> fluidTank = be.getFluidStorage(direction);
        if (fluidTank == null) {
            return class_1269.field_5811;
        }
        FluidStack prevFluidInTank = TransferUtil.firstCopyOrEmpty(fluidTank);
        if (FluidHelper.tryEmptyItemIntoBE((class_1937)world, (class_1657)player, (class_1268)hand, (class_1799)heldItem, (SmartBlockEntity)be, (class_2350)direction)) {
            exchange = FluidHelper.FluidExchange.ITEM_TO_TANK;
        } else if (FluidHelper.tryFillItemFromBE((class_1937)world, (class_1657)player, (class_1268)hand, (class_1799)heldItem, (SmartBlockEntity)be, (class_2350)direction)) {
            exchange = FluidHelper.FluidExchange.TANK_TO_ITEM;
        }
        if (exchange == null) {
            if (GenericItemEmptying.canItemBeEmptied((class_1937)world, (class_1799)heldItem) || GenericItemFilling.canItemBeFilled((class_1937)world, (class_1799)heldItem)) {
                return class_1269.field_5812;
            }
            return class_1269.field_5811;
        }
        class_3414 soundevent = null;
        class_2680 fluidState = null;
        FluidStack fluidInTank = TransferUtil.firstOrEmpty(fluidTank);
        if (exchange == FluidHelper.FluidExchange.ITEM_TO_TANK) {
            fluid = fluidInTank.getFluid();
            fluidState = fluid.method_15785().method_15759();
            soundevent = FluidVariantAttributes.getEmptySound((FluidVariant)FluidVariant.of((class_3611)fluid));
        }
        if (exchange == FluidHelper.FluidExchange.TANK_TO_ITEM) {
            fluid = prevFluidInTank.getFluid();
            fluidState = fluid.method_15785().method_15759();
            soundevent = FluidVariantAttributes.getFillSound((FluidVariant)FluidVariant.of((class_3611)fluid));
        }
        if (soundevent != null && !onClient) {
            float pitch = class_3532.method_15363((float)(1.0f - 1.0f * (float)fluidInTank.getAmount() / (float)(FuelTankBlockEntity.getCapacityMultiplier() * 16L)), (float)0.0f, (float)1.0f);
            pitch /= 1.5f;
            pitch += 0.5f;
            world.method_8396(null, pos, soundevent, class_3419.field_15245, 0.5f, pitch += (world.field_9229.method_43057() - 0.5f) / 4.0f);
        }
        if (!fluidInTank.isFluidEqual(prevFluidInTank) && (controllerBE = be.getControllerBE()) != null) {
            if (onClient) {
                class_2388 blockParticleData = new class_2388(class_2398.field_11217, fluidState);
                float level = (float)fluidInTank.getAmount() / (float)TransferUtil.firstCapacity(fluidTank);
                boolean reversed = FluidVariantAttributes.isLighterThanAir((FluidVariant)fluidInTank.getType());
                if (reversed) {
                    level = 1.0f - level;
                }
                class_243 vec = ray.method_17784();
                vec = new class_243(vec.field_1352, (double)((float)controllerBE.method_11016().method_10264() + level * ((float)controllerBE.height - 0.5f) + 0.25f), vec.field_1350);
                class_243 motion = player.method_19538().method_1020(vec).method_1021((double)0.05f);
                vec = vec.method_1019(motion);
                world.method_8406((class_2394)blockParticleData, vec.field_1352, vec.field_1351, vec.field_1350, motion.field_1352, motion.field_1351, motion.field_1350);
                return class_1269.field_5812;
            }
            controllerBE.sendDataImmediately();
            controllerBE.method_5431();
        }
        return class_1269.field_5812;
    }

    public void method_9536(class_2680 state, @NotNull class_1937 world, @NotNull class_2338 pos, @NotNull class_2680 newState, boolean isMoving) {
        if (state.method_31709() && (state.method_26204() != newState.method_26204() || !newState.method_31709())) {
            class_2586 be = world.method_8321(pos);
            if (!(be instanceof FuelTankBlockEntity)) {
                return;
            }
            FuelTankBlockEntity tankBE = (FuelTankBlockEntity)be;
            world.method_8544(pos);
            ConnectivityHandler.splitMulti((class_2586)tankBE);
        }
    }

    public Class<FuelTankBlockEntity> getBlockEntityClass() {
        return FuelTankBlockEntity.class;
    }

    public class_2591<? extends FuelTankBlockEntity> getBlockEntityType() {
        return (class_2591)CRBlockEntitiesImpl.FUEL_TANK.get();
    }

    @NotNull
    public class_2680 method_9569(@NotNull class_2680 state, @NotNull class_2415 mirror) {
        if (mirror == class_2415.field_11302) {
            return state;
        }
        boolean x = mirror == class_2415.field_11301;
        return switch ((Shape)((Object)state.method_11654(SHAPE))) {
            case Shape.WINDOW_NE -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NW : Shape.WINDOW_SE)));
            case Shape.WINDOW_NW -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_NE : Shape.WINDOW_SW)));
            case Shape.WINDOW_SE -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SW : Shape.WINDOW_NE)));
            case Shape.WINDOW_SW -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)(x ? Shape.WINDOW_SE : Shape.WINDOW_NW)));
            default -> state;
        };
    }

    @NotNull
    public class_2680 method_9598(@NotNull class_2680 state, class_2470 rotation) {
        for (int i = 0; i < rotation.ordinal(); ++i) {
            state = this.rotateOnce(state);
        }
        return state;
    }

    private class_2680 rotateOnce(class_2680 state) {
        return switch ((Shape)((Object)state.method_11654(SHAPE))) {
            case Shape.WINDOW_NE -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.WINDOW_SE));
            case Shape.WINDOW_NW -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.WINDOW_NE));
            case Shape.WINDOW_SE -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.WINDOW_SW));
            case Shape.WINDOW_SW -> (class_2680)state.method_11657(SHAPE, (Comparable)((Object)Shape.WINDOW_NW));
            default -> state;
        };
    }

    public class_2498 getSoundType(class_2680 state, class_4538 world, class_2338 pos, class_1297 entity) {
        class_2498 soundType = this.method_9573(state);
        if (entity != null && entity.getCustomData().method_10577("SilenceTankSound")) {
            return SILENCED_METAL;
        }
        return soundType;
    }

    public boolean method_9498(@NotNull class_2680 state) {
        return true;
    }

    public int method_9572(@NotNull class_2680 blockState, @NotNull class_1937 worldIn, @NotNull class_2338 pos) {
        return this.getBlockEntityOptional((class_1922)worldIn, pos).map(FuelTankBlockEntity::getControllerBE).map(be -> ComparatorUtil.fractionToRedstoneLevel((double)be.getFillState())).orElse(0);
    }

    public static enum Shape implements class_3542
    {
        PLAIN,
        WINDOW,
        WINDOW_NW,
        WINDOW_SW,
        WINDOW_NE,
        WINDOW_SE;


        @NotNull
        public String method_15434() {
            return Lang.asId((String)this.name());
        }
    }
}

