/*
 * Decompiled with CFR 0.152.
 */
package com.tiviacz.travelersbackpack.inventory.upgrades.feeding;

import com.tiviacz.travelersbackpack.client.screens.BackpackScreen;
import com.tiviacz.travelersbackpack.client.screens.widgets.WidgetBase;
import com.tiviacz.travelersbackpack.config.TravelersBackpackConfig;
import com.tiviacz.travelersbackpack.inventory.StorageAccessWrapper;
import com.tiviacz.travelersbackpack.inventory.UpgradeManager;
import com.tiviacz.travelersbackpack.inventory.handler.ItemStackHandler;
import com.tiviacz.travelersbackpack.inventory.upgrades.FilterUpgradeBase;
import com.tiviacz.travelersbackpack.inventory.upgrades.IEnable;
import com.tiviacz.travelersbackpack.inventory.upgrades.ITickableUpgrade;
import com.tiviacz.travelersbackpack.inventory.upgrades.Point;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingFilterSettings;
import com.tiviacz.travelersbackpack.inventory.upgrades.feeding.FeedingWidget;
import com.tiviacz.travelersbackpack.inventory.upgrades.filter.FilterHandler;
import com.tiviacz.travelersbackpack.util.InventoryHelper;
import com.tiviacz.travelersbackpack.util.NbtHelper;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.event.player.UseItemCallback;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_4174;
import org.jetbrains.annotations.Nullable;

public class FeedingUpgrade
extends FilterUpgradeBase<FeedingUpgrade, FeedingFilterSettings>
implements IEnable,
ITickableUpgrade {
    private static final int STILL_HUNGRY_COOLDOWN = 10;

    public FeedingUpgrade(UpgradeManager manager, int dataHolderSlot, class_2371<class_1799> filter) {
        super(manager, dataHolderSlot, new Point(66, 49), TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.filterSlotCount, TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.slotsInRow, filter, List.of());
    }

    @Override
    public boolean hasTagSelector() {
        return false;
    }

    @Override
    public List<Integer> getFilter() {
        List<Integer> filter = NbtHelper.getOrDefault(this.getDataHolderStack(), "FilterSettings", List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0)));
        if (filter.size() != 3) {
            filter = List.of(Integer.valueOf(1), Integer.valueOf(1), Integer.valueOf(0));
        }
        return filter;
    }

    @Override
    public FeedingFilterSettings createFilterSettings(UpgradeManager manager, class_2371<class_1799> filter, List<String> filterTags) {
        return new FeedingFilterSettings(manager.getWrapper().getStorage(), filter.stream().limit(this.getFilterSlotCount()).filter(stack -> !stack.method_7960()).toList(), this.getFilter());
    }

    public boolean canEat(class_1657 player, class_1799 stack) {
        return ((FeedingFilterSettings)this.getFilterSettings()).matchesFilter(player, stack) && !player.method_7357().method_7904(stack.method_7909());
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public WidgetBase<BackpackScreen> createWidget(BackpackScreen screen, int x, int y) {
        return new FeedingWidget(screen, this, new Point(screen.getGuiLeft() + x, screen.getGuiTop() + y));
    }

    @Override
    protected FilterHandler createFilter(class_2371<class_1799> stacks, int size) {
        return new FilterHandler(stacks, size){

            @Override
            protected void onContentsChanged(int slot) {
                FeedingUpgrade.this.updateDataHolderUnchecked("Inventory", FeedingUpgrade.this.filter);
                ((FeedingFilterSettings)FeedingUpgrade.this.getFilterSettings()).updateFilter((List)NbtHelper.get(FeedingUpgrade.this.getDataHolderStack(), "Inventory"));
            }

            @Override
            public boolean isItemValid(int slot, class_1799 stack) {
                return stack.method_19267();
            }
        };
    }

    @Override
    public int getTickRate() {
        return TravelersBackpackConfig.getConfig().backpackUpgrades.feedingUpgradeSettings.tickRate;
    }

    @Override
    public void tick(@Nullable class_1657 player, class_1937 level, class_2338 pos, int currentTick) {
        if (this.getCooldown() == 0) {
            return;
        }
        if (currentTick % this.getCooldown() != 0) {
            return;
        }
        if (level.field_9236) {
            return;
        }
        this.getUpgradeManager().getWrapper().loadAdditionally(0);
        if (this.feedPlayerAndGetHungry(player, level)) {
            this.setCooldown(10);
            return;
        }
        if (!this.hasCooldown() || this.getCooldown() != this.getTickRate()) {
            this.setCooldown(this.getTickRate());
        }
    }

    private boolean feedPlayerAndGetHungry(class_1657 player, class_1937 level) {
        int hungerLevel = 20 - player.method_7344().method_7586();
        if (hungerLevel == 0 || level.field_9236) {
            return false;
        }
        return this.tryFeedingFoodFromStorage(level, hungerLevel, player) && player.method_7344().method_7586() < 20;
    }

    private boolean tryFeedingFoodFromStorage(class_1937 level, int hungerLevel, class_1657 player) {
        ItemStackHandler storage = this.getUpgradeManager().getWrapper().getStorage();
        return InventoryHelper.iterate(storage, (slot, stack) -> this.tryFeedingStack(level, hungerLevel, player, (Integer)slot, (class_1799)stack, storage));
    }

    private boolean tryFeedingStack(class_1937 level, int hungerLevel, class_1657 player, Integer slot, class_1799 stack, ItemStackHandler backpackStorage) {
        if (FeedingUpgrade.isEdible(stack, (class_1309)player) && this.canEat(player, stack)) {
            class_1799 mainHandItem = player.method_6047();
            player.method_6122(class_1268.field_5808, stack);
            class_1799 singleItemCopy = stack.method_7972();
            singleItemCopy.method_7939(1);
            if (singleItemCopy.method_7913(level, player, class_1268.field_5808).method_5467() == class_1269.field_21466) {
                class_1799 insertResult;
                stack.method_7934(1);
                backpackStorage.setStackInSlot(slot, stack);
                class_1271 result = ((UseItemCallback)UseItemCallback.EVENT.invoker()).interact(player, level, class_1268.field_5808);
                class_1799 resultItem = (class_1799)result.method_5466();
                if (result.method_5467() == class_1269.field_5811) {
                    resultItem = singleItemCopy.method_7909().method_7861(singleItemCopy, level, (class_1309)player);
                }
                if (!resultItem.method_7960() && !(insertResult = InventoryHelper.addItemStackToHandler(new StorageAccessWrapper(this.getUpgradeManager().getWrapper(), backpackStorage), resultItem, false)).method_7960()) {
                    player.method_7328(insertResult, true);
                }
                player.method_6122(class_1268.field_5808, mainHandItem);
                return true;
            }
            player.method_6122(class_1268.field_5808, mainHandItem);
        }
        return false;
    }

    private static boolean isEdible(class_1799 stack, class_1309 player) {
        if (!stack.method_19267()) {
            return false;
        }
        class_4174 foodProperties = stack.method_7909().method_19264();
        return foodProperties != null && foodProperties.method_19230() >= 1;
    }
}

