/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.utils;

import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import com.simibubi.create.foundation.utility.Couple;
import io.github.fabricators_of_create.porting_lib.event.common.FluidPlaceBlockCallback;
import io.github.fabricators_of_create.porting_lib.fluids.FluidType;
import io.github.fabricators_of_create.porting_lib.fluids.PortingLibFluids;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1936;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;

public final class FluidInteractionRegistry {
    private static final Multimap<FluidType, InteractionInformation> INTERACTIONS = MultimapBuilder.hashKeys().arrayListValues().build();
    private static final List<InteractionInformation> LAVA_INTERACTIONS = new ArrayList<InteractionInformation>();

    private FluidInteractionRegistry() {
    }

    public static void addInteraction(FluidType fluidType, InteractionInformation interaction) {
        if (interaction.fluidType() == PortingLibFluids.LAVA_TYPE) {
            LAVA_INTERACTIONS.add(new InteractionInformation(fluidType, interaction.callback()));
        }
        INTERACTIONS.put((Object)fluidType, (Object)interaction);
    }

    public static Optional<Couple<FluidType>> getInteractionType(class_3611 fluid1, class_3611 fluid2) {
        block4: {
            FluidType type2;
            FluidType type1;
            block3: {
                type1 = FluidInteractionRegistry.fluidTypeOf(fluid1);
                type2 = FluidInteractionRegistry.fluidTypeOf(fluid2);
                if (type1 == PortingLibFluids.EMPTY_TYPE || type2 == PortingLibFluids.EMPTY_TYPE) {
                    return Optional.empty();
                }
                if (!INTERACTIONS.containsKey((Object)type1)) break block3;
                for (InteractionInformation info : INTERACTIONS.get((Object)type1)) {
                    if (info.fluidType() != type2) continue;
                    return Optional.of(Couple.create((Object)type1, (Object)type2));
                }
                break block4;
            }
            if (!INTERACTIONS.containsKey((Object)type2)) break block4;
            for (InteractionInformation info : INTERACTIONS.get((Object)type2)) {
                if (info.fluidType() != type1) continue;
                return Optional.of(Couple.create((Object)type2, (Object)type1));
            }
        }
        return Optional.empty();
    }

    public static boolean hasFluidInteraction(class_3611 fluid1, class_3611 fluid2) {
        return FluidInteractionRegistry.getInteractionType(fluid1, fluid2).isPresent();
    }

    public static Optional<class_2680> getFluidInteraction(class_3610 fluid1, class_3610 fluid2) {
        Optional<Couple<FluidType>> interactionType = FluidInteractionRegistry.getInteractionType(fluid1.method_15772(), fluid2.method_15772());
        if (interactionType.isPresent()) {
            FluidType type1 = (FluidType)interactionType.get().getFirst();
            FluidType type2 = (FluidType)interactionType.get().getSecond();
            if (FluidInteractionRegistry.fluidTypeOf(fluid1.method_15772()) == type2) {
                fluid2 = fluid1;
            }
            for (InteractionInformation info : INTERACTIONS.get((Object)type1)) {
                if (info.fluidType() != type2) continue;
                return Optional.of(info.callback().apply(fluid2));
            }
        }
        return Optional.empty();
    }

    private static FluidType fluidTypeOf(class_3611 fluid) {
        try {
            if (fluid == class_3612.field_15908 || fluid == class_3612.field_15907) {
                return PortingLibFluids.LAVA_TYPE;
            }
            if (fluid == class_3612.field_15910 || fluid == class_3612.field_15909) {
                return PortingLibFluids.WATER_TYPE;
            }
            return fluid.getFluidType();
        }
        catch (RuntimeException ex) {
            return PortingLibFluids.EMPTY_TYPE;
        }
    }

    private static class_2680 getLavaInteraction(class_1936 world, class_2338 pos, class_2680 blockState) {
        class_3610 fluidState = blockState.method_26227();
        for (InteractionInformation i : LAVA_INTERACTIONS) {
            if (i.fluidType() != FluidInteractionRegistry.fluidTypeOf(fluidState.method_15772())) continue;
            return i.callback().apply(fluidState);
        }
        return null;
    }

    public static void register() {
        FluidPlaceBlockCallback.EVENT.register(FluidInteractionRegistry::getLavaInteraction);
    }

    public record InteractionInformation(FluidType fluidType, Function<class_3610, class_2680> callback) {
    }
}

