/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.client.ponder;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllItems;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.content.kinetics.saw.SawBlockEntity;
import com.simibubi.create.content.kinetics.simpleRelays.ShaftBlock;
import com.simibubi.create.foundation.ponder.ElementLink;
import com.simibubi.create.foundation.ponder.PonderPalette;
import com.simibubi.create.foundation.ponder.SceneBuilder;
import com.simibubi.create.foundation.ponder.SceneBuildingUtil;
import com.simibubi.create.foundation.ponder.Selection;
import com.simibubi.create.foundation.ponder.element.InputWindowElement;
import com.simibubi.create.foundation.ponder.instruction.EmitParticlesInstruction;
import com.simibubi.create.foundation.utility.Pointing;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3865;
import uwu.lopyluna.create_dd.blocks.hydraulic_press.HydraulicPressBlockEntity;

public class DDProcessingScenes {
    public static void industrial_fan_source(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("industrial_fan_source", "Generating Rotational Force using Industrial Fans");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 fan = util.grid.at(2, 2, 2);
        class_2338 lever = util.grid.at(1, 2, 2);
        class_2338 burner = util.grid.at(2, 1, 2);
        class_2338 cog = util.grid.at(3, 2, 2);
        class_2338 pos1 = util.grid.at(3, 1, 0);
        class_2338 pos2 = util.grid.at(3, 1, 4);
        scene.world.showSection(util.select.position(burner), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.position(fan), class_2350.field_11033);
        scene.idle(10);
        scene.addKeyframe();
        scene.overlay.showText(80).text("Industrial Fans facing down into a source of heat can provide Rotational Force").placeNearTarget().pointAt(util.vector.blockSurface(fan, class_2350.field_11039));
        scene.idle(70);
        scene.addKeyframe();
        scene.world.showSection(util.select.position(lever), class_2350.field_11034);
        scene.idle(15);
        scene.world.toggleRedstonePower(util.select.position(lever));
        scene.effects.indicateRedstone(lever);
        scene.world.setKineticSpeed(util.select.position(fan), 64.0f);
        scene.world.setKineticSpeed(util.select.position(cog), 64.0f);
        scene.world.setKineticSpeed(util.select.fromTo(pos1, pos2), 64.0f);
        scene.effects.rotationSpeedIndicator(fan);
        scene.idle(10);
        scene.addKeyframe();
        scene.overlay.showText(80).text("When given a Strong Redstone Signal, the Industrial Fans will start providing power").colored(PonderPalette.RED).placeNearTarget().pointAt(util.vector.blockSurface(lever, class_2350.field_11034));
        scene.idle(20);
        scene.world.showSection(util.select.position(cog), class_2350.field_11039);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(pos1, pos2), class_2350.field_11039);
        scene.idle(50);
        scene.markAsFinished();
    }

    public static void Motors(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("motors", "Generating Rotational Force using Motors");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 motor = util.grid.at(3, 1, 2);
        class_2338 speedBox = util.grid.at(1, 1, 2);
        class_2338 flywheel = util.grid.at(1, 1, 4);
        class_2338 belt1 = util.grid.at(2, 1, 0);
        class_2338 belt2 = util.grid.at(2, 1, 4);
        scene.world.showSection(util.select.position(motor), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(belt1, belt2), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(flywheel), class_2350.field_11033);
        scene.idle(5);
        scene.world.showSection(util.select.position(speedBox), class_2350.field_11033);
        scene.idle(10);
        scene.effects.rotationSpeedIndicator(motor);
        scene.overlay.showText(50).text("Motors are a compact and configurable source of Rotational Force").placeNearTarget().pointAt(util.vector.topOf(motor));
        scene.idle(70);
        class_243 blockSurface = util.vector.blockSurface(motor, class_2350.field_11043).method_1031(0.0625, 0.0, 0.1875);
        scene.overlay.showFilterSlotInput(blockSurface, class_2350.field_11043, 80);
        scene.overlay.showControls(new InputWindowElement(blockSurface, Pointing.DOWN).rightClick(), 60);
        scene.idle(20);
        scene.overlay.showText(60).text("The generated speed can be configured on its input panels").attachKeyFrame().placeNearTarget().pointAt(blockSurface);
        scene.idle(10);
        scene.idle(50);
        scene.world.modifyKineticSpeed(util.select.position(motor), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.world.modifyKineticSpeed(util.select.position(speedBox), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.world.modifyKineticSpeed(util.select.position(flywheel), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.world.modifyKineticSpeed(util.select.fromTo(belt1, belt2), f -> Float.valueOf(4.0f * f.floatValue()));
        scene.idle(10);
        scene.effects.rotationSpeedIndicator(motor);
    }

    public static void cogCrank(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("cog_crank", "Generating Rotational Force using Cog Cranks");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        class_2338 gaugePos = util.grid.at(1, 3, 3);
        class_2338 handlePos = util.grid.at(2, 1, 2);
        class_2338 pos1 = util.grid.at(1, 1, 3);
        scene.world.showSection(util.select.layer(1), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.layer(2), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.layer(3), class_2350.field_11033);
        scene.idle(20);
        class_243 centerOf = util.vector.centerOf(handlePos);
        class_243 sideOf = centerOf.method_1031(-0.5, 0.0, 0.0);
        scene.overlay.showText(70).text("Cog Cranks can be used by players to apply rotational force manually").placeNearTarget().pointAt(sideOf);
        scene.idle(80);
        scene.overlay.showControls(new InputWindowElement(centerOf, Pointing.DOWN).rightClick(), 40);
        scene.idle(7);
        scene.world.setKineticSpeed(util.select.position(handlePos), 32.0f);
        scene.world.setKineticSpeed(util.select.fromTo(pos1, gaugePos), -16.0f);
        scene.effects.rotationDirectionIndicator(handlePos);
        scene.effects.indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay.showText(50).text("Hold Right-Click to rotate it Counter-Clockwise").attachKeyFrame().placeNearTarget().pointAt(sideOf);
        scene.idle(35);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.idle(15);
        scene.overlay.showControls(new InputWindowElement(centerOf, Pointing.DOWN).rightClick().whileSneaking(), 40);
        scene.idle(7);
        scene.world.setKineticSpeed(util.select.position(handlePos), -32.0f);
        scene.world.setKineticSpeed(util.select.fromTo(pos1, gaugePos), 16.0f);
        scene.effects.rotationDirectionIndicator(handlePos);
        scene.effects.indicateSuccess(gaugePos);
        scene.idle(10);
        scene.overlay.showText(90).text("Sneak and Hold Right-Click to rotate it Clockwise").attachKeyFrame().placeNearTarget().pointAt(sideOf);
        scene.idle(35);
        scene.world.setKineticSpeed(util.select.everywhere(), 0.0f);
        scene.idle(45);
    }

    public static void fan_sails(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("fan_sails", "Using Fan Sails for Changing Encased/Industrial Fans Types");
        scene.configureBasePlate(0, 0, 9);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.layer(1), class_2350.field_11033);
        scene.idle(5);
        scene.idle(20);
    }

    public static void stone_generation(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("stone_generation", "Using Fluids to Generator Stones");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        scene.world.showSection(util.select.layer(1), class_2350.field_11033);
        scene.idle(10);
        scene.rotateCameraY(-90.0f);
        scene.idle(5);
        scene.idle(20);
    }

    public static void bulk_pressing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("hydraulic_press", "Bulk Processing Items with the Hydraulic Press");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        scene.idle(5);
        ElementLink depot = scene.world.showIndependentSection(util.select.position(2, 1, 1), class_2350.field_11033);
        scene.world.moveSection(depot, util.vector.of(0.0, 0.0, 1.0), 0);
        scene.idle(10);
        Selection pressS = util.select.position(2, 3, 2);
        class_2338 pressPos = util.grid.at(2, 3, 2);
        class_2338 depotPos = util.grid.at(2, 1, 1);
        scene.world.setKineticSpeed(pressS, 0.0f);
        scene.world.showSection(pressS, class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 5), class_2350.field_11043);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 2, 3), class_2350.field_11035);
        scene.idle(3);
        scene.world.showSection(util.select.position(2, 3, 3), class_2350.field_11043);
        scene.world.setKineticSpeed(pressS, -32.0f);
        scene.effects.indicateSuccess(pressPos);
        scene.idle(10);
        class_243 pressSide = util.vector.blockSurface(pressPos, class_2350.field_11039);
        scene.overlay.showText(60).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Hydraulic Press can bulk process items provided beneath it");
        scene.idle(70);
        scene.overlay.showText(60).pointAt(pressSide.method_1023(0.0, 2.0, 0.0)).placeNearTarget().text("The Input items can be dropped or placed on a Depot under the Press");
        scene.idle(50);
        class_1799 copper = new class_1799((class_1935)class_1802.field_27022, 64);
        scene.world.createItemOnBeltLike(depotPos, class_2350.field_11043, copper);
        class_243 depotCenter = util.vector.centerOf(depotPos.method_10072());
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(copper), 30);
        scene.idle(10);
        Class<HydraulicPressBlockEntity> type = HydraulicPressBlockEntity.class;
        scene.world.modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.idle(30);
        scene.world.modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.method_1031(0.0, 0.5, 0.0), copper));
        scene.world.removeItemsFromBelt(depotPos);
        class_1799 sheet = new class_1799((class_1935)AllItems.COPPER_SHEET.asStack().method_7909(), 64);
        scene.world.createItemOnBeltLike(depotPos, class_2350.field_11036, sheet);
        scene.idle(10);
        scene.overlay.showControls(new InputWindowElement(depotCenter, Pointing.UP).withItem(sheet), 50);
        scene.idle(60);
        scene.world.hideIndependentSection(depot, class_2350.field_11043);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(0, 1, 3, 0, 2, 3), class_2350.field_11033);
        scene.idle(10);
        scene.world.showSection(util.select.fromTo(4, 1, 2, 0, 2, 2), class_2350.field_11035);
        scene.idle(20);
        class_2338 beltPos = util.grid.at(0, 1, 2);
        scene.overlay.showText(40).pointAt(util.vector.blockSurface(beltPos, class_2350.field_11039)).placeNearTarget().attachKeyFrame().text("When items are provided on a belt...");
        scene.idle(30);
        ElementLink ingot = scene.world.createItemOnBelt(beltPos, class_2350.field_11035, copper);
        scene.idle(15);
        ElementLink ingot2 = scene.world.createItemOnBelt(beltPos, class_2350.field_11035, copper);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, true);
        scene.world.modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.overlay.showText(50).pointAt(pressSide).placeNearTarget().attachKeyFrame().text("The Press will hold and bulk process them automatically");
        scene.idle(30);
        scene.world.modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.method_1031(0.0, 0.5, 0.0), copper));
        scene.world.removeItemsFromBelt(pressPos.method_10087(2));
        ingot = scene.world.createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, sheet);
        scene.world.stallBeltItem(ingot, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot, false);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, true);
        scene.world.modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().start(PressingBehaviour.Mode.BELT));
        scene.idle(30);
        scene.world.modifyBlockEntity(pressPos, type, pte -> pte.getPressingBehaviour().makePressingParticleEffect(depotCenter.method_1031(0.0, 0.5, 0.0), copper));
        scene.world.removeItemsFromBelt(pressPos.method_10087(2));
        ingot2 = scene.world.createItemOnBelt(pressPos.method_10087(2), class_2350.field_11036, sheet);
        scene.world.stallBeltItem(ingot2, true);
        scene.idle(15);
        scene.world.stallBeltItem(ingot2, false);
    }

    public static void processing(SceneBuilder scene, SceneBuildingUtil util) {
        scene.title("bronze_saw_processing", "Bulk Processing Items on the Bronze Saw");
        scene.configureBasePlate(0, 0, 5);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 shaftPos = util.grid.at(2, 1, 3);
        scene.world.setBlock(shaftPos, (class_2680)AllBlocks.SHAFT.getDefaultState().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), false);
        class_2338 sawPos = util.grid.at(2, 1, 2);
        Selection sawSelect = util.select.position(sawPos);
        scene.world.modifyBlockEntityNBT(sawSelect, SawBlockEntity.class, nbt -> nbt.method_10569("RecipeIndex", 0));
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(2, 1, 3, 2, 1, 5), class_2350.field_11033);
        scene.idle(10);
        scene.effects.rotationDirectionIndicator(shaftPos);
        scene.world.showSection(sawSelect, class_2350.field_11033);
        scene.idle(10);
        scene.overlay.showText(50).attachKeyFrame().text("Upward facing Bronze Saws can bulk process a variety of items").pointAt(util.vector.blockSurface(sawPos, class_2350.field_11039)).placeNearTarget();
        scene.idle(45);
        class_1799 log = new class_1799((class_1935)class_1802.field_8583, 16);
        class_1799 strippedLog = new class_1799((class_1935)class_1802.field_8415, 16);
        class_1799 planks = new class_1799((class_1935)class_1802.field_8118, 16);
        class_243 itemSpawn = util.vector.centerOf(sawPos.method_10084().method_10067());
        ElementLink logItem = scene.world.createItemEntity(itemSpawn, util.vector.of(0.0, 0.0, 0.0), log);
        scene.idle(12);
        scene.overlay.showControls(new InputWindowElement(itemSpawn, Pointing.DOWN).withItem(log), 20);
        scene.idle(10);
        scene.world.modifyEntity(logItem, e -> e.method_18799(util.vector.of(0.05, 0.2, 0.0)));
        scene.idle(12);
        scene.world.modifyEntity(logItem, class_1297::method_31472);
        scene.world.createItemOnBeltLike(sawPos, class_2350.field_11039, log);
        scene.idle(60);
        logItem = scene.world.createItemEntity(util.vector.topOf(sawPos).method_1031(0.5, -0.1, 0.0), util.vector.of(0.05, 0.18, 0.0), strippedLog);
        scene.idle(12);
        scene.overlay.showControls(new InputWindowElement(itemSpawn.method_1031(2.0, 0.0, 0.0), Pointing.DOWN).withItem(strippedLog), 20);
        scene.idle(30);
        scene.overlay.showText(60).attachKeyFrame().text("The processed item always moves against the rotational input to the saw").pointAt(util.vector.blockSurface(sawPos, class_2350.field_11036)).placeNearTarget();
        scene.idle(70);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-2.0f * f.floatValue()));
        scene.effects.rotationDirectionIndicator(shaftPos);
        scene.world.modifyEntity(logItem, e -> e.method_18799(util.vector.of(-0.05, 0.2, 0.0)));
        scene.idle(12);
        scene.world.modifyEntity(logItem, class_1297::method_31472);
        scene.world.createItemOnBeltLike(sawPos, class_2350.field_11034, strippedLog);
        scene.idle(60);
        logItem = scene.world.createItemEntity(util.vector.topOf(sawPos).method_1031(-0.5, -0.1, 0.0), util.vector.of(-0.05, 0.18, 0.0), planks);
        scene.idle(22);
        Selection otherBelt = util.select.fromTo(3, 1, 3, 4, 1, 2);
        Selection belt = util.select.fromTo(0, 1, 2, 1, 1, 3);
        scene.world.modifyEntity(logItem, class_1297::method_31472);
        scene.world.setKineticSpeed(otherBelt, 0.0f);
        scene.world.setKineticSpeed(belt, 0.0f);
        scene.world.modifyKineticSpeed(util.select.everywhere(), f -> Float.valueOf(-f.floatValue()));
        scene.world.setBlock(shaftPos, (class_2680)AllBlocks.COGWHEEL.getDefaultState().method_11657((class_2769)ShaftBlock.AXIS, (Comparable)class_2350.class_2351.field_11051), true);
        scene.idle(3);
        scene.addKeyframe();
        scene.world.multiplyKineticSpeed(util.select.everywhere(), 0.5f);
        ElementLink beltSection = scene.world.showIndependentSection(belt, class_2350.field_11034);
        scene.world.moveSection(beltSection, util.vector.of(0.0, 100.0, 0.0), 0);
        scene.idle(1);
        scene.world.removeItemsFromBelt(util.grid.at(1, 1, 2));
        scene.idle(1);
        scene.world.setKineticSpeed(belt, -64.0f);
        scene.idle(1);
        scene.world.moveSection(beltSection, util.vector.of(0.0, -100.0, 0.0), 0);
        scene.idle(3);
        ElementLink otherBeltSection = scene.world.showIndependentSection(otherBelt, class_2350.field_11039);
        scene.world.moveSection(otherBeltSection, util.vector.of(0.0, 100.0, 0.0), 0);
        scene.idle(1);
        scene.world.removeItemsFromBelt(util.grid.at(3, 1, 2));
        scene.idle(1);
        scene.world.setKineticSpeed(otherBelt, -64.0f);
        scene.idle(1);
        scene.world.moveSection(otherBeltSection, util.vector.of(0.0, -100.0, 0.0), 0);
        scene.idle(3);
        class_1799 stone = new class_1799((class_1935)class_2246.field_10340, 16);
        class_2338 firstBelt = util.grid.at(0, 1, 2);
        scene.overlay.showText(60).text("Saws can work in-line with Mechanical Belts").pointAt(util.vector.blockSurface(firstBelt, class_2350.field_11039)).placeNearTarget();
        scene.idle(40);
        scene.world.createItemOnBelt(firstBelt, class_2350.field_11039, stone);
        scene.idle(40);
        class_243 filter = util.vector.of(2.5, 1.8125, 2.3125);
        scene.overlay.showFilterSlotInput(filter, class_2350.field_11036, 80);
        scene.overlay.showText(80).attachKeyFrame().text("When an ingredient has multiple possible outcomes, the filter slot can specify it").pointAt(filter).placeNearTarget();
        scene.idle(90);
        class_1799 bricks = new class_1799((class_1935)class_2246.field_10056, 16);
        scene.overlay.showControls(new InputWindowElement(filter, Pointing.DOWN).withItem(bricks), 30);
        scene.world.modifyEntities(class_1542.class, class_1297::method_31472);
        scene.idle(7);
        scene.world.setFilterData(util.select.position(sawPos), SawBlockEntity.class, bricks);
        scene.idle(10);
        scene.world.createItemOnBelt(firstBelt, class_2350.field_11039, stone);
        scene.idle(50);
        scene.markAsFinished();
        scene.overlay.showText(100).text("Without filter, the Saw would cycle through all outcomes instead").colored(PonderPalette.RED).pointAt(filter).placeNearTarget();
        scene.idle(65);
        scene.world.modifyEntities(class_1542.class, class_1297::method_31472);
    }

    public static void furnaceEngine(SceneBuilder scene, SceneBuildingUtil util) {
        DDProcessingScenes.furnaceEngine(scene, util, false);
    }

    public static void flywheel(SceneBuilder scene, SceneBuildingUtil util) {
        DDProcessingScenes.furnaceEngine(scene, util, true);
    }

    private static void furnaceEngine(SceneBuilder scene, SceneBuildingUtil util, boolean flywheel) {
        scene.title(flywheel ? "flywheel" : "furnace_engine", "Generating Rotational Force using the " + (flywheel ? "Flywheel Component" : "Flywheel Engine"));
        scene.configureBasePlate(0, 0, 7);
        scene.world.showSection(util.select.layer(0), class_2350.field_11036);
        class_2338 furnacePos = util.grid.at(4, 2, 3);
        class_2338 flywheelbasePos = util.grid.at(4, 1, 3);
        class_2338 base1 = util.grid.at(3, 1, 2);
        class_2338 base2 = util.grid.at(5, 1, 2);
        class_2338 cogPos = util.grid.at(1, 2, 2);
        class_2338 gaugePos = util.grid.at(1, 2, 1);
        class_2338 shaftPos = util.grid.at(1, 2, 0);
        scene.idle(5);
        scene.world.showSection(util.select.fromTo(base1, base2), class_2350.field_11033);
        scene.idle(2);
        scene.world.showSection(util.select.fromTo(base1.method_10077(1), base2.method_10077(1)), class_2350.field_11033);
        scene.idle(2);
        Selection furnaceSelect = util.select.position(furnacePos);
        scene.world.showSection(furnaceSelect, class_2350.field_11033);
        scene.idle(2);
        scene.world.showSection(util.select.position(furnacePos.method_10067()), class_2350.field_11033);
        scene.idle(8);
        scene.world.showSection(util.select.position(flywheelbasePos.method_10088(3)), class_2350.field_11034);
        scene.idle(2);
        scene.world.showSection(util.select.position(furnacePos.method_10088(3)), class_2350.field_11034);
        scene.idle(8);
        String text = flywheel ? "Flywheel Components are required for generating rotational force with the Flywheel Engine" : "Flywheel Engines generate Rotational Force while their attached Furnace is running";
        scene.overlay.showText(50).attachKeyFrame().placeNearTarget().pointAt(util.vector.topOf(furnacePos.method_10088(flywheel ? 3 : 1))).text(text);
        scene.idle(60);
        scene.addKeyframe();
        scene.overlay.showControls(new InputWindowElement(util.vector.topOf(furnacePos), Pointing.DOWN).withItem(new class_1799((class_1935)class_1802.field_8583)), 30);
        scene.idle(5);
        scene.overlay.showControls(new InputWindowElement(util.vector.blockSurface(furnacePos, class_2350.field_11043), Pointing.RIGHT).withItem(new class_1799((class_1935)class_1802.field_8713)), 30);
        scene.idle(7);
        scene.world.cycleBlockProperty(furnacePos, (class_2769)class_3865.field_11105);
        scene.effects.emitParticles(util.vector.of(4.5, 2.2, 2.9), EmitParticlesInstruction.Emitter.simple((class_2394)class_2398.field_11239, (class_243)class_243.field_1353), 4.0f, 1);
        scene.world.setKineticSpeed(util.select.fromTo(1, 2, 3, 1, 2, 0), 24.0f);
        scene.idle(40);
        scene.world.showSection(util.select.position(cogPos), class_2350.field_11035);
        scene.idle(8);
        scene.effects.rotationSpeedIndicator(cogPos);
        scene.world.showSection(util.select.position(gaugePos.method_10087(1)), class_2350.field_11035);
        scene.idle(2);
        scene.world.showSection(util.select.position(gaugePos), class_2350.field_11035);
        scene.idle(8);
        scene.world.showSection(util.select.position(shaftPos), class_2350.field_11035);
        scene.idle(8);
        scene.effects.rotationSpeedIndicator(shaftPos);
        scene.overlay.showText(40).attachKeyFrame().placeNearTarget().colored(PonderPalette.GREEN).pointAt(util.vector.blockSurface(gaugePos, class_2350.field_11039)).text("The provided Rotational Force has a decently large stress capacity unlike the Steam Engine");
        scene.idle(20);
    }
}

