/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.industrial_fan.Processing;

import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;
import uwu.lopyluna.create_dd.blocks.industrial_fan.Processing.IndustrialProcessingType;

public class DDFanProcessingTypeRegistry {
    private static final Map<class_2960, IndustrialProcessingType> TYPES = new Object2ReferenceOpenHashMap();
    private static final Map<IndustrialProcessingType, class_2960> IDS = new Reference2ObjectOpenHashMap();
    private static final List<IndustrialProcessingType> SORTED_TYPES = new ReferenceArrayList();
    private static final List<IndustrialProcessingType> SORTED_TYPES_VIEW = Collections.unmodifiableList(SORTED_TYPES);

    public static void register(class_2960 id, IndustrialProcessingType type) {
        if (TYPES.put(id, type) != null) {
            throw new IllegalArgumentException("Tried to override FanProcessingType registration for id '" + id + "'. This is not supported!");
        }
        class_2960 prevId = IDS.put(type, id);
        if (prevId != null) {
            throw new IllegalArgumentException("Tried to register same FanProcessingType instance for multiple ids '" + prevId + "' and '" + id + "'. This is not supported!");
        }
        DDFanProcessingTypeRegistry.insertSortedType(type, id);
    }

    private static void insertSortedType(IndustrialProcessingType type, class_2960 id) {
        int index = Collections.binarySearch(SORTED_TYPES, type, (type1, type2) -> type2.getPriority() - type1.getPriority());
        if (index >= 0) {
            throw new IllegalStateException();
        }
        SORTED_TYPES.add(-index - 1, type);
    }

    @Nullable
    public static IndustrialProcessingType getType(class_2960 id) {
        return TYPES.get(id);
    }

    public static IndustrialProcessingType getTypeOrThrow(class_2960 id) {
        IndustrialProcessingType type = DDFanProcessingTypeRegistry.getType(id);
        if (type == null) {
            throw new IllegalArgumentException("Could not get FanProcessingType for id '" + id + "'!");
        }
        return type;
    }

    @Nullable
    public static class_2960 getId(IndustrialProcessingType type) {
        return IDS.get(type);
    }

    public static class_2960 getIdOrThrow(IndustrialProcessingType type) {
        class_2960 id = DDFanProcessingTypeRegistry.getId(type);
        if (id == null) {
            throw new IllegalArgumentException("Could not get id for FanProcessingType " + type + "!");
        }
        return id;
    }

    public static List<IndustrialProcessingType> getSortedTypesView() {
        return SORTED_TYPES_VIEW;
    }
}

