/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.industrial_fan;

import com.simibubi.create.content.kinetics.base.GeneratingKineticBlockEntity;
import com.simibubi.create.content.logistics.chute.ChuteBlockEntity;
import com.simibubi.create.content.processing.burner.BlazeBurnerBlock;
import com.simibubi.create.foundation.advancement.AllAdvancements;
import com.simibubi.create.foundation.advancement.CreateAdvancement;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import uwu.lopyluna.create_dd.blocks.industrial_fan.IndustrialAirCurrent;
import uwu.lopyluna.create_dd.blocks.industrial_fan.IndustrialAirCurrentSource;
import uwu.lopyluna.create_dd.blocks.industrial_fan.IndustrialFanBlock;
import uwu.lopyluna.create_dd.config.DDConfigs;
import uwu.lopyluna.create_dd.registry.DDBlocks;
import uwu.lopyluna.create_dd.registry.DDTags;

public class IndustrialFanBlockEntity
extends GeneratingKineticBlockEntity
implements IndustrialAirCurrentSource {
    public IndustrialAirCurrent airCurrent = new IndustrialAirCurrent(this);
    protected static int airCurrentUpdateCooldown;
    protected int entitySearchCooldown;
    protected boolean updateAirFlow = true;
    protected boolean isGenerator = false;
    protected boolean updateGenerator = false;

    public IndustrialFanBlockEntity(class_2591<?> typeIn, class_2338 pos, class_2680 state) {
        super(typeIn, pos, state);
    }

    @Override
    @Nullable
    public IndustrialAirCurrent getAirCurrent() {
        return this.airCurrent;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        super.addBehaviours(behaviours);
        this.registerAwardables(behaviours, new CreateAdvancement[]{AllAdvancements.ENCASED_FAN, AllAdvancements.FAN_PROCESSING});
    }

    protected void read(class_2487 compound, boolean clientPacket) {
        super.read(compound, clientPacket);
        if (!this.wasMoved) {
            this.isGenerator = compound.method_10577("Generating");
        }
        if (clientPacket) {
            this.airCurrent.rebuild();
        }
    }

    public void write(class_2487 compound, boolean clientPacket) {
        compound.method_10556("Generating", this.isGenerator);
        super.write(compound, clientPacket);
    }

    public float calculateAddedStressCapacity() {
        return this.isGenerator ? super.calculateAddedStressCapacity() : 0.0f;
    }

    public float calculateStressApplied() {
        return this.isGenerator ? 0.0f : super.calculateStressApplied();
    }

    public float getGeneratedSpeed() {
        return this.isGenerator ? 64.0f : 0.0f;
    }

    public void queueGeneratorUpdate() {
        this.updateGenerator = true;
    }

    public void updateGenerator() {
        class_2680 blockState = this.method_11010();
        boolean shouldGenerate = DDBlocks.industrial_fan.has(blockState);
        if (shouldGenerate && blockState.method_11654((class_2769)IndustrialFanBlock.FACING) != class_2350.field_11033 && !this.blockBelowIsHot()) {
            shouldGenerate = false;
        }
        if (shouldGenerate) {
            boolean bl = shouldGenerate = this.field_11863 != null && this.blockBelowIsHot() && this.field_11863.method_49807(this.field_11867, class_2350.field_11033) && this.field_11863.method_49803(this.field_11867.method_10074()) && blockState.method_11654((class_2769)IndustrialFanBlock.FACING) == class_2350.field_11033;
        }
        if (shouldGenerate == this.isGenerator) {
            return;
        }
        this.isGenerator = shouldGenerate;
        this.updateGeneratedRotation();
    }

    public boolean blockBelowIsHot() {
        assert (this.field_11863 != null);
        class_2680 blockState = this.field_11863.method_8320(this.field_11867.method_10074());
        if (DDTags.AllBlockTags.fan_heaters.matches(blockState)) {
            return !blockState.method_28498((class_2769)BlazeBurnerBlock.HEAT_LEVEL) || ((BlazeBurnerBlock.HeatLevel)blockState.method_11654((class_2769)BlazeBurnerBlock.HEAT_LEVEL)).isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
        }
        return false;
    }

    @Override
    @javax.annotation.Nullable
    public class_1937 getAirCurrentWorld() {
        return this.field_11863;
    }

    @Override
    @NotNull
    public class_2338 getAirCurrentPos() {
        return this.field_11867;
    }

    @Override
    @NotNull
    public class_2350 getAirflowOriginSide() {
        return (class_2350)this.method_11010().method_11654((class_2769)IndustrialFanBlock.FACING);
    }

    @Override
    public class_2350 getAirFlowDirection() {
        float speed = this.getSpeed();
        if (speed == 0.0f) {
            return null;
        }
        class_2350 facing = (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
        return (speed = IndustrialFanBlockEntity.convertToDirection((float)speed, (class_2350)facing)) > 0.0f ? facing : facing.method_10153();
    }

    public void remove() {
        super.remove();
        this.updateChute();
    }

    @Override
    public boolean isSourceRemoved() {
        return this.field_11865;
    }

    public void onSpeedChanged(float prevSpeed) {
        super.onSpeedChanged(prevSpeed);
        this.updateAirFlow = true;
        this.updateChute();
    }

    public void updateChute() {
        class_2350 direction = (class_2350)this.method_11010().method_11654((class_2769)IndustrialFanBlock.FACING);
        if (!direction.method_10166().method_10178()) {
            return;
        }
        assert (this.field_11863 != null);
        class_2586 poweredChute = this.field_11863.method_8321(this.field_11867.method_10093(direction));
        if (!(poweredChute instanceof ChuteBlockEntity)) {
            return;
        }
        ChuteBlockEntity chuteBE = (ChuteBlockEntity)poweredChute;
        if (direction == class_2350.field_11033) {
            chuteBE.updatePull();
        } else {
            chuteBE.updatePush(1);
        }
    }

    public void blockInFrontChanged() {
        this.updateAirFlow = true;
    }

    public void tick() {
        boolean server;
        super.tick();
        assert (this.field_11863 != null);
        boolean bl = server = !this.field_11863.field_9236 || this.isVirtual();
        if (server && airCurrentUpdateCooldown-- <= 0) {
            airCurrentUpdateCooldown = (Integer)DDConfigs.server().kinetics.fanBlockCheckRate.get();
            this.updateAirFlow = true;
        }
        if (this.updateAirFlow) {
            this.updateAirFlow = false;
            this.airCurrent.rebuild();
            if (this.airCurrent.maxDistance > 0.0f) {
                this.award(AllAdvancements.ENCASED_FAN);
            }
            this.sendData();
        }
        if (this.updateGenerator) {
            this.updateGenerator = false;
            this.updateGenerator();
        }
        if (this.isGenerator || this.getSpeed() == 0.0f) {
            return;
        }
        if (this.entitySearchCooldown-- <= 0) {
            this.entitySearchCooldown = 5;
            this.airCurrent.findEntities();
        }
        this.airCurrent.tick();
    }
}

