/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.hydraulic_press;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.api.instance.DynamicInstance;
import com.jozufozu.flywheel.core.Materials;
import com.jozufozu.flywheel.core.materials.FlatLit;
import com.jozufozu.flywheel.core.materials.oriented.OrientedData;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftInstance;
import com.simibubi.create.content.kinetics.press.PressingBehaviour;
import com.simibubi.create.foundation.utility.AngleHelper;
import com.simibubi.create.foundation.utility.AnimationTickHolder;
import net.minecraft.class_2350;
import net.minecraft.class_7833;
import org.joml.Quaternionf;
import uwu.lopyluna.create_dd.blocks.hydraulic_press.HydraulicPressBlock;
import uwu.lopyluna.create_dd.blocks.hydraulic_press.HydraulicPressBlockEntity;
import uwu.lopyluna.create_dd.client.registry.DDBlockPartials;

public class HYPressInstance
extends ShaftInstance<HydraulicPressBlockEntity>
implements DynamicInstance {
    private final OrientedData pressHead;

    public HYPressInstance(MaterialManager materialManager, HydraulicPressBlockEntity blockEntity) {
        super(materialManager, (KineticBlockEntity)blockEntity);
        this.pressHead = (OrientedData)materialManager.defaultSolid().material(Materials.ORIENTED).getModel(DDBlockPartials.HYDRAULIC_PRESS_HEAD, this.blockState).createInstance();
        Quaternionf q = class_7833.field_40716.rotationDegrees(AngleHelper.horizontalAngle((class_2350)((class_2350)this.blockState.method_11654(HydraulicPressBlock.HORIZONTAL_FACING))));
        this.pressHead.setRotation(q);
        this.transformModels();
    }

    public void beginFrame() {
        this.transformModels();
    }

    private void transformModels() {
        float renderedHeadOffset = this.getRenderedHeadOffset((HydraulicPressBlockEntity)this.blockEntity);
        this.pressHead.setPosition(this.getInstancePosition()).nudge(0.0f, -renderedHeadOffset, 0.0f);
    }

    private float getRenderedHeadOffset(HydraulicPressBlockEntity press) {
        PressingBehaviour pressingBehaviour = press.getPressingBehaviour();
        return pressingBehaviour.getRenderedHeadOffset(AnimationTickHolder.getPartialTicks()) * pressingBehaviour.mode.headOffset;
    }

    public void updateLight() {
        super.updateLight();
        this.relight(this.pos, new FlatLit[]{this.pressHead});
    }

    public void remove() {
        super.remove();
        this.pressHead.delete();
    }
}

