/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.flywheel.engine;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2363;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_6880;

public class FurnaceEngineInteractions {
    private static final Map<class_6880<class_2248>, InteractionHandler> HANDLERS = new HashMap<class_6880<class_2248>, InteractionHandler>();
    private static final InteractionHandler DEFAULT_HANDLER = new InteractionHandler(){};

    public static void registerHandler(class_6880<class_2248> block, InteractionHandler handler) {
        HANDLERS.put(block, handler);
    }

    public static InteractionHandler getHandler(class_6880<class_2248> delegate) {
        return HANDLERS.getOrDefault(delegate, DEFAULT_HANDLER);
    }

    public static InteractionHandler getHandler(class_2680 state) {
        return FurnaceEngineInteractions.getHandler((class_6880<class_2248>)state.method_26204().method_9564().method_41520());
    }

    public static void registerDefaults() {
        FurnaceEngineInteractions.registerHandler((class_6880<class_2248>)class_2246.field_16333.method_9564().method_41520(), InteractionHandler.ofCustomSpeedModifier(state -> Float.valueOf(2.0f)));
    }

    public static interface InteractionHandler {
        default public HeatSource getHeatSource(class_2680 state) {
            if (state.method_26204() instanceof class_2363 && state.method_28498((class_2769)class_2363.field_11105)) {
                if (((Boolean)state.method_11654((class_2769)class_2363.field_11105)).booleanValue()) {
                    return HeatSource.ACTIVE;
                }
                return HeatSource.VALID;
            }
            return HeatSource.EMPTY;
        }

        default public float getSpeedModifier(class_2680 state) {
            return 1.0f;
        }

        public static InteractionHandler of(final Function<class_2680, HeatSource> heatSourceFunc, final Function<class_2680, Float> speedModifierFunc) {
            return new InteractionHandler(){

                @Override
                public HeatSource getHeatSource(class_2680 state) {
                    return (HeatSource)((Object)heatSourceFunc.apply(state));
                }

                @Override
                public float getSpeedModifier(class_2680 state) {
                    return ((Float)speedModifierFunc.apply(state)).floatValue();
                }
            };
        }

        public static InteractionHandler ofCustomHeatSource(final Function<class_2680, HeatSource> heatSourceFunc) {
            return new InteractionHandler(){

                @Override
                public HeatSource getHeatSource(class_2680 state) {
                    return (HeatSource)((Object)heatSourceFunc.apply(state));
                }
            };
        }

        public static InteractionHandler ofCustomSpeedModifier(final Function<class_2680, Float> speedModifierFunc) {
            return new InteractionHandler(){

                @Override
                public float getSpeedModifier(class_2680 state) {
                    return ((Float)speedModifierFunc.apply(state)).floatValue();
                }
            };
        }
    }

    public static enum HeatSource {
        EMPTY,
        VALID,
        ACTIVE;


        public boolean isEmpty() {
            return this == EMPTY;
        }

        public boolean isValid() {
            return this != EMPTY;
        }

        public boolean isActive() {
            return this == ACTIVE;
        }
    }
}

