/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.drill.radiant;

import com.jozufozu.flywheel.api.MaterialManager;
import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.AllTags;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.render.ActorInstance;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.contraptions.render.ContraptionRenderDispatcher;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.utility.VecHelper;
import javax.annotation.Nullable;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import uwu.lopyluna.create_dd.blocks.drill.radiant.RadiantDrillActorInstance;
import uwu.lopyluna.create_dd.blocks.drill.radiant.RadiantDrillBlock;
import uwu.lopyluna.create_dd.blocks.drill.radiant.RadiantDrillBlockBreakingKineticBlockEntity;
import uwu.lopyluna.create_dd.blocks.drill.radiant.RadiantDrillRenderer;
import uwu.lopyluna.create_dd.registry.DDTags;

public class RadiantDrillMovementBehaviour
extends BlockBreakingMovementBehaviour {
    public void tickBreaker(MovementContext context) {
        class_2487 data = context.data;
        if (context.world.field_9236) {
            return;
        }
        if (!data.method_10545("BreakingPos")) {
            context.stall = false;
            return;
        }
        if (context.relativeMotion.equals((Object)class_243.field_1353)) {
            context.stall = false;
            return;
        }
        int ticksUntilNextProgress = data.method_10550("TicksUntilNextProgress");
        if (ticksUntilNextProgress-- > 0) {
            data.method_10569("TicksUntilNextProgress", ticksUntilNextProgress);
            return;
        }
        class_1937 world = context.world;
        class_2338 breakingPos = class_2512.method_10691((class_2487)data.method_10562("BreakingPos"));
        int destroyProgress = data.method_10550("Progress");
        int id = data.method_10550("BreakerId");
        class_2680 stateToBreak = world.method_8320(breakingPos);
        float blockHardness = stateToBreak.method_26214((class_1922)world, breakingPos);
        if (!this.canBreak(world, breakingPos, stateToBreak)) {
            if (destroyProgress != 0) {
                destroyProgress = 0;
                data.method_10551("Progress");
                data.method_10551("TicksUntilNextProgress");
                data.method_10551("BreakingPos");
                world.method_8517(id, breakingPos, -1);
            }
            context.stall = false;
            return;
        }
        float breakSpeed = this.getBlockBreakingSpeed(context);
        destroyProgress += class_3532.method_15340((int)((int)(breakSpeed / blockHardness)), (int)1, (int)(10 - destroyProgress));
        world.method_8396(null, breakingPos, stateToBreak.method_26231().method_10596(), class_3419.field_15254, 0.25f, 1.0f);
        if (destroyProgress >= 10) {
            world.method_8517(id, breakingPos, -1);
            class_2338 ogPos = breakingPos;
            class_2680 stateAbove = world.method_8320(breakingPos.method_10084());
            while (stateAbove.method_26204() instanceof class_2346) {
                breakingPos = breakingPos.method_10084();
                stateAbove = world.method_8320(breakingPos.method_10084());
            }
            stateToBreak = world.method_8320(breakingPos);
            context.stall = false;
            if (this.shouldDestroyStartBlock(stateToBreak)) {
                this.radiantDestroyBlock(context, breakingPos);
            }
            this.onBlockBroken(context, ogPos, stateToBreak);
            ticksUntilNextProgress = -1;
            data.method_10551("Progress");
            data.method_10551("TicksUntilNextProgress");
            data.method_10551("BreakingPos");
            return;
        }
        ticksUntilNextProgress = (int)(blockHardness / breakSpeed);
        world.method_8517(id, breakingPos, destroyProgress);
        data.method_10569("TicksUntilNextProgress", ticksUntilNextProgress);
        data.method_10569("Progress", destroyProgress);
    }

    protected void radiantDestroyBlock(MovementContext context, class_2338 breakingPos) {
        RadiantDrillBlockBreakingKineticBlockEntity.fortunedestroyBlock(context.world, breakingPos, 1.0f, stack -> this.dropItem(context, (class_1799)stack));
    }

    protected void destroyBlock(MovementContext context, class_2338 breakingPos) {
        RadiantDrillBlockBreakingKineticBlockEntity.fortunedestroyBlock(context.world, breakingPos, 1.0f, stack -> this.dropItem(context, (class_1799)stack));
    }

    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards((class_243)context.relativeMotion, (class_2350)((class_2350)context.state.method_11654((class_2769)RadiantDrillBlock.FACING)).method_10153());
    }

    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)RadiantDrillBlock.FACING)).method_10163()).method_1021((double)0.65f);
    }

    @Environment(value=EnvType.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        if (!ContraptionRenderDispatcher.canInstance()) {
            RadiantDrillRenderer.renderInContraption(context, renderWorld, matrices, buffer);
        }
    }

    public boolean hasSpecialInstancedRendering() {
        return true;
    }

    @Nullable
    public ActorInstance createInstance(MaterialManager materialManager, VirtualRenderWorld simulationWorld, MovementContext context) {
        return new RadiantDrillActorInstance(materialManager, simulationWorld, context);
    }

    protected class_1282 getDamageSource(class_1937 level) {
        return CreateDamageSources.drill((class_1937)level);
    }

    protected float getBlockBreakingSpeed(MovementContext context) {
        float lowerLimit = 0.0078125f;
        if (context.contraption instanceof MountedContraption) {
            lowerLimit = 1.0f;
        }
        if (context.contraption instanceof CarriageContraption) {
            lowerLimit = 2.0f;
        }
        return class_3532.method_15363((float)(Math.abs(context.getAnimationSpeed()) / 25.0f), (float)lowerLimit, (float)16.0f);
    }

    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        return super.canBreak(world, breakingPos, state) && !state.method_26220((class_1922)world, breakingPos).method_1110() && !AllTags.AllBlockTags.TRACKS.matches(state) && !DDTags.AllBlockTags.radiant_drill_immune.matches(state);
    }
}

