/*
 * Decompiled with CFR 0.152.
 */
package uwu.lopyluna.create_dd.blocks.bronze_saw;

import com.jozufozu.flywheel.core.virtual.VirtualRenderWorld;
import com.simibubi.create.content.contraptions.Contraption;
import com.simibubi.create.content.contraptions.behaviour.MovementContext;
import com.simibubi.create.content.contraptions.mounted.MountedContraption;
import com.simibubi.create.content.contraptions.render.ContraptionMatrices;
import com.simibubi.create.content.kinetics.base.BlockBreakingMovementBehaviour;
import com.simibubi.create.content.trains.entity.CarriageContraption;
import com.simibubi.create.foundation.damageTypes.CreateDamageSources;
import com.simibubi.create.foundation.utility.AbstractBlockBreakQueue;
import com.simibubi.create.foundation.utility.TreeCutter;
import com.simibubi.create.foundation.utility.VecHelper;
import io.github.fabricators_of_create.porting_lib.transfer.TransferUtil;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_4597;
import uwu.lopyluna.create_dd.blocks.bronze_saw.BronzeSawBlock;
import uwu.lopyluna.create_dd.blocks.bronze_saw.BronzeSawBlockEntity;
import uwu.lopyluna.create_dd.blocks.bronze_saw.BronzeSawRenderer;

public class BronzeSawMovementBehaviour
extends BlockBreakingMovementBehaviour {
    public boolean isActive(MovementContext context) {
        return super.isActive(context) && !VecHelper.isVecPointingTowards((class_243)context.relativeMotion, (class_2350)((class_2350)context.state.method_11654((class_2769)BronzeSawBlock.FACING)).method_10153());
    }

    public class_243 getActiveAreaOffset(MovementContext context) {
        return class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)BronzeSawBlock.FACING)).method_10163()).method_1021((double)0.65f);
    }

    public void visitNewPosition(MovementContext context, class_2338 pos) {
        super.visitNewPosition(context, pos);
        class_243 facingVec = class_243.method_24954((class_2382)((class_2350)context.state.method_11654((class_2769)BronzeSawBlock.FACING)).method_10163());
        facingVec = (class_243)context.rotation.apply(facingVec);
        class_2350 closestToFacing = class_2350.method_10142((double)facingVec.field_1352, (double)facingVec.field_1351, (double)facingVec.field_1350);
        if (closestToFacing.method_10166().method_10178() && context.data.method_10545("BreakingPos")) {
            context.data.method_10551("BreakingPos");
            context.stall = false;
        }
    }

    public boolean canBreak(class_1937 world, class_2338 breakingPos, class_2680 state) {
        return super.canBreak(world, breakingPos, state) && BronzeSawBlockEntity.isSawable(state);
    }

    protected void onBlockBroken(MovementContext context, class_2338 pos, class_2680 brokenState) {
        if (brokenState.method_26164(class_3481.field_15503)) {
            return;
        }
        Optional dynamicTree = TreeCutter.findDynamicTree((class_2248)brokenState.method_26204(), (class_2338)pos);
        if (dynamicTree.isPresent()) {
            ((AbstractBlockBreakQueue)dynamicTree.get()).destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (class_2338)stack, (class_1799)dropPos));
            return;
        }
        TreeCutter.findTree((class_1922)context.world, (class_2338)pos).destroyBlocks(context.world, null, (stack, dropPos) -> this.dropItemFromCutTree(context, (class_2338)stack, (class_1799)dropPos));
    }

    public void dropItemFromCutTree(MovementContext context, class_2338 pos, class_1799 stack) {
        Contraption.ContraptionInvWrapper storage = context.contraption.getSharedInventory();
        try (Transaction t = TransferUtil.getTransaction();){
            long trying = stack.method_7947();
            long success = storage.insert((Object)ItemVariant.of((class_1799)stack), (long)stack.method_7947(), (TransactionContext)t);
            int remainder = (int)(trying - success);
            if (remainder > 0) {
                class_1937 world = context.world;
                class_243 dropPos = VecHelper.getCenterOf((class_2382)pos);
                float distance = context.position == null ? 1.0f : (float)dropPos.method_1022(context.position);
                class_1542 entity = new class_1542(world, dropPos.field_1352, dropPos.field_1351, dropPos.field_1350, stack.method_46651(remainder));
                entity.method_18799(context.relativeMotion.method_1021((double)(distance / 20.0f)));
                world.method_8649((class_1297)entity);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void renderInContraption(MovementContext context, VirtualRenderWorld renderWorld, ContraptionMatrices matrices, class_4597 buffer) {
        BronzeSawRenderer.renderInContraption(context, renderWorld, matrices, buffer);
    }

    protected boolean shouldDestroyStartBlock(class_2680 stateToBreak) {
        return !TreeCutter.canDynamicTreeCutFrom((class_2248)stateToBreak.method_26204());
    }

    protected class_1282 getDamageSource(class_1937 level) {
        return CreateDamageSources.saw((class_1937)level);
    }

    protected float getBlockBreakingSpeed(MovementContext context) {
        float lowerLimit = 0.0078125f;
        if (context.contraption instanceof MountedContraption) {
            lowerLimit = 1.0f;
        }
        if (context.contraption instanceof CarriageContraption) {
            lowerLimit = 2.0f;
        }
        return class_3532.method_15363((float)(Math.abs(context.getAnimationSpeed()) / 175.0f), (float)lowerLimit, (float)16.0f);
    }
}

