/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.utility.fabric.PlatformEnvironmentImpl;
import com.copycatsplus.copycats.utility.fabric.PlatformImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;

public enum Platform {
    FORGE,
    FABRIC;

    public static final Platform CURRENT;

    public boolean isCurrent() {
        return this == CURRENT;
    }

    public void runIfCurrent(Supplier<Runnable> run) {
        if (this.isCurrent()) {
            run.get().run();
        }
    }

    @ApiStatus.Internal
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static Platform getCurrent() {
        return PlatformImpl.getCurrent();
    }

    static {
        CURRENT = Platform.getCurrent();
    }

    public static enum Environment {
        CLIENT,
        SERVER;

        public static final Environment CURRENT;

        public boolean isCurrent() {
            return this == CURRENT;
        }

        public void runIfCurrent(Supplier<Runnable> run) {
            if (this.isCurrent()) {
                run.get().run();
            }
        }

        public <T> T getIfCurrent(Supplier<T> supplier) {
            return this.isCurrent() ? (T)supplier.get() : null;
        }

        public <T> T getIfCurrent(Supplier<T> supplier, T defaultValue) {
            return this.isCurrent() ? supplier.get() : defaultValue;
        }

        @ApiStatus.Internal
        @ExpectPlatform
        @ExpectPlatform.Transformed
        public static Environment getCurrent() {
            return PlatformEnvironmentImpl.getCurrent();
        }

        static {
            CURRENT = Environment.getCurrent();
        }
    }
}

