/*
 * Decompiled with CFR 0.152.
 */
package net.irisshaders.iris.compat.sodium.impl.vertex_format.terrain_xhfp;

import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexAttributeFormat;
import me.jellysquid.mods.sodium.client.gl.attribute.GlVertexFormat;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkMeshAttribute;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexEncoder;
import me.jellysquid.mods.sodium.client.render.chunk.vertex.format.ChunkVertexType;
import net.irisshaders.iris.compat.sodium.impl.vertex_format.IrisChunkMeshAttributes;
import net.irisshaders.iris.compat.sodium.impl.vertex_format.IrisGlVertexAttributeFormat;
import net.irisshaders.iris.compat.sodium.impl.vertex_format.terrain_xhfp.XHFPTerrainVertex;
import net.minecraft.class_3532;

public class XHFPModelVertexType
implements ChunkVertexType {
    public static final int STRIDE = 40;
    public static final GlVertexFormat<ChunkMeshAttribute> VERTEX_FORMAT = GlVertexFormat.builder(ChunkMeshAttribute.class, (int)40).addElement((Enum)ChunkMeshAttribute.POSITION, 0, GlVertexAttributeFormat.UNSIGNED_INT, 2, false, true).addElement((Enum)ChunkMeshAttribute.COLOR, 8, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, true, false).addElement((Enum)ChunkMeshAttribute.TEXTURE, 12, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, true).addElement((Enum)ChunkMeshAttribute.LIGHT_MATERIAL_INDEX, 16, GlVertexAttributeFormat.UNSIGNED_BYTE, 4, false, true).addElement((Enum)IrisChunkMeshAttributes.MID_TEX_COORD, 20, GlVertexAttributeFormat.UNSIGNED_SHORT, 2, false, false).addElement((Enum)IrisChunkMeshAttributes.TANGENT, 24, IrisGlVertexAttributeFormat.BYTE, 4, true, false).addElement((Enum)IrisChunkMeshAttributes.NORMAL, 28, IrisGlVertexAttributeFormat.BYTE, 3, true, false).addElement((Enum)IrisChunkMeshAttributes.BLOCK_ID, 32, IrisGlVertexAttributeFormat.SHORT, 2, false, false).addElement((Enum)IrisChunkMeshAttributes.MID_BLOCK, 36, IrisGlVertexAttributeFormat.BYTE, 4, false, false).build();
    public static final int POSITION_MAX_VALUE = 0x100000;
    public static final int TEXTURE_MAX_VALUE = 32768;
    private static final float MODEL_ORIGIN = 8.0f;
    private static final float MODEL_RANGE = 32.0f;

    protected static int packPositionHi(int x, int y, int z) {
        return (x >>> 10 & 0x3FF) << 0 | (y >>> 10 & 0x3FF) << 10 | (z >>> 10 & 0x3FF) << 20;
    }

    protected static int packPositionLo(int x, int y, int z) {
        return (x & 0x3FF) << 0 | (y & 0x3FF) << 10 | (z & 0x3FF) << 20;
    }

    public static int quantizePosition(float position) {
        return (int)(XHFPModelVertexType.normalizePosition(position) * 1048576.0f) & 0xFFFFF;
    }

    public static int encodeTextureOld(float u, float v) {
        return (Math.round(u * 32768.0f) & 0xFFFF) << 0 | (Math.round(v * 32768.0f) & 0xFFFF) << 16;
    }

    public static float normalizePosition(float v) {
        return (8.0f + v) / 32.0f;
    }

    public static int packTexture(int u, int v) {
        return (u & 0xFFFF) << 0 | (v & 0xFFFF) << 16;
    }

    public static int encodeTexture(float center, float x) {
        int bias = x < center ? 1 : -1;
        int quantized = Math.round(x * 32768.0f) + bias;
        return quantized & Short.MAX_VALUE | XHFPModelVertexType.sign(bias) << 15;
    }

    public static int encodeLight(int light) {
        int sky = class_3532.method_15340((int)(light >>> 16 & 0xFF), (int)8, (int)248);
        int block = class_3532.method_15340((int)(light >>> 0 & 0xFF), (int)8, (int)248);
        return block << 0 | sky << 8;
    }

    public static int packLightAndData(int light, int material, int section) {
        return (light & 0xFFFF) << 0 | (material & 0xFF) << 16 | (section & 0xFF) << 24;
    }

    private static int sign(int x) {
        return x >>> 31;
    }

    public GlVertexFormat<ChunkMeshAttribute> getVertexFormat() {
        return VERTEX_FORMAT;
    }

    public ChunkVertexEncoder getEncoder() {
        return new XHFPTerrainVertex();
    }
}

