/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.google.gson.JsonParser;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.Unpooled;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_2540;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import org.slf4j.Logger;

public class HandshakeClient<L, F extends L> {
    public static final int PROTOCOL_VERSION = 3;
    private final Codec<F> transferCodec;
    private final Codec<L> limitedTransferCodec;
    private final Consumer<L> updateCallback;
    private L serverConfig = null;
    private F fullServerConfig = null;
    private boolean hasConnected = false;

    public HandshakeClient(Codec<F> transferCodec, Codec<L> limitedTransferCodec, Consumer<L> updateCallback) {
        this.transferCodec = transferCodec;
        this.limitedTransferCodec = limitedTransferCodec;
        this.updateCallback = updateCallback;
    }

    public Optional<L> getConfig() {
        return Optional.ofNullable(this.serverConfig);
    }

    public Optional<F> getFullConfig() {
        return Optional.ofNullable(this.fullServerConfig);
    }

    public boolean hasConnected() {
        return this.hasConnected;
    }

    public class_2540 handleConfigSync(class_2540 buf) {
        this.serverConfig = null;
        this.fullServerConfig = null;
        try {
            int protocolVersion = buf.readInt();
            if (protocolVersion < 1 || protocolVersion > 3) {
                DoABarrelRoll.LOGGER.warn("Received config with unknown protocol version: {}, will attempt to load anyway", (Object)protocolVersion);
            }
            String data = buf.method_19772();
            boolean isLimited = true;
            if (protocolVersion >= 2) {
                isLimited = buf.readBoolean();
            }
            if (protocolVersion == 2) {
                Object codec = isLimited ? this.limitedTransferCodec : this.transferCodec;
                this.serverConfig = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)data)).getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0));
                if (!isLimited) {
                    this.fullServerConfig = this.serverConfig;
                }
            } else {
                this.serverConfig = this.limitedTransferCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)data)).getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0));
                if (!isLimited) {
                    String data2 = buf.method_19772();
                    this.fullServerConfig = this.transferCodec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseString((String)data2)).getOrThrow(false, arg_0 -> ((Logger)DoABarrelRoll.LOGGER).error(arg_0));
                }
            }
        }
        catch (RuntimeException e) {
            DoABarrelRoll.LOGGER.error("Failed to parse config from server", (Throwable)e);
        }
        if (this.serverConfig != null) {
            this.updateCallback.accept(this.serverConfig);
            this.hasConnected = true;
            DoABarrelRoll.LOGGER.info("Received config from server");
        }
        class_2540 returnBuf = new class_2540(Unpooled.buffer());
        returnBuf.writeInt(3);
        returnBuf.writeBoolean(this.serverConfig != null);
        return returnBuf;
    }

    public void reset() {
        this.serverConfig = null;
        this.hasConnected = false;
    }
}

