/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.util;

import com.google.common.collect.AbstractIterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.minecraft.class_2338;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class ShapeBuilder {
    Iterable<class_2338> blocks;

    ShapeBuilder() {
    }

    public static ShapeBuilder start() {
        return new ShapeBuilder();
    }

    public ShapeBuilder getAllInSphereMutable(int radius, class_2338 center) {
        return this.getAllInSphereMutable(radius, center.method_10263(), center.method_10264(), center.method_10260());
    }

    public ShapeBuilder getAllInSphereMutable(int radius, int c1, int c2, int c3) {
        return this.getAllInCutOffSphereMutable(radius, radius, c1, c2, c3);
    }

    public ShapeBuilder getAllInCutOffSphereMutable(int radiusX, int yCutOff, class_2338 center) {
        return this.getAllInCutOffSphereMutable(radiusX, yCutOff, yCutOff, center.method_10263(), center.method_10264(), center.method_10260());
    }

    public ShapeBuilder getAllInCutOffSphereMutable(int radiusX, int yCutOff, int c1, int c2, int c3) {
        return this.getAllInCutOffSphereMutable(radiusX, yCutOff, yCutOff, c1, c2, c3);
    }

    public ShapeBuilder getAllInCutOffSphereMutable(int radiusX, int yCutOffMax, int yCutOffMin, class_2338 center) {
        return this.getAllInCutOffSphereMutable(radiusX, yCutOffMax, yCutOffMin, center.method_10263(), center.method_10264(), center.method_10260());
    }

    public ShapeBuilder getAllInCutOffSphereMutable(final int radiusX, final int yCutOffMax, final int yCutOffMin, final int c1, final int c2, final int c3) {
        final int r2 = radiusX * radiusX;
        this.blocks = () -> new AbstractIterator<class_2338>(){
            private final class_2338.class_2339 mutablePos = new class_2338.class_2339();
            private int currRX = radiusX;
            private int currRY = yCutOffMax;
            private int offset = 0;
            private int phase = 1;

            protected class_2338 computeNext() {
                if (-this.currRY > yCutOffMin) {
                    return (class_2338)this.endOfData();
                }
                if (this.isWithinRange(this.currRX, this.currRY, this.phase, this.offset, r2)) {
                    class_2338.class_2339 pos = this.mutablePos.method_10103(c1 + this.currRX, c2 + this.currRY, c3 + this.phase * this.offset);
                    ++this.offset;
                    return pos;
                }
                if (this.phase == 1) {
                    this.phase = -1;
                    this.offset = 1;
                } else if (this.phase == -1) {
                    this.phase = 1;
                    this.offset = 0;
                    --this.currRX;
                }
                if (-this.currRX > radiusX) {
                    --this.currRY;
                    this.currRX = radiusX;
                }
                return this.computeNext();
            }

            private boolean isWithinRange(int currentRadiusX, int currentRadiusY, int phase, int offset, int radius2) {
                return Math.round((double)currentRadiusX * (double)currentRadiusX + (double)(currentRadiusY * currentRadiusY) + (double)(phase * offset * (phase * offset))) <= (long)radius2;
            }
        };
        return this;
    }

    public ShapeBuilder getAllInRandomlyDistributedRangeYCutOffSphereMutable(int maxRadiusX, int minRadiusX, int yCutOff, class_5819 rand, class_2338 center) {
        return this.getAllInRandomlyDistributedRangeYCutOffSphereMutable(maxRadiusX, minRadiusX, yCutOff, rand, center.method_10263(), center.method_10264(), center.method_10260());
    }

    public ShapeBuilder getAllInRandomlyDistributedRangeYCutOffSphereMutable(int maxRadiusX, int minRadiusX, int ycutoffmin, class_5819 rand, int c1, int c2, int c3) {
        return this.getAllInRandomlyDistributedRangeYCutOffSphereMutable(maxRadiusX, minRadiusX, ycutoffmin, ycutoffmin, rand, c1, c2, c3);
    }

    public ShapeBuilder getAllInRandomlyDistributedRangeYCutOffSphereMutable(final int maxRadiusX, int minRadiusX, final int yCutOffMax, final int yCutOffMin, final class_5819 rand, final int c1, final int c2, final int c3) {
        final int maxr2 = maxRadiusX * maxRadiusX;
        final int minr2 = minRadiusX * minRadiusX;
        final float rDifference = (float)minRadiusX / (float)maxRadiusX;
        this.blocks = () -> new AbstractIterator<class_2338>(){
            private final class_2338.class_2339 mutablePos = new class_2338.class_2339();
            private int currRX = maxRadiusX;
            private int currRY = yCutOffMax;
            private int offset = 0;
            private int phase = 1;

            protected class_2338 computeNext() {
                if (-this.currRY > yCutOffMin) {
                    return (class_2338)this.endOfData();
                }
                int distance = this.distance(this.currRX, this.currRY, this.phase, this.offset);
                if (distance <= minr2 || (float)distance <= (float)maxr2 * class_3532.method_15363((float)rand.method_43057(), (float)rDifference, (float)1.0f)) {
                    class_2338.class_2339 pos = this.mutablePos.method_10103(c1 + this.currRX, c2 + this.currRY, c3 + this.phase * this.offset);
                    ++this.offset;
                    return pos;
                }
                if (distance <= maxr2) {
                    ++this.offset;
                    return this.computeNext();
                }
                if (this.phase == 1) {
                    this.phase = -1;
                    this.offset = 1;
                } else if (this.phase == -1) {
                    this.phase = 1;
                    this.offset = 0;
                    --this.currRX;
                }
                if (-this.currRX > maxRadiusX) {
                    --this.currRY;
                    this.currRX = maxRadiusX;
                }
                return this.computeNext();
            }

            private int distance(int currentRadiusX, int currentRadiusY, int phase, int offset) {
                return (int)Math.round((double)currentRadiusX * (double)currentRadiusX + (double)(currentRadiusY * currentRadiusY) + (double)(phase * offset * (phase * offset)));
            }
        };
        return this;
    }

    public ShapeBuilder getAllInCircleMutable(final int radius, final int c1, final int c2, final int c3) {
        final int r2 = radius * radius;
        this.blocks = () -> new AbstractIterator<class_2338>(){
            private final class_2338.class_2339 mutablePos = new class_2338.class_2339();
            private int totalAmount;
            private int currR = radius;
            private int offset = 0;
            private int phase = 1;

            protected class_2338 computeNext() {
                if (-this.currR > radius) {
                    return (class_2338)this.endOfData();
                }
                if (this.isWithinRange(this.currR, this.phase, this.offset, r2)) {
                    class_2338.class_2339 pos = this.mutablePos.method_10103(c1 + this.currR, c2, c3 + this.phase * this.offset);
                    ++this.offset;
                    return pos;
                }
                if (this.phase == 1) {
                    this.phase = -1;
                    this.offset = 1;
                } else if (this.phase == -1) {
                    this.phase = 1;
                    this.offset = 0;
                    --this.currR;
                }
                return this.computeNext();
            }

            private boolean isWithinRange(int currentRadius, int phase, int offset, int radius2) {
                return Math.floor((double)currentRadius * (double)currentRadius + (double)(phase * offset * (phase * offset))) <= (double)radius2;
            }
        };
        return this;
    }

    public Stream<class_2338> toStream(boolean parallel) {
        return StreamSupport.stream(this.blocks.spliterator(), parallel);
    }

    public Iterable<class_2338> toIterable() {
        return this.blocks;
    }
}

