/*
 * Decompiled with CFR 0.152.
 */
package com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs;

import com.iafenvoy.uranus.Uranus;
import com.iafenvoy.uranus.object.BlockUtil;
import com.iafenvoy.uranus.object.PathUtil;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.AbstractAdvancedPathNavigate;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.ChunkCache;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.IPassabilityNavigator;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.ITallWalker;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.MNode;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathPointExtended;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathResult;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathfindingConstants;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.PathingOptions;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.SurfaceType;
import com.iafenvoy.uranus.object.entity.pathfinding.raycoms.pathjobs.ICustomSizeNavigator;
import com.mojang.datafixers.util.Pair;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import net.minecraft.class_11;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2185;
import net.minecraft.class_2202;
import net.minecraft.class_2211;
import net.minecraft.class_2241;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2349;
import net.minecraft.class_2350;
import net.minecraft.class_2354;
import net.minecraft.class_2358;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_2440;
import net.minecraft.class_2478;
import net.minecraft.class_2488;
import net.minecraft.class_2510;
import net.minecraft.class_2533;
import net.minecraft.class_2541;
import net.minecraft.class_2544;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2760;
import net.minecraft.class_2769;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3612;
import net.minecraft.class_3830;
import net.minecraft.class_3922;
import net.minecraft.class_4538;
import net.minecraft.class_5815;
import net.minecraft.class_7;
import net.minecraft.class_9;

public abstract class AbstractPathJob
implements Callable<class_11> {
    public static Map<class_1657, UUID> trackingMap = new HashMap<class_1657, UUID>();
    private final Queue<MNode> nodesOpen = new PriorityQueue<MNode>(500);
    private final Map<Integer, MNode> nodesVisited = new HashMap<Integer, MNode>();
    private final AbstractAdvancedPathNavigate.RestrictionType restrictionType;
    private final boolean hardXzRestriction;
    protected class_2338 start;
    protected class_4538 world;
    protected PathResult result;
    protected WeakReference<class_1309> entity;
    protected int maxRange;
    protected class_2338 end = null;
    protected boolean debugDrawEnabled = false;
    protected Set<MNode> debugNodesVisited = new HashSet<MNode>();
    protected Set<MNode> debugNodesNotVisited = new HashSet<MNode>();
    protected Set<MNode> debugNodesPath = new HashSet<MNode>();
    IPassabilityNavigator passabilityNavigator;
    private boolean allowJumpPointSearchTypeWalk;
    private float entitySizeXZ = 1.0f;
    private int entitySizeY = 1;
    private boolean circumventSizeCheck = false;
    private int totalNodesAdded = 0;
    private int totalNodesVisited = 0;
    private PathingOptions pathingOptions = new PathingOptions();
    private int maxX;
    private int minX;
    private int maxZ;
    private int minZ;
    private int maxY;
    private int minY;
    private double maxJumpHeight = 1.3;
    private int maxNavigableGroundDist = 1;

    public AbstractPathJob(class_1937 world, class_2338 start, class_2338 end, int range, class_1309 entity) {
        this(world, start, end, range, new PathResult(), entity);
    }

    public AbstractPathJob(class_1937 world, class_2338 start, class_2338 end, int range, PathResult result, class_1309 entity) {
        int minX = Math.min(start.method_10263(), end.method_10263()) - range / 2;
        int minZ = Math.min(start.method_10260(), end.method_10260()) - range / 2;
        int maxX = Math.max(start.method_10263(), end.method_10263()) + range / 2;
        int maxZ = Math.max(start.method_10260(), end.method_10260()) + range / 2;
        this.restrictionType = AbstractAdvancedPathNavigate.RestrictionType.NONE;
        this.hardXzRestriction = false;
        this.world = new ChunkCache(world, new class_2338(minX, world.method_31607(), minZ), new class_2338(maxX, world.method_31600(), maxZ), range, world.method_8597());
        this.start = new class_2338((class_2382)start);
        this.end = end;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.method_5667())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<MNode>();
            this.debugNodesNotVisited = new HashSet<MNode>();
            this.debugNodesPath = new HashSet<MNode>();
        }
        this.setEntitySizes(entity);
        if (entity instanceof IPassabilityNavigator) {
            this.passabilityNavigator = (IPassabilityNavigator)entity;
            this.maxRange = this.passabilityNavigator.maxSearchNodes();
        }
        if (entity instanceof ITallWalker) {
            ITallWalker tallWalker = (ITallWalker)entity;
            this.maxNavigableGroundDist = tallWalker.getMaxNavigableDistanceToGround();
        }
        assert (entity != null);
        this.maxJumpHeight = (float)Math.floor(entity.method_49476() - 0.2f) + 1.3f;
        this.entity = new WeakReference<class_1309>(entity);
    }

    public AbstractPathJob(class_1937 world, class_2338 start, class_2338 startRestriction, class_2338 endRestriction, int range, boolean hardRestriction, PathResult result, class_1309 entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this(world, start, startRestriction, endRestriction, range, class_2382.field_11176, hardRestriction, result, entity, restrictionType);
        this.setEntitySizes(entity);
        if (entity instanceof IPassabilityNavigator) {
            this.passabilityNavigator = (IPassabilityNavigator)entity;
            this.maxRange = this.passabilityNavigator.maxSearchNodes();
        }
        this.maxJumpHeight = (float)Math.floor(entity.method_49476() - 0.2f) + 1.3f;
    }

    public AbstractPathJob(class_1937 world, class_2338 start, class_2338 startRestriction, class_2338 endRestriction, int range, class_2382 grow, boolean hardRestriction, PathResult result, class_1309 entity, AbstractAdvancedPathNavigate.RestrictionType restrictionType) {
        this.minX = Math.min(startRestriction.method_10263(), endRestriction.method_10263()) - grow.method_10263();
        this.minZ = Math.min(startRestriction.method_10260(), endRestriction.method_10260()) - grow.method_10260();
        this.maxX = Math.max(startRestriction.method_10263(), endRestriction.method_10263()) + grow.method_10263();
        this.maxZ = Math.max(startRestriction.method_10260(), endRestriction.method_10260()) + grow.method_10260();
        this.minY = Math.min(startRestriction.method_10264(), endRestriction.method_10264()) - grow.method_10264();
        this.maxY = Math.max(startRestriction.method_10264(), endRestriction.method_10264()) + grow.method_10264();
        this.restrictionType = restrictionType;
        this.hardXzRestriction = hardRestriction;
        this.world = new ChunkCache(world, new class_2338(this.minX, world.method_31607(), this.minZ), new class_2338(this.maxX, world.method_31600(), this.maxZ), range, world.method_8597());
        this.start = start;
        this.maxRange = range;
        this.result = result;
        result.setJob(this);
        this.allowJumpPointSearchTypeWalk = false;
        if (entity != null && trackingMap.containsValue(entity.method_5667())) {
            this.debugDrawEnabled = true;
            this.debugNodesVisited = new HashSet<MNode>();
            this.debugNodesNotVisited = new HashSet<MNode>();
            this.debugNodesPath = new HashSet<MNode>();
        }
        this.entity = new WeakReference<class_1309>(entity);
    }

    public static class_2338 prepareStart(class_1309 entity) {
        class_2338.class_2339 pos = new class_2338.class_2339(entity.method_31477(), entity.method_31478(), entity.method_31479());
        class_1937 world = entity.method_37908();
        class_2680 bs = world.method_8320((class_2338)pos);
        class_265 collisionShape = bs.method_26222((class_1922)world, (class_2338)pos);
        if (bs.method_51366() && collisionShape.method_1105(class_2350.class_2351.field_11048) > 0.0) {
            double relPosX = Math.abs(entity.method_23317() % 1.0);
            double relPosZ = Math.abs(entity.method_23321() % 1.0);
            for (class_238 box : collisionShape.method_1090()) {
                if (!(relPosX >= box.field_1323) || !(relPosX <= box.field_1320) || !(relPosZ >= box.field_1321) || !(relPosZ <= box.field_1324) || !(box.field_1325 > 0.0)) continue;
                pos.method_10103(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
                bs = world.method_8320((class_2338)pos);
                break;
            }
        }
        class_2680 down = world.method_8320(pos.method_10074());
        while (!(bs.method_51366() || down.method_51366() || BlockUtil.isLadder(down.method_26204()))) {
            pos.method_10104(class_2350.field_11033, 1);
            bs = down;
            down = world.method_8320(pos.method_10074());
            if (pos.method_10264() >= world.method_31607()) continue;
            return entity.method_24515();
        }
        class_2248 b = bs.method_26204();
        if (entity.method_5799()) {
            while (!bs.method_26227().method_15769()) {
                pos.method_10103(pos.method_10263(), pos.method_10264() + 1, pos.method_10260());
                bs = world.method_8320((class_2338)pos);
            }
        } else if (b instanceof class_2354 || b instanceof class_2544 || bs.method_51367()) {
            double dX = entity.method_23317() - Math.floor(entity.method_23317());
            double dZ = entity.method_23321() - Math.floor(entity.method_23321());
            if (dX < 0.25) {
                pos.method_10103(pos.method_10263() - 1, pos.method_10264(), pos.method_10260());
            } else if (dX > 0.75) {
                pos.method_10103(pos.method_10263() + 1, pos.method_10264(), pos.method_10260());
            }
            if (dZ < 0.25) {
                pos.method_10103(pos.method_10263(), pos.method_10264(), pos.method_10260() - 1);
            } else if (dZ > 0.75) {
                pos.method_10103(pos.method_10263(), pos.method_10264(), pos.method_10260() + 1);
            }
        }
        return pos.method_10062();
    }

    private static void setLadderFacing(class_4538 world, class_2338 pos, PathPointExtended p) {
        class_2680 state = world.method_8320(pos);
        class_2248 block = state.method_26204();
        if (block instanceof class_2541) {
            if (((Boolean)state.method_11654((class_2769)class_2541.field_11699)).booleanValue()) {
                p.setLadderFacing(class_2350.field_11043);
            } else if (((Boolean)state.method_11654((class_2769)class_2541.field_11696)).booleanValue()) {
                p.setLadderFacing(class_2350.field_11034);
            } else if (((Boolean)state.method_11654((class_2769)class_2541.field_11706)).booleanValue()) {
                p.setLadderFacing(class_2350.field_11035);
            } else if (((Boolean)state.method_11654((class_2769)class_2541.field_11702)).booleanValue()) {
                p.setLadderFacing(class_2350.field_11039);
            }
        } else if (block instanceof class_2399) {
            p.setLadderFacing((class_2350)state.method_11654((class_2769)class_2399.field_11253));
        } else {
            p.setLadderFacing(class_2350.field_11036);
        }
    }

    private static boolean onALadder(MNode node, MNode nextInPath, class_2338 pos) {
        return nextInPath != null && node.isLadder() && nextInPath.pos.method_10263() == pos.method_10263() && nextInPath.pos.method_10260() == pos.method_10260();
    }

    private static int computeNodeKey(class_2338 pos) {
        return (pos.method_10263() & 0xFFF) << 20 | (pos.method_10264() & 0xFF) << 12 | pos.method_10260() & 0xFFF;
    }

    private static boolean nodeClosed(MNode node) {
        return node != null && node.isClosed();
    }

    private static boolean calculateSwimming(class_4538 world, class_2338 pos, MNode node) {
        return node == null ? SurfaceType.isWater(world, pos.method_10074()) : node.isSwimming();
    }

    public static class_2350 getXZFacing(class_2338 pos, class_2338 neighbor) {
        class_2338 vector = neighbor.method_10059((class_2382)pos);
        return class_2350.method_10147((float)vector.method_10263(), (float)0.0f, (float)vector.method_10260());
    }

    protected boolean onLadderGoingUp(MNode currentNode, class_2338 dPos) {
        return currentNode.isLadder() && (dPos.method_10264() >= 0 || dPos.method_10263() != 0 || dPos.method_10260() != 0);
    }

    public void setEntitySizes(class_1309 entity) {
        if (entity instanceof ICustomSizeNavigator) {
            this.entitySizeXZ = ((ICustomSizeNavigator)entity).getXZNavSize();
            this.entitySizeY = ((ICustomSizeNavigator)entity).getYNavSize();
            this.circumventSizeCheck = ((ICustomSizeNavigator)entity).isSmallerThanBlock();
        } else {
            this.entitySizeXZ = entity.method_17681() / 2.0f;
            this.entitySizeY = class_3532.method_15386((float)entity.method_17682());
        }
        this.allowJumpPointSearchTypeWalk = false;
    }

    protected double computeCost(class_2338 dPos, boolean isSwimming, boolean onRails, boolean railsExit, boolean swimStart, boolean corner, class_2680 state, class_2338 blockPos) {
        double cost = Math.sqrt(dPos.method_10263() * dPos.method_10263() + dPos.method_10264() * dPos.method_10264() + dPos.method_10260() * dPos.method_10260());
        if (!(dPos.method_10264() == 0 || Math.abs(dPos.method_10264()) <= 1 && this.world.method_8320(blockPos).method_26204() instanceof class_2510)) {
            cost *= dPos.method_10264() > 0 ? this.pathingOptions.jumpCost * (double)Math.abs(dPos.method_10264()) : this.pathingOptions.dropCost * (double)Math.abs(dPos.method_10264());
        }
        if (this.world.method_8320(blockPos).method_28498((class_2769)class_2741.field_12537)) {
            cost *= this.pathingOptions.traverseToggleAbleCost;
        }
        if (onRails) {
            cost *= this.pathingOptions.onRailCost;
        }
        if (railsExit) {
            cost *= this.pathingOptions.railsExitCost;
        }
        if (state.method_26204() instanceof class_2541) {
            cost *= this.pathingOptions.vineCost;
        }
        if (isSwimming) {
            cost *= swimStart ? this.pathingOptions.swimCostEnter : this.pathingOptions.swimCost;
        }
        return cost;
    }

    public PathResult getResult() {
        return this.result;
    }

    @Override
    public class_11 call() {
        try {
            return this.search();
        }
        catch (Exception e) {
            Uranus.LOGGER.warn("Pathfinding Exception", (Throwable)e);
            return null;
        }
    }

    protected class_11 search() {
        MNode bestNode = this.getAndSetupStartNode();
        double bestNodeResultScore = Double.MAX_VALUE;
        while (!this.nodesOpen.isEmpty()) {
            boolean isViablePosition;
            if (Thread.currentThread().isInterrupted()) {
                return null;
            }
            MNode currentNode = this.nodesOpen.poll();
            ++this.totalNodesVisited;
            if (this.totalNodesVisited > 5000 || this.totalNodesVisited > this.maxRange * this.maxRange) break;
            currentNode.setCounterVisited(this.totalNodesVisited);
            currentNode.setClosed();
            boolean bl = isViablePosition = this.isInRestrictedArea(currentNode.pos) && SurfaceType.getSurfaceType((class_1922)this.world, this.world.method_8320(currentNode.pos.method_10074()), currentNode.pos.method_10074()) == SurfaceType.WALKABLE;
            if (isViablePosition && this.isAtDestination(currentNode)) {
                bestNode = currentNode;
                this.result.setPathReachesDestination(true);
                break;
            }
            double nodeResultScore = this.getNodeResultScore(currentNode);
            if (isViablePosition && nodeResultScore < bestNodeResultScore && !currentNode.isCornerNode()) {
                bestNode = currentNode;
                bestNodeResultScore = nodeResultScore;
            }
            if (this.hardXzRestriction && !isViablePosition) continue;
            this.walkCurrentNode(currentNode);
        }
        return this.finalizePath(bestNode);
    }

    private void addPathNodeToDebug(MNode node) {
        this.debugNodesVisited.remove(node);
        this.debugNodesPath.add(node);
    }

    private void walkCurrentNode(MNode currentNode) {
        class_2338 dPos = PathfindingConstants.BLOCKPOS_IDENTITY;
        if (currentNode.parent != null) {
            dPos = currentNode.pos.method_10059((class_2382)currentNode.parent.pos);
        }
        if (this.onLadderGoingUp(currentNode, dPos)) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_UP);
        }
        if (this.onLadderGoingDown(currentNode, dPos)) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_DOWN);
        }
        if (this.pathingOptions.canClimb()) {
            if ((Integer)this.getHighest(currentNode).getFirst() > 1) {
                this.walk(currentNode, PathfindingConstants.BLOCKPOS_IDENTITY.method_10086(((Integer)this.getHighest(currentNode).getFirst()).intValue()));
            }
            if (currentNode.parent != null && dPos.method_10263() == 0 && dPos.method_10260() == 0 && dPos.method_10264() > 1 && this.getHighest(currentNode.parent).getSecond() != null) {
                this.walk(currentNode, (class_2338)this.getHighest(currentNode.parent).getSecond());
            }
        }
        if ((currentNode.parent == null || !currentNode.parent.pos.equals((Object)currentNode.pos.method_10074())) && currentNode.isCornerNode()) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_DOWN);
            return;
        }
        if (this.circumventSizeCheck && this.isPassable(currentNode.pos.method_10074(), false, currentNode.parent) && !currentNode.isSwimming() && this.isLiquid(this.world.method_8320(currentNode.pos.method_10074())) || currentNode.parent != null && this.isPassableBBDown(currentNode.parent.pos, currentNode.pos.method_10074(), currentNode.parent)) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_DOWN);
        }
        if (dPos.method_10260() <= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_NORTH);
        }
        if (dPos.method_10263() >= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_EAST);
        }
        if (dPos.method_10260() >= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_SOUTH);
        }
        if (dPos.method_10263() <= 0) {
            this.walk(currentNode, PathfindingConstants.BLOCKPOS_WEST);
        }
    }

    private boolean onLadderGoingDown(MNode currentNode, class_2338 dPos) {
        return (dPos.method_10264() <= 0 || dPos.method_10263() != 0 || dPos.method_10260() != 0) && this.isLadder(currentNode.pos.method_10074());
    }

    private MNode getAndSetupStartNode() {
        MNode startNode = new MNode(this.start, this.computeHeuristic(this.start));
        if (this.pathingOptions.isFlying() && this.start.method_19771((class_2382)this.end, (double)this.maxRange)) {
            startNode = new MNode(this.end, this.computeHeuristic(this.end));
        }
        if (this.isLadder(this.start)) {
            startNode.setLadder();
        } else if (this.isLiquid(this.world.method_8320(this.start.method_10074()))) {
            startNode.setSwimming();
        }
        startNode.setOnRails(this.pathingOptions.canUseRails() && this.world.method_8320(this.start).method_26204() instanceof class_2241);
        this.nodesOpen.offer(startNode);
        this.nodesVisited.put(AbstractPathJob.computeNodeKey(this.start), startNode);
        ++this.totalNodesAdded;
        return startNode;
    }

    public boolean isLiquid(class_2680 state) {
        return state.method_51176() || !state.method_51366() && !state.method_26227().method_15769();
    }

    private class_11 finalizePath(MNode targetNode) {
        int pathLength = 1;
        int railsLength = 0;
        MNode node = targetNode;
        while (node.parent != null) {
            ++pathLength;
            if (node.isOnRails()) {
                ++railsLength;
            }
            node = node.parent;
        }
        class_9[] points = new class_9[pathLength];
        points[0] = new PathPointExtended(node.pos);
        MNode nextInPath = null;
        PathPointExtended next = null;
        node = targetNode;
        while (node.parent != null) {
            --pathLength;
            class_2338 pos = node.pos;
            if (node.isSwimming()) {
                pos.method_10081((class_2382)PathfindingConstants.BLOCKPOS_DOWN);
            }
            PathPointExtended p = new PathPointExtended(pos);
            if (railsLength >= 8) {
                PathPointExtended point;
                p.setOnRails(node.isOnRails());
                if (p.isOnRails() && (!node.parent.isOnRails() || node.parent.parent == null)) {
                    p.setRailsEntry();
                } else if (p.isOnRails() && points.length > pathLength + 1 && !(point = (PathPointExtended)points[pathLength + 1]).isOnRails()) {
                    point.setRailsExit();
                }
            }
            if (AbstractPathJob.onALadder(node, nextInPath, pos)) {
                p.setOnLadder(true);
                if (nextInPath.pos.method_10264() > pos.method_10264()) {
                    AbstractPathJob.setLadderFacing(this.world, pos, p);
                }
            } else if (AbstractPathJob.onALadder(node.parent, node.parent, pos)) {
                p.setOnLadder(true);
            }
            if (next != null) {
                next.field_35 = p;
            }
            next = p;
            points[pathLength] = p;
            nextInPath = node;
            node = node.parent;
        }
        return new class_11(Arrays.asList(points), this.getPathTargetPos(targetNode), this.isAtDestination(targetNode));
    }

    protected class_2338 getPathTargetPos(MNode finalNode) {
        return finalNode.pos;
    }

    protected abstract double computeHeuristic(class_2338 var1);

    protected abstract boolean isAtDestination(MNode var1);

    protected abstract double getNodeResultScore(MNode var1);

    protected void walk(MNode parent, class_2338 dPos) {
        int nodeKey;
        MNode node;
        class_2338 pos = parent.pos.method_10081((class_2382)dPos);
        int newY = this.getGroundHeight(parent, pos);
        if (newY < this.world.method_31607()) {
            return;
        }
        boolean corner = false;
        if (pos.method_10264() != newY) {
            if (!(parent.isCornerNode() || newY - pos.method_10264() <= 0 || parent.parent != null && parent.parent.pos.equals((Object)parent.pos.method_10081((class_2382)new class_2338(0, newY - pos.method_10264(), 0))))) {
                dPos = new class_2338(0, newY - pos.method_10264(), 0);
                pos = parent.pos.method_10081((class_2382)dPos);
                corner = true;
            } else if (!(parent.isCornerNode() || newY - pos.method_10264() >= 0 || dPos.method_10263() == 0 && dPos.method_10260() == 0 || parent.parent != null && parent.pos.method_10074().equals((Object)parent.parent.pos))) {
                dPos = new class_2338(dPos.method_10263(), 0, dPos.method_10260());
                pos = parent.pos.method_10081((class_2382)dPos);
                corner = true;
            } else if (!this.pathingOptions.canClimb() || dPos.method_10264() <= 1) {
                dPos = dPos.method_10069(0, newY - pos.method_10264(), 0);
                pos = new class_2338(pos.method_10263(), newY, pos.method_10260());
            }
        }
        if (AbstractPathJob.nodeClosed(node = this.nodesVisited.get(nodeKey = AbstractPathJob.computeNodeKey(pos)))) {
            return;
        }
        boolean isSwimming = AbstractPathJob.calculateSwimming(this.world, pos, node);
        if (isSwimming && !this.pathingOptions.canSwim()) {
            return;
        }
        boolean swimStart = isSwimming && !parent.isSwimming();
        class_2680 state = this.world.method_8320(pos);
        boolean onRails = this.pathingOptions.canUseRails() && this.world.method_8320(corner ? pos.method_10074() : pos).method_26204() instanceof class_2241;
        boolean railsExit = !onRails && parent.isOnRails();
        double stepCost = this.computeCost(dPos, isSwimming, onRails, railsExit, swimStart, corner, state, pos);
        double heuristic = this.computeHeuristic(pos);
        double cost = parent.getCost() + stepCost;
        double score = cost + heuristic;
        if (node == null) {
            node = this.createNode(parent, pos, nodeKey, isSwimming, heuristic, cost, score);
            node.setOnRails(onRails);
            node.setCornerNode(corner);
        } else if (this.updateCurrentNode(parent, node, heuristic, cost, score)) {
            return;
        }
        this.nodesOpen.offer(node);
        if (this.pathingOptions.canClimb() && dPos.method_10264() > 1) {
            return;
        }
        this.performJumpPointSearch(parent, dPos, node);
    }

    private void performJumpPointSearch(MNode parent, class_2338 dPos, MNode node) {
        if (this.allowJumpPointSearchTypeWalk && node.getHeuristic() <= parent.getHeuristic()) {
            this.walk(node, dPos);
        }
    }

    private MNode createNode(MNode parent, class_2338 pos, int nodeKey, boolean isSwimming, double heuristic, double cost, double score) {
        MNode node = new MNode(parent, pos, cost, heuristic, score);
        this.nodesVisited.put(nodeKey, node);
        if (this.debugDrawEnabled) {
            this.debugNodesNotVisited.add(node);
        }
        if (this.isLadder(pos)) {
            node.setLadder();
        } else if (isSwimming) {
            node.setSwimming();
        }
        ++this.totalNodesAdded;
        node.setCounterAdded(this.totalNodesAdded);
        return node;
    }

    private boolean updateCurrentNode(MNode parent, MNode node, double heuristic, double cost, double score) {
        if (score >= node.getScore()) {
            return true;
        }
        if (!this.nodesOpen.remove(node)) {
            return true;
        }
        node.parent = parent;
        node.setSteps(parent.getSteps() + 1);
        node.setCost(cost);
        node.setHeuristic(heuristic);
        node.setScore(score);
        return false;
    }

    protected int getGroundHeight(MNode parent, class_2338 pos) {
        if (this.checkHeadBlock(parent, pos)) {
            return this.handleTargetNotPassable(parent, pos.method_10084(), this.world.method_8320(pos.method_10084()));
        }
        class_2680 target = this.world.method_8320(pos);
        if (parent != null && !this.isPassableBB(parent.pos, pos, parent)) {
            return this.handleTargetNotPassable(parent, pos, target);
        }
        int i = 0;
        class_2680 below = null;
        SurfaceType lastSurfaceType = null;
        while (i < this.maxNavigableGroundDist) {
            below = this.world.method_8320(pos.method_10087(++i));
            if (!(this.pathingOptions.isFlying() ? (lastSurfaceType = this.isFlyable(below, pos, parent)) == SurfaceType.FLYABLE : (lastSurfaceType = this.isWalkableSurface(below, pos)) == SurfaceType.WALKABLE)) continue;
            return pos.method_10264();
        }
        return lastSurfaceType != SurfaceType.NOT_PASSABLE && below != null ? this.handleNotStanding(parent, pos, below) : -1;
    }

    private int handleNotStanding(MNode parent, class_2338 pos, class_2680 below) {
        boolean isSwimming;
        boolean bl = isSwimming = parent != null && parent.isSwimming();
        if (this.isLiquid(below)) {
            return this.handleInLiquid(pos, below, isSwimming);
        }
        if (this.isLadder(below.method_26204(), pos.method_10074())) {
            return pos.method_10264();
        }
        return this.checkDrop(parent, pos, isSwimming);
    }

    private int checkDrop(MNode parent, class_2338 pos, boolean isSwimming) {
        boolean canDrop = parent != null && !parent.isLadder();
        boolean isChonker = true;
        if (this.pathingOptions.canClimb() && parent != null && pos.method_10264() > parent.pos.method_10264() + 1) {
            return pos.method_10264();
        }
        if (!isChonker && (!canDrop || isSwimming || (parent.pos.method_10263() != pos.method_10263() || parent.pos.method_10260() != pos.method_10260()) && this.isPassableBBFull(parent.pos.method_10074(), parent) && this.isWalkableSurface(this.world.method_8320(parent.pos.method_10074()), parent.pos.method_10074()) == SurfaceType.DROPABLE)) {
            return -1;
        }
        for (int i = 2; i <= 10; ++i) {
            class_2680 below = this.world.method_8320(pos.method_10087(i));
            if (this.isWalkableSurface(below, pos) == SurfaceType.WALKABLE && i <= 4 || below.method_51176()) {
                return pos.method_10264() - i + 1;
            }
            if (!below.method_26215()) continue;
            return -1;
        }
        return -1;
    }

    private int handleInLiquid(class_2338 pos, class_2680 below, boolean isSwimming) {
        if (isSwimming) {
            return pos.method_10264();
        }
        if (this.pathingOptions.canSwim() && SurfaceType.isWater(this.world, pos.method_10074())) {
            return pos.method_10264();
        }
        return -1;
    }

    private int handleTargetNotPassable(MNode parent, class_2338 pos, class_2680 target) {
        class_265 bb2;
        class_265 bb1;
        boolean canJump;
        boolean bl = canJump = parent != null && !parent.isLadder() && !parent.isSwimming();
        if (!canJump || SurfaceType.getSurfaceType((class_1922)this.world, target, pos) != SurfaceType.WALKABLE) {
            return -1;
        }
        if (!this.isPassable(pos.method_10086(2), false, parent)) {
            bb1 = this.world.method_8320(pos).method_26222((class_1922)this.world, pos);
            bb2 = this.world.method_8320(pos.method_10086(2)).method_26222((class_1922)this.world, pos.method_10086(2));
            if ((double)pos.method_10086(2).method_10264() + this.getStartY(bb2) - ((double)pos.method_10264() + this.getEndY(bb1)) < 2.0) {
                return -1;
            }
        }
        if (!this.isPassable(parent.pos.method_10086(2), false, parent)) {
            bb1 = this.world.method_8320(pos).method_26222((class_1922)this.world, pos);
            bb2 = this.world.method_8320(parent.pos.method_10086(2)).method_26222((class_1922)this.world, parent.pos.method_10086(2));
            if ((double)parent.pos.method_10086(2).method_10264() + this.getStartY(bb2) - ((double)pos.method_10264() + this.getEndY(bb1)) < 2.0) {
                return -1;
            }
        }
        class_2680 parentBelow = this.world.method_8320(parent.pos.method_10074());
        class_265 parentBB = parentBelow.method_26222((class_1922)this.world, parent.pos.method_10074());
        double parentY = parentBB.method_1105(class_2350.class_2351.field_11052);
        double parentMaxY = parentY + (double)parent.pos.method_10074().method_10264();
        double targetMaxY = target.method_26222((class_1922)this.world, pos).method_1105(class_2350.class_2351.field_11052) + (double)pos.method_10264();
        if (targetMaxY - parentMaxY < this.maxJumpHeight) {
            return pos.method_10264() + 1;
        }
        if (target.method_26204() instanceof class_2510 && parentY - 0.5 < this.maxJumpHeight && target.method_11654((class_2769)class_2510.field_11572) == class_2760.field_12617 && AbstractPathJob.getXZFacing(parent.pos, pos) == target.method_11654((class_2769)class_2510.field_11571)) {
            return pos.method_10264() + 1;
        }
        return -1;
    }

    private Pair<Integer, class_2338> getHighest(MNode node) {
        int max = 1;
        class_2338 pos = node.pos;
        class_2338 direction = null;
        if (this.world.method_8320(pos.method_10095()).method_26225() && this.climbableTop(pos.method_10095(), class_2350.field_11035, node) > max) {
            max = this.climbableTop(pos.method_10095(), class_2350.field_11035, node);
            direction = PathfindingConstants.BLOCKPOS_NORTH;
        }
        if (this.world.method_8320(pos.method_10078()).method_26225() && this.climbableTop(pos.method_10078(), class_2350.field_11039, node) > max) {
            max = this.climbableTop(pos.method_10078(), class_2350.field_11039, node);
            direction = PathfindingConstants.BLOCKPOS_EAST;
        }
        if (this.world.method_8320(pos.method_10072()).method_26225() && this.climbableTop(pos.method_10072(), class_2350.field_11043, node) > max) {
            max = this.climbableTop(pos.method_10072(), class_2350.field_11043, node);
            direction = PathfindingConstants.BLOCKPOS_SOUTH;
        }
        if (this.world.method_8320(pos.method_10067()).method_26225() && this.climbableTop(pos.method_10067(), class_2350.field_11034, node) > max) {
            max = this.climbableTop(pos.method_10067(), class_2350.field_11034, node);
            direction = PathfindingConstants.BLOCKPOS_WEST;
        }
        return new Pair((Object)max, (Object)direction);
    }

    private int climbableTop(class_2338 pos, class_2350 direction, MNode node) {
        class_2680 target = this.world.method_8320(pos);
        int i = 0;
        while (target.method_26225()) {
            pos = pos.method_10084();
            target = this.world.method_8320(pos);
            class_2680 origin = this.world.method_8320(pos.method_10093(direction));
            if (!this.isPassable(origin, pos.method_10093(direction), node)) {
                i = 0;
                break;
            }
            ++i;
        }
        return i;
    }

    private boolean checkHeadBlock(MNode parent, class_2338 pos) {
        class_2338 localPos = pos;
        class_265 bb = this.world.method_8320(localPos).method_26220((class_1922)this.world, localPos);
        if (bb.method_1105(class_2350.class_2351.field_11052) < 1.0) {
            localPos = pos.method_10084();
        }
        if (parent == null || !this.isPassableBB(parent.pos, pos.method_10084(), parent)) {
            class_265 bb1 = this.world.method_8320(pos.method_10074()).method_26222((class_1922)this.world, pos.method_10074());
            class_265 bb2 = this.world.method_8320(pos.method_10084()).method_26222((class_1922)this.world, pos.method_10084());
            if ((double)pos.method_10084().method_10264() + this.getStartY(bb2) - ((double)pos.method_10074().method_10264() + this.getEndY(bb1)) < 2.0) {
                return true;
            }
            if (parent != null) {
                class_265 bb3 = this.world.method_8320(parent.pos.method_10074()).method_26222((class_1922)this.world, pos.method_10074());
                if ((double)pos.method_10084().method_10264() + this.getStartY(bb2) - ((double)parent.pos.method_10074().method_10264() + this.getEndY(bb3)) < 1.75) {
                    return true;
                }
            }
        }
        if (parent != null) {
            class_2680 hereState = this.world.method_8320(localPos.method_10074());
            class_265 bb1 = this.world.method_8320(pos).method_26222((class_1922)this.world, pos);
            class_265 bb2 = this.world.method_8320(localPos.method_10084()).method_26222((class_1922)this.world, localPos.method_10084());
            if ((double)localPos.method_10084().method_10264() + this.getStartY(bb2) - ((double)pos.method_10264() + this.getEndY(bb1)) >= 2.0) {
                return false;
            }
            return this.isLiquid(hereState) && !this.isPassable(pos, false, parent);
        }
        return false;
    }

    private double getStartY(class_265 bb) {
        return bb.method_1110() ? 1.0 : bb.method_1091(class_2350.class_2351.field_11052);
    }

    private double getEndY(class_265 bb) {
        return bb.method_1110() ? 0.0 : bb.method_1105(class_2350.class_2351.field_11052);
    }

    protected boolean isPassable(class_2680 block, class_2338 pos, MNode parent) {
        class_2350 facing;
        class_2350 direction;
        class_2338 dir;
        class_2338 parentPos = parent == null ? this.start : parent.pos;
        class_2680 parentBlock = this.world.method_8320(parentPos);
        if (parentBlock.method_26204() instanceof class_2533 && ((dir = pos.method_10059((class_2382)parentPos)).method_10263() != 0 || dir.method_10260() != 0) && (direction = AbstractPathJob.getXZFacing(parentPos, pos)) == (facing = (class_2350)parentBlock.method_11654((class_2769)class_2533.field_11177)).method_10153()) {
            return false;
        }
        if (!block.method_26215()) {
            class_265 shape = block.method_26222((class_1922)this.world, pos);
            if (block.method_51366() && !shape.method_1110() && !(shape.method_1105(class_2350.class_2351.field_11052) <= 0.1)) {
                if (block.method_26204() instanceof class_2533) {
                    class_2350 facing2;
                    class_2338 dir2 = pos.method_10059((class_2382)parentPos);
                    if (dir2.method_10264() != 0 && dir2.method_10263() == 0 && dir2.method_10260() == 0) {
                        return true;
                    }
                    class_2350 direction2 = AbstractPathJob.getXZFacing(parentPos, pos);
                    if (direction2 == (facing2 = (class_2350)block.method_11654((class_2769)class_2533.field_11177)).method_10153()) {
                        return true;
                    }
                    return direction2 != facing2;
                }
                return this.pathingOptions.canEnterDoors() && (block.method_26204() instanceof class_2323 || block.method_26204() instanceof class_2349) || block.method_26204() instanceof class_2440 || block.method_26204() instanceof class_2478 || block.method_26204() instanceof class_2185;
            }
            if (block.method_26204() instanceof class_2358 || block.method_26204() instanceof class_3830) {
                return false;
            }
            if (this.isLadder(block.method_26204(), pos)) {
                return true;
            }
            if (shape.method_1110() || shape.method_1105(class_2350.class_2351.field_11052) <= 0.125 && !this.isLiquid(block) && (block.method_26204() != class_2246.field_10477 || (Integer)block.method_11654((class_2769)class_2488.field_11518) == 1)) {
                class_7 pathType = PathUtil.getAiPathNodeType(block, this.world, pos);
                return pathType == null || PathUtil.getDanger(pathType) == null;
            }
            return false;
        }
        return true;
    }

    protected boolean isPassable(class_2338 pos, boolean head, MNode parent) {
        class_2680 state = this.world.method_8320(pos);
        class_265 shape = state.method_26222((class_1922)this.world, pos);
        if (this.passabilityNavigator != null && this.passabilityNavigator.isBlockExplicitlyNotPassable(state, pos, pos)) {
            return false;
        }
        if (shape.method_1110() || shape.method_1105(class_2350.class_2351.field_11052) <= 0.1) {
            if (this.passabilityNavigator != null && this.passabilityNavigator.isBlockExplicitlyPassable(state, pos, pos)) {
                return this.isPassable(state, pos, parent);
            }
            return !head || !(state.method_26204() instanceof class_5815) || this.isLadder(state.method_26204(), pos);
        }
        return this.isPassable(state, pos, parent);
    }

    protected boolean isPassableBBFull(class_2338 pos, MNode parent) {
        if (this.circumventSizeCheck) {
            return this.isPassable(pos, false, parent) && this.isPassable(pos.method_10084(), true, parent);
        }
        int i = 0;
        while ((float)i <= this.entitySizeXZ) {
            for (int j = 0; j <= this.entitySizeY; ++j) {
                int k = 0;
                while ((float)k <= this.entitySizeXZ) {
                    if (!this.isPassable(pos.method_10069(i, j, k), false, parent)) {
                        return false;
                    }
                    ++k;
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean isPassableBB(class_2338 parentPos, class_2338 pos, MNode parent) {
        if (this.circumventSizeCheck) {
            return this.isPassable(pos, false, parent) && this.isPassable(pos.method_10084(), true, parent);
        }
        class_2350 facingDir = AbstractPathJob.getXZFacing(parentPos, pos);
        if (facingDir == class_2350.field_11033 || facingDir == class_2350.field_11036) {
            return false;
        }
        facingDir = facingDir.method_10170();
        int i = 0;
        while ((float)i <= this.entitySizeXZ) {
            for (int j = 0; j <= this.entitySizeY; ++j) {
                if (this.isPassable(pos.method_10079(facingDir, i).method_10086(j), false, parent)) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    protected boolean isPassableBBDown(class_2338 parentPos, class_2338 pos, MNode parent) {
        if (this.circumventSizeCheck) {
            return this.isPassable(pos, true, parent);
        }
        class_2350 facingDir = AbstractPathJob.getXZFacing(parentPos, pos);
        if (facingDir == class_2350.field_11033 || facingDir == class_2350.field_11036) {
            return false;
        }
        facingDir = facingDir.method_10170();
        int i = 0;
        while ((float)i <= this.entitySizeXZ) {
            for (int j = 0; j <= this.entitySizeY; ++j) {
                if (this.isPassable(pos.method_10079(facingDir, i).method_10086(j), false, parent) && pos.method_10264() > parentPos.method_10264()) continue;
                return false;
            }
            ++i;
        }
        return true;
    }

    protected SurfaceType isFlyable(class_2680 blockState, class_2338 pos, MNode parent) {
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2354 || block instanceof class_2349 || block instanceof class_2544 || block instanceof class_2358 || block instanceof class_3922 || block instanceof class_2211 || block instanceof class_2202 || blockState.method_26218((class_1922)this.world, pos).method_1105(class_2350.class_2351.field_11052) > 1.0) {
            return SurfaceType.NOT_PASSABLE;
        }
        class_3610 fluid = this.world.method_8316(pos);
        if (!(fluid == null || fluid.method_15769() || fluid.method_15772() != class_3612.field_15908 && fluid.method_15772() != class_3612.field_15907)) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (this.isPassable(blockState, pos, parent)) {
            return SurfaceType.FLYABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected SurfaceType isWalkableSurface(class_2680 blockState, class_2338 pos) {
        class_2248 block = blockState.method_26204();
        if (block instanceof class_2354 || block instanceof class_2349 || block instanceof class_2544 || block instanceof class_2358 || block instanceof class_3922 || block instanceof class_2211 || block instanceof class_2202 || blockState.method_26218((class_1922)this.world, pos).method_1105(class_2350.class_2351.field_11052) > 1.0) {
            return SurfaceType.NOT_PASSABLE;
        }
        class_3610 fluid = this.world.method_8316(pos);
        if (!(fluid == null || fluid.method_15769() || fluid.method_15772() != class_3612.field_15908 && fluid.method_15772() != class_3612.field_15907)) {
            return SurfaceType.NOT_PASSABLE;
        }
        if (block instanceof class_2478) {
            return SurfaceType.DROPABLE;
        }
        if (blockState.method_51367() || blockState.method_26204() == class_2246.field_10477 && (Integer)blockState.method_11654((class_2769)class_2488.field_11518) > 1 || block instanceof class_5815) {
            return SurfaceType.WALKABLE;
        }
        return SurfaceType.DROPABLE;
    }

    protected boolean isLadder(class_2248 block, class_2338 pos) {
        return BlockUtil.isLadder(block);
    }

    protected boolean isLadder(class_2338 pos) {
        return this.isLadder(this.world.method_8320(pos).method_26204(), pos);
    }

    public void setPathingOptions(PathingOptions pathingOptions) {
        this.pathingOptions = pathingOptions;
    }

    public boolean isInRestrictedArea(class_2338 pos) {
        boolean isInXZ;
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.NONE) {
            return true;
        }
        boolean bl = isInXZ = pos.method_10263() <= this.maxX && pos.method_10260() <= this.maxZ && pos.method_10260() >= this.minZ && pos.method_10263() >= this.minX;
        if (!isInXZ) {
            return false;
        }
        if (this.restrictionType == AbstractAdvancedPathNavigate.RestrictionType.XZ) {
            return true;
        }
        return pos.method_10264() <= this.maxY && pos.method_10264() >= this.minY;
    }
}

