/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_texture_features.compat;

import java.lang.reflect.Method;
import java.util.Objects;
import me.jellysquid.mods.sodium.client.render.vertex.buffer.ExtendedBufferBuilder;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import org.apache.logging.log4j.util.TriConsumer;
import traben.entity_texture_features.features.ETFRenderContext;
import traben.entity_texture_features.utils.ETFUtils2;
import traben.entity_texture_features.utils.ETFVertexConsumer;

public abstract class SodiumGetBufferInjector {
    private static final TriConsumer<class_4597, class_1921, class_4588> INSTANCE = SodiumGetBufferInjector.get();

    public static void inject(class_4597 provider, class_1921 renderLayer, class_4588 vertexConsumer) {
        if (INSTANCE != null) {
            INSTANCE.accept((Object)provider, (Object)renderLayer, (Object)vertexConsumer);
        }
    }

    private static TriConsumer<class_4597, class_1921, class_4588> get() {
        try {
            return new Impl();
        }
        catch (NoClassDefFoundError | NoSuchMethodError | NullPointerException ignored) {
            ETFUtils2.logWarn("ETF compatibility method for sodium versions prior to 0.5.9 failed, this is fine if you are using a newer sodium or if it isn't installed at all");
            return null;
        }
    }

    private static class Impl
    implements TriConsumer<class_4597, class_1921, class_4588> {
        Impl() {
            Objects.requireNonNull(ExtendedBufferBuilder.class);
            Method[] methods = ExtendedBufferBuilder.class.getMethods();
            boolean found = false;
            for (Method method : methods) {
                if (!method.getName().equals("sodium$getDelegate")) continue;
                found = true;
                break;
            }
            if (!found) {
                throw new NoSuchMethodError("Method sodium$getDelegate not found");
            }
        }

        public void accept(class_4597 vertexConsumerProvider, class_1921 renderLayer, class_4588 vertexConsumer) {
            ExtendedBufferBuilder buff;
            class_4588 delegate;
            if (vertexConsumer instanceof ExtendedBufferBuilder && (delegate = (class_4588)(buff = (ExtendedBufferBuilder)vertexConsumer).sodium$getDelegate()) instanceof ETFVertexConsumer) {
                ETFRenderContext.insertETFDataIntoVertexConsumer(vertexConsumerProvider, renderLayer, delegate);
            }
        }
    }
}

